package com.elitesland.fin.repo.invoice;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoice.PaymentRecordsParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.entity.invoice.QPaymentRecordsDDO;
import com.elitesland.fin.entity.invoice.QPaymentRecordsDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/4/11
 */
@Component
@RequiredArgsConstructor
public class PaymentRecordsRepoProc {

    private static final QPaymentRecordsDO paymentRecordsDO = QPaymentRecordsDO.paymentRecordsDO;
    private static final QPaymentRecordsDDO paymentRecordsDDO = QPaymentRecordsDDO.paymentRecordsDDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<InvoiceAwaitRespVO> paymentList = Projections.bean(
            InvoiceAwaitRespVO.class,
            paymentRecordsDO.id,
            paymentRecordsDO.docNo,
            paymentRecordsDO.noticeId,
            paymentRecordsDO.franchiseeId,
            paymentRecordsDO.paymentStatus,
            paymentRecordsDO.invBankNo,
            paymentRecordsDO.ouCode,
            paymentRecordsDO.ouName,
            paymentRecordsDO.ouId,
            paymentRecordsDO.custCode,
            paymentRecordsDO.custName,
            paymentRecordsDO.custId,
            paymentRecordsDO.bankAccount,
            paymentRecordsDO.amt,
            paymentRecordsDO.noticeDate,
            paymentRecordsDO.associateNumber,
            paymentRecordsDO.paymentDate,
            paymentRecordsDO.noticeContent,
            paymentRecordsDO.voucherFileCode,
            paymentRecordsDO.uniBankNo,
            paymentRecordsDO.storeCode,
            paymentRecordsDO.sourceDocType,
            paymentRecordsDO.realRecAmt,
            paymentRecordsDO.sourceDocId,
            paymentRecordsDO.sourceDocNo,
            paymentRecordsDO.receiptId,
            paymentRecordsDO.invoiceInfo,
            paymentRecordsDO.payAccount,
            paymentRecordsDO.payType,
            paymentRecordsDO.payBank/*,
            franchiseeDO.franchiseeCode,
            franchiseeDO.franchiseeName*/
    );
    //private static final QFranchiseeDO franchiseeDO = QFranchiseeDO.franchiseeDO;
    private final QBean<InvoiceAwaitRespVO> detailList = Projections.bean(
            InvoiceAwaitRespVO.class,
            paymentRecordsDDO.id,
            paymentRecordsDO.id.as("masId"),
            paymentRecordsDO.docNo,
            paymentRecordsDO.noticeId,
            paymentRecordsDO.franchiseeId,
            paymentRecordsDO.invBankNo,
            paymentRecordsDO.ouCode,
            paymentRecordsDO.ouName,
            paymentRecordsDO.ouId,
            paymentRecordsDO.bankAccount,
            paymentRecordsDO.noticeDate,
            paymentRecordsDO.paymentDate,
            paymentRecordsDO.noticeContent,
            paymentRecordsDO.voucherFileCode,
            paymentRecordsDO.uniBankNo,
            paymentRecordsDO.storeCode,
            paymentRecordsDO.sourceDocType,
            paymentRecordsDO.sourceDocId,
            paymentRecordsDO.paymentStatus,
            paymentRecordsDDO.lineNo,
            paymentRecordsDDO.itemCode,
            paymentRecordsDDO.taxRate,
            paymentRecordsDDO.amt,
            paymentRecordsDDO.remark,
            paymentRecordsDDO.realRecAmt,
            paymentRecordsDDO.receiptId,
            paymentRecordsDDO.isToBilling,
            paymentRecordsDO.payBank,
            paymentRecordsDO.payAccount,
            paymentRecordsDO.payType/*,
            franchiseeDO.franchiseeCode,
            franchiseeDO.franchiseeName*/
    );
//    @UnicomReference
//    private FranchiseeRpcService franchiseeRpcService;

    public long countPaymentRecords(PaymentRecordsParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(paymentRecordsDO.count())
                .from(paymentRecordsDO);
        //.leftJoin(franchiseeDO).on(paymentRecordsDO.franchiseeId.eq(franchiseeDO.id));
        jpaQuery.where(this.wherePaymentRecords(paramVO));
        return jpaQuery.fetchCount();
    }

    public PagingVO<InvoiceAwaitRespVO> queryPaymentRecords(PaymentRecordsParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(paymentList)
                .from(paymentRecordsDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, paymentRecordsDO);
        jpaQuery.where(this.wherePaymentRecords(paramVO));

        return PagingVO.<InvoiceAwaitRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public List<InvoiceAwaitRespVO> queryPaymentDetails(PaymentRecordsParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(detailList)
                .from(paymentRecordsDO)
                .leftJoin(paymentRecordsDDO).on(paymentRecordsDO.id.eq(paymentRecordsDDO.masId));
        //.leftJoin(franchiseeDO).on(paymentRecordsDO.franchiseeId.eq(franchiseeDO.id));
        jpaQuery.where(this.wherePaymentRecords(paramVO));
        return jpaQuery.fetch();
    }

    public List<InvoiceAwaitRespVO> findByIds(List<Long> ids) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(paymentRecordsDO.id.in(ids));
        predicates.add(paymentRecordsDDO.isToBilling.eq("0"));
        var jpaQuery = jpaQueryFactory.select(detailList)
                .from(paymentRecordsDO)
                .leftJoin(paymentRecordsDDO).on(paymentRecordsDO.id.eq(paymentRecordsDDO.masId))
                .where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    private Predicate wherePaymentRecords(PaymentRecordsParam paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotEmpty(paramVO.getChargeType())) {
            var matchExpress = paymentRecordsDDO.itemCode.eq(paramVO.getChargeType());
            predicates.add(JPAExpressions.selectFrom(paymentRecordsDDO)
                    .where(paymentRecordsDDO.masId.eq(paymentRecordsDO.id).and(matchExpress)).exists());

        }
        if (!ObjectUtils.isEmpty(paramVO.getPaymentDateStart())) {
            predicates.add(paymentRecordsDO.paymentDate.after(paramVO.getPaymentDateStart())
                    .or(paymentRecordsDO.paymentDate.eq(paramVO.getPaymentDateStart())));
        }
        if (!ObjectUtils.isEmpty(paramVO.getPaymentDateEnd())) {
            predicates.add(paymentRecordsDO.paymentDate.before(paramVO.getPaymentDateEnd())
                    .or(paymentRecordsDO.paymentDate.eq(paramVO.getPaymentDateEnd())));
        }
        if (StringUtils.isNotEmpty(paramVO.getPaymentStatus())) {
            predicates.add(paymentRecordsDO.paymentStatus.eq(paramVO.getPaymentStatus()));
        }
        if (ObjectUtil.isNotNull(paramVO.getMasId())) {
            predicates.add(paymentRecordsDDO.masId.eq(paramVO.getMasId()));
        }
        if (StringUtils.isNotEmpty(paramVO.getSourceNo())) {
            predicates.add(paymentRecordsDO.sourceDocNo.eq(paramVO.getSourceNo()));
        }
        if (StrUtil.isNotBlank(paramVO.getOuCode())) {
            predicates.add(paymentRecordsDO.ouCode.eq(paramVO.getOuCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getOuName())) {
            predicates.add(paymentRecordsDO.ouName.like("%" + paramVO.getOuName() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getCustCodeName())) {
            String likeStr = "%" + paramVO.getCustCodeName() + "%";
            predicates.add(paymentRecordsDO.custCode.like(likeStr).or(paymentRecordsDO.custName.like(likeStr)));
        }

        return ExpressionUtils.allOf(predicates);
    }

    public long updatePaymentStatus(long id, String status, long receiptId, BigDecimal realRecAmt, String recOrderNo) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(paymentRecordsDO.id.eq(id));
        JPAUpdateClause update = jpaQueryFactory.update(paymentRecordsDO)
                .set(paymentRecordsDO.paymentStatus, status)
                .set(paymentRecordsDO.receiptId, receiptId)
                .set(paymentRecordsDO.realRecAmt, realRecAmt)
                .set(paymentRecordsDO.associateNumber, recOrderNo)
                .where(ExpressionUtils.allOf(predicates));
        return update.execute();
    }

    public long updatePayment(long id, String recOrderNo) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(paymentRecordsDO.id.eq(id));
        JPAUpdateClause update = jpaQueryFactory.update(paymentRecordsDO)
                .set(paymentRecordsDO.associateNumber, recOrderNo)
                .where(ExpressionUtils.allOf(predicates));
        return update.execute();
    }

    /**
     * 更新付款记录状态
     *
     * @param id
     * @param status
     * @return
     */
    public long updatePaymentDStatus(long id, String status, long receiptId, BigDecimal realRecAmt) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(paymentRecordsDDO.id.eq(id));
        JPAUpdateClause update = jpaQueryFactory.update(paymentRecordsDDO)
                .set(paymentRecordsDDO.paymentStatus, status)
                .set(paymentRecordsDDO.receiptId, receiptId)
                .set(paymentRecordsDDO.realRecAmt, realRecAmt)
                .where(ExpressionUtils.allOf(predicates));
        return update.execute();
    }

    public List<InvoiceAwaitRespVO> findByDetails(List<Long> bizKey) {
        var jpaQuery = jpaQueryFactory.select(detailList)
                .from(paymentRecordsDO)
                .leftJoin(paymentRecordsDDO).on(paymentRecordsDO.id.eq(paymentRecordsDDO.masId))
                //.leftJoin(franchiseeDO).on(paymentRecordsDO.franchiseeId.eq(franchiseeDO.id))
                .where(paymentRecordsDDO.id.in(bizKey));
        return jpaQuery.fetch();
    }

    public long updateInvoiceInfo(List<String> paymentNoList, String invoiceInfo) {
        JPAUpdateClause update = jpaQueryFactory.update(paymentRecordsDO)
                .set(paymentRecordsDO.invoiceInfo, invoiceInfo)
                .where(paymentRecordsDO.docNo.in(paymentNoList));
        return update.execute();
    }

    public List<String> getSourceIdByDocNo(List<String> paymentNoList, String sourceDocType) {
        JPAQuery<String> where = jpaQueryFactory.select(paymentRecordsDO.sourceDocNo)
                .from(paymentRecordsDO)
                .where(paymentRecordsDO.docNo.in(paymentNoList).and(paymentRecordsDO.sourceDocType.eq(sourceDocType)));
        return where.fetch();
    }
}
