package com.elitesland.fin.application.facade.param.aporder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.param.aporder
 * @date 2022/3/21 14:31
 */
@Data
public class ApOrderDtlSaveParam implements Serializable {

    private static final long serialVersionUID = 2166300493044526170L;
    private Long id;

    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("规格型号")
    private String itemType;

    @ApiModelProperty("小类编码")
    private String smallCateCode;

    @ApiModelProperty("小类名称")
    private String smallCateName;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("计量单位名称")
    private String uomName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("单价")
    private BigDecimal exclTaxPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;

    @ApiModelProperty("起算日期")
    private LocalDate startCalDate;

    @ApiModelProperty("到期付款日")
    private LocalDate expirePayDate;

    @ApiModelProperty("单位成本")
    private BigDecimal costPrice;

    @ApiModelProperty("应付暂估差异")
    private BigDecimal invoicePriceVariance;
}
