package com.elitesland.fin.application.service.excel.exp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.arorder.ArOrderDtlService;
import com.elitesland.fin.application.service.excel.entity.ArListExportEntity;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderExcelDTO;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_AR_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class ArExportUsingParamServiceImpl implements DataExport<ArListExportEntity, ArOrderPageParam> {
    private final ArOrderDtlService arOrderDtlService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    public String getTmplCode() {
        return FIN_AR_EXPORT_DEFAULT;
    }

    @Override
    public PagingVO<ArListExportEntity> executeExport(ArOrderPageParam queryParam) {
        PagingVO<ArOrderExcelDTO> page = arOrderDtlService.exportArOrder(queryParam);
        List<ArOrderExcelDTO> records = page.getRecords();
        if (CollUtil.isEmpty(records)) {
            return new PagingVO<>();
        }
        List<String> relOuCodes = records.stream().map(ArOrderExcelDTO::getRelevanceOuCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relOuCodes);
        records.forEach(row -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(row.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                row.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return new PagingVO<>(page.getTotal(), ExcelConvertUtils.convertLoosely(records, ArListExportEntity.class));
    }
}
