package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_AWAIT_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class DefaultFinAwaitExportServiceImpl implements DataExport<InvoiceAwaitVO, InvoiceAwaitQueryParam> {
    private final InvoiceAwaitService invoiceAwaitService;
    @Override
    public String getTmplCode() {
        return FIN_AWAIT_EXPORT_DEFAULT;
    }
    @Override
    public PagingVO<InvoiceAwaitVO> executeExport(InvoiceAwaitQueryParam queryParam) {
        return invoiceAwaitService.queryInvoiceAwait(queryParam);
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
}
