package com.elitesland.fin.application.service.excel.exp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.RecOrderEntity;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_REC_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class DefaultRecOrderExportServiceImpl implements DataExport<RecOrderEntity, RecOrderPageParam> {
    private final RecOrderDomainService recOrderDomainService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    public String getTmplCode() {
        return FIN_REC_EXPORT_DEFAULT;
    }

    @Override
    @SysCodeProc
    public PagingVO<RecOrderEntity> executeExport(RecOrderPageParam queryParam) {
        if (queryParam.getReDateStart() == null || queryParam.getReDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "请选择收款日期!");
        }
        PagingVO<RecOrderEntity> recOrderDTOPagingVO = recOrderDomainService.exportRecOrder(queryParam);
        List<RecOrderEntity> records = recOrderDTOPagingVO.getRecords();
        if (CollUtil.isEmpty(records)) {
            return new PagingVO<>();
        }
        List<String> relOuCodes = records.stream().map(RecOrderEntity::getRelevanceOuCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relOuCodes);
        records.forEach(row -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(row.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                row.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return new PagingVO<>(recOrderDTOPagingVO.getTotal(), ExcelConvertUtils.convertLoosely(records, RecOrderEntity.class));
    }

    @Override
    public Integer pageSize() {
        return 1000;
    }
}
