package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_SALE_INV_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class DefaultSaleInvExportServiceImpl implements DataExport<SaleInvVO, SaleInvPageParam> {
    private final SaleInvDomainService saleInvDomainService;
    
    private final UdcProvider udcProvider;
    
    private final static Map<String, String> emptyMap = Map.of();
    @Override
    public String getTmplCode() {
        return FIN_SALE_INV_EXPORT_DEFAULT;
    }
    @Override
    public PagingVO<SaleInvVO> executeExport(SaleInvPageParam queryParam) {
        PagingVO<SaleInvDTO> page = saleInvDomainService.page(queryParam);
        if(page.isEmpty()) {
            return new PagingVO<>(0, List.of());
        }
        List<SaleInvDTO> records = page.getRecords();
        var docClsMap = getUdcMap("yst-supp", "DOC_CLS");
        var orderStateMap = getUdcMap("yst-supp", "APPLY_STATUS");
        var invTypeMap = getUdcMap("yst-fin", "INV_TYPE");
        var pushMethodMap = getUdcMap("yst-fin", "PUSH_METHOD");
        ExcelConverterManager.refresh();
        ArrayList<SaleInvVO> saleInvVOS = new ArrayList<>();
        for (SaleInvDTO record : records) {
            SaleInvVO saleInvVO = new SaleInvVO();
            ExcelConvertUtils.convertLoosely(record, saleInvVO);
            saleInvVO.setCreateModeName(docClsMap.get(record.getCreateMode()));
            saleInvVO.setOrderStateName(orderStateMap.get(record.getOrderState()));
            saleInvVO.setInvTypeName(invTypeMap.get(record.getInvType()));
            saleInvVO.setPushMethodName(pushMethodMap.get(record.getPushMethod()));
            saleInvVOS.add(saleInvVO);
        }
        return new PagingVO<>(page.getTotal(), saleInvVOS);
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
    
    private Map<String, String> getUdcMap(String appCode, String udcCode) {
        if(StringUtils.isBlank(appCode) || StringUtils.isBlank(udcCode)) {
            return emptyMap;
        }
        Map<String, String> valueMapByUdcCode = udcProvider.getValueMapByUdcCode(appCode, udcCode);
        return ObjectUtils.defaultIfNull(valueMapByUdcCode, emptyMap);
    }
}
