package com.elitesland.fin.application.service.expense;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.expense.ExpRuleConfigConvert;
import com.elitesland.fin.application.convert.expense.ExpRuleConfigDtlConvert;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDTO;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSaveParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSortParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigQueryVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigDtlVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigQueryVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.FinRedisConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.expense.ExpRuleConfigDomainService;
import com.elitesland.fin.domain.service.expense.ExpRuleConfigDtlDomainService;
import com.elitesland.fin.entity.expense.ExpRuleConfigDO;
import com.elitesland.fin.entity.expense.ExpRuleConfigDtlDO;
import com.elitesland.fin.repo.expense.ExpRuleConfigDtlRepo;
import com.elitesland.fin.repo.expense.ExpRuleConfigRepo;
import com.elitesland.fin.repo.expense.ExpRuleConfigRepoProc;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;


/**
 * @author Mark
 * @Date: 2024/8/13 13:23
 */

@Slf4j
@Service
@AllArgsConstructor
@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
public class ExpenseRuleConfigServiceImpl implements ExpenseRuleConfigService {

    public static final String PLUS = "+";
    private final ExpRuleConfigDomainService expRuleConfigDomainService;

    private final ExpRuleConfigDtlDomainService expRuleConfigDtlDomainService;

    private final RedissonClient redissonClient;

    private final ExpRuleConfigRepo expRuleConfigRepo;

    private final ExpRuleConfigDtlRepo expRuleConfigDtlRepo;

    private final UdcProvider udcProvider;

    private final AccountService accountService;
    private final RedisUtils redisUtils;
    private final ExpRuleConfigRepoProc expRuleConfigRepoProc;


    @Override
    @SysCodeProc
    public PagingVO<ExpRuleConfigPageVO> searchPage(ExpRuleConfigQueryParam param) {
        PagingVO<ExpRuleConfigPageVO> ExpRuleConfigPageVOPagingVO =
                expRuleConfigDomainService.searchPage(param);
        log.info("费用计算规则,分页查询结果:{}", JSONUtil.toJsonStr(ExpRuleConfigPageVOPagingVO));
       /* if (CollectionUtil.isNotEmpty(ExpRuleConfigPageVOPagingVO.getRecords())) {
            convertPage(ExpRuleConfigPageVOPagingVO.getRecords());
        }*/

        // pageCode2Name(ExpRuleConfigPageVOPagingVO.getRecords());
        var expTypeMap = udcProvider.getValueMapByUdcCode("yst-fin", "EXPENSES_TYPE");
        if (CollectionUtil.isNotEmpty(ExpRuleConfigPageVOPagingVO.getRecords())) {
            ExpRuleConfigPageVOPagingVO.getRecords().forEach(
                    e -> {
                        e.setExpTypeName(expTypeMap.get(e.getExpTypeCode()));
                        if ("FIXED_PERCENT".equals(e.getCalculateType())) {
                            e.setCalculateStrategy(e.getCalculatePercent());
                        } else if ("FIXED_AMT".equals(e.getCalculateType())) {
                            e.setCalculateStrategy(e.getUomAmt());
                        }
                    }
            );
        }
        return ExpRuleConfigPageVOPagingVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdate(ExpRuleConfigSaveParam param) {
        param.setEnableFlag(true);
        validateSaveOrUpdateParam(param);
        persistence(param);
        //   redisUtils.del(FinRedisConstant.ACCOUNT_RULE_CONFIG);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sort(List<ExpRuleConfigSortParam> param) {
        log.info("排序接口参数:{}", JSONUtil.toJsonStr(param));
        List<Long> ids = param.stream().map(BaseModelParam::getId).distinct().collect(Collectors.toList());
        Map<Long, Integer> idPriorityMap = param.stream().collect(Collectors.toMap(BaseModelParam::getId,
                ExpRuleConfigSortParam::getPriorityNo));
        List<ExpRuleConfigDO> data = expRuleConfigRepo.findAllById(ids);
        log.info("排序保存前参数1:{}", JSONUtil.toJsonStr(data));
        data.forEach(
                e -> {
                    if (idPriorityMap.containsKey(e.getId())) {
                        e.setPriorityNo(idPriorityMap.get(e.getId()));
                    }
                }
        );
        log.info("排序保存前参数2:{}", JSONUtil.toJsonStr(data));
        expRuleConfigRepo.saveAll(data);
    }

    private void persistence(ExpRuleConfigSaveParam param) {
        log.info("费用规则保存参数:{}", JSONUtil.toJsonStr(param));
        if (param.getId() == null) {
            checkExist(param);
            saveConfigAndDtl(param);
        } else {
            checkExistWhenUpdate(param);
            updateConfigAndDtl(param);
        }
    }

    private void checkExist(ExpRuleConfigSaveParam param) {
        List<ExpRuleConfigDO> expRuleConfigDOList;
        log.info("校验创建参数:{}", JSONUtil.toJsonStr(param));
        expRuleConfigDOList = expRuleConfigRepo.findAllByRuleCode(param.getRuleCode());
        if (CollectionUtils.isNotEmpty(expRuleConfigDOList)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigDOList.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("已经存在相同编码的规则，编码为:" + ruleCode + ",名称为:" + ruleName);
        }

        expRuleConfigDOList = expRuleConfigRepo.findAllByRuleName(param.getRuleName());
        if (CollectionUtils.isNotEmpty(expRuleConfigDOList)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigDOList.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("已经存在相同名称的规则，编码为:" + ruleCode + ",名称为:" + ruleName);
        }

    }

    private void checkExistWhenUpdate(ExpRuleConfigSaveParam param) {
        List<ExpRuleConfigDO> expRuleConfigDOList;
        log.info("校验编辑参数:{}", JSONUtil.toJsonStr(param));
        expRuleConfigDOList = expRuleConfigRepo.findAllByRuleCode(param.getRuleCode());
        expRuleConfigDOList =
                expRuleConfigDOList.stream().filter(e -> !e.getId().equals(param.getId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(expRuleConfigDOList)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigDOList.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("已经存在相同编码的规则，编码为:" + ruleCode + ",名称为:" + ruleName);
        }

        expRuleConfigDOList = expRuleConfigRepo.findAllByRuleName(param.getRuleName());
        expRuleConfigDOList =
                expRuleConfigDOList.stream().filter(e -> !e.getId().equals(param.getId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(expRuleConfigDOList)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigDOList.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("已经存在相同名称的规则，编码为:" + ruleCode + ",名称为:" + ruleName);
        }

    }

    private void checkRepeatData(ExpRuleConfigSaveParam param) {
       /* Map<Integer, String> seq = new HashMap();
        param.getExpRuleConfigDtlDTOList().stream().forEach(item -> {
            Assert.isNull(seq.get(item.getPriorityNo()), "优先级不能重复");
            seq.put(item.getPriorityNo(), "");
        });


        Set<String> repeatSet = new HashSet<>();
        param.getExpRuleConfigDtlDTOList().stream().forEach(item -> {

            Arrays.stream(item.getOptDocType().split(FinConstant.TRANSLATION_PLUS)).forEach(optDocType -> {
                if (StringUtils.isNotEmpty(item.getSpecificAccount())) {
                    Arrays.stream(item.getSpecificAccount().split(FinConstant.TRANSLATION_PLUS)).forEach
                            (specificAccount -> {
                                String uniqueKey =
                                        item.getIoCode().concat(optDocType).concat(item.getOptDocStatus()).concat(item
                                                .getOptAccountType()).concat(specificAccount);
                                Assert.isFalse(repeatSet.contains(uniqueKey), "存在重复规则," +
                                        "事务码、适用单据类型、适用单据状态、适用账户类型、指定账户需唯一");
                                repeatSet.add(uniqueKey);

                            });
                } else {
                    String uniqueKey =
                            item.getIoCode().concat(optDocType).concat(item.getOptDocStatus()).concat(item
                                    .getOptAccountType());
                    Assert.isFalse(repeatSet.contains(uniqueKey), "存在重复规则,事务码、适用单据类型、适用单据状态、适用账户类型、指定账户需唯一");
                    repeatSet.add(uniqueKey);
                }
            });
        });

        //判断空指定用和有指定用户重复的情况
        repeatSet.stream().forEach(item -> {
            repeatSet.stream().forEach(item1 -> {
                if (item.contains(item1) && !StringUtils.equals(item, item1)) {
                    Assert.isTrue(false, "存在重复规则,事务码、适用单据类型、适用单据状态、指定账户需唯一");
                }
            });
        });*/
    }

    private void updateConfigAndDtl(ExpRuleConfigSaveParam param) {
        ExpRuleConfigDO expRuleConfigDO =
                expRuleConfigRepo.findById(param.getId()).orElseThrow(new BusinessException("该单据不存在"));
        BeanUtil.copyProperties(param, expRuleConfigDO);  //ExpRuleConfigConvert.INSTANCE.param2DO(param);
        String expElement = getExpElement(param);
        //  checkSameElementOnUpdate(param.getExpTypeCode(), expElement, param.getId());
        expRuleConfigDO.setExpElement(expElement);
        log.info("保存前参数:{}", JSONUtil.toJsonStr(expRuleConfigDO));
        expRuleConfigRepo.save(expRuleConfigDO);

        //用于防止参数中重复元素
        List<String> usedRangeCode = new ArrayList<>();
        List<ExpRuleConfigDtlDO> expRuleConfigDtlDOS = new ArrayList<>();
        for (ExpRuleConfigDtlDTO dtlDTO : param.getExpRuleConfigDtlDTOList()) {
            for (ExpRuleConfigDtlDTO.RangeObject rangeObject : dtlDTO.getRangeObjects()) {
                if (usedRangeCode.contains(rangeObject.getRangeCode())) {
                    continue;
                }
                ExpRuleConfigDtlDO expRuleConfigDtlDO = new ExpRuleConfigDtlDO();
                expRuleConfigDtlDO.setMasId(expRuleConfigDO.getId());
                expRuleConfigDtlDO.setRangeId(rangeObject.getRangeId());
                expRuleConfigDtlDO.setRangeCode(rangeObject.getRangeCode());
                expRuleConfigDtlDO.setRangeName(rangeObject.getRangeName());
                expRuleConfigDtlDO.setRangeType(dtlDTO.getRangeType());
                expRuleConfigDtlDOS.add(expRuleConfigDtlDO);
                usedRangeCode.add(rangeObject.getRangeCode());
            }
        }
        log.info("明细保存前参数:{}", JSONUtil.toJsonStr(expRuleConfigDtlDOS));
        if (CollUtil.isNotEmpty(expRuleConfigDtlDOS)) {
            expRuleConfigDtlDomainService.deleteByParam(getQueryBeanByMasId(expRuleConfigDO.getId()));
            expRuleConfigDtlRepo.saveAll(expRuleConfigDtlDOS);
        }
    }

    private Integer getPriorityNo(String expTypeCode) {
        List<ExpRuleConfigDO> allExpRuleConfig = expRuleConfigRepoProc.getAllExpRuleConfig(expTypeCode);
        Optional<Integer> max =
                allExpRuleConfig.stream().map(ExpRuleConfigDO::getPriorityNo).filter(Objects::nonNull).max(Integer::compareTo);
        return max.orElse(0);
    }

    //同一个费用类型下  排序元素不能重复
    private void checkSameElementOnSave(String expTypeCode, String expElement) {
        List<ExpRuleConfigDO> expRuleConfigByExpTypeAndElement =
                expRuleConfigRepoProc.findExpRuleConfigByExpTypeAndElement(expTypeCode, expElement);
        if (CollUtil.isNotEmpty(expRuleConfigByExpTypeAndElement)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigByExpTypeAndElement.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("已经存在相同排序元素的规则，编码为:" + ruleCode + ",名称为:" + ruleName);
        }
    }

    private void checkSameElementOnUpdate(String expTypeCode, String expElement, Long id) {
        List<ExpRuleConfigDO> expRuleConfigByExpTypeAndElement =
                expRuleConfigRepoProc.findExpRuleConfigByExpTypeAndElement(expTypeCode, expElement);
        expRuleConfigByExpTypeAndElement =
                expRuleConfigByExpTypeAndElement.stream().filter(e -> !e.getId().equals(id)).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(expRuleConfigByExpTypeAndElement)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigByExpTypeAndElement.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("已经存在相同排序元素的规则，编码为:" + ruleCode + ",名称为:" + ruleName);
        }
    }


    private Long saveConfigAndDtl(ExpRuleConfigSaveParam param) {
        ExpRuleConfigDO expRuleConfigDO = ExpRuleConfigConvert.INSTANCE.param2DO(param);
        String expElement = getExpElement(param);
        // checkSameElementOnSave(param.getExpTypeCode(), expElement);
        expRuleConfigDO.setExpElement(expElement);
        Integer priorityNo = getPriorityNo(param.getExpTypeCode());
        expRuleConfigDO.setPriorityNo(priorityNo + 1);
        log.info("保存前参数:{}", JSONUtil.toJsonStr(expRuleConfigDO));
        expRuleConfigRepo.save(expRuleConfigDO);

        //用于防止参数中重复元素
        List<String> usedRangeCode = new ArrayList<>();
        List<ExpRuleConfigDtlDO> expRuleConfigDtlDOS = new ArrayList<>();
        for (ExpRuleConfigDtlDTO dtlDTO : param.getExpRuleConfigDtlDTOList()) {
            for (ExpRuleConfigDtlDTO.RangeObject rangeObject : dtlDTO.getRangeObjects()) {
                if (usedRangeCode.contains(rangeObject.getRangeCode())) {
                    continue;
                }
                ExpRuleConfigDtlDO expRuleConfigDtlDO = new ExpRuleConfigDtlDO();
                expRuleConfigDtlDO.setMasId(expRuleConfigDO.getId());
                expRuleConfigDtlDO.setRangeId(rangeObject.getRangeId());
                expRuleConfigDtlDO.setRangeCode(rangeObject.getRangeCode());
                expRuleConfigDtlDO.setRangeName(rangeObject.getRangeName());
                expRuleConfigDtlDO.setRangeType(dtlDTO.getRangeType());
                expRuleConfigDtlDOS.add(expRuleConfigDtlDO);
                usedRangeCode.add(rangeObject.getRangeCode());
            }
        }
        log.info("明细保存前参数:{}", JSONUtil.toJsonStr(expRuleConfigDtlDOS));
        if (CollUtil.isNotEmpty(expRuleConfigDtlDOS)) {
            expRuleConfigDtlDomainService.deleteByParam(getQueryBeanByMasId(expRuleConfigDO.getId()));
            expRuleConfigDtlRepo.saveAll(expRuleConfigDtlDOS);
        }
        return expRuleConfigDO.getId();
    }

    private String getExpElement(ExpRuleConfigSaveParam param) {
        String calculateType = param.getCalculateType();
        String rangeTypeStr =
                param.getExpRuleConfigDtlDTOList().stream().map(ExpRuleConfigDtlDTO::getRangeType).collect(Collectors.joining(PLUS));
        return calculateType + PLUS + rangeTypeStr;
    }

    private void validateSaveOrUpdateParam(ExpRuleConfigSaveParam param) {
        Assert.notEmpty(param.getRuleCode(), "规则编码必填");
        Assert.notEmpty(param.getRuleName(), "规则名称必填");
        Assert.notEmpty(param.getExpTypeCode(), "费用类型必填");
        Assert.notEmpty(param.getCalculateType(), "计算方式必填");
        Assert.notNull(param.isAutomaticReview(), "台账自动审核必填");
        Assert.notNull(param.getValidDate(), "生效日期必填");
        Assert.notNull(param.getEnableFlag(), "是否启用必填");

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void del(Long id) {
        Optional<ExpRuleConfigDO> expRuleConfigDOOptional = expRuleConfigDomainService.findById(id);
        String expTypeCode = null;
        if (expRuleConfigDOOptional.isPresent()) {
            //   ExpRuleConfigDO dbSceneConfig = expRuleConfigDOOptional.get();
            //  expRuleConfigDtlDomainService.deleteByCondition(getQueryBeanByMasId(id));
            expRuleConfigDomainService.deleteById(id);
            // removeCache(dbSceneConfig.getRuleCode());
            //     redisUtils.del(FinRedisConstant.ACCOUNT_RULE_CONFIG);
            expTypeCode = expRuleConfigDOOptional.get().getExpTypeCode();

            //重新获取规则数据,按1开始进行优先级重排序
            List<ExpRuleConfigDO> all = expRuleConfigRepoProc.getAllExpRuleConfig(expTypeCode);
            List<ExpRuleConfigDO> sortedList = all.stream()
                    .sorted(Comparator.comparing(ExpRuleConfigDO::getPriorityNo,
                            Comparator.nullsLast(Comparator.naturalOrder())))
                    .collect(Collectors.toList());
            log.info("全局重新排序后1:{}", JSONUtil.toJsonStr(sortedList));
            updatePriorityNo(sortedList);
        }

    }

    public void updatePriorityNo(List<ExpRuleConfigDO> sortedList) {
        for (int i = 0; i < sortedList.size(); i++) {
            sortedList.get(i).setPriorityNo(i + 1);
        }
        log.info("全局重新排序后2:{}", JSONUtil.toJsonStr(sortedList));
        expRuleConfigRepo.saveAll(sortedList);
    }

    private ExpRuleConfigDtlDO getQueryBeanByMasId(Long id) {
        ExpRuleConfigDtlDO whereBean = new ExpRuleConfigDtlDO();
        whereBean.setMasId(id);
        return whereBean;
    }

    @Override
    @SysCodeProc
    public ExpRuleConfigQueryVO detail(Long id) {
        Optional<ExpRuleConfigDO> dbConfig = expRuleConfigRepo.findById(id);
        if (dbConfig.isEmpty()) {
            return null;
        }
        ExpRuleConfigQueryVO queryVO = ExpRuleConfigConvert.INSTANCE.do2VO(dbConfig.get());
        log.info("费用计算规则详情:{}", JSONUtil.toJsonStr(queryVO));
       /* List<ExpRuleConfigDtlDO> all = expRuleConfigDtlDomainService.findExpRuleConfigDtlByMasId(masId);
        List<ExpRuleConfigDtlVO> expRuleConfigDtlVoList = ExpRuleConfigDtlConvert.INSTANCE.do2VOList(all);

        detailCode2Name(expRuleConfigDtlVoList);
          queryVO.setExpRuleConfigDtlVoList(expRuleConfigDtlVoList);*/
        var calTypeMap = udcProvider.getValueMapByUdcCode("yst-fin", "CAL_TYPE");
        queryVO.setExpTypeName(calTypeMap.get(queryVO.getExpTypeCode()));

        List<ExpRuleConfigDtlDTO> expRuleConfigDtlDTOList = new ArrayList<>();
        List<ExpRuleConfigDtlDO> dtlData = expRuleConfigDtlDomainService.findExpRuleConfigDtlByMasId(id);
        Map<String, List<ExpRuleConfigDtlDO>> groupedData =
                dtlData.stream().collect(Collectors.groupingBy(ExpRuleConfigDtlDO::getRangeType));
        log.info("规则明细分组数据:{}", JSONUtil.toJsonStr(groupedData));
        for (Map.Entry<String, List<ExpRuleConfigDtlDO>> entry : groupedData.entrySet()) {
            ExpRuleConfigDtlDTO expRuleConfigDtlDTO = new ExpRuleConfigDtlDTO();
            String rangeType = entry.getKey();
            expRuleConfigDtlDTO.setRangeType(rangeType);
            List<ExpRuleConfigDtlDTO.RangeObject> rangeObjects = new ArrayList<>();
            for (ExpRuleConfigDtlDO expRuleConfigDtlDO : entry.getValue()) {
                ExpRuleConfigDtlDTO.RangeObject objectDTO = new ExpRuleConfigDtlDTO.RangeObject();
                objectDTO.setRangeId(expRuleConfigDtlDO.getRangeId());
                objectDTO.setRangeCode(expRuleConfigDtlDO.getRangeCode());
                objectDTO.setRangeName(expRuleConfigDtlDO.getRangeName());
                rangeObjects.add(objectDTO);
            }
            expRuleConfigDtlDTO.setRangeObjects(rangeObjects);
            expRuleConfigDtlDTOList.add(expRuleConfigDtlDTO);
        }
        queryVO.setExpRuleConfigDtlDTOList(expRuleConfigDtlDTOList);

        return queryVO;
    }

    @Override
    @SysCodeProc
    public List<ExpRuleConfigQueryVO> getList(String code) {
        List<ExpRuleConfigDO> allExpRuleConfig = expRuleConfigRepoProc.getAllExpRuleConfig(code);
        List<Long> ruleIds = allExpRuleConfig.stream().map(BaseModel::getId).collect(Collectors.toList());
        log.info("所有状态的规则数据:{}", JSONUtil.toJsonStr(allExpRuleConfig));
        List<ExpRuleConfigQueryVO> dataToReturn = ExpRuleConfigConvert.INSTANCE.do2VOBatch(allExpRuleConfig);
        log.info("添加详情前:{}", JSONUtil.toJsonStr(dataToReturn));


        List<ExpRuleConfigDtlDO> dtlData = expRuleConfigDtlDomainService.findExpRuleConfigDtlByMasIdsIn(ruleIds);
        Map<Long, List<ExpRuleConfigDtlDO>> groupByMasId = dtlData.stream().collect(Collectors.groupingBy(ExpRuleConfigDtlDO::getMasId));
        log.info("规则明细数据,按规则id分组:{}",JSONUtil.toJsonStr(groupByMasId));

        for (ExpRuleConfigQueryVO expRuleConfigQueryVO : dataToReturn) {
            List<ExpRuleConfigDtlDTO> expRuleConfigDtlDTOList = new ArrayList<>();
            List<ExpRuleConfigDtlDO> dtlDOS = groupByMasId.get(expRuleConfigQueryVO.getId());
            expRuleConfigQueryVO.setExpElementName(getElementName(expRuleConfigQueryVO.getExpElement()));
            if (CollUtil.isEmpty(dtlDOS)) {
                continue;
            }
            Map<String, List<ExpRuleConfigDtlDO>> groupedData =
                    dtlDOS.stream().collect(Collectors.groupingBy(ExpRuleConfigDtlDO::getRangeType));
            log.info("规则明细按条件分组数据:{}", JSONUtil.toJsonStr(groupedData));
            for (Map.Entry<String, List<ExpRuleConfigDtlDO>> entry : groupedData.entrySet()) {
                ExpRuleConfigDtlDTO expRuleConfigDtlDTO = new ExpRuleConfigDtlDTO();
                String rangeType = entry.getKey();
                expRuleConfigDtlDTO.setRangeType(rangeType);
                List<ExpRuleConfigDtlDTO.RangeObject> rangeObjects = new ArrayList<>();
                for (ExpRuleConfigDtlDO expRuleConfigDtlDO : entry.getValue()) {
                    ExpRuleConfigDtlDTO.RangeObject objectDTO = new ExpRuleConfigDtlDTO.RangeObject();
                    objectDTO.setRangeId(expRuleConfigDtlDO.getRangeId());
                    objectDTO.setRangeCode(expRuleConfigDtlDO.getRangeCode());
                    objectDTO.setRangeName(expRuleConfigDtlDO.getRangeName());
                    rangeObjects.add(objectDTO);
                }
                expRuleConfigDtlDTO.setRangeObjects(rangeObjects);
                expRuleConfigDtlDTOList.add(expRuleConfigDtlDTO);
            }
            expRuleConfigQueryVO.setExpRuleConfigDtlDTOList(expRuleConfigDtlDTOList);
        }
        log.info("添加详情后:{}", JSONUtil.toJsonStr(dataToReturn));
        // 按 priorityNo 排序，数字越小排在前面
        List<ExpRuleConfigQueryVO> sortedData = dataToReturn.stream()
                .sorted(Comparator.comparingInt(ExpRuleConfigQueryVO::getPriorityNo)) // 根据 priorityNo 排序
                .collect(Collectors.toList());
        return sortedData;
    }

    @Override
    @SysCodeProc
    public List<ExpRuleConfigQueryVO> getListByParam(ExpRuleConfigQueryParam param){
        List<ExpRuleConfigDO> allExpRuleConfig = expRuleConfigRepoProc.getAllExpRuleConfigByParam(param);
        List<Long> ruleIds = allExpRuleConfig.stream().map(BaseModel::getId).collect(Collectors.toList());
        log.info("所有状态的规则数据:{}", JSONUtil.toJsonStr(allExpRuleConfig));
        List<ExpRuleConfigQueryVO> dataToReturn = ExpRuleConfigConvert.INSTANCE.do2VOBatch(allExpRuleConfig);
        log.info("添加详情前:{}", JSONUtil.toJsonStr(dataToReturn));


        List<ExpRuleConfigDtlDO> dtlData = expRuleConfigDtlDomainService.findExpRuleConfigDtlByMasIdsIn(ruleIds);
        Map<Long, List<ExpRuleConfigDtlDO>> groupByMasId = dtlData.stream().collect(Collectors.groupingBy(ExpRuleConfigDtlDO::getMasId));
        log.info("规则明细数据,按规则id分组:{}",JSONUtil.toJsonStr(groupByMasId));

        for (ExpRuleConfigQueryVO expRuleConfigQueryVO : dataToReturn) {
            List<ExpRuleConfigDtlDTO> expRuleConfigDtlDTOList = new ArrayList<>();
            List<ExpRuleConfigDtlDO> dtlDOS = groupByMasId.get(expRuleConfigQueryVO.getId());
            expRuleConfigQueryVO.setExpElementName(getElementName(expRuleConfigQueryVO.getExpElement()));
            if (CollUtil.isEmpty(dtlDOS)) {
                continue;
            }
            Map<String, List<ExpRuleConfigDtlDO>> groupedData =
                    dtlDOS.stream().collect(Collectors.groupingBy(ExpRuleConfigDtlDO::getRangeType));
            log.info("规则明细按条件分组数据:{}", JSONUtil.toJsonStr(groupedData));
            for (Map.Entry<String, List<ExpRuleConfigDtlDO>> entry : groupedData.entrySet()) {
                ExpRuleConfigDtlDTO expRuleConfigDtlDTO = new ExpRuleConfigDtlDTO();
                String rangeType = entry.getKey();
                expRuleConfigDtlDTO.setRangeType(rangeType);
                List<ExpRuleConfigDtlDTO.RangeObject> rangeObjects = new ArrayList<>();
                for (ExpRuleConfigDtlDO expRuleConfigDtlDO : entry.getValue()) {
                    ExpRuleConfigDtlDTO.RangeObject objectDTO = new ExpRuleConfigDtlDTO.RangeObject();
                    objectDTO.setRangeId(expRuleConfigDtlDO.getRangeId());
                    objectDTO.setRangeCode(expRuleConfigDtlDO.getRangeCode());
                    objectDTO.setRangeName(expRuleConfigDtlDO.getRangeName());
                    rangeObjects.add(objectDTO);
                }
                expRuleConfigDtlDTO.setRangeObjects(rangeObjects);
                expRuleConfigDtlDTOList.add(expRuleConfigDtlDTO);
            }
            expRuleConfigQueryVO.setExpRuleConfigDtlDTOList(expRuleConfigDtlDTOList);
        }
        log.info("添加详情后:{}", JSONUtil.toJsonStr(dataToReturn));
        // 按 priorityNo 排序，数字越小排在前面
        List<ExpRuleConfigQueryVO> sortedData = dataToReturn.stream()
                .sorted(Comparator.comparingInt(ExpRuleConfigQueryVO::getPriorityNo)) // 根据 priorityNo 排序
                .collect(Collectors.toList());
        return sortedData;
    }

    private String getElementName(String element) {
        if (element == null || element.isEmpty()) {
            return "";
        }
        return Arrays.stream(element.split("\\+"))
                .map(key -> ExpenseConstant.elementNameMapping.getOrDefault(key, key))
                .collect(Collectors.joining("+"));
    }

    @Override
    public List<ExpRuleConfigQueryVO> getExpTypeList() {
        List<ExpRuleConfigDO> allEnableExpRuleConfig = expRuleConfigRepoProc.getAllEnableExpRuleConfig();
        log.info("所有启用状态的规则数据:{}", JSONUtil.toJsonStr(allEnableExpRuleConfig));
        List<ExpRuleConfigDO> distinctExpRuleConfig = allEnableExpRuleConfig.stream()
                .collect(Collectors.collectingAndThen(
                        Collectors.toMap(ExpRuleConfigDO::getExpTypeCode, expRuleConfig -> expRuleConfig, (existing,
                                                                                                           replacement) -> existing),
                        map -> new ArrayList<>(map.values())
                ));
        distinctExpRuleConfig =
                distinctExpRuleConfig.stream()
                        .sorted(Comparator.comparingInt(ExpRuleConfigDO::getPriorityNo))
                        .collect(Collectors.toList());

        return ExpRuleConfigConvert.INSTANCE.do2VOBatch(distinctExpRuleConfig);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateEnableFlag(List<Long> ids, boolean enable) {
        List<ExpRuleConfigDO> configDOList = expRuleConfigDomainService.findByIds(ids);
        if (enable) {
            checkEnableRule(configDOList);
        }
        if (!enable) {
            checkStopRule(configDOList);
        }
        Boolean res = expRuleConfigDomainService.updateEnableFlag(ids, enable);
    }

    public void detailCode2Name(List<ExpRuleConfigDtlVO> expRuleConfigDtlVOList) {
        //单据类型
        Map<String, String> docClsUdc = udcProvider.getValueMapByUdcCode(UdcEnum.DOC_CLS_SO_C.getModel(),
                UdcEnum.DOC_CLS_SO_C.getCode());
        //订单状态
        Map<String, String> docStatusUdc = udcProvider.getValueMapByUdcCode(UdcEnum.DOC_STATUS_RSO_CL.getModel(),
                UdcEnum.DOC_STATUS_RSO_CL.getCode());
        //适用账户类型
        Map<String, String> accountTypeUdc = udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(),
                UdcEnum.ACCOUNT_TYPE_STORE.getCode());

        //根据账户编码获取账户信息
        Set<String> accountCodeSet = new HashSet<>();
        expRuleConfigDtlVOList.stream().forEach(item -> {
            if (StringUtils.isNotEmpty(item.getSpecificAccount())) {
                String[] specificAccountArray = item.getSpecificAccount().split(FinConstant.TRANSLATION_PLUS);
                Arrays.stream(specificAccountArray).forEach(specificAccount -> accountCodeSet.add(specificAccount));
            }
        });

        List<AccountDTO> accountDTOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(accountCodeSet)) {
            AccountParam accountParam = new AccountParam();
            accountParam.setAccountCodes(accountCodeSet);

            accountDTOList = accountService.getAccountByAccountParam(accountParam);
            Assert.notEmpty(accountDTOList, "查询账户名称失败");
        }


        //设置单据类型名称
        //设置指定账户名称
        List<String> optDocTypeList = new ArrayList<>();
        List<String> specificAccountList = new ArrayList<>();
        List<AccountDTO> finalAccountDTOList = accountDTOList;
        expRuleConfigDtlVOList.stream().forEach(item -> {
            optDocTypeList.clear();
            specificAccountList.clear();

            String[] optDocTypeArray = item.getOptDocType().split(FinConstant.TRANSLATION_PLUS);
            Arrays.stream(optDocTypeArray).forEach(optDocType -> {
                optDocTypeList.add(docClsUdc.get(optDocType));
            });

            if (StringUtils.isNotEmpty(item.getSpecificAccount())) {
                String[] specificAccountArray = item.getSpecificAccount().split(FinConstant.TRANSLATION_PLUS);
                Arrays.stream(specificAccountArray).forEach(specificAccount -> {
                    AccountDTO result = finalAccountDTOList.stream()
                            .filter(accountVO -> specificAccount.equals(accountVO.getAccountCode()))
                            .findFirst()
                            .orElse(null);
                    if (result != null) {
                        specificAccountList.add(result.getAccountName());
                    }
                });
            }


            item.setOptDocTypeName(joinedWithPlus(optDocTypeList));

            if (CollectionUtils.isNotEmpty(specificAccountList)) {
                item.setSpecificAccountName(joinedWithPlus(specificAccountList));
            }

            item.setOptDocStatusName(docStatusUdc.get(item.getOptDocStatus()));
            item.setOptAccountTypeName(accountTypeUdc.get(item.getOptAccountType()));
        });
    }

    public void pageCode2Name(List<ExpRuleConfigPageVO> expRuleConfigPageVOList) {
       /* //单据类型
        Map<String, String> docClsUdc = udcProvider.getValueMapByUdcCode(UdcEnum.DOC_CLS_SO_C.getModel(),
                UdcEnum.DOC_CLS_SO_C.getCode());
        //订单状态
        Map<String, String> docStatusUdc = udcProvider.getValueMapByUdcCode(UdcEnum.DOC_STATUS_RSO_CL.getModel(),
                UdcEnum.DOC_STATUS_RSO_CL.getCode());

        //设置单据类型名称
        List<String> optDocTypeList = new ArrayList<>();
        expRuleConfigPageVOList.stream().forEach(item -> {
            optDocTypeList.clear();

            String[] optDocTypeArray = item.getOptDocType().split(FinConstant.TRANSLATION_PLUS);
            Arrays.stream(optDocTypeArray).forEach(optDocType -> {
                optDocTypeList.add(docClsUdc.get(optDocType));
            });

            item.setOptDocTypeName(joinedWithPlus(optDocTypeList));
            item.setOptDocStatusName(docStatusUdc.get(item.getOptDocStatus()));
        });*/
    }

    private String joinedWithPlus(List<String> param) {
        return StringUtils.join(param, FinConstant.PLUS);
    }

    private void removeCache(String ruleCode) {
        RBucket<AccountRuleConfigQueryVO> bucket =
                redissonClient.getBucket(FinRedisConstant.RULE_CONFIG_KEY + ruleCode);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    @Override
    public ExpRuleConfigDTO getByRuleCode(String ruleCode) {
        RBucket<ExpRuleConfigDTO> bucket = redissonClient.getBucket(FinRedisConstant.RULE_CONFIG_KEY + ruleCode);
        if (bucket.isExists()) {
            return bucket.get();
        }
        var dbConfig = expRuleConfigDomainService.findByRuleCode(ruleCode);
        if (dbConfig != null) {
            Example<ExpRuleConfigDtlDO> dtlExample = Example.of(getQueryBeanByMasId(dbConfig.getId()));
            List<ExpRuleConfigDtlDO> all = expRuleConfigDtlDomainService.findAll(dtlExample);
            List<ExpRuleConfigDtlDTO> expRuleConfigDtls = ExpRuleConfigDtlConvert.INSTANCE.do2DTOList(all);
            dbConfig.setExpRuleConfigDtlDTOList(expRuleConfigDtls);
            bucket.set(dbConfig);
            return dbConfig;
        }
        return null;
    }

    @Override
    public PagingVO<ExpRuleConfigPageVO> searchPageWithOutName(ExpRuleConfigQueryParam param) {
        PagingVO<ExpRuleConfigPageVO> expRuleConfigPageVOPagingVO =
                expRuleConfigDomainService.searchPage(param);

        if (CollectionUtil.isNotEmpty(expRuleConfigPageVOPagingVO.getRecords())) {
            convertPage(expRuleConfigPageVOPagingVO.getRecords());
        }

        pageCode2Name(expRuleConfigPageVOPagingVO.getRecords());

        return expRuleConfigPageVOPagingVO;
    }

    private void convertPage(List<ExpRuleConfigPageVO> expRuleConfigDtls) {
        /*List<AccountIocDTO> accountIocNameList =
                accountIocDomainService.findByCodeBatch(expRuleConfigDtls.stream().map
                        (ExpRuleConfigPageVO::getIoCode).collect(Collectors.toList()));
        Map<String, String> ioCodeMap = new HashMap<>();
        Map<String, String> ioTypeMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(accountIocNameList)) {
            ioTypeMap = accountIocNameList.stream().collect(Collectors.toMap(AccountIocDTO::getIoType,
                    i -> i.getIoTypeName() == null ? "" : i.getIoTypeName(), (key1, key2) -> key2));
            ioCodeMap = accountIocNameList.stream().collect(Collectors.toMap(AccountIocDTO::getIoCode,
                    i -> i.getIoName() == null ? "" : i.getIoName(), (key1, key2) -> key2));
        }
        for (ExpRuleConfigPageVO configDtl : expRuleConfigDtls) {
            if (StringUtils.isNotBlank(configDtl.getIoCode())) {
                configDtl.setIoName(ioCodeMap.get(configDtl.getIoCode()));
            }
        }*/
    }

    /**
     * 停用状态校验
     */
    private void checkStopRule(List<ExpRuleConfigDO> configDOList) {
        for (ExpRuleConfigDO expRuleConfigDO : configDOList) {
            // 停用需是启用状态
            if (!expRuleConfigDO.getEnableFlag()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,
                        "已停用状态不能再停用");
            }
        }
    }

    /**
     * 启用状态校验
     */
    private void checkEnableRule(List<ExpRuleConfigDO> configDOList) {

        for (ExpRuleConfigDO expRuleConfigDO : configDOList) {
            // 启用需是停用状态
            if (expRuleConfigDO.getEnableFlag()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,
                        "已启用状态不能再启动");
            }
            // 启用需校验已分配公司
           /* List<ArTypeOuDTO> arTypeOuDTOS = expTypeOuDomainService.queryByArTypeId(expTypeDTO.getId());
            if (CollUtil.isEmpty(arTypeOuDTOS)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,
                        "类型代码" + expTypeDTO.getArTypeCode() + "启用前需要分配公司");
            }*/

        }

    }
}

