package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlConvert;
import com.elitesland.fin.application.convert.artype.ArTypeDtlConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderDtlConvert;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyConvert;
import com.elitesland.fin.application.facade.dto.writeoff.*;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlExPageParam;
import com.elitesland.fin.application.facade.param.arorder.FinArOrderDetailQuery;
import com.elitesland.fin.application.facade.param.recorder.FinRecOrderDetailQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyArQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyRecQuery;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlVO;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.facade.vo.arorder.WriteoffVO;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderDtlVO;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.facade.vo.writeoff.*;
import com.elitesland.fin.application.service.arorder.ArOrderDtlService;
import com.elitesland.fin.application.service.arorder.ArOrderExService;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.recorder.RecOrderDtlService;
import com.elitesland.fin.application.service.recorder.RecOrderExService;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.common.*;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.entity.artype.ArTypeDtl;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyDO;
import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderDtlPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arverconfig.ArVerConfigDomainService;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.ThreadLocalCopyUtil;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FinArRecVerApplyServiceImpl implements FinArRecVerApplyService {

    private final UdcProvider udcProvider;
    private final FinArRecVerApplyRepoProc finArRecVerApplyRepoProc;
    private final FinArRecVerApplyArService finArRecVerApplyArService;
    private final FinArRecVerApplyArHeadService finArRecVerApplyArHeadService;
    private final FinArRecVerApplyRecService finArRecVerApplyRecService;
    private final FinArRecVerApplyRecHeadService finArRecVerApplyRecHeadService;
    private final SeqNumProvider seqNumProvider;
    //private final FinArRecVerRpcService finArRecVerRpcService;

    private final FinArRecVerLocalService finArRecVerLocalService;
    private final ArOrderExService arOrderExService;
    private final RecOrderExService recOrderExService;
    private final FinArRecVerApplySettleService finArRecVerApplySettleService;
    private final OperationLogService operationLogService;
    private final ThreadLocalCopyUtil threadLocalCopyUtil;
    private final ArOrderDtlService arOrderDtlService;
    private final RecOrderDtlService recOrderDtlService;

    private final RecOrderService recOrderService;
    private final ArVerConfigDomainService arVerConfigDomainService;
    private final ArVerConfigDtlRepoProc arVerConfigDtlRepoProc;
    private final ArOrderDomainService arOrderDomainService;
    private final RecOrderDomainService recOrderDomainService;
    public static final ThreadLocal<String> CURRENT_USER = new ThreadLocal<>();
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    //@Value("${sync.tenantCode}")
    //private String tenantCode;
    private ArOrderService arOrderService;
    @Autowired
    @Lazy
    public void setArOrderService(ArOrderService arOrderService) {
        this.arOrderService = arOrderService;
    }

    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderDtlRepo arOrderDtlRepo;

    private final RecOrderRepoProc recOrderRepoProc;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(FinArRecVerApplySaveDTO save) {
        if (save.getId() == null) {
            return doCreate(save);
        } else {
            return doUpdate(save);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long submit(FinArRecVerApplySaveDTO save) {

        verifyDataNew(save);

        save.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode());
        Long id = this.save(save);
        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, id.toString(), OperationTypeEnum.APPROVE_SUBMIT,
            BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_SUBMIT));

        updateArMiddleVerAmt(save.getArSaveList());
        updateRecMiddleVerAmt(save.getRecSaveList());

        finArRecVerApplySettleService.createBatch(id, settleApplyDetailListNew(save.getArSaveList(), save.getRecSaveList()));
        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long writeOffSubmit(FinArRecVerApplySaveDTO save) {

        checkWriteOffParamNew(save);

        //金额分摊
        buildArAndRecSaveList(save);

        save.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode());
        Long id = saveFinArRecVerApply(save);

        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, id.toString(), OperationTypeEnum.APPROVE_SUBMIT,
            BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_SUBMIT));

        List<FinArRecVerApplyArSaveDTO> finArRecVerApplyArSaveDTOList = save.getArHeadSaveList().stream()
                .flatMap(item -> item.getArSaveList().stream())
                .collect(Collectors.toList());

        List<FinArRecVerApplyRecSaveDTO> finArRecVerApplyRecSaveDTOList = save.getRecHeadSaveList().stream()
                .flatMap(item -> item.getRecSaveList().stream())
                .collect(Collectors.toList());

        updateArMiddleVerAmt(finArRecVerApplyArSaveDTOList);
        updateRecMiddleVerAmt(finArRecVerApplyRecSaveDTOList);

        List<FinArRecVerApplySettleSaveDTO> finArRecVerApplySettleSaveDTOList = settleApplyDetailListNew(finArRecVerApplyArSaveDTOList, finArRecVerApplyRecSaveDTOList);
        finArRecVerApplySettleSaveDTOList.forEach(finArRecVerApplySettleSaveDTO -> {
            finArRecVerApplySettleSaveDTO.setOuId(save.getOuId());
            finArRecVerApplySettleSaveDTO.setOuCode(save.getOuCode());
            finArRecVerApplySettleSaveDTO.setOuName(save.getOuName());
        });

        finArRecVerApplySettleService.createBatch(id, finArRecVerApplySettleSaveDTOList);
        save.setId(id);
        //审核
        FinArRecApplyApprovalDTO dto = new FinArRecApplyApprovalDTO();
        ArrayList<String> applyNos=new ArrayList<>();
        applyNos.add(save.getApplyDocNo());
        dto.setApplyNos(applyNos);
        dto.setApprovalType(FinArRecApplyApprovalDTO.ApprovalType.APPROVE);
        this.writeOffApprove(dto);

        //更新应收单\收款单核销状态
        handleVerState(finArRecVerApplyArSaveDTOList,finArRecVerApplyRecSaveDTOList);

        return id;
    }

    private void handleVerState(List<FinArRecVerApplyArSaveDTO> arVOList,List<FinArRecVerApplyRecSaveDTO> recVOList){

        // 更新应收单核销状态
        List<Long> arIdList = arVOList.stream().map(FinArRecVerApplyArSaveDTO::getArId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> arDtlIdList = arVOList.stream().map(FinArRecVerApplyArSaveDTO::getArDId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        List<ArOrderDTO> arOrderAllList = arOrderRepoProc.queryByIds(arIdList);
        //List<ArOrderDtlDTO> arOrderDtlAllList = arOrderDtlRepoProc.listByMasIds(arDtlIdList);
        List<ArOrderDtlDTO> arOrderDtlAllList = arOrderDtlRepoProc.listByIds(arDtlIdList);

        Map<Long, List<ArOrderDtlDTO>> arOrderDtlMap = CollectionUtil.isEmpty(arOrderDtlAllList) ? new HashMap<>() : arOrderDtlAllList.stream().collect(Collectors.groupingBy(ArOrderDtlDTO::getMasId));
        if (CollectionUtil.isNotEmpty(arOrderAllList)){
            for (ArOrderDTO arOrderDTO : arOrderAllList) {
                List<ArOrderDtlDTO> arOrderDtlList = arOrderDtlMap.get(arOrderDTO.getId());
                updateArVerState(arOrderDTO,arOrderDtlList);
            }

        }


        // 更新收款单核销状态
        List<Long> recIdList = recVOList.stream().map(FinArRecVerApplyRecSaveDTO::getRecId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> recDtlIdList = recVOList.stream().map(FinArRecVerApplyRecSaveDTO::getRecDId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        List<RecOrderDTO> recOrderAllList = recOrderRepoProc.queryByIds(recIdList);
        //List<RecOrderDtlDTO> recOrderDtlAllList = recOrderDtlRepoProc.queryByMasIds(recDtlIdList);
        List<RecOrderDtlDTO> recOrderDtlAllList = recOrderDtlRepoProc.queryByIds(recDtlIdList);

        Map<Long, List<RecOrderDtlDTO>> recOrderDtlMap = CollectionUtil.isEmpty(recOrderDtlAllList) ? new HashMap<>() : recOrderDtlAllList.stream().collect(Collectors.groupingBy(RecOrderDtlDTO::getMasId));
        if (CollectionUtil.isNotEmpty(recOrderAllList)){
            for (RecOrderDTO recOrderDTO : recOrderAllList) {
                List<RecOrderDtlDTO> recOrdeDtlList = recOrderDtlMap.get(recOrderDTO.getId());
                updateRecVerState(recOrderDTO,recOrdeDtlList);
            }

        }
    }

    public Long saveFinArRecVerApply(FinArRecVerApplySaveDTO save) {
        if (save.getId() == null) {
            return createFinArRecVerApply(save);
        } else {
            return updateFinArRecVerApply(save);
        }
    }

    private Long updateFinArRecVerApply(FinArRecVerApplySaveDTO save) {
        if(save.getSchemeId()==null){
            save.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_MANUAL.getValueCode());
        }
        updateApplyOrder(save);

        List<FinArRecVerApplyArHeadVO> finArRecVerApplyArHeadVOList = finArRecVerApplyArHeadService.listByMasIds(Lists.newArrayList(save.getId()));
        Assert.notEmpty(finArRecVerApplyArHeadVOList, "查不到应收单");

        List<FinArRecVerApplyRecHeadVO> finArRecVerApplyRecHeadVOList = finArRecVerApplyRecHeadService.listByMasIds(Lists.newArrayList(save.getId()));
        Assert.notEmpty(finArRecVerApplyRecHeadVOList, "查不到收款单");

        // 删除核销单
        finArRecVerApplyArHeadService.deleteByMasId(Lists.newArrayList(save.getId()));
        finArRecVerApplyRecHeadService.deleteByMasId(Lists.newArrayList(save.getId()));

        finArRecVerApplyArService.deleteByMasId(finArRecVerApplyArHeadVOList.stream().map(FinArRecVerApplyArHeadVO::getId).collect(Collectors.toSet()));
        finArRecVerApplyRecService.deleteByMasId(finArRecVerApplyRecHeadVOList.stream().map(FinArRecVerApplyRecHeadVO::getId).collect(Collectors.toSet()));


        // 插入核销单
        save.getArHeadSaveList().stream().forEach(item -> {
            Long masId = finArRecVerApplyArHeadService.create(save.getId(), item);
            // 插入核销单明细
            finArRecVerApplyArService.createBatch(masId, item.getArSaveList());
        });

        save.getRecHeadSaveList().stream().forEach(item -> {
            Long masId = finArRecVerApplyRecHeadService.create(save.getId(), item);
            // 插入核销单明细
            finArRecVerApplyRecService.createBatch(masId, save.getRecSaveList());
        });

        return save.getId();
    }

    private Long createFinArRecVerApply(FinArRecVerApplySaveDTO save) {

        Optional<FinArRecVerApplyArHeadSaveDTO> arHeadSaveDTOOptional = save.getArHeadSaveList().stream().filter(arHeadSaveDTO ->
                org.apache.commons.lang3.StringUtils.isNotBlank(arHeadSaveDTO.getOuCode()) || Objects.nonNull(arHeadSaveDTO.getOuId())).findFirst();
        if (arHeadSaveDTOOptional.isPresent()){
            arHeadSaveDTOOptional.ifPresent(finArRecVerApplyArHeadSaveDTO -> {
                save.setOuId(finArRecVerApplyArHeadSaveDTO.getOuId());
                save.setOuCode(finArRecVerApplyArHeadSaveDTO.getOuCode());
                save.setOuName(finArRecVerApplyArHeadSaveDTO.getOuName());
            });

        }else {
            Optional<FinArRecVerApplyRecHeadSaveDTO> recHeadSaveDTOOptional = save.getRecHeadSaveList().stream().filter(recHeadSaveDTO ->
                    org.apache.commons.lang3.StringUtils.isNotBlank(recHeadSaveDTO.getOuCode()) || Objects.nonNull(recHeadSaveDTO.getOuId())).findFirst();
            if (recHeadSaveDTOOptional.isPresent()){
                recHeadSaveDTOOptional.ifPresent(recVerApplyRecHeadSaveDTO -> {
                    save.setOuId(recVerApplyRecHeadSaveDTO.getOuId());
                    save.setOuCode(recVerApplyRecHeadSaveDTO.getOuCode());
                    save.setOuName(recVerApplyRecHeadSaveDTO.getOuName());
                });
            }
        }
       /* if(save.getSchemeId()==null){
            save.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_MANUAL.getValueCode());
        }*/
        // 插入核销单数据
        long id = createApplyOrder(save);

        save.getArHeadSaveList().stream().forEach(item -> {
            item.setId(null);
            Long masId = finArRecVerApplyArHeadService.create(id, item);
            // 插入核销单明细
            finArRecVerApplyArService.createBatch(masId, item.getArSaveList());
        });

        save.getRecHeadSaveList().stream().forEach(item -> {
            item.setId(null);
            Long masId = finArRecVerApplyRecHeadService.create(id, item);
            // 插入核销单明细
            finArRecVerApplyRecService.createBatch(masId, item.getRecSaveList());
        });
        return id;
    }

    private void buildArAndRecSaveList(FinArRecVerApplySaveDTO save) {

        buildArHeadSaveList(save);

        buildRecHeadSaveList(save);
    }

    private void buildArHeadSaveList(FinArRecVerApplySaveDTO save) {

        List<FinArRecVerApplyArHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = save.getArHeadSaveList();
        // 查询应收单
        List<Long> arOrderIds = finArRecVerApplyArHeadSaveDTOList.stream().map(FinArRecVerApplyArHeadSaveDTO::getId).collect(Collectors.toList());
        ArOrderDtlPageParam arOrderDtlPageParam = new ArOrderDtlExPageParam();
        arOrderDtlPageParam.setMasIds(arOrderIds);
        arOrderDtlPageParam.setSize(Integer.MAX_VALUE);
        PagingVO<ArOrderDtlVO> arOrderDtlVOPagingVO = arOrderDtlService.page(arOrderDtlPageParam);
        List<ArOrderDtlVO> arOrderDtlVOS = arOrderDtlVOPagingVO.getRecords();
        Assert.notEmpty(arOrderDtlVOS, "查不到应收单明细");
        finArRecVerApplyArHeadSaveDTOList.forEach(arOrder -> {
            List<ArOrderDtlVO> arOrderDtlVOList = arOrderDtlVOS.stream()
                    .filter(arOrderDtlVO -> arOrderDtlVO.getMasId().equals(arOrder.getId()))
                    .collect(Collectors.toList());
            Assert.notEmpty(arOrderDtlVOList, "查不到应收单明细");

            //设置初始值
            arOrder.setArSaveList(CollectionUtils.isEmpty(arOrder.getArSaveList()) ? Lists.newArrayList() : arOrder.getArSaveList());
            if (arOrder.getVerAmt().compareTo(BigDecimal.ZERO) == 0) {
                ArOrderDtlVO arOrderDtlVO = arOrderDtlVOList.get(0);
                buildArSaveList(arOrderDtlVO, arOrder.getVerAmt(), arOrder);
                return;
            }
            ArOrderDtlVO arOrderDtlVO = arOrderDtlVOList.stream()
                    .filter(item -> arOrder.getVerAmt().compareTo(item.getUnVerAmt()) == 0).findFirst()
                    .orElse(null);
            if (arOrderDtlVO != null) {
                buildArSaveList(arOrderDtlVO, arOrder.getVerAmt(), arOrder);
            }
            if (arOrderDtlVO == null) {

                BigDecimal balance = arOrder.getVerAmt();

                for (ArOrderDtlVO item : arOrderDtlVOList) {

                    if (BigDecimal.ZERO.compareTo(item.getUnVerAmt()) == 0) {
                        continue;
                    }

                    if (arOrder.getVerAmt().compareTo(BigDecimal.ZERO) > 0) {
                        if (balance.compareTo(item.getUnVerAmt()) <= 0) {
                            buildArSaveList(item, balance, arOrder);
                            break;
                        }
                        if (balance.compareTo(item.getUnVerAmt()) > 0) {
                            buildArSaveList(item, item.getUnVerAmt(), arOrder);
                            balance = balance.subtract(item.getUnVerAmt());
                        }
                    }

                    if (arOrder.getVerAmt().compareTo(BigDecimal.ZERO) < 0) {

                        if (balance.compareTo(item.getUnVerAmt()) >= 0) {
                            buildArSaveList(item, balance, arOrder);
                            break;
                        }

                        if (balance.compareTo(item.getUnVerAmt()) < 0) {
                            buildArSaveList(item, item.getUnVerAmt(), arOrder);
                            balance = balance.subtract(item.getUnVerAmt());
                        }
                    }
                }
            }
        });
    }

    private void buildArSaveList(ArOrderDtlVO arOrderDtlVO, BigDecimal amount, FinArRecVerApplyArHeadSaveDTO finArRecVerApplyArHeadSaveDTO) {
        arOrderDtlVO.setVerAmt(amount);
        arOrderDtlVO.setArId(finArRecVerApplyArHeadSaveDTO.getId());
        arOrderDtlVO.setArDocNo(finArRecVerApplyArHeadSaveDTO.getArOrderNo());
        arOrderDtlVO.setOutArDocNo(finArRecVerApplyArHeadSaveDTO.getSourceNo());
     /*   arOrderDtlVO.setOutArDId(arOrderDtlVO.getThirdOrderDtId());
        arOrderDtlVO.setSalesmanName(arOrderDtlVO.getBusinessName());
        arOrderDtlVO.setOrdererName(arOrderDtlVO.getRecvContactName());
        arOrderDtlVO.setOrdererPhone(arOrderDtlVO.getRecvContactTel());
        arOrderDtlVO.setOrdererAddr(arOrderDtlVO.getRecDetailaddr());*/
        arOrderDtlVO.setNotVerAmt(arOrderDtlVO.getUnVerAmt());
     /*   arOrderDtlVO.setChanType(arOrderDtlVO.getSoSource());*/
        arOrderDtlVO.setSubCustName(arOrderDtlVO.getCustName());
/*        arOrderDtlVO.setCustName(arOrderDtlVO.getCustomName());*/
        arOrderDtlVO.setNotVerAmt(arOrderDtlVO.getUnVerAmt());
        FinArRecVerApplyArSaveDTO finArRecVerApplyArSaveDTO = ArOrderDtlConvert.INSTANCE.VO2DTO(arOrderDtlVO);
        finArRecVerApplyArSaveDTO.setArDId(arOrderDtlVO.getId());
        finArRecVerApplyArHeadSaveDTO.getArSaveList().add(finArRecVerApplyArSaveDTO);
        finArRecVerApplyArHeadSaveDTO.setSalesmanName(finArRecVerApplyArHeadSaveDTO.getBusinessName());
        finArRecVerApplyArHeadSaveDTO.setSalesmanCode(finArRecVerApplyArHeadSaveDTO.getSaleUser());
    }

    private void buildRecHeadSaveList(FinArRecVerApplySaveDTO save) {
        List<FinArRecVerApplyRecHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = save.getRecHeadSaveList();
        // 查询收款单
        List<Long> recIds = finArRecVerApplyRecHeadSaveDTOList.stream().map(FinArRecVerApplyRecHeadSaveDTO::getId).collect(Collectors.toList());
        RecOrderDtlPageParam recOrderDtlPageParam = new RecOrderDtlPageParam();
        recOrderDtlPageParam.setMasIds(recIds);
        recOrderDtlPageParam.setSize(Integer.MAX_VALUE);
        final PagingVO<RecOrderDtlVO> recOrderDtlVOPagingVO= recOrderDtlService.page(recOrderDtlPageParam);
        final List<RecOrderDtlVO> recOrderDtlVOS=recOrderDtlVOPagingVO.getRecords();
        Assert.notEmpty(recOrderDtlVOS, "查不到收款单明细");
        finArRecVerApplyRecHeadSaveDTOList.forEach(recOrder -> {
            List<RecOrderDtlVO> recOrderDtlVOList = recOrderDtlVOS.stream()
                    .filter(recOrderDtlVO -> recOrderDtlVO.getMasId().equals(recOrder.getId()))
                    .collect(Collectors.toList());
            Assert.notEmpty(recOrderDtlVOList, "查不到收款单明细");
            //设置初始值
            recOrder.setRecSaveList(CollectionUtils.isEmpty(recOrder.getRecSaveList()) ? Lists.newArrayList() : recOrder.getRecSaveList());
            if (recOrder.getVerAmt().compareTo(BigDecimal.ZERO) == 0) {
                RecOrderDtlVO recOrderDtlVO = recOrderDtlVOList.get(0);
                buildRecSaveList(recOrderDtlVO, recOrder.getVerAmt(), recOrder);
                return;
            }
            RecOrderDtlVO recOrderDtlVO = recOrderDtlVOList.stream()
                    .filter(item -> recOrder.getVerAmt().compareTo(item.getUnVerAmt()) == 0).findFirst()
                    .orElse(null);

            if (recOrderDtlVO != null) {
                buildRecSaveList(recOrderDtlVO, recOrder.getVerAmt(), recOrder);
            }

            if (recOrderDtlVO == null) {

                BigDecimal balance = recOrder.getVerAmt();

                for (RecOrderDtlVO item : recOrderDtlVOList) {

                    if (BigDecimal.ZERO.compareTo(item.getUnVerAmt()) == 0) {
                        continue;
                    }

                    if (recOrder.getVerAmt().compareTo(BigDecimal.ZERO) > 0) {
                        if (balance.compareTo(item.getUnVerAmt()) <= 0) {
                            buildRecSaveList(item, balance, recOrder);
                            break;
                        }
                        if (balance.compareTo(item.getUnVerAmt()) > 0) {
                            buildRecSaveList(item, item.getUnVerAmt(), recOrder);
                            balance = balance.subtract(item.getUnVerAmt());
                        }
                    }

                    if (recOrder.getVerAmt().compareTo(BigDecimal.ZERO) < 0) {

                        if (balance.compareTo(item.getUnVerAmt()) >= 0) {
                            buildRecSaveList(item, balance, recOrder);
                            break;
                        }

                        if (balance.compareTo(item.getUnVerAmt()) < 0) {
                            buildRecSaveList(item, item.getUnVerAmt(), recOrder);
                            balance = balance.subtract(item.getUnVerAmt());
                        }
                    }
                }
            }
        });
    }

    private void buildRecSaveList(RecOrderDtlVO recOrderDtlVO, BigDecimal amount, FinArRecVerApplyRecHeadSaveDTO finArRecVerApplyRecHeadSaveDTO) {
        recOrderDtlVO.setVerAmt(amount);
        recOrderDtlVO.setRecId(finArRecVerApplyRecHeadSaveDTO.getId());
        recOrderDtlVO.setRecDocNo(finArRecVerApplyRecHeadSaveDTO.getRecOrderNo());
        recOrderDtlVO.setOutRecDocNo(finArRecVerApplyRecHeadSaveDTO.getSourceNo());
      /*  recOrderDtlVO.setOutRecDId(recOrderDtlVO.getThirdOrderDtId());
        recOrderDtlVO.setSalesmanName(recOrderDtlVO.getBusinessName());*/
        recOrderDtlVO.setOuName(finArRecVerApplyRecHeadSaveDTO.getRecOuName());
        recOrderDtlVO.setRecBuType(recOrderDtlVO.getRecKindName());
       /* recOrderDtlVO.setRecNat(recOrderDtlVO.getNaturePayment());*/
        recOrderDtlVO.setNotVerAmt(recOrderDtlVO.getUnVerAmt());
        FinArRecVerApplyRecSaveDTO finArRecVerApplyRecSaveDTO = RecOrderDtlConvert.INSTANCE.VO2DTO(recOrderDtlVO);
        finArRecVerApplyRecSaveDTO.setRecDId(recOrderDtlVO.getId());
        finArRecVerApplyRecHeadSaveDTO.getRecSaveList().add(finArRecVerApplyRecSaveDTO);
        finArRecVerApplyRecHeadSaveDTO.setSalesmanName(finArRecVerApplyRecHeadSaveDTO.getBusinessName());
        finArRecVerApplyRecHeadSaveDTO.setSalesmanCode(finArRecVerApplyRecHeadSaveDTO.getSaleUser());
    }

    private void checkWriteOffParam(FinArRecVerApplySaveDTO finArRecVerApplySaveDTO) {
        List<FinArRecVerApplyArHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = finArRecVerApplySaveDTO.getArHeadSaveList();
        Assert.notEmpty(finArRecVerApplyArHeadSaveDTOList, "应收单不能为空");
        finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "核销金额不能为空"));

        List<FinArRecVerApplyRecHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = finArRecVerApplySaveDTO.getRecHeadSaveList();
        Assert.notEmpty(finArRecVerApplyRecHeadSaveDTOList, "收款单不能为空");
        finArRecVerApplyRecHeadSaveDTOList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "核销金额不能为空"));

        BigDecimal arVerAmt = finArRecVerApplyArHeadSaveDTOList.stream().map(FinArRecVerApplyArHeadSaveDTO::getVerAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        BigDecimal recVerAmt = finArRecVerApplyRecHeadSaveDTOList.stream().map(FinArRecVerApplyRecHeadSaveDTO::getVerAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        Assert.isTrue(arVerAmt.compareTo(recVerAmt) == 0, "应收单收款单核销金额不相等");

        finArRecVerApplySaveDTO.setVerAmt(arVerAmt);
    }
    private void checkWriteOffParamNew(FinArRecVerApplySaveDTO finArRecVerApplySaveDTO) {
        List<FinArRecVerApplyArHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = finArRecVerApplySaveDTO.getArHeadSaveList();
        List<FinArRecVerApplyRecHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = finArRecVerApplySaveDTO.getRecHeadSaveList();
        if(CollectionUtils.isEmpty(finArRecVerApplyArHeadSaveDTOList)&&CollectionUtils.isEmpty(finArRecVerApplyRecHeadSaveDTOList)){
            throw new BusinessException("应收单和收款单不能同时为空");
        }
        BigDecimal arVerAmt = BigDecimal.ZERO;
        BigDecimal recVerAmt = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadSaveDTOList)){
            finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "应收单核销金额不能为空"));
            arVerAmt = finArRecVerApplyArHeadSaveDTOList.stream().map(FinArRecVerApplyArHeadSaveDTO::getVerAmt)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if(CollectionUtils.isNotEmpty(finArRecVerApplyRecHeadSaveDTOList)){
            finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "收款单核销金额不能为空"));
            recVerAmt = finArRecVerApplyRecHeadSaveDTOList.stream().map(FinArRecVerApplyRecHeadSaveDTO::getVerAmt)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        Assert.isTrue(arVerAmt.compareTo(recVerAmt) == 0, "应收单收款单核销金额不相等");
        finArRecVerApplySaveDTO.setVerAmt(arVerAmt);
    }

    @Override
    @SysCodeProc
    public FinArRecVerApplyVO detail(Long id) {

        FinArRecVerApplyDO entity = findApplyOrder(id);

        FinArRecVerApplyVO result = FinArRecVerApplyConvert.INSTANCE.entity2Vo(entity);

        // 数查询核销申请 应收单、收款单明细
        result.setArList(finArRecVerApplyArService.listByMasIds(Collections.singletonList(id)));
        result.setRecList(finArRecVerApplyRecService.listByMasIds(Collections.singletonList(id)));

        return result;
    }

    @Override
    @SysCodeProc
    public FinArRecVerApplyVO writeOffDetail(Long id) {
        FinArRecVerApplyDO entity = findApplyOrder(id);

        FinArRecVerApplyVO result = FinArRecVerApplyConvert.INSTANCE.entity2Vo(entity);

        FinArRecVerApplyVO headAndDetailInfo = queryHeadAndDetailInfo(Lists.newArrayList(id));

        result.setArHeadList(headAndDetailInfo.getArHeadList());
        result.setRecHeadList(headAndDetailInfo.getRecHeadList());

        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<FinArRecVerApplyVO> page(FinArRecVerApplyQuery query) {
        List<Long> masIds = new ArrayList<>();
        List<Long> arIds = new ArrayList<>();
        List<Long> recIds = new ArrayList<>();
        List<FinArRecVerApplyArVO> arVOList = finArRecVerApplyArService.listByOutArDocNoOrDId(query);

        if(CollUtil.isNotEmpty(arVOList)){
            masIds.addAll(arVOList.stream().map(FinArRecVerApplyArVO::getMasId).distinct().collect(Collectors.toList()));
            arIds.addAll(arVOList.stream().map(FinArRecVerApplyArVO::getId).distinct().collect(Collectors.toList()));
        }

        List<FinArRecVerApplyRecVO> recVOList = finArRecVerApplyRecService.listByOutRecDocNoOrDId(query);

        if(CollUtil.isNotEmpty(recVOList)){
            masIds.addAll(recVOList.stream().map(FinArRecVerApplyRecVO::getMasId).distinct().collect(Collectors.toList()));
            recIds.addAll(recVOList.stream().map(FinArRecVerApplyRecVO::getId).distinct().collect(Collectors.toList()));
        }

        if(CollUtil.isNotEmpty(masIds)){
            query.setIds(masIds.stream().distinct().collect(Collectors.toList()));
        }

        // 如果有参数，但是查询不到结果则直接返回
        if( (StrUtil.isNotEmpty(query.getOutArDocNo()) || StrUtil.isNotEmpty(query.getOutArDId())
                || StrUtil.isNotEmpty(query.getOutRecDocNo()) || StrUtil.isNotEmpty(query.getOutRecDId()) ) && CollUtil.isEmpty(masIds)){
            return PagingVO.empty();
        }

        PagingVO<FinArRecVerApplyVO> result = finArRecVerApplyRepoProc.joinPage(query);

        if (result.isEmpty()) {
            return PagingVO.empty();
        }

        // 查询核销申请 应收单、收款单明细
        List<Long> ids = result.getRecords().stream().map(FinArRecVerApplyVO::getId).collect(Collectors.toList());
        List<FinArRecVerApplyArVO> arList = finArRecVerApplyArService.listByQuery(FinArRecVerApplyArQuery.builder().ids(arIds).masIds(ids).build());
        List<FinArRecVerApplyRecVO> recList = finArRecVerApplyRecService.listByQuery(FinArRecVerApplyRecQuery.builder().ids(recIds).masIds(ids).build());

        if (arList.isEmpty() && recList.isEmpty()) {
            return result;
        }

        List<String> apRelevanceOuCodeList = arList.stream().map(FinArRecVerApplyArVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> payRelevanceOuCodeList = recList.stream().map(FinArRecVerApplyRecVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        List<String> relevanceOuCodeAllList = Stream.of(apRelevanceOuCodeList, payRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(arList)){
            arList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)){
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }

        if (CollectionUtil.isNotEmpty(recList)){
            recList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)){
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }

        //处理核销方案名称
        List<ArVerConfigDTO> arVerConfigDTOS = arVerConfigDomainService.queryAll();
        Map<Long, String> arVerConfigDTOMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(arVerConfigDTOS)){
             arVerConfigDTOMap = arVerConfigDTOS.stream().collect(Collectors.toMap(ArVerConfigDTO::getId, ArVerConfigDTO::getSchemeName));
        }
        Map<Long, String> finArVerConfigDTOMap = arVerConfigDTOMap;
        result.getRecords().forEach(e -> {
            e.setSchemeName(finArVerConfigDTOMap.get(e.getSchemeId()));
            e.setArList(arList.stream().filter(fi -> fi.getMasId().equals(e.getId())).collect(Collectors.toList()));
            e.setRecList(recList.stream().filter(fi -> fi.getMasId().equals(e.getId())).collect(Collectors.toList()));
        });
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<FinArRecVerApplyVO> writeOffPage(FinArRecVerApplyQuery query) {
        List<Long> arMasIds = new ArrayList<>();
        List<Long> recNasIds = new ArrayList<>();
        List<Long> totalMasIds = new ArrayList<>();
        List<Long> arIds = new ArrayList<>();
        List<Long> recIds = new ArrayList<>();
        List<FinArRecVerApplyArVO> arVOList = finArRecVerApplyArService.listByOutArDocNoOrDId(query);
        boolean existArRecQueryConditionFlag=false;
        boolean existApPayQueryConditionFlag=false;
        if(CollUtil.isNotEmpty(arVOList)){
            List<FinArRecVerApplyArHeadVO> finArRecVerApplyArHeadVOS = finArRecVerApplyArHeadService.listByIds(arVOList.stream().map(FinArRecVerApplyArVO::getMasId).distinct().collect(Collectors.toList()),query);
            if(CollUtil.isNotEmpty(finArRecVerApplyArHeadVOS)){
                arMasIds.addAll(finArRecVerApplyArHeadVOS.stream().map(FinArRecVerApplyArHeadVO::getMasId).distinct().collect(Collectors.toList()));
            }
            arIds.addAll(arVOList.stream().map(FinArRecVerApplyArVO::getId).distinct().collect(Collectors.toList()));
        }
        if( (StrUtil.isNotEmpty(query.getOutArDocNo()) || StrUtil.isNotEmpty(query.getWriteOffArOuCode())
                || StrUtil.isNotEmpty(query.getWriteOffArSalesmanCode()) || StrUtil.isNotEmpty(query.getWriteOffArCustCode()))){
            existArRecQueryConditionFlag=true;
            if(CollUtil.isEmpty(arMasIds)){
                return PagingVO.empty();
            }
        }
        List<FinArRecVerApplyRecVO> recVOList = finArRecVerApplyRecService.listByOutRecDocNoOrDId(query);

        if(CollUtil.isNotEmpty(recVOList)){
            List<FinArRecVerApplyRecHeadVO> finArRecVerApplyArHeadVOS = finArRecVerApplyRecHeadService.listByIds(recVOList.stream().map(FinArRecVerApplyRecVO::getMasId).distinct().collect(Collectors.toList()),query);
            if(CollUtil.isNotEmpty(finArRecVerApplyArHeadVOS)){
                recNasIds.addAll(finArRecVerApplyArHeadVOS.stream().map(FinArRecVerApplyRecHeadVO::getMasId).distinct().collect(Collectors.toList()));
            }
            recIds.addAll(recVOList.stream().map(FinArRecVerApplyRecVO::getId).distinct().collect(Collectors.toList()));
        }
        // 如果有参数，但是查询不到结果则直接返回
        if( (StrUtil.isNotEmpty(query.getOutRecDocNo()) || StrUtil.isNotEmpty(query.getWriteOffRecOuCode())
                || StrUtil.isNotEmpty(query.getWriteOffRecCustCode()) || StrUtil.isNotEmpty(query.getWriteOffRecSalesmanCode()) )){
            existApPayQueryConditionFlag=true;
            if(CollUtil.isEmpty(recNasIds)){
                return PagingVO.empty();
            }
        }
        if(existArRecQueryConditionFlag&&!existApPayQueryConditionFlag){
            totalMasIds=arMasIds;
        }else if(!existArRecQueryConditionFlag&&existApPayQueryConditionFlag){
            totalMasIds=recNasIds;
        }else if(existArRecQueryConditionFlag&&existApPayQueryConditionFlag){
            totalMasIds=arMasIds.stream()
                    .filter(recNasIds::contains)
                    .collect(Collectors.toList());
        }else{
            totalMasIds.addAll(arMasIds);
            totalMasIds.addAll(recNasIds);
        }
        if(CollUtil.isEmpty(totalMasIds)){
            return PagingVO.empty();
        }
        query.setIds(totalMasIds.stream().distinct().collect(Collectors.toList()));
        PagingVO<FinArRecVerApplyVO> result = finArRecVerApplyRepoProc.writeOffJoinPage(query);

        if (result.isEmpty()) {
            return PagingVO.empty();
        }

        // 查询核销申请 应收单、收款单明细
        List<Long> ids = result.getRecords().stream().map(FinArRecVerApplyVO::getId).collect(Collectors.toList());
        List<Long> schemeIds = result.getRecords().stream().filter(v -> WriteoffUdcEnum.FIN_VER_MODE_AUTOMATIC.getValueCode().equals(v.getVerMode()) && v.getSchemeId() != null)
                .map(v -> v.getSchemeId()).collect(Collectors.toList());
        Map<Long, String> arVerConfigNameMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(schemeIds)){
            List<ArVerConfigDTO> arVerConfigDTOS = arVerConfigDomainService.findByIds(schemeIds);
            if(CollectionUtils.isNotEmpty(arVerConfigDTOS)){
                arVerConfigNameMap = arVerConfigDTOS.stream().collect(Collectors.toMap(ArVerConfigDTO::getId, ArVerConfigDTO::getSchemeName));
            }
        }
        Map<Long, String> arVerConfigNameMapFinal = arVerConfigNameMap;
        FinArRecVerApplyVO headAndDetailInfo = queryHeadAndDetailInfoByQuery(arIds,recIds,ids);

        result.getRecords().forEach(record -> {
            record.setArHeadList(headAndDetailInfo.getArHeadList().stream()
                    .filter(finArRecVerApplyArHeadVO -> record.getId().equals(finArRecVerApplyArHeadVO.getMasId())).collect(Collectors.toList()));

            record.setRecHeadList(headAndDetailInfo.getRecHeadList().stream()
                    .filter(finArRecVerApplyRecHeadVO -> record.getId().equals(finArRecVerApplyRecHeadVO.getMasId())).collect(Collectors.toList()));
            if (WriteoffUdcEnum.FIN_VER_MODE_AUTOMATIC.getValueCode().equals(record.getVerMode())&&record.getSchemeId()!=null) {
                record.setSchemeName(arVerConfigNameMapFinal.get(record.getSchemeId()));
            }

        });

        return result;
    }

    /**
     * 根据查询条件查询核销明细
     * @param arIds 应收id
     * @param recIds 收款id
     * @param masIds 主表id
     * @return
     */
    private FinArRecVerApplyVO queryHeadAndDetailInfoByQuery(List<Long> arIds,List<Long> recIds,List<Long> masIds) {

        List<FinArRecVerApplyArHeadVO> finArRecVerApplyArHeadVOList = finArRecVerApplyArHeadService.listByMasIds(masIds);
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)){
            //Assert.notEmpty(finArRecVerApplyArHeadVOList, "查不到应收单申请单");
            List<Long> arMasIds = finArRecVerApplyArHeadVOList.stream().map(FinArRecVerApplyArHeadVO::getId).collect(Collectors.toList());
            List<FinArRecVerApplyArVO> finArRecVerApplyArVOList = finArRecVerApplyArService.listByQuery(FinArRecVerApplyArQuery.builder().masIds(arMasIds).ids(arIds).build());
            finArRecVerApplyArHeadVOList.stream().forEach(finArRecVerApplyArHeadVO -> {
                List<FinArRecVerApplyArVO> resultList = finArRecVerApplyArVOList.stream()
                        .filter(finArRecVerApplyArVO -> finArRecVerApplyArHeadVO.getId().equals(finArRecVerApplyArVO.getMasId()))
                        .collect(Collectors.toList());
                //Assert.notEmpty(resultList, "查不到应收单申请单明细");
                finArRecVerApplyArHeadVO.setArList(resultList);
            });
        }
        List<FinArRecVerApplyRecHeadVO> finArRecVerApplyRecHeadVOList = finArRecVerApplyRecHeadService.listByMasIds(masIds);
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)){
            //Assert.notEmpty(finArRecVerApplyRecHeadVOList, "查不到收款单申请单");
            List<Long> recMasIds = finArRecVerApplyRecHeadVOList.stream().map(FinArRecVerApplyRecHeadVO::getId).collect(Collectors.toList());
            List<FinArRecVerApplyRecVO> finArRecVerApplyRecVOList = finArRecVerApplyRecService.listByQuery(FinArRecVerApplyRecQuery.builder().masIds(recMasIds).ids(recIds).build());
            finArRecVerApplyRecHeadVOList.stream().forEach(finArRecVerApplyRecHead -> {
                List<FinArRecVerApplyRecVO> resultList = finArRecVerApplyRecVOList.stream()
                        .filter(finArRecVerApplyRecVO -> finArRecVerApplyRecHead.getId().equals(finArRecVerApplyRecVO.getMasId()))
                        .collect(Collectors.toList());
                //Assert.notEmpty(resultList, "查不到收款单申请单明细");
                finArRecVerApplyRecHead.setRecList(resultList);
            });

        }

        List<String> apRelevanceOuCodeList = finArRecVerApplyArHeadVOList.stream().map(FinArRecVerApplyArHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> payRelevanceOuCodeList = finArRecVerApplyRecHeadVOList.stream().map(FinArRecVerApplyRecHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        List<String> relevanceOuCodeAllList = Stream.of(apRelevanceOuCodeList, payRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(finArRecVerApplyArHeadVOList)){
            finArRecVerApplyArHeadVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)){
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }

        if (CollectionUtil.isNotEmpty(finArRecVerApplyRecHeadVOList)){
            finArRecVerApplyRecHeadVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)){
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }

        FinArRecVerApplyVO finArRecVerApplyVO = new FinArRecVerApplyVO();
        finArRecVerApplyVO.setArHeadList(finArRecVerApplyArHeadVOList);
        finArRecVerApplyVO.setRecHeadList(finArRecVerApplyRecHeadVOList);
        return finArRecVerApplyVO;
    }

    private FinArRecVerApplyVO queryHeadAndDetailInfo(Collection<Long> ids) {
        //Map<String, String> custInOut = udcProvider.getValueMapByUdcCode("yst-purc", "IO_TYPE");
        Map<String, String> custInOut = udcProvider.getValueMapByUdcCode("yst-sale", "CUST_IN_OUT");
        List<FinArRecVerApplyArHeadVO> finArRecVerApplyArHeadVOList = finArRecVerApplyArHeadService.listByMasIds(ids);
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)){
            //Assert.notEmpty(finArRecVerApplyArHeadVOList, "查不到应收单申请单");
            List<Long> arMasIds = finArRecVerApplyArHeadVOList.stream().map(FinArRecVerApplyArHeadVO::getId).collect(Collectors.toList());
            List<FinArRecVerApplyArVO> finArRecVerApplyArVOList = finArRecVerApplyArService.listByMasIds(arMasIds);
            finArRecVerApplyArHeadVOList.stream().forEach(finArRecVerApplyArHeadVO -> {
                List<FinArRecVerApplyArVO> resultList = finArRecVerApplyArVOList.stream()
                        .filter(finArRecVerApplyArVO -> finArRecVerApplyArHeadVO.getId().equals(finArRecVerApplyArVO.getMasId()))
                        .collect(Collectors.toList());
                //Assert.notEmpty(resultList, "查不到应收单申请单明细");
                finArRecVerApplyArHeadVO.setArList(resultList);
                if (custInOut != null) {
                    finArRecVerApplyArHeadVO.setInOutCustName(custInOut.get(finArRecVerApplyArHeadVO.getInOutCust()));
                }
            });
        }
        List<FinArRecVerApplyRecHeadVO> finArRecVerApplyRecHeadVOList = finArRecVerApplyRecHeadService.listByMasIds(ids);
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)){
            //Assert.notEmpty(finArRecVerApplyRecHeadVOList, "查不到收款单申请单");
            List<Long> recMasIds = finArRecVerApplyRecHeadVOList.stream().map(FinArRecVerApplyRecHeadVO::getId).collect(Collectors.toList());
            List<FinArRecVerApplyRecVO> finArRecVerApplyRecVOList = finArRecVerApplyRecService.listByMasIds(recMasIds);
            finArRecVerApplyRecHeadVOList.stream().forEach(finArRecVerApplyRecHead -> {
                List<FinArRecVerApplyRecVO> resultList = finArRecVerApplyRecVOList.stream()
                        .filter(finArRecVerApplyRecVO -> finArRecVerApplyRecHead.getId().equals(finArRecVerApplyRecVO.getMasId()))
                        .collect(Collectors.toList());
                //Assert.notEmpty(resultList, "查不到收款单申请单明细");
                finArRecVerApplyRecHead.setRecList(resultList);
                if (custInOut != null) {
                    finArRecVerApplyRecHead.setInOutCustName(custInOut.get(finArRecVerApplyRecHead.getInOutCust()));
                }
            });

        }

        List<String> apRelevanceOuCodeList = finArRecVerApplyArHeadVOList.stream().map(FinArRecVerApplyArHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> payRelevanceOuCodeList = finArRecVerApplyRecHeadVOList.stream().map(FinArRecVerApplyRecHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        List<String> relevanceOuCodeAllList = Stream.of(apRelevanceOuCodeList, payRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(finArRecVerApplyArHeadVOList)){
            finArRecVerApplyArHeadVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)){
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }

        if (CollectionUtil.isNotEmpty(finArRecVerApplyRecHeadVOList)){
            finArRecVerApplyRecHeadVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)){
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }

        FinArRecVerApplyVO finArRecVerApplyVO = new FinArRecVerApplyVO();
        finArRecVerApplyVO.setArHeadList(finArRecVerApplyArHeadVOList);
        finArRecVerApplyVO.setRecHeadList(finArRecVerApplyRecHeadVOList);
        return finArRecVerApplyVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void approve(FinArRecApplyApprovalDTO dto) {

        if (!FinArRecApplyApprovalDTO.ApprovalType.APPROVE.equals(dto.getApprovalType())) {
            throw new BusinessException("非法的approvalType");
        }

        List<FinArRecVerApplyDO> applyList = finArRecVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());

        preCheckForApproval(dto.getApplyNos(), applyList);

        setApprovalMsg(dto, applyList);

        // 更新单据信息
        finArRecVerApplyRepoProc.save(applyList);

        GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        SysUserDTO sysUserDTO = principal.getUser();
        String user = sysUserDTO!=null?sysUserDTO.getLastName():principal.getUsername();
        // 更新核销金额，改为异步操作
        threadLocalCopyUtil.asyncTask(()->{
            CURRENT_USER.set(user);
            // 兼容系统域调用的时候不会带上租户id的问题
            final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();;
            TenantContextHolder.setCurrentTenant(sysTenantDTO);
            String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
            String erpLog = "";
            try {
                // 更新核销金额
                //addVerAmt(applyList.stream().map(BaseModel::getId).collect(Collectors.toList()));
            }catch (Exception e){
                log.error("更新核销金额,推送nc失败,{}",e.getMessage());
                applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode();
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_FAILED.getValueCode();
                erpLog = e.getMessage();
            }
            String finalApplyState = applyState;
            String finalVerState = verState;
            String finalErpLog = erpLog;
            applyList.forEach(e->{
                e.setState(finalApplyState);
                e.setVerState(finalVerState);
               // e.setErpLog(finalErpLog);
            });
            // 更新单据信息
            finArRecVerApplyRepoProc.save(applyList);
            //日志
            applyList.forEach(apply->{
                if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(apply.getState())) {
                    operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, apply.getId().toString(), OperationTypeEnum.APPROVE_OK,
                        BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_OK));
                }
            });
            // 用完清除
            CURRENT_USER.remove();

        });

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void writeOffApprove(FinArRecApplyApprovalDTO dto) {
      /*  if (!FinArRecApplyApprovalDTO.ApprovalType.APPROVE.equals(dto.getApprovalType())) {
            throw new BusinessException("非法的approvalType");
        }*/

        List<FinArRecVerApplyDO> applyList = finArRecVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());

        preCheckForApproval(dto.getApplyNos(), applyList);

        setApprovalMsg(dto, applyList);

        // 更新单据信息
        finArRecVerApplyRepoProc.save(applyList);


      /*  GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        SysUserDTO sysUserDTO = principal.getUser();
        String user = sysUserDTO!=null?sysUserDTO.getLastName():principal.getUsername();*/
        // 更新核销金额，改为异步操作
  /*      threadLocalCopyUtil.asyncTask(()->{
            CURRENT_USER.set(user);*/

            // 兼容系统域调用的时候不会带上租户id的问题
            final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
            String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
            String erpLog = "";
            try {
                updateAmount(applyList.stream().map(BaseModel::getId).collect(Collectors.toList()), FinArRecVerificationDTO.VerType.APPROVE);
            }catch (Exception e){
                log.error("更新核销金额失败",e);
                applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode();
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_FAILED.getValueCode();
                erpLog = e.getMessage();
            }
            String finalApplyState = applyState;
            String finalVerState = verState;
            String finalErpLog = erpLog;
            applyList.forEach(e->{
                e.setState(finalApplyState);
                e.setVerState(finalVerState);
               // e.setErpLog(finalErpLog);
            });
            // 更新单据信息
            finArRecVerApplyRepoProc.save(applyList);
            applyList.forEach(apply -> {
                if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(apply.getState())) {
                    operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, apply.getId().toString(), OperationTypeEnum.APPROVE_OK,
                        BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_OK));
                }
            });
            // 用完清除
      /*      CURRENT_USER.remove();*/
/*
        });*/

    }

    /**
     * 重推核销审批接口
     * @param id
     * @return
     */
    public ApiResult<String> reTryApprove(Long id){
        FinArRecVerApplyDO applyDO = finArRecVerApplyRepoProc.get(id);
        // 兼容系统域调用的时候不会带上租户id的问题
        final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();;
        TenantContextHolder.setCurrentTenant(sysTenantDTO);
        String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
        String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
        String erpLog = "";
        Boolean isSuccess = Boolean.TRUE;
        try {
            //updateAmount(CollUtil.newArrayList(applyDO.getId()), FinArRecVerificationDTO.VerType.APPROVE);
        }catch (Exception e){
            log.error("更新核销金额,推送nc失败,{}",e.getMessage());
            applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode();
            verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_FAILED.getValueCode();
            erpLog = e.getMessage();
            isSuccess = Boolean.FALSE;
        }
        String finalApplyState = applyState;
        String finalVerState = verState;
        String finalErpLog = erpLog;
        applyDO.setState(finalApplyState);
        applyDO.setVerState(finalVerState);
       // applyDO.setErpLog(finalErpLog);
        // 更新单据信息
        finArRecVerApplyRepoProc.save(applyDO);
        return isSuccess?ApiResult.ok("重推核销审批成功"):ApiResult.fail(erpLog);
    }

    /**
     * 核销接口重试
     * @param param
     * @return
     */
    /*public ApiResult<String> reTrySend2Nc(ReTryParam param){
		log.info("核销接口重试,{}",JSONUtil.toJsonStr(param));
		if(ObjUtil.isNull(param)){
			return ApiResult.ok("重试参数为空");
		}
		FinArRecVerApplyDO applyDO = finArRecVerApplyRepoProc.get(param.getId());
		if(ObjectUtil.isNull(applyDO)){
			return ApiResult.ok("查询核销单为空");
		}
		ApiResult<String> result = ApiResult.ok();

		if("APPROVE".equals(param.getBusinessType())){
			result = this.reTryApprove(param.getId());
		}else {
			try {
				this.writeOffCancel(param.getId());
			}catch (Exception e){
				log.error("核销接口重试失败，{}",e.getMessage());
				result = ApiResult.fail("核销接口重试失败" + e.getMessage());
			}
		}
		return result;
	}*/
    @Transactional(rollbackFor = Exception.class)
    public FinApPayVerApplyHandleDTO updateAmount(Collection<Long> ids, String verType) {
        FinApPayVerApplyHandleDTO finApPayVerApplyHandleDTO = new FinApPayVerApplyHandleDTO();
                // 无效处理
        BigDecimal factor = BigDecimal.ONE;

        FinArRecVerApplyVO headAndDetailInfo = queryHeadAndDetailInfo(ids);

        List<Long> arMasIds = headAndDetailInfo.getArHeadList().stream().map(FinArRecVerApplyArHeadVO::getId).collect(Collectors.toList());

        List<Long> recMasIds = headAndDetailInfo.getRecHeadList().stream().map(FinArRecVerApplyRecHeadVO::getId).collect(Collectors.toList());


        // 进行 NC接口调用
        //sendNcVerRequest(ids, verType);

        // 更新应收单核销金额
        List<FinArRecVerApplyArVO> arVOList = finArRecVerApplyArService.listByMasIds(arMasIds);
        arVOList.forEach(e -> arOrderService.updateVerAmt(e.getArDId(), e.getVerAmt().multiply(factor), verType));

        // 更新收款单核销金额
        List<FinArRecVerApplyRecVO> recVOList = finArRecVerApplyRecService.listByMasIds(recMasIds);
        recVOList.forEach(e -> recOrderService.updateVerAmt(e.getRecDId(), e.getVerAmt().multiply(factor), verType));

        finApPayVerApplyHandleDTO.setArVOList(arVOList);
        finApPayVerApplyHandleDTO.setRecVOList(recVOList);
        return finApPayVerApplyHandleDTO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void refuse(FinArRecApplyApprovalDTO dto) {

        if (!FinArRecApplyApprovalDTO.ApprovalType.REFUSE.equals(dto.getApprovalType())) {
            throw new BusinessException("非法的approvalType");
        }

        List<FinArRecVerApplyDO> applyList = finArRecVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        Assert.notEmpty(applyList, "未查询到核销申请单");
        List<Long> masIds = applyList.stream().map(BaseModel::getId).collect(Collectors.toList());

        preCheckForApproval(dto.getApplyNos(), applyList);

        setApprovalMsg(dto, applyList);

        // 释放核销中金额
        finArRecVerApplyArService.listByMasIds(masIds)
                .forEach(e -> arOrderExService.updateMiddleVerAmt(e.getArDId(), e.getVerAmt().negate()));
        finArRecVerApplyRecService.listByMasIds(masIds)
                .forEach(e -> recOrderExService.updateMiddleVerAmt(e.getRecDId(), e.getVerAmt().negate()));
        // 更新单据信息
        finArRecVerApplyRepoProc.save(applyList);
        applyList.forEach(apply->{
            operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, apply.getId().toString(), OperationTypeEnum.APPROVE_REJECT,
                BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_REJECT));
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void writeOffRefuse(FinArRecApplyApprovalDTO dto) {
        if (!FinArRecApplyApprovalDTO.ApprovalType.REFUSE.equals(dto.getApprovalType())) {
            throw new BusinessException("非法的approvalType");
        }

        List<FinArRecVerApplyDO> applyList = finArRecVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        Assert.notEmpty(applyList, "未查询到核销申请单");
        List<Long> masIds = applyList.stream().map(BaseModel::getId).collect(Collectors.toList());

        preCheckForApproval(dto.getApplyNos(), applyList);

        setApprovalMsg(dto, applyList);


        FinArRecVerApplyVO headAndDetailInfo = queryHeadAndDetailInfo(masIds);

        List<Long> arMasIds = headAndDetailInfo.getArHeadList().stream().map(FinArRecVerApplyArHeadVO::getId).collect(Collectors.toList());

        List<Long> recMasIds = headAndDetailInfo.getRecHeadList().stream().map(FinArRecVerApplyRecHeadVO::getId).collect(Collectors.toList());

        // 更新应收单核销金额
        finArRecVerApplyArService.listByMasIds(arMasIds).forEach(e -> arOrderExService.updateMiddleVerAmt(e.getArDId(), e.getVerAmt().negate()));
        finArRecVerApplyRecService.listByMasIds(recMasIds).forEach(e -> recOrderExService.updateMiddleVerAmt(e.getRecDId(), e.getVerAmt().negate()));

        // 更新单据信息
        finArRecVerApplyRepoProc.save(applyList);
        //日志
        applyList.forEach(apply->{
            operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, apply.getId().toString(), OperationTypeEnum.APPROVE_REJECT,
                BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_REJECT));
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancel(Long id) {

        FinArRecVerApplyDO entity = findApplyOrder(id);

        List<String> verStateList = Arrays.asList(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode(), WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());

        if (!verStateList.contains(entity.getVerState())) {
            throw new BusinessException("仅核销状态为已核销或者取消失败的单据可进行该操作!");
        }

        // 更新单据状态
        updateOrderForVerCancel(entity);

        GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();

        String user = principal.getUsername();

        // 释放核销金额,更改为异步
        ThreadUtil.execute(()-> {
            CURRENT_USER.set(user);
            log.info("取消核销异步执行");
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode();
            String erpLog = "";
            try {
                final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();;
                TenantContextHolder.setCurrentTenant(sysTenantDTO);
                // 释放核销金额
                //releaseVerAmt(Collections.singleton(id));
            }catch (Exception e){
                log.error("取消核销,推送nc失败,{}",e.getMessage());
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode();
                erpLog = e.getMessage();
            }
            String finalVerState = verState;
            entity.setVerState(finalVerState);
           // entity.setErpLog(erpLog);
            log.info("取消核销更新状态,{}",JSONUtil.toJsonStr(entity));
            // 更新单据信息
            finArRecVerApplyRepoProc.save(entity);
            CURRENT_USER.remove();
        });

        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, entity.getId().toString(), OperationTypeEnum.UPDATE,
            "取消核销");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void writeOffCancel(Long id) {

        FinArRecVerApplyDO entity = findApplyOrder(id);
        List<String> verStateList = Arrays.asList(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode(),
                WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());

        if (!verStateList.contains(entity.getVerState())) {
            throw new BusinessException("仅核销状态为已核销或者取消失败的单据可进行该操作!");
        }

        if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(entity.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode()
                .equals(entity.getProposedStatus())) {
            throw new BusinessException("拟定状态必须为草稿或拟定失败");
        }

        // 更新单据状态
        updateOrderForVerCancel(entity);

       /* GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();

        String user = principal.getUsername();*/

        // 释放核销金额,更改为异步
      /*  ThreadUtil.execute(()->{
            CURRENT_USER.set(user);
            log.info("取消核销异步执行");
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode();
            String errlog = "";
            try {
                final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
                TenantContextHolder.setCurrentTenant(sysTenantDTO);
                updateAmount(Collections.singleton(id), FinArRecVerificationDTO.VerType.CANCEL);
            }catch (Exception e){
                log.error("取消核销失败,{}",e.getMessage());
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode();
                errlog = e.getMessage();
            }
            String finalVerState = verState;
            entity.setVerState(finalVerState);
            entity.setErpLog(errlog);
            log.info("取消核销更新状态,{}",JSONUtil.toJsonStr(entity));
            // 更新单据信息
            finArRecVerApplyRepoProc.save(entity);
            CURRENT_USER.remove();
        });*/
        FinApPayVerApplyHandleDTO finApPayVerApplyHandleDTO = updateAmount(Collections.singleton(id), FinArRecVerificationDTO.VerType.CANCEL);

        // 更新应收单核销状态
        List<FinArRecVerApplyArVO> arVOList = finApPayVerApplyHandleDTO.getArVOList();
        List<Long> arIdList = arVOList.stream().map(FinArRecVerApplyArVO::getArId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> arDtlIdList = arVOList.stream().map(FinArRecVerApplyArVO::getArDId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        List<ArOrderDTO> arOrderAllList = arOrderRepoProc.queryByIds(arIdList);
        //List<ArOrderDtlDO>  arOrderDtlDOList = arOrderDtlRepo.findAllByMasIdIn(arDtlIdList);
        //List<ArOrderDtlDTO> arOrderDtlAllList = arOrderDtlDOList.stream().map(ArOrderDtlConvert.INSTANCE::doConvertToDto).collect(Collectors.toList());

        //List<ArOrderDtlDTO> arOrderDtlAllList = arOrderDtlRepoProc.listByMasIds(arDtlIdList);
        List<ArOrderDtlDTO> arOrderDtlAllList = arOrderDtlRepoProc.listByIds(arDtlIdList);
        Map<Long, List<ArOrderDtlDTO>> arOrderDtlMap = CollectionUtil.isEmpty(arOrderDtlAllList) ? new HashMap<>() : arOrderDtlAllList.stream().collect(Collectors.groupingBy(ArOrderDtlDTO::getMasId));
        if (CollectionUtil.isNotEmpty(arOrderAllList)){
            for (ArOrderDTO arOrderDTO : arOrderAllList) {
                List<ArOrderDtlDTO> arOrderDtlList = arOrderDtlMap.get(arOrderDTO.getId());
                updateArVerState(arOrderDTO,arOrderDtlList);
            }

        }


        // 更新收款单核销状态
        List<FinArRecVerApplyRecVO> recVOList = finApPayVerApplyHandleDTO.getRecVOList();
        List<Long> recIdList = recVOList.stream().map(FinArRecVerApplyRecVO::getRecId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> recDtlIdList = recVOList.stream().map(FinArRecVerApplyRecVO::getRecDId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        List<RecOrderDTO> recOrderAllList = recOrderRepoProc.queryByIds(recIdList);

        //List<RecOrderDtlDTO> recOrderDtlAllList = recOrderDtlRepoProc.queryByMasIds(recDtlIdList);
        List<RecOrderDtlDTO> recOrderDtlAllList = recOrderDtlRepoProc.queryByIds(recDtlIdList);

        Map<Long, List<RecOrderDtlDTO>> recOrderDtlMap = CollectionUtil.isEmpty(recOrderDtlAllList) ? new HashMap<>() : recOrderDtlAllList.stream().collect(Collectors.groupingBy(RecOrderDtlDTO::getMasId));
        if (CollectionUtil.isNotEmpty(recOrderAllList)){
            for (RecOrderDTO recOrderDTO : recOrderAllList) {
                List<RecOrderDtlDTO> recOrdeDtlList = recOrderDtlMap.get(recOrderDTO.getId());
                updateRecVerState(recOrderDTO,recOrdeDtlList);
            }

        }

        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, entity.getId().toString(), OperationTypeEnum.UPDATE,
                "取消核销");
    }

    private void updateRecVerState(RecOrderDTO newRecOrderDTO,List<RecOrderDtlDTO> newRecOrderDtlDTOList){
        //处理核销状态
       /* RecOrderDTO newRecOrderDTO = recOrderRepoProc.queryById(id);
        List<RecOrderDtlDTO> newRecOrderDtlDTOList = recOrderDtlRepoProc.queryByMasId(id);*/

        BigDecimal verAmtSum = BigDecimal.ZERO;//已核销金额
        BigDecimal verAmtingSum = BigDecimal.ZERO;//核销中金额
        BigDecimal unVerAmtSum = BigDecimal.ZERO;//未核销金额
        if (CollUtil.isNotEmpty(newRecOrderDtlDTOList)) {
            for (RecOrderDtlDTO recOrderDtlDTO : newRecOrderDtlDTOList) {
                if(null != recOrderDtlDTO.getVerAmt()){
                    verAmtSum = verAmtSum.add(recOrderDtlDTO.getVerAmt());
                }
                if(recOrderDtlDTO.getApplyVerAmTing()!=null){
                    verAmtingSum = verAmtingSum.add(recOrderDtlDTO.getApplyVerAmTing());
                }
                if(recOrderDtlDTO.getUnVerAmt()!=null){
                    unVerAmtSum = unVerAmtSum.add(recOrderDtlDTO.getUnVerAmt());
                }
            }
        }

        String verState = null;
        /*if (Objects.nonNull(newRecOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newRecOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) != 0 &&
                Objects.nonNull(newRecOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newRecOrderDTO.getTotalAmt()) != 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();

        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) == 0){
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        }*/

        if (unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (Objects.nonNull(newRecOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newRecOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        } else {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();
        }

        if (org.apache.commons.lang3.StringUtils.isNotBlank(verState)){
            recOrderRepoProc.updateVerState(verState,newRecOrderDTO.getId());
        }

    }

    private void updateArVerState(ArOrderDTO newArOrderDTO,List<ArOrderDtlDTO> newArOrderDtlDTOList){
        //处理核销状态
        /*ArOrderDTO newArOrderDTO = arOrderRepoProc.get(id);
        List<ArOrderDtlDTO> newArOrderDtlDTOList = arOrderDtlRepoProc.listByMisId(id);*/
        BigDecimal verAmtSum = BigDecimal.ZERO;//已核销金额
        BigDecimal verAmtingSum = BigDecimal.ZERO;//核销中金额
        BigDecimal unVerAmtSum = BigDecimal.ZERO;//未核销金额
        if (CollUtil.isNotEmpty(newArOrderDtlDTOList)) {
            for (ArOrderDtlDTO arOrderDtlDTO : newArOrderDtlDTOList) {
                if(null != arOrderDtlDTO.getVerAmt()){
                    verAmtSum = verAmtSum.add(arOrderDtlDTO.getVerAmt());
                }
                if(arOrderDtlDTO.getApplyVerAmTing()!=null){
                    verAmtingSum = verAmtingSum.add(arOrderDtlDTO.getApplyVerAmTing());
                }
                if(arOrderDtlDTO.getUnVerAmt()!=null){
                    unVerAmtSum = unVerAmtSum.add(arOrderDtlDTO.getUnVerAmt());
                }
            }
        }

        String verState = null;
        /*if (Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newArOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) != 0 &&
                Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newArOrderDTO.getTotalAmt()) != 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();

        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) == 0){
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        }*/

        if (unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newArOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        } else {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();
        }

        if (org.apache.commons.lang3.StringUtils.isNotBlank(verState)){
            arOrderRepoProc.updateVerState(verState,newArOrderDTO.getId());
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        List<FinArRecVerApplyDO> list = finArRecVerApplyRepoProc.get(ids);
        Assert.notEmpty(list, "未查询到对应的数据信息");

        list.forEach(e -> {
            if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_NEW.getValueCode().equals(e.getState())) {
                throw new BusinessException("单据无法进行删除，请核对单据状态");
            }
        });

        finArRecVerApplyRepoProc.delete(ids);
        finArRecVerApplyArService.deleteByMasId(ids);
        finArRecVerApplyRecService.deleteByMasId(ids);
    }

    @Override
    public List<FinArRecVerApplySettleVO> settleList(Long id) {
        return finArRecVerApplySettleService.listByMasIds(Collections.singletonList(id));
    }

    private void updateArMiddleVerAmt(List<FinArRecVerApplyArSaveDTO> list) {
        list.forEach(e -> arOrderService.updateMiddleVerAmt(e.getArDId(), e.getVerAmt()));
    }

    private void updateRecMiddleVerAmt(List<FinArRecVerApplyRecSaveDTO> list) {
        list.forEach(e -> recOrderExService.updateMiddleVerAmt(e.getRecDId(), e.getVerAmt()));
    }

    private void updateOrderForVerCancel(FinArRecVerApplyDO entity) {
        entity.setVerState(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode());
        finArRecVerApplyRepoProc.save(entity);
    }

    private static final BigDecimal ZERO = BigDecimal.ZERO;

    private void verifyData(FinArRecVerApplySaveDTO save) {

        List<FinArRecVerApplyArSaveDTO> arSaveList = save.getArSaveList();
        List<FinArRecVerApplyRecSaveDTO> recSaveList = save.getRecSaveList();

        // TODO 当前不考虑对冲情况
        if (arSaveList.isEmpty()) {
            throw new BusinessException("应收单核销明细不能为空!");
        }
        if (recSaveList.isEmpty()) {
            throw new BusinessException("核销单核销明细不能为空!");
        }

        save.setVerAmt(checkAndGetTotalVerAmt(arSaveList, recSaveList));

        // 查询应收单
        List<Long> arDIds = arSaveList.stream().map(FinArRecVerApplyArSaveDTO::getArDId).collect(Collectors.toList());
        List<ArOrderDtlExVo> arOrderDtlExVos = arOrderExService.listArOrderDetail(FinArOrderDetailQuery.builder()
                .arDIds(arDIds)
                .build());
        if (arDIds.size() != arOrderDtlExVos.size()) {
            throw new BusinessException("请核对应收单单号");
        }
        // 校验应收单核销金额
        arSaveList.forEach(arSave -> arOrderDtlExVos.stream().filter(fi -> fi.getId().equals(arSave.getArDId()))
                .findFirst()
                .ifPresent(ar -> {
                    if (ZERO.compareTo(ar.getUnVerAmt().multiply(arSave.getVerAmt())) >= 0) {
                        throw new BusinessException("请校验应收单核销金额数据，单号:" + arSave.getArDocNo());
                    }
                    // 校验明细金额
                    if (ar.getUnVerAmt().abs().compareTo(arSave.getVerAmt().abs()) < 0) {
                        throw new BusinessException("应收单核销金额大于未核销金额，单号:" + arSave.getArDocNo());
                    }
                }));

        // 查询收款单
        List<Long> recDId = recSaveList.stream().map(FinArRecVerApplyRecSaveDTO::getRecDId).collect(Collectors.toList());
        List<RecOrderDtlExVo> recOrderDtlExVos = recOrderExService.listRecOrderDetail(FinRecOrderDetailQuery.builder()
                .recDIds(recDId)
                .build());
        if (recOrderDtlExVos.size() != recDId.size()) {
            throw new BusinessException("请核对收款单单号");
        }
        // 校验收款单核销金额
        recSaveList.forEach(recSave -> recOrderDtlExVos.stream().filter(fi -> fi.getId().equals(recSave.getRecDId()))
                .findFirst()
                .ifPresent(rec -> {
                    if (ZERO.compareTo(rec.getUnVerAmt().multiply(recSave.getVerAmt())) >= 0) {
                        throw new BusinessException("请校验收款单核销金额数据，单号:" + recSave.getRecDocNo());
                    }
                    // 校验明细金额
                    if (rec.getUnVerAmt().abs().compareTo(recSave.getVerAmt().abs()) < 0) {
                        throw new BusinessException("收款单核销金额大于未核销金额，单号:" + recSave.getRecDocNo());
                    }
                }));
    }
    private void verifyDataNew(FinArRecVerApplySaveDTO save) {
        List<FinArRecVerApplyArSaveDTO> arSaveList = save.getArSaveList();
        List<FinArRecVerApplyRecSaveDTO> recSaveList = save.getRecSaveList();
        if(CollectionUtils.isEmpty(arSaveList)&&CollectionUtils.isEmpty(recSaveList)){
            throw new BusinessException("应收单和收款单不能同时为空");
        }
        save.setVerAmt(checkAndGetTotalVerAmtNew(arSaveList, recSaveList));
        // 查询应收单
        if(CollectionUtils.isNotEmpty(arSaveList)){
            List<Long> arDIds = arSaveList.stream().map(FinArRecVerApplyArSaveDTO::getArDId).collect(Collectors.toList());
            List<ArOrderDtlExVo> arOrderDtlExVos = arOrderExService.listArOrderDetail(FinArOrderDetailQuery.builder()
                    .arDIds(arDIds)
                    .build());
            if (arDIds.size() != arOrderDtlExVos.size()) {
                throw new BusinessException("请核对应收单单号");
            }
            // 校验应收单核销金额
            arSaveList.forEach(arSave -> arOrderDtlExVos.stream().filter(fi -> fi.getId().equals(arSave.getArDId()))
                    .findFirst()
                    .ifPresent(ar -> {
                        if (ZERO.compareTo(ar.getUnVerAmt().multiply(arSave.getVerAmt())) >= 0) {
                            throw new BusinessException("请校验应收单核销金额数据，单号:" + arSave.getArDocNo());
                        }
                        // 校验明细金额
                        if (ar.getUnVerAmt().abs().compareTo(arSave.getVerAmt().abs()) < 0) {
                            throw new BusinessException("应收单核销金额大于未核销金额，单号:" + arSave.getArDocNo());
                        }
                    }));
        }
        if(CollectionUtils.isNotEmpty(recSaveList)){
            // 查询收款单
            List<Long> recDId = recSaveList.stream().map(FinArRecVerApplyRecSaveDTO::getRecDId).collect(Collectors.toList());
            List<RecOrderDtlExVo> recOrderDtlExVos = recOrderExService.listRecOrderDetail(FinRecOrderDetailQuery.builder()
                    .recDIds(recDId)
                    .build());
            if (recOrderDtlExVos.size() != recDId.size()) {
                throw new BusinessException("请核对收款单单号");
            }
            // 校验收款单核销金额
            recSaveList.forEach(recSave -> recOrderDtlExVos.stream().filter(fi -> fi.getId().equals(recSave.getRecDId()))
                    .findFirst()
                    .ifPresent(rec -> {
                        if (ZERO.compareTo(rec.getUnVerAmt().multiply(recSave.getVerAmt())) >= 0) {
                            throw new BusinessException("请校验收款单核销金额数据，单号:" + recSave.getRecDocNo());
                        }
                        // 校验明细金额
                        if (rec.getUnVerAmt().abs().compareTo(recSave.getVerAmt().abs()) < 0) {
                            throw new BusinessException("收款单核销金额大于未核销金额，单号:" + recSave.getRecDocNo());
                        }
                    }));
        }
    }
    /**
     * 校验应收单、收款单核销总金额是否相等，并返回核销总金额.
     *
     * @param arSaveList  应收单明细
     * @param recSaveList 收款单明细
     */
    private BigDecimal checkAndGetTotalVerAmt(List<FinArRecVerApplyArSaveDTO> arSaveList,
                                              List<FinArRecVerApplyRecSaveDTO> recSaveList) {

        BigDecimal arVerAmt = arSaveList.stream().map(FinArRecVerApplyArSaveDTO::getVerAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        BigDecimal recVerAmt = recSaveList.stream().map(FinArRecVerApplyRecSaveDTO::getVerAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        if (arVerAmt.compareTo(recVerAmt) != 0) {
            throw new BusinessException("应收单收款单核销金额不相等");
        }
        return arVerAmt;
    }
    private BigDecimal checkAndGetTotalVerAmtNew(List<FinArRecVerApplyArSaveDTO> arSaveList,
                                              List<FinArRecVerApplyRecSaveDTO> recSaveList) {
        BigDecimal arVerAmt = BigDecimal.ZERO;
        BigDecimal recVerAmt = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(arSaveList)){
            arSaveList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "应收单核销金额不能为空"));
            arVerAmt = arSaveList.stream().map(FinArRecVerApplyArSaveDTO::getVerAmt)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if(CollectionUtils.isNotEmpty(recSaveList)){
            recSaveList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "收款单核销金额不能为空"));
            recVerAmt = recSaveList.stream().map(FinArRecVerApplyRecSaveDTO::getVerAmt)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (arVerAmt.compareTo(recVerAmt) != 0) {
            throw new BusinessException("应收单收款单核销金额不相等");
        }
        return arVerAmt;
    }
    /*private void releaseVerAmt(Collection<Long> ids) {
        updateVerAmt(ids, FinArRecVerificationDTO.VerType.CANCEL);
    }

    private void addVerAmt(Collection<Long> ids) {
        updateVerAmt(ids, FinArRecVerificationDTO.VerType.APPROVE);
    }*/

    public void updateVerAmt(Collection<Long> ids, String verType) {
        // 进行 NC接口调用
      //  sendNcVerRequest(ids, verType);

        // 无效处理
        BigDecimal factor = BigDecimal.ONE;

        // 更新应收单核销金额
        List<FinArRecVerApplyArVO> arVOList = finArRecVerApplyArService.listByMasIds(ids);
        arVOList.forEach(e -> arOrderExService.updateVerAmt(e.getArDId(), e.getVerAmt().multiply(factor), verType));

        // 更新收款单核销金额
        List<FinArRecVerApplyRecVO> recVOList = finArRecVerApplyRecService.listByMasIds(ids);
        recVOList.forEach(e -> recOrderExService.updateVerAmt(e.getRecDId(), e.getVerAmt().multiply(factor), verType));

    }

   /* *//**
     * 调用NC接口进行 通过核销/取消核销.
     *
     * @param ids     核销申请单主键
     * @param verType 操作类型
     *//*
    private void sendNcVerRequest(Collection<Long> ids, String verType) {

        List<FinArRecVerApplySettleVO> settleList = finArRecVerApplySettleService.listByMasIds(ids);
        Assert.notEmpty(settleList, "明细拆分集合为空，请核对数据!");

        List<FinArRecVerificationDTO> requestParam = null;//new ArrayList<>(settleList.size());

        ids.forEach(id -> settleList.stream().filter(fi -> fi.getMasId().equals(id)).collect(Collectors.toList())
                .forEach(e -> requestParam.add(getBuilder(verType, e).build())));

        if (requestParam.isEmpty()) {
            throw new BusinessException("构建NC接口请求参数失败");
        }

        ApiResult<String> result = sendRequest(finArRecVerApplyRepoProc.get(ids).stream().map(FinArRecVerApplyDO::getApplyDocNo).distinct().collect(Collectors.joining(",")), verType, requestParam);
        if (null == result) {
            log.error("接口调用失败，请稍后再试");
            throw new BusinessException("接口调用失败，请稍后再试");
        }
        if (result.isFailed()) {
            log.error("NC核销通过/取消核销接口调用失败:{}", result.getMsg());
            throw new BusinessException("NC核销通过/取消核销接口调用失败:" + result.getMsg());
        }

        if (FinArRecVerificationDTO.VerType.APPROVE.equals(verType)) {
            String bachNo = result.getData();
            Assert.notEmpty(bachNo, "核销处理编号不能为空!");

            // 兼容红蓝对冲，返回的是list
            if (bachNo.startsWith("[{")) {
                JSONArray array = JSONUtil.parseArray(bachNo);

                array.forEach(e->{
                    NcFinResultVo ncFinResult = JSONUtil.toBean(e.toString(), NcFinResultVo.class);
                    // 成功则更新核销批次号
                    if("1".equals(ncFinResult.getFlag())){
                        if(StrUtil.isNotEmpty(ncFinResult.getRedbluevbillcode())) {
                            if (StrUtil.isNotEmpty(ncFinResult.getYsztmxid())) {
                                finArRecVerApplySettleService.updateBatchNoByArDid(ncFinResult.getYsztmxid(), ncFinResult.getRedbluevbillcode());
                            } else {
                                finArRecVerApplySettleService.updateBatchNoByRcDid(ncFinResult.getSkztmxid(), ncFinResult.getRedbluevbillcode());
                            }
                        }else {
                            finArRecVerApplySettleService.updateBatchNoByArDid(ncFinResult.getYsztmxid(), ncFinResult.getVbillcode());
                        }

                    }
                });
            }else {
                finArRecVerApplySettleService.updateBatchNo(ids, bachNo);
            }
        }else {
            finArRecVerApplySettleService.updateVerFlag(ids, "CANCEL");
        }
    }*/

    /*private FinArRecVerificationDTO.FinArRecVerificationDTOBuilder getBuilder(String verType, FinArRecVerApplySettleVO e) {
        // 查询应收收款核销申请单
        FinArRecVerApplyDO applyDO = finArRecVerApplyRepoProc.get(e.getMasId());
        Assert.notNull(applyDO, "未查询到对应的申请单信息，id:" + e.getMasId());

        FinArRecVerificationDTO.FinArRecVerificationDTOBuilder builder = FinArRecVerificationDTO.builder()
                .arOutNo(e.getOutArDocNo())
                .arCustCode(e.getArCustCode())
                .arDId(e.getOutArDId())
                .arAmt(e.getArNotVerAmt())
                .recOutNo(e.getOutRecDocNo())
                .recCustCode(e.getRecCustCode())
                .recDId(e.getOutRecDId())
                .recAmt(e.getRecNotVerAmt())
                .verAmt(e.getVerAmt())
                .creator(applyDO.getApplyUserName())
                .verType(FinArRecVerificationDTO.VerType.CANCEL.equals(verType)?"2":"NORMA".equals(e.getVerFlag())?"1":"3");
        if (FinArRecVerificationDTO.VerType.CANCEL.equals(verType)) {
            builder.batchNo(e.getBatchNo());
        }
        return builder;
    }*/

/*    private ApiResult<String> sendRequest(String bizKey, String verType, List<FinArRecVerificationDTO> param) {
        ApiResult<String> result;
        if (FinArRecVerificationDTO.VerType.CANCEL.equals(verType)) {
            // 如果是取消则取当前用户
            param.forEach(e -> e.setCreator(CURRENT_USER.get()));
            result = finArRecVerLocalService.cancel(bizKey, param);
        } else {
            result = finArRecVerLocalService.approve(bizKey, param);
        }
        return result;
    }*/

    private Long doUpdate(FinArRecVerApplySaveDTO save) {

        updateApplyOrder(save);

        // 删除核销单明细数据
        finArRecVerApplyArService.deleteByMasId(Collections.singleton(save.getId()));
        finArRecVerApplyRecService.deleteByMasId(Collections.singleton(save.getId()));

        // 插入核销单明细
        finArRecVerApplyArService.createBatch(save.getId(), save.getArSaveList());
        finArRecVerApplyRecService.createBatch(save.getId(), save.getRecSaveList());

        return save.getId();
    }

    @NotNull
    private FinArRecVerApplyDO findApplyOrder(Long id) {
        FinArRecVerApplyDO entity = finArRecVerApplyRepoProc.get(id);
        Assert.notNull(entity, "未查询到对应的申请单信息，id:" + id);
        return entity;
    }

    private Long doCreate(FinArRecVerApplySaveDTO save) {

        // 插入核销单数据
        long id = createApplyOrder(save);

        // 插入核销单明细
        finArRecVerApplyArService.createBatch(id, save.getArSaveList());
        finArRecVerApplyRecService.createBatch(id, save.getRecSaveList());

        return id;
    }

    private long createApplyOrder(FinArRecVerApplySaveDTO save) {
        FinArRecVerApplyDO entity = FinArRecVerApplyConvert.INSTANCE.save2Do(save);

        entity.setApplyDocNo(seqNumProvider.generateCode(com.elitesland.fin.Application.NAME, FinConstant.ACCOUNT_FLOW_NO, Collections.emptyList()));
        entity.setState(save.getState() == null ? WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_NEW.getValueCode() : save.getState());
        entity.setVerState(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_NOT.getValueCode());
        entity.setApplyDate(LocalDateTime.now());

        entity.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());


        GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        entity.setApplyUserId(principal.getUserId());
        //entity.setApplyUserName(principal.getUsername());
        SysUserDTO user = principal.getUser();
        if(user!=null){
            entity.setApplyUserName(user.getLastName());
        }
        finArRecVerApplyRepoProc.save(entity);
        //日志
        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, entity.getId().toString(), OperationTypeEnum.ADD,
            BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.ADD));
        save.setApplyDocNo(entity.getApplyDocNo());
        return entity.getId();
    }

    private void updateApplyOrder(FinArRecVerApplySaveDTO save) {
        FinArRecVerApplyDO entity = finArRecVerApplyRepoProc.get(save.getId());
        Assert.notNull(entity, "未查询到对应的核销申请单，ID:" + save.getId());

        // 更新核销单信息
        FinArRecVerApplyConvert.INSTANCE.save2Do(save, entity);
        finArRecVerApplyRepoProc.save(entity);
        //日志
        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, entity.getId().toString(), OperationTypeEnum.UPDATE,
            BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.UPDATE));
    }

    private void setApprovalMsg(FinArRecApplyApprovalDTO dto, List<FinArRecVerApplyDO> applyList) {
        applyList.forEach(e -> {
            if (dto.getApprovalType() == FinArRecApplyApprovalDTO.ApprovalType.APPROVE) {
                e.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVALING.getValueCode());
//                e.setVerState(UdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());
            } else {
                e.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_REFUSE.getValueCode());
            }
            GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            e.setApprovalUserId(principal.getUserId());
            //e.setApprovalUserName(principal.getUsername());
            SysUserDTO user = principal.getUser();
            if(user!=null){
                e.setApprovalUserName(user.getLastName());
            }
            e.setApprovalDate(LocalDateTime.now());
            if (StringUtils.hasText(dto.getApprovalRemark())) {
                e.setApprovalRemark(dto.getApprovalRemark());
            }
        });
    }

    private void preCheckForApproval(List<String> applyNos, List<FinArRecVerApplyDO> applyList) {

        // 校验查询数据
        if (applyNos.size() > applyList.size()) {
            if (applyNos.removeAll(applyList.stream().map(FinArRecVerApplyDO::getApplyDocNo).collect(Collectors.toList()))) {
                throw new BusinessException("未查询到核销申请信息，请核对以下单号:" + applyNos);
            }
        }

        // 校验核销申请状态
        List<String> fiRes = applyList.stream()
                .filter(fi -> !WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(fi.getState()))
                .map(FinArRecVerApplyDO::getApplyDocNo)
                .collect(Collectors.toList());

        if (CollUtil.isNotEmpty(fiRes)) {
            throw new BusinessException("以下核销申请单无法进行当前操作:" + fiRes);
        }
    }

    private List<FinArRecVerApplySettleSaveDTO> settleApplyDetailList(List<FinArRecVerApplyArSaveDTO> ars, List<FinArRecVerApplyRecSaveDTO> recs) {

        List<FinArRecVerApplyArSaveDTO> arList = ars.stream()
                .sorted(Comparator.comparing(FinArRecVerApplyArSaveDTO::getVerAmt))
                .collect(Collectors.toList());

        List<FinArRecVerApplyRecSaveDTO> recList = recs.stream()
                .sorted(Comparator.comparing(FinArRecVerApplyRecSaveDTO::getVerAmt))
                .collect(Collectors.toList());

        return doSettle(arList, recList);
    }
    private List<FinArRecVerApplySettleSaveDTO> settleApplyDetailListNew(List<FinArRecVerApplyArSaveDTO> ars, List<FinArRecVerApplyRecSaveDTO> recs) {
        List<FinArRecVerApplySettleSaveDTO> settles = new ArrayList<>();
        List<FinArRecVerApplyArSaveDTO> leftAllArlist = new ArrayList<>();
        List<FinArRecVerApplyRecSaveDTO> leftAllReclist = new ArrayList<>();
        List<FinArRecVerApplyArSaveDTO> zeroArlist = ars.stream().filter(ar->ar.getVerAmt().compareTo(BigDecimal.ZERO)==0).collect(Collectors.toList());
        List<FinArRecVerApplyRecSaveDTO> zeroReclist = recs.stream().filter(rec->rec.getVerAmt().compareTo(BigDecimal.ZERO)==0).collect(Collectors.toList());
        //1.应收单是否有正负数核销金额
        List<FinArRecVerApplyArSaveDTO> arListPositive  = ars.stream().filter(ar->ar.getVerAmt().compareTo(BigDecimal.ZERO)>0).collect(Collectors.toList());
        List<FinArRecVerApplyArSaveDTO> arListNegative  = ars.stream().filter(ar->ar.getVerAmt().compareTo(BigDecimal.ZERO)<0).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(arListPositive)&&CollectionUtils.isNotEmpty(arListNegative)){
            List<FinArRecVerApplyArSaveDTO> leftArlist = doSettleForArOffset(arListPositive, arListNegative, settles);
            if(CollectionUtils.isNotEmpty(leftArlist)){
                leftAllArlist.addAll(leftArlist);
            }
        }else{
            if(CollectionUtils.isNotEmpty(arListPositive)){
                leftAllArlist.addAll(arListPositive);
            }
            if(CollectionUtils.isNotEmpty(arListNegative)){
                leftAllArlist.addAll(arListNegative);
            }
        }
        //2.收款单是否有正负数核销金额
        List<FinArRecVerApplyRecSaveDTO> recListPositive  = recs.stream().filter(rec->rec.getVerAmt().compareTo(BigDecimal.ZERO)>0).collect(Collectors.toList());
        List<FinArRecVerApplyRecSaveDTO> recListNegative  = recs.stream().filter(rec->rec.getVerAmt().compareTo(BigDecimal.ZERO)<0).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(recListPositive)&&CollectionUtils.isNotEmpty(recListNegative)){
            List<FinArRecVerApplyRecSaveDTO> leftReclist = doSettleForRecOffset(recListPositive, recListNegative, settles);
            if(CollectionUtils.isNotEmpty(leftReclist)){
                leftAllReclist.addAll(leftReclist);
            }
        }else{
            if(CollectionUtils.isNotEmpty(recListPositive)){
                leftAllReclist.addAll(recListPositive);
            }
            if(CollectionUtils.isNotEmpty(recListNegative)){
                leftAllReclist.addAll(recListNegative);
            }
        }
        //一方为0，则说明另一方也为0，所以不用再进一步核销了
        if(CollectionUtils.isEmpty(leftAllArlist)||CollectionUtils.isEmpty(leftAllReclist)){
            return settles;
        }
        List<FinArRecVerApplyArSaveDTO> arList = leftAllArlist.stream()
                .sorted(Comparator.comparing(FinArRecVerApplyArSaveDTO::getVerAmt))
                .collect(Collectors.toList());
        List<FinArRecVerApplyRecSaveDTO> recList = leftAllReclist.stream()
                .sorted(Comparator.comparing(FinArRecVerApplyRecSaveDTO::getVerAmt))
                .collect(Collectors.toList());
        settles.addAll(doSettleNew(arList,recList));
        return settles;
    }
    private List<FinArRecVerApplyArSaveDTO> doSettleForArOffset(List<FinArRecVerApplyArSaveDTO> arListPositive, List<FinArRecVerApplyArSaveDTO> arListNegative,List<FinArRecVerApplySettleSaveDTO> settles) {
           //设置原始核销金额
        arListPositive.forEach(v->v.setOrigVerAmt(v.getVerAmt()));
        arListNegative.forEach(v->v.setOrigVerAmt(v.getVerAmt()));
            //正数从小到大排序
        List<FinArRecVerApplyArSaveDTO> arListPositiveSorted = arListPositive.stream()
                .sorted(Comparator.comparing(FinArRecVerApplyArSaveDTO::getVerAmt))
                .collect(Collectors.toList());
        //负数从大到小排序
        List<FinArRecVerApplyArSaveDTO> arListNegativeSorted = arListNegative.stream()
                .sorted(Comparator.comparing(FinArRecVerApplyArSaveDTO::getVerAmt))
                .collect(Collectors.toList());
        Collections.reverse(arListNegativeSorted);
        List<FinArRecVerApplyArSaveDTO> arListPositiveRm = new ArrayList<>();
        List<FinArRecVerApplyArSaveDTO> arListNegativeRm = new ArrayList<>();
        arListNegativeSorted.stream().forEach(arn -> arListPositiveSorted.stream().forEach(arp -> {
            //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
            boolean writeOffFlag = BigDecimal.ZERO.compareTo(arn.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(arp.getVerAmt()) == 0;
            //本次循环是否继续
            if (writeOffFlag) {
                return;
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) < 0) {
                settles.add(buildSettleForArOffset(arp,null));
                arn.setVerAmt(arn.getVerAmt().add(arp.getVerAmt()));
                arp.setVerAmt(BigDecimal.ZERO);
                arListPositiveRm.add(arp);
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) == 0) {
                settles.add(buildSettleForArOffset(arn,null));
                settles.add(buildSettleForArOffset(arp,null));
                arn.setVerAmt(BigDecimal.ZERO);
                arp.setVerAmt(BigDecimal.ZERO);
                arListPositiveRm.add(arp);
                arListNegativeRm.add(arn);
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) > 0) {
                settles.add(buildSettleForArOffset(arn,null));
                arp.setVerAmt(arp.getVerAmt().add(arn.getVerAmt()));
                arn.setVerAmt(BigDecimal.ZERO);
                arListNegativeRm.add(arn);
            }
        }));
        arListPositive.removeAll(arListPositiveRm);
        arListNegative.removeAll(arListNegativeRm);
        if(CollectionUtils.isNotEmpty(arListPositive)){
            Optional<FinArRecVerApplyArSaveDTO> first = arListPositive.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if(first.isPresent()){
                settles.add(buildSettleForArOffset(first.get(),first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return arListPositive;
        }
        if(CollectionUtils.isNotEmpty(arListNegative)){
            Optional<FinArRecVerApplyArSaveDTO> first = arListNegative.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if(first.isPresent()){
                settles.add(buildSettleForArOffset(first.get(),first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return arListNegative;
        }
        return null;
    }
    private List<FinArRecVerApplyRecSaveDTO> doSettleForRecOffset(List<FinArRecVerApplyRecSaveDTO> recListPositive, List<FinArRecVerApplyRecSaveDTO> recListNegative,List<FinArRecVerApplySettleSaveDTO> settles) {
        //设置原始核销金额
        recListPositive.forEach(v->v.setOrigVerAmt(v.getVerAmt()));
        recListNegative.forEach(v->v.setOrigVerAmt(v.getVerAmt()));
        //正数从小到大排序
        List<FinArRecVerApplyRecSaveDTO> recListPositiveSorted = recListPositive.stream()
                .sorted(Comparator.comparing(FinArRecVerApplyRecSaveDTO::getVerAmt))
                .collect(Collectors.toList());
        //负数从大到小排序
        List<FinArRecVerApplyRecSaveDTO> recListNegativeSorted = recListNegative.stream()
                .sorted(Comparator.comparing(FinArRecVerApplyRecSaveDTO::getVerAmt))
                .collect(Collectors.toList());
        Collections.reverse(recListNegativeSorted);
        List<FinArRecVerApplyRecSaveDTO> recListPositiveRm = new ArrayList<>();
        List<FinArRecVerApplyRecSaveDTO> recListNegativeRm = new ArrayList<>();
        recListNegativeSorted.stream().forEach(recn -> recListPositiveSorted.stream().forEach(recp -> {
            //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
            boolean writeOffFlag = BigDecimal.ZERO.compareTo(recn.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(recp.getVerAmt()) == 0;
            //本次循环是否继续
            if (writeOffFlag) {
                return;
            }
            if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) < 0) {
                settles.add(buildSettleForRecOffset(recp,null));
                recn.setVerAmt(recn.getVerAmt().add(recp.getVerAmt()));
                recp.setVerAmt(BigDecimal.ZERO);
                recListPositiveRm.add(recp);
            }else if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) == 0) {
                settles.add(buildSettleForRecOffset(recn,null));
                settles.add(buildSettleForRecOffset(recp,null));
                recn.setVerAmt(BigDecimal.ZERO);
                recp.setVerAmt(BigDecimal.ZERO);
                recListPositiveRm.add(recp);
                recListNegativeRm.add(recn);
            }else if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) > 0) {
                settles.add(buildSettleForRecOffset(recn,null));
                recp.setVerAmt(recp.getVerAmt().add(recn.getVerAmt()));
                recn.setVerAmt(BigDecimal.ZERO);
                recListNegativeRm.add(recn);
            }
        }));
        recListPositive.removeAll(recListPositiveRm);
        recListNegative.removeAll(recListNegativeRm);
        if(CollectionUtils.isNotEmpty(recListPositive)){
            Optional<FinArRecVerApplyRecSaveDTO> first = recListPositive.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if(first.isPresent()){
                settles.add(buildSettleForRecOffset(first.get(),first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return recListPositive;
        }
        if(CollectionUtils.isNotEmpty(recListNegative)){
            Optional<FinArRecVerApplyRecSaveDTO> first = recListNegative.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if(first.isPresent()){
                settles.add(buildSettleForRecOffset(first.get(),first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return recListNegative;
        }
        return null;
    }
    private List<FinArRecVerApplySettleSaveDTO> doSettle(List<FinArRecVerApplyArSaveDTO> arList, List<FinArRecVerApplyRecSaveDTO> recList) {
        List<FinArRecVerApplySettleSaveDTO> settles = new ArrayList<>();

        arList.stream().forEach(ar -> recList.stream().forEach(rec -> {

            //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
            boolean writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) &&
                    settles.size() != 0;

            //核销金额为0
            if (writeOffFlag) {
                return;
            }
            if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                ar.setVerAmt(BigDecimal.ZERO);
            } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                ar.setVerAmt(BigDecimal.ZERO);
                rec.setVerAmt(BigDecimal.ZERO);
            }else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                settles.add(buildSettle(ar, rec, rec.getVerAmt()));
                ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                rec.setVerAmt(BigDecimal.ZERO);
            }
        }));
        return settles;
    }
    private List<FinArRecVerApplySettleSaveDTO> doSettleNew(List<FinArRecVerApplyArSaveDTO> arList, List<FinArRecVerApplyRecSaveDTO> recList) {
        //确定正向、负向，通过对冲之后，只有一种情况，要么是正要么是负
        final boolean isPositive=arList.get(0).getVerAmt().compareTo(BigDecimal.ZERO)>0;
        List<FinArRecVerApplySettleSaveDTO> settles = new ArrayList<>();
        if(isPositive){
            arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
                //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
                boolean writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) &&
                        settles.size() != 0;
                //核销金额为0
                if (writeOffFlag) {
                    return;
                }
                if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                    settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                    rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                    settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                    rec.setVerAmt(BigDecimal.ZERO);
                }else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                    settles.add(buildSettle(ar, rec, rec.getVerAmt()));
                    ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                    rec.setVerAmt(BigDecimal.ZERO);
                }
            }));
        }else{
            arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
                //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
                boolean writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) &&
                        settles.size() != 0;
                //核销金额为0
                if (writeOffFlag) {
                    return;
                }
                if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                    settles.add(buildSettle(ar, rec, rec.getVerAmt()));
                    ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                    rec.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                    settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                    rec.setVerAmt(BigDecimal.ZERO);
                }else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                    settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                    rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                }
            }));
        }
        return settles;
    }
    private FinArRecVerApplySettleSaveDTO buildSettle(FinArRecVerApplyArSaveDTO ar, FinArRecVerApplyRecSaveDTO rec, BigDecimal verAmt) {
        FinArRecVerApplySettleSaveDTO settle = new FinArRecVerApplySettleSaveDTO();
        settle.setArId(ar.getArId());
        settle.setArDocNo(ar.getArDocNo());
        settle.setOutArDocNo(ar.getOutArDocNo());
        settle.setArDId(ar.getArDId());
        settle.setOutArDId(ar.getOutArDId());

        settle.setRecId(rec.getRecId());
        settle.setRecDocNo(rec.getRecDocNo());
        settle.setOutRecDocNo(rec.getOutRecDocNo());
        settle.setRecDId(rec.getRecDId());
        settle.setOutRecDId(rec.getOutRecDId());

        settle.setArCustCode(ar.getCustCode());
        settle.setRecCustCode(rec.getCustCode());
        settle.setArNotVerAmt(ar.getNotVerAmt());
        settle.setRecNotVerAmt(rec.getNotVerAmt());
        settle.setVerAmt(verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_NORMAL.getValueCode());
        return settle;
    }
    private FinArRecVerApplySettleSaveDTO buildSettleForArOffset(FinArRecVerApplyArSaveDTO arOffset,BigDecimal verAmt) {
        FinArRecVerApplySettleSaveDTO settle = new FinArRecVerApplySettleSaveDTO();
        settle.setArId(arOffset.getArId());
        settle.setArDocNo(arOffset.getArDocNo());
        settle.setOutArDocNo(arOffset.getOutArDocNo());
        settle.setArDId(arOffset.getArDId());
        settle.setOutArDId(arOffset.getOutArDId());

        /*settle.setRecId(rec.getRecId());
        settle.setRecDocNo(rec.getRecDocNo());
        settle.setOutRecDocNo(rec.getOutRecDocNo());
        settle.setRecDId(rec.getRecDId());
        settle.setOutRecDId(rec.getOutRecDId());*/

        settle.setArCustCode(arOffset.getCustCode());
        //settle.setRecCustCode(rec.getCustCode());
        settle.setArNotVerAmt(arOffset.getNotVerAmt());
        //settle.setRecNotVerAmt(rec.getNotVerAmt());
        settle.setVerAmt(verAmt==null?arOffset.getOrigVerAmt():verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_INTERNAL.getValueCode());
        return settle;
    }
    private FinArRecVerApplySettleSaveDTO buildSettleForRecOffset(FinArRecVerApplyRecSaveDTO recOffset,BigDecimal verAmt) {
        FinArRecVerApplySettleSaveDTO settle = new FinArRecVerApplySettleSaveDTO();
     /*   settle.setArId(arOffset.getArId());
        settle.setArDocNo(arOffset.getArDocNo());
        settle.setOutArDocNo(arOffset.getOutArDocNo());
        settle.setArDId(arOffset.getArDId());
        settle.setOutArDId(arOffset.getOutArDId());*/

        settle.setRecId(recOffset.getRecId());
        settle.setRecDocNo(recOffset.getRecDocNo());
        settle.setOutRecDocNo(recOffset.getOutRecDocNo());
        settle.setRecDId(recOffset.getRecDId());
        settle.setOutRecDId(recOffset.getOutRecDId());

        //settle.setArCustCode(arOffset.getCustCode());
        settle.setRecCustCode(recOffset.getCustCode());
        //settle.setArNotVerAmt(arOffset.getNotVerAmt());
        settle.setRecNotVerAmt(recOffset.getNotVerAmt());
        settle.setVerAmt(verAmt==null?recOffset.getOrigVerAmt():verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_INTERNAL.getValueCode());
        return settle;
    }
    @Override
    public Long autoWriteoff(List<WriteoffVO> writeoffVOS,Long schemeId){
        if(CollectionUtils.isEmpty(writeoffVOS)){
            return null;
        }
        FinArRecVerApplySaveDTO finArRecVerApplySaveDTO = new FinArRecVerApplySaveDTO();
        List<FinArRecVerApplyArHeadSaveDTO> arHeadSaveList = new ArrayList<>();
        List<FinArRecVerApplyRecHeadSaveDTO> recHeadSaveList = new ArrayList<>();
        finArRecVerApplySaveDTO.setArHeadSaveList(arHeadSaveList);
        finArRecVerApplySaveDTO.setRecHeadSaveList(recHeadSaveList);
        for (WriteoffVO writeoffVO : writeoffVOS) {
            if(writeoffVO instanceof ArOrderVO){
                ArOrderVO arOrderVO = (ArOrderVO) writeoffVO;
                FinArRecVerApplyArHeadSaveDTO finArRecVerApplyArHeadSaveDTO = ArOrderConvert.INSTANCE.convertVO2FinArRecVerApplyArHeadSaveDTO(arOrderVO);
                arHeadSaveList.add(finArRecVerApplyArHeadSaveDTO);
            }else if(writeoffVO instanceof RecOrderVO){
                RecOrderVO recOrderVO=(RecOrderVO)writeoffVO;
                FinArRecVerApplyRecHeadSaveDTO finArRecVerApplyRecHeadSaveDTO = RecOrderConvert.INSTANCE.convertVO2FinArRecVerApplyRecHeadSaveDTO(recOrderVO);
                recHeadSaveList.add(finArRecVerApplyRecHeadSaveDTO);
            }
        }
        finArRecVerApplySaveDTO.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_AUTOMATIC.getValueCode());
        finArRecVerApplySaveDTO.setSchemeId(schemeId);
        finArRecVerApplySaveDTO.setHeadFlag(true);
        final Long id = this.writeOffSubmit(finArRecVerApplySaveDTO);
        return id;
    }
    @Override
    public void autoWriteoffAr(ArOrderDTO arOrderDTO) {
        log.info("自动核销应收单,-------开始");
        final Long arId= arOrderDTO.getId();
        if(arId==null){
            log.error("自动核销应收单，单据ID为空");
            throw new BusinessException("自动核销应收单，单据ID为空");
        }
        //1.根据ID查找应收单即明细信息
        final ArOrderDTO arOrderDTO1 = arOrderDomainService.get(arId);
        if(arOrderDTO1==null){
            log.error("自动核销应收单，查询应收单失败，单据ID：{}",arId);
            return ;
            //throw new BusinessException(String.format("自动核销应收单，查询应收单失败，单据ID：%s",arId));
        }
        if(BigDecimal.ZERO.equals(arOrderDTO.getTotalAmt())){
            log.info("自动核销收款单，待核销金额为0，无需核销，单据ID：{}",arId);
            return ;
        }
        ArOrderVO currArOrderVO=ArOrderConvert.INSTANCE.convert(arOrderDTO1);
        boolean positiveAmtFlag=arOrderDTO1.getTotalAmt().compareTo(BigDecimal.ZERO)>0;
        //2.查询核销方案列表
        final ArVerConfigDTO arVerConfigDTO = arVerConfigDomainService.queryDef();
        if(arVerConfigDTO==null){
            log.error("自动核销应收单，未查询到核销方案，单据编码：{}",arOrderDTO1.getArOrderNo());
            //throw new BusinessException(String.format("自动核销应收单，未查询到核销方案，单据编码：%s",arOrderDTO1.getArOrderNo()));
            return ;
        }
        Long schemeId = arVerConfigDTO.getId();
        final List<ArVerConfigDtlDTO> arVerConfigDtlDTOS = arVerConfigDtlRepoProc.queryByMasId(arVerConfigDTO.getId());
        if(org.apache.commons.collections4.CollectionUtils.isEmpty(arVerConfigDtlDTOS)){
            log.error("自动核销应收单，未查询到核销方案明细，未查询到核销方案编码：{}",arOrderDTO1.getArOrderNo());
            //throw new BusinessException(String.format("自动核销应收单，未查询到核销方案明细，未查询到核销方案编码，单据编码：%s",arOrderDTO1.getArOrderNo()));
            return ;
        }
        //3.过滤出默认、且启用的
        //4.遍历查找field_no是so_doc_no的核销方案列表，找到即结束，为找到则记录报错日志，结束流程
        final Boolean redOffsetFlag = arVerConfigDTO.getRedOffsetFlag();
        final String writeoffOrder = arVerConfigDTO.getWriteoffOrder();
        String ou_code=null;
        String cust_code=null;
        String curr_code=null;
        String so_doc_no=null;
        for (ArVerConfigDtlDTO arVerConfigDtlDTO : arVerConfigDtlDTOS) {
            if("ou_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                ou_code = arOrderDTO1.getOuCode();
            }else if("cust_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                cust_code = arOrderDTO1.getCustCode();
            }else if("curr_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                curr_code = arOrderDTO1.getCurrCode();
            }else if("so_doc_no".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                so_doc_no = arOrderDTO1.getSourceNo();
            }
        }
        //5.找出当前核销方案公司、客户、币种、来源单号的匹配标识
        //6.根据上步找到的匹配标识，和当前应收单信息，确定过滤参数值
        //7.查看红蓝对冲标识，若是红蓝对冲匹配，增加查询其他应收单
        //8.根据6,7参数值联合查询待核销应收单和收款单列表，并按核销方案排序标识进行排序，分页查询，按整单处理
        //如果支持红蓝对冲，查询应付单
        boolean asc=true;
        if(WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_FRONT_BACK.getValueCode().equals(writeoffOrder)){
            asc=true;
        }else if(WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_BACK_FRONT.getValueCode().equals(writeoffOrder)){
            asc=false;
        }
        final boolean finAsc=asc;
        List<OrderItem> orders = new ArrayList<>();
        OrderItem orderItem=new OrderItem();
        orderItem.setColumn("buDate");
        orderItem.setAsc(asc);
        orders.add(orderItem);
        PagingVO<ArOrderVO> arOrderVOPagingVO=null;
        if(redOffsetFlag){
            ArOrderPageParam arOrderPageParam = new ArOrderPageParam();
            arOrderPageParam.setOuCode(ou_code);
            arOrderPageParam.setCustCode(cust_code);
            arOrderPageParam.setCurrCode(curr_code);
            arOrderPageParam.setOrders(orders);
            arOrderPageParam.setSize(Integer.MAX_VALUE);
            if(positiveAmtFlag){
                arOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_LT);
            }else{
                arOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_GT);
            }
            arOrderVOPagingVO = arOrderService.writeoffPage(arOrderPageParam);
        }
        //查询收款款单
        RecOrderPageParam recOrderPageParam = new RecOrderPageParam();
        recOrderPageParam.setOuCode(ou_code);
        recOrderPageParam.setCustCode(cust_code);
        recOrderPageParam.setCurrCode(curr_code);
        orderItem.setColumn("reDate");
        recOrderPageParam.setOrders(orders);
        recOrderPageParam.setSize(Integer.MAX_VALUE);
        if(positiveAmtFlag){
            recOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_GT);
        }else{
            recOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_LT);
        }
        final PagingVO<RecOrderVO> recOrderVOPagingVO = recOrderService.writeoffPage(recOrderPageParam);
        //一起排序
        List<WriteoffVO> allList = new ArrayList();
        List<ArOrderVO> arOrderVOS=null;
        if(arOrderVOPagingVO!=null&& org.apache.commons.collections4.CollectionUtils.isNotEmpty(arOrderVOPagingVO.getRecords())){
            arOrderVOS=arOrderVOPagingVO.getRecords().stream().filter(v -> !v.getId().equals(arId)).collect(Collectors.toList());
            allList.addAll(arOrderVOS);
        }
        if(recOrderVOPagingVO!=null&& org.apache.commons.collections4.CollectionUtils.isNotEmpty(recOrderVOPagingVO.getRecords())){
            allList.addAll(recOrderVOPagingVO.getRecords());
        }
        if(org.apache.commons.collections4.CollectionUtils.isEmpty(allList)){
            log.error("自动核销应收单，未匹配到待核销单据，单据编码：{}",arOrderDTO.getArOrderNo());
            //throw new BusinessException(String.format("自动核销应收单，未匹配到待核销单据，单据编码：%s",arOrderDTO.getArOrderNo()));
            return ;
        }
        //联合排序
        CollUtil.sort(allList,(o1,o2)->{
            if(finAsc){
                return o1.getBuDate().compareTo(o2.getBuDate());
            }else{
                return o2.getBuDate().compareTo(o1.getBuDate());
            }
        });
        BigDecimal unVerAmtBalance= arOrderDTO1.getTotalAmt();
        List<WriteoffVO> matchList=new ArrayList<>();
        if(positiveAmtFlag){
            for (WriteoffVO writeoffVO : allList) {
                if(writeoffVO instanceof ArOrderVO){
                    if(writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance)){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                        break;
                    }else if(writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance)<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                        break;
                    }
                }else{
                    if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance)){
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance)<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }
                }
            }
        }else{
            for (WriteoffVO writeoffVO : allList) {
                if(writeoffVO instanceof ArOrderVO){
                    if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance.abs())){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                        break;
                    }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance.abs())<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                        break;
                    }
                }else{
                    if(writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance.abs())){
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }else if(writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance.abs())<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }
                }
            }
        }
        //主单匹配

        if(unVerAmtBalance.compareTo(BigDecimal.ZERO)>0){
            log.info("自动核销应收单，未匹配到足够的核销金额，单据编码：{}",arOrderDTO.getArOrderNo());
            //throw new BusinessException(String.format("自动核销应收单，未匹配到足够的核销金额，单据编码：%s",arOrderDTO.getArOrderNo()));
            return ;
        }
        currArOrderVO.setVerAmt(currArOrderVO.getTotalAmt());
        matchList.add(currArOrderVO);
        //生成核销数据
        this.autoWriteoff(matchList,schemeId);
        log.info("自动核销应收单,-------结束");
    }
    @Override
    public void autoWriteoffRec(RecOrderDTO recOrderDTO) {
        log.info("自动核销收款单,-------开始");
        final Long recId= recOrderDTO.getId();
        if(recId==null){
            log.error("自动核销收款单，单据ID为空");
            throw new BusinessException("自动核销收款单，单据ID为空");
        }
        //1.根据ID查找应收单即明细信息
        final RecOrderDTO recOrderDTO1 = recOrderDomainService.queryById(recId, false);
        if(recOrderDTO1==null){
            log.error("自动核销收款单，查询收款单失败，单据ID：{}",recId);
            //throw new BusinessException(String.format("自动核销收款单，查询收款单失败，单据ID：%s",recId));
            return ;
        }
        if(BigDecimal.ZERO.equals(recOrderDTO1.getTotalAmt())){
            log.info("自动核销收款单，待核销金额为0，无需核销，单据ID：{}",recId);
            return ;
        }
        RecOrderVO currRecOrderVO=RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO1);
        boolean positiveAmtFlag=recOrderDTO1.getTotalAmt().compareTo(BigDecimal.ZERO)>0;
        //2.查询核销方案列表
        final ArVerConfigDTO arVerConfigDTO = arVerConfigDomainService.queryDef();
        if(arVerConfigDTO==null){
            log.error("自动核销收款单，未查询到核销方案，单据编码：{}",recOrderDTO1.getRecOrderNo());
            //throw new BusinessException(String.format("自动核销收款单，未查询到核销方案，单据编码：%s",recOrderDTO1.getRecOrderNo()));
            return ;
        }
        Long schemeId = arVerConfigDTO.getId();
        final List<ArVerConfigDtlDTO> arVerConfigDtlDTOS = arVerConfigDtlRepoProc.queryByMasId(arVerConfigDTO.getId());
        if(org.apache.commons.collections4.CollectionUtils.isEmpty(arVerConfigDtlDTOS)){
            log.error("自动核销收款单，未查询到核销方案明细，单据编码：{}",recOrderDTO1.getRecOrderNo());
            //throw new BusinessException(String.format("自动核销收款单，未查询到核销方案明细，单据编码：%s",recOrderDTO1.getRecOrderNo()));
            return ;
        }
        //3.过滤出默认、且启用的
        //4.遍历查找field_no是so_doc_no的核销方案列表，找到即结束，为找到则记录报错日志，结束流程
        final Boolean redOffsetFlag = arVerConfigDTO.getRedOffsetFlag();
        final String writeoffOrder = arVerConfigDTO.getWriteoffOrder();
        String ou_code=null;
        String cust_code=null;
        String curr_code=null;
        String so_doc_no=null;
        for (ArVerConfigDtlDTO arVerConfigDtlDTO : arVerConfigDtlDTOS) {
            if("ou_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                ou_code = recOrderDTO1.getOuCode();
            }else if("cust_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                cust_code = recOrderDTO1.getCustCode();
            }else if("curr_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                curr_code = recOrderDTO1.getCurrCode();
            }else if("so_doc_no".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                so_doc_no = recOrderDTO1.getSourceNo();
            }
        }
        //5.找出当前核销方案公司、客户、币种、来源单号的匹配标识
        //6.根据上步找到的匹配标识，和当前应收单信息，确定过滤参数值
        //7.查看红蓝对冲标识，若是红蓝对冲匹配，增加查询其他应收单
        //8.根据6,7参数值联合查询待核销应收单和收款单列表，并按核销方案排序标识进行排序，分页查询，按整单处理
        //如果支持红蓝对冲，查询应付单
        boolean asc=true;
        if(WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_FRONT_BACK.getValueCode().equals(writeoffOrder)){
            asc=true;
        }else if(WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_BACK_FRONT.getValueCode().equals(writeoffOrder)){
            asc=false;
        }
        final boolean finAsc=asc;
        List<OrderItem> orders = new ArrayList<>();
        OrderItem orderItem=new OrderItem();
        orderItem.setAsc(asc);
        orders.add(orderItem);
        PagingVO<ArOrderVO> arOrderVOPagingVO=null;
        PagingVO<RecOrderVO> recOrderVOPagingVO=null;
        //查询收款款单
        if(redOffsetFlag){
            RecOrderPageParam recOrderPageParam = new RecOrderPageParam();
            recOrderPageParam.setOuCode(ou_code);
            recOrderPageParam.setCustCode(cust_code);
            recOrderPageParam.setCurrCode(curr_code);
            orderItem.setColumn("reDate");
            recOrderPageParam.setOrders(orders);
            recOrderPageParam.setSize(Integer.MAX_VALUE);
            if(positiveAmtFlag){
                recOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_LT);
            }else{
                recOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_GT);
            }
            recOrderVOPagingVO = recOrderService.writeoffPage(recOrderPageParam);
        }
        orderItem.setColumn("buDate");
        ArOrderPageParam arOrderPageParam = new ArOrderPageParam();
        arOrderPageParam.setOuCode(ou_code);
        arOrderPageParam.setCustCode(cust_code);
        arOrderPageParam.setCurrCode(curr_code);
        arOrderPageParam.setOrders(orders);
        arOrderPageParam.setSize(Integer.MAX_VALUE);
        if(positiveAmtFlag){
            arOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_GT);
        }else{
            arOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_LT);
        }
        arOrderVOPagingVO = arOrderService.writeoffPage(arOrderPageParam);
        //一起排序
        List<WriteoffVO> allList = new ArrayList();
        List<RecOrderVO> recOrderVOS=null;
        if(recOrderVOPagingVO!=null&& org.apache.commons.collections4.CollectionUtils.isNotEmpty(recOrderVOPagingVO.getRecords())){
            recOrderVOS=recOrderVOPagingVO.getRecords().stream().filter(v -> !v.getId().equals(recId)).collect(Collectors.toList());
            allList.addAll(recOrderVOS);
        }
        if(arOrderVOPagingVO!=null&& org.apache.commons.collections4.CollectionUtils.isNotEmpty(arOrderVOPagingVO.getRecords())){
            allList.addAll(arOrderVOPagingVO.getRecords());
        }
        if(org.apache.commons.collections4.CollectionUtils.isEmpty(allList)){
            log.error("自动核销收款单，未匹配到待核销单据，单据编码：{}",recOrderDTO1.getRecOrderNo());
            //throw new BusinessException(String.format("自动核销收款单，未匹配到待核销单据，单据编码：%s",recOrderDTO1.getRecOrderNo()));
            return ;
        }
        //联合排序
        CollUtil.sort(allList,(o1,o2)->{
            if(finAsc){
                return o1.getBuDate().compareTo(o2.getBuDate());
            }else{
                return o2.getBuDate().compareTo(o1.getBuDate());
            }
        });
        BigDecimal unVerAmtBalance= recOrderDTO1.getTotalAmt();
        List<WriteoffVO> matchList=new ArrayList<>();
        //主单匹配
        if(positiveAmtFlag){
            for (WriteoffVO writeoffVO : allList) {
                if(writeoffVO instanceof RecOrderVO){
                    if(writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance)){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                        break;
                    }else if(writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance)<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                        break;
                    }
                }else{
                    if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance)){
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance)<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }
                }
            }
        }else{
            for (WriteoffVO writeoffVO : allList) {
                if(writeoffVO instanceof RecOrderVO){
                    if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance.abs())){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                        break;
                    }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance.abs())<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                        break;
                    }
                }else{
                    if(writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance.abs())){
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }else if(writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance.abs())<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }
                }
            }
        }
        if(unVerAmtBalance.compareTo(BigDecimal.ZERO)>0){
            log.info("自动核销收款单，未匹配到足够的核销金额，单据编码：{}",recOrderDTO1.getRecOrderNo());
            //throw new BusinessException(String.format("自动核销收款单，未匹配到足够的核销金额，单据编码：%s",recOrderDTO1.getRecOrderNo()));
            return ;
        }
        currRecOrderVO.setVerAmt(currRecOrderVO.getTotalAmt());
        matchList.add(currRecOrderVO);
        //生成核销数据
        this.autoWriteoff(matchList,schemeId);
        log.info("自动核销收款单,-------结束");
    }
}
