package com.elitesland.fin.application.web.writeoff;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecApplyApprovalDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplySaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplySettleVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyVO;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.WriteoffUdcEnum;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 应收收款核销申请.
 *
 * @author shihao.ma
 * @since 2023/8/29
 */
@RestController
@RequestMapping(value = "/fin/ver/apply", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "应收收款核销申请", tags = {"应收收款核销申请"})
@RequiredArgsConstructor
public class FinArRecVerApplyController {

    private final FinArRecVerApplyService finArRecVerApplyService;

    @PostMapping("/page")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    public ApiResult<PagingVO<FinArRecVerApplyVO>> page(@RequestBody @Valid FinArRecVerApplyQuery query) {
        return ApiResult.ok(finArRecVerApplyService.page(query));
    }

    @PostMapping("writeOff/page")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    public ApiResult<PagingVO<FinArRecVerApplyVO>> writeOffPage(@RequestBody @Valid FinArRecVerApplyQuery query) {
        return ApiResult.ok(finArRecVerApplyService.writeOffPage(query));
    }

    @GetMapping("/{id}")
    @ApiOperation(value = "获取明细", notes = "获取明细")
    public ApiResult<FinArRecVerApplyVO> detail(@PathVariable Long id) {
        return ApiResult.ok(finArRecVerApplyService.detail(id));
    }

    @GetMapping("/writeOff/{id}")
    @ApiOperation(value = "获取明细", notes = "获取明细")
    public ApiResult<FinArRecVerApplyVO> writeOffDetail(@PathVariable Long id) {
        return ApiResult.ok(finArRecVerApplyService.writeOffDetail(id));
    }

    @PostMapping("/save")
    @ApiOperation(value = "保存", notes = "保存")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "核销申请保存",allowRepeatRequest = false
    )
    public ApiResult<Long> save(@RequestBody @Valid FinArRecVerApplySaveDTO save) {
        return ApiResult.ok(finArRecVerApplyService.save(save));
    }

    @PostMapping("/submit")
    @ApiOperation(value = "提交", notes = "提交")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "核销申请提交",allowRepeatRequest = false
    )
    public ApiResult<Long> submit(@RequestBody @Valid FinArRecVerApplySaveDTO save) {
        return ApiResult.ok(finArRecVerApplyService.submit(save));
    }

    @PostMapping("/writeOff/submit")
    @ApiOperation(value = "核销", notes = "核销")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "整单核销申请提交",allowRepeatRequest = false
    )
    public ApiResult<Long> writeOffSubmit(@RequestBody @Valid FinArRecVerApplySaveDTO save) {
        save.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_MANUAL.getValueCode());
        final Long id = finArRecVerApplyService.writeOffSubmit(save);
      /*  FinArRecApplyApprovalDTO dto = new FinArRecApplyApprovalDTO();
        ArrayList<String> applyNos=new ArrayList<>();
        applyNos.add(save.getApplyDocNo());
        dto.setApplyNos(applyNos);
        dto.setApprovalType(FinArRecApplyApprovalDTO.ApprovalType.APPROVE);
        finArRecVerApplyService.writeOffApprove(dto);*/
        return ApiResult.ok(id);
    }

    @DeleteMapping()
    @ApiOperation(value = "数据删除", notes = "数据删除")
    public ApiResult<Void> deleteByIds(@RequestBody List<Long> ids) {
        finArRecVerApplyService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value = "审批通过", notes = "审批通过")
    @PostMapping("/approve")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "审批通过",allowRepeatRequest = false
    )
    public ApiResult<Void> approve(@RequestBody @Valid FinArRecApplyApprovalDTO dto) {
        finArRecVerApplyService.approve(dto);
        return ApiResult.ok();
    }

    @ApiOperation(value = "审批通过", notes = "审批通过")
    @PostMapping("writeOff/approve")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "整单审批通过",allowRepeatRequest = false
    )
    public ApiResult<Void> writeOffApprove(@RequestBody @Valid FinArRecApplyApprovalDTO dto) {
        finArRecVerApplyService.writeOffApprove(dto);
        return ApiResult.ok();
    }

    @ApiOperation(value = "审批拒绝", notes = "审批拒绝")
    @PostMapping("/refuse")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "审批拒绝",allowRepeatRequest = false
    )
    public ApiResult<Void> refuse(@RequestBody @Valid FinArRecApplyApprovalDTO dto) {
        finArRecVerApplyService.refuse(dto);
        return ApiResult.ok();
    }

    @ApiOperation(value = "审批拒绝", notes = "审批拒绝")
    @PostMapping("writeOff/refuse")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "整单审批拒绝",allowRepeatRequest = false
    )
    public ApiResult<Void> writeOffRefuse(@RequestBody @Valid FinArRecApplyApprovalDTO dto) {
        finArRecVerApplyService.writeOffRefuse(dto);
        return ApiResult.ok();
    }

    @ApiOperation(value = "取消核销", notes = "取消核销")
    @PostMapping("/cancel/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "取消核销",allowRepeatRequest = false
    )
    public ApiResult<Void> verCancel(@PathVariable("id") Long id) {
        finArRecVerApplyService.cancel(id);
        return ApiResult.ok();
    }

    @ApiOperation(value = "取消核销", notes = "取消核销")
    @PostMapping("writeOff/cancel/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "整单取消核销",allowRepeatRequest = false
    )
    public ApiResult<Void> writeOffCancel(@PathVariable("id") Long id) {
        finArRecVerApplyService.writeOffCancel(id);
        return ApiResult.ok();
    }

    @ApiOperation(value = "明细拆单详情", notes = "明细拆单详情")
    @GetMapping("/settle/{id}")
    public ApiResult<List<FinArRecVerApplySettleVO>> settleList(@ApiParam("申请单ID") @PathVariable("id") Long id) {
        return ApiResult.ok(finArRecVerApplyService.settleList(id));
    }
    @ApiOperation(value = "测试应收单自动核销", notes = "测试应收单自动核销")
    @PostMapping("writeOff/autoWriteoffAr")
    public ApiResult<Void> autoWriteoffAr(@RequestBody ArOrderDTO arOrderDTO) {
        finArRecVerApplyService.autoWriteoffAr(arOrderDTO);
        return ApiResult.ok();
    }
    @ApiOperation(value = "测试收款单自动核销", notes = "测试收款单自动核销")
    @PostMapping("writeOff/autoWriteoffRec")
    public ApiResult<Void> autoWriteoffRec(@RequestBody RecOrderDTO recOrderDTO) {
        finArRecVerApplyService.autoWriteoffRec(recOrderDTO);
        return ApiResult.ok();
    }
}
