package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_flexible")
@org.hibernate.annotations.Table(appliesTo = "fin_flexible", comment = "值集")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinFlexibleDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "flexible_code", columnDefinition = "varchar(20) comment '值集编码'")
    private String flexibleCode;

    @Column(name = "flexible_name", columnDefinition = "varchar(32) comment '值集名称'")
    private String flexibleName;

    @Column(name = "flexible_type", columnDefinition = "varchar(1)comment '值集类型，0：主值集，1：从属值集'")
    private String flexibleType;

    @Column(name = "parent_flexible_code", columnDefinition = "varchar(20) comment '主值集编码'")
    private String parentFlexibleCode;

    @Column(name = "parent_flexible_name", columnDefinition = "varchar(32) comment '主值集名称'")
    private String parentFlexibleName;

    @Column(name = "status", columnDefinition = "varchar(32) comment '状态'")
    private String status;
}
