package com.elitesland.fin.domain.entity.recorder;

import com.elitesland.fin.domain.entity.base.BaseWorkflowModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/4/13 9:25
 */
@Entity
@Table(name = "rec_order")
@org.hibernate.annotations.Table(appliesTo = "rec_order", comment = "收款单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class RecOrderDO extends BaseWorkflowModel implements Serializable {


    private static final long serialVersionUID = -721579334653117155L;
    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '销售公司编码'")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '销售公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '销售公司名称'")
    private String ouName;

    @Column(name = "ar_type_id", columnDefinition = "bigint(20) comment '应收单类型定义ID'")
    private Long arTypeId;

    @Column(name = "ar_type_name", columnDefinition = "varchar(32) comment '应收单类型名称'")
    private String arTypeName;

    @Column(name = "ar_type_code", columnDefinition = "varchar(32) comment '应收单类型代码'")
    private String arTypeCode;

    @Column(name = "rec_type_id", columnDefinition = "bigint(20) comment '收款单类型ID'")
    private Long recTypeId;

    @Column(name = "rec_type_code", columnDefinition = "varchar(32) comment '收款单类型代码'")
    private String recTypeCode;

    @Column(name = "rec_type_name", columnDefinition = "varchar(32) comment '收款单类型名称'")
    private String recTypeName;

    @Column(name = "rec_order_no", columnDefinition = "varchar(32) comment '收款单号'")
    private String recOrderNo;

    @Column(name = "curr_code", columnDefinition = "varchar(32) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(32) comment '币种'")
    private String currName;

    @Column(name = "local_curr_code", columnDefinition = "varchar(32) comment '本位币编码'")
    private String localCurrCode;

    @Column(name = "local_curr_name", columnDefinition = "varchar(32) comment '本位币名称'")
    private String localCurrName;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "audit_user", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditDate;

    @Column(name = "order_state", columnDefinition = "varchar(32) comment '单据状态'")
    private String orderState;

    @Column(name = "exchange_rate", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal exchangeRate;

    @Column(name = "init_flag", columnDefinition = "tinyint(1) comment '是否期初'")
    private Boolean initFlag;

    @Column(name = "real_rec_amt", columnDefinition = "decimal(18,8) comment '实际收款金额'")
    private BigDecimal realRecAmt;

    @Column(name = "real_rec_cur_amt", columnDefinition = "decimal(18,8) comment '实际收款金额(本位币)'")
    private BigDecimal realRecCurAmt;

    @Column(name = "re_date", columnDefinition = "datetime(6) comment '收款日期'")
    private LocalDateTime reDate;

    @Column(name = "re_flag", columnDefinition = "tinyint(1) comment '是否预收'")
    private Boolean reFlag;

    @Column(name = "audit_rejection", columnDefinition = "varchar(128) comment '审核拒绝理由'")
    private String auditRejection;

    @Column(name = "create_mode", columnDefinition = "varchar(32) comment '单据来源'")
    private String createMode;

    @Column(name = "ver_state", columnDefinition = "varchar(32) comment '核销状态'")
    private String verState;

    @Column(name = "ver_amt", columnDefinition = "decimal(18,8) comment '已核销金额'")
    private BigDecimal verAmt;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(32) comment '客户名称'")
    private String custName;

    @Column(name = "bu_id", columnDefinition = "bigint(20) comment '销售部门ID'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '销售部门编码'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(32) comment '销售部门名称'")
    private String buName;

    @Column(name = "rec_ou_code", columnDefinition = "varchar(32) comment '收款公司编码'")
    private String recOuCode;

    @Column(name = "rec_ou_id", columnDefinition = "bigint(20) comment '收款公司ID'")
    private Long recOuId;

    @Column(name = "rec_ou_name", columnDefinition = "varchar(32) comment '收款公司名称'")
    private String recOuName;

    @Column(name = "org_code", columnDefinition = "varchar(32) comment '销售组织编码'")
    private String orgCode;

    @Column(name = "org_id", columnDefinition = "bigint(20) comment '销售组织ID'")
    private Long orgId;

    @Column(name = "org_name", columnDefinition = "varchar(32) comment '销售组织名称'")
    private String orgName;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "rec_order_type", columnDefinition = "varchar(32) comment '单据类型'")
    private String recOrderType;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "sale_user_id", columnDefinition = "bigint(20) comment '销售业务员ID'")
    private Long saleUserId;

    @Column(name = "sale_user", columnDefinition = "varchar(32) comment '销售业务员'")
    private String saleUser;

    @Column(name = "proc_inst_id", columnDefinition = "varchar(64) comment '流程实例ID'")
    private String procInstId;

    @Column(name = "proc_inst_status", columnDefinition = "varchar(32) comment '流程实例状态'")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Column(name = "submit_time", columnDefinition = "datetime(6) comment '提交时间'")
    private LocalDateTime submitTime;

    @Column(name = "approved_time", columnDefinition = "datetime(6) comment '审批通过时间'")
    private LocalDateTime approvedTime;

    @Column(name = "addr_no", columnDefinition = "varchar(32) comment '地址号'")
    private String addrNo;

    @Column(name = "supp_addr_no", columnDefinition = "varchar(32) comment '供应商地址号'")
    private String suppAddrNo;

    @Column(name = "doc_type", columnDefinition = "varchar(32) comment '具体订单场景'")
    private String docType;

    @Column(name = "doc_type2", columnDefinition = "varchar(32) comment 'B端订单/C端订单'")
    private String docType2;

    @Column(name = "doc_cls", columnDefinition = "varchar(32) comment '传SO代表正向，传RSO代表退货负向'")
    private String docCls;

    @ApiModelProperty("拟定状态,DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    @Column(name = "proposed_status", columnDefinition = "varchar(32) comment '拟定状态'")
    private String proposedStatus;

    @ApiModelProperty("红冲状态")
    @Column(name = "red_state", columnDefinition = "varchar(20) comment '扩展表关联id'")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    @Column(name = "red_source_no", columnDefinition = "varchar(32) comment '红冲来源单号'")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    @Column(name = "red_source_id", columnDefinition = "bigint(20) comment '红冲来源id'")
    private Long redSourceId;

    @Column(name = "in_out_cust", columnDefinition = "varchar(40)  comment '内外部客户'")
    private String inOutCust;

    @Column(name = "relevance_ou_code", columnDefinition = "varchar(32) comment '关联公司编码'")
    private String relevanceOuCode;

    @Column(name = "cust_type2", columnDefinition = "varchar(40)  comment '客户类型'")
    private String custType2;
//    @Column(name = "es1", columnDefinition = "varchar(32) comment '发票号'")
//    private String es1;
//
//    @Column(name = "es2", columnDefinition = "varchar(32) comment '红冲标志'")
//    private String es2;
//
//    @Column(name = "es3", columnDefinition = "datetime(6) comment '开票备注'")
//    private String es3;
//
//    @Column(name = "es4", columnDefinition = "varchar(32) comment '第三方支付辅助'")
//    private String es4;
//
//    @Column(name = "es5", columnDefinition = "varchar(32) comment '消费卡辅助'")
//    private String es5;
//
//    @Column(name = "es6", columnDefinition = "varchar(32) comment '信用卡辅助'")
//    private String es6;
//
//    @Column(name = "es7", columnDefinition = "varchar(32) comment '结算方式'")
//    private String es7;
//
//    @Column(name = "es8", columnDefinition = "varchar(32) comment '收款银行账户'")
//    private String es8;
//
//    @Column(name = "es9", columnDefinition = "varchar(32) comment '付款银行账户'")
//    private String es9;



    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecOrderDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RecOrderDO entity = (RecOrderDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}
