package com.elitesland.fin.domain.service.creditAccountFlow;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.creditaccountflow.CreditAccountFlowConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.creditaccount.CreditAccountDomainService;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepo;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
@AllArgsConstructor
public class CreditAccountFlowDomainServiceImpl implements CreditAccountFlowDomainService{
    private final CreditAccountFlowRepo creditAccountFlowRepo;
    private final FlexFieldUtilService flexFieldUtilService;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private final CreditAccountDomainService creditAccountDomainService;
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public CreditAccountFlowDO save(CreditAccountFlowParam creditAccountFlowParam) {
        CreditAccountFlowDO creditAccountFlowDO = CreditAccountFlowConvert.INSTANCE.param2DO(creditAccountFlowParam);
        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.CREDIT_ACCOUNT_FLOW, creditAccountFlowDO);
        creditAccountFlowDO=creditAccountFlowRepo.save(creditAccountFlowDO);
        return creditAccountFlowDO;
    }
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void updateBalanceAndGenerateCreditAccountFlow(List<CreditAccountFlowParam> creditAccountFlowParams) {
        //checkApproveParam(creditAccountFlowParam);
        creditAccountFlowParams.forEach(v->{
            CreditAccountFlowParam creditAccountFlowParam=v;
            CreditAccountDTO oldCreditAccountDTO = creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals(oldCreditAccountDTO.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");
            if(UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(creditAccountFlowParam.getTransactionType())){
                /*CreditAccountDTO creditAccountDTOOld = creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
                Assert.equals(creditAccountDTOOld.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");*/
                int res= creditAccountDomainService.updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户占用流水生成，更新信用账户失败，可用金额不足");
                    throw new BusinessException("信用账户占用流水生成，更新信用账户失败，可用金额不足");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountDomainService.updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户增加流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户增加流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户增加流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountDomainService.updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户扣减流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户扣减流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户扣减流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountDomainService.updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户占用释放流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户占用释放流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户占用释放流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountDomainService.updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户使用增加流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户使用增加流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户使用增加流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountDomainService.updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户使用减少流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户使用减少流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户使用减少流水生成，更新信用账户失败!");
                }
            }else {
                throw new BusinessException("信用账户未匹配到交易类型!");
            }

            CreditAccountDTO newCreditAccountDTO = creditAccountRepoProc.get(oldCreditAccountDTO.getId());
            if(newCreditAccountDTO==null){
                log.error("信用账户流水生成，查询更新后信用账户失败");
                throw new BusinessException("信用账户流水生成，查询更新后信用账户失败");
            }
            BigDecimal creditAccountLimit = newCreditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = newCreditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = newCreditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit= newCreditAccountDTO.getCreditAccountAvailableLimit();

            //更新审批中的流水的状态
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            //creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            //更新流水单状态
            SysUserDTO user = getUser();

            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            creditAccountFlowParam.setAuditDate(LocalDateTime.now());
            creditAccountFlowParam.setAuditUserName(FinConstant.SYSTEM);

            if (user != null) {
                creditAccountFlowParam.setAuditUserId(user.getId());
                creditAccountFlowParam.setAuditUserName(user.getLastName());
            }
            //创建信用账户流水
            CreditAccountFlowDO creditAccountFlowDO=save(creditAccountFlowParam);
            creditAccountFlowParam.setId(creditAccountFlowDO.getId());
        });
    }
    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getUser();
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void saveCreditAccountFlowList(List<CreditAccountFlowParam> creditAccountFlowParams) {
        creditAccountFlowParams.stream().forEach(v->{
            //创建信用账户流水
            CreditAccountFlowDO creditAccountFlowDO =save(v);
            v.setId(creditAccountFlowDO.getId());
        });
    }
}
