package com.elitesland.fin.entity.account;

import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * @author sunxw
 * @description
 * @Date 2023/5/18
 */
@Entity
@Table(name = "account_storage", indexes = {
        @Index(name = "idx_pay_order_id",columnList = "pay_order_id",unique = false)
})
@org.hibernate.annotations.Table(appliesTo = "account_storage", comment = "账户储值表")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class AccountStorageDO extends BaseModel {

    @Column(name = "receipt_type", columnDefinition = "varchar(32) comment '单据类型'")
    private String receiptType;

    @Column(name = "receipt_status", columnDefinition = "varchar(32) comment '单据状态'")
    private String receiptStatus;

    @Column(name = "franchisee", columnDefinition = "varchar(32) comment '归属加盟商'")
    private String franchisee;

    @Column(name = "franchisee_name", columnDefinition = "varchar(32) comment '归属加盟商名称'")
    private String franchiseeName;

    @Column(name = "company", columnDefinition = "varchar(32) comment '归属公司'")
    private String company;

    @Column(name = "sec_ou_code", columnDefinition = "varchar(32) comment '归属公司编码'")
    private String secOuCode;

    @Column(name = "sec_ou_name", columnDefinition = "varchar(32) comment '归属公司名称'")
    private String secOuName;

    @ApiModelProperty("汇款主体类型")
    @Column(name = "remitter_type_name", columnDefinition = "varchar(32) comment '汇款主体类型'")
    private String remitterTypeName;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '收款公司'")
    private String ouName;

    @Column(name = "acc_name", columnDefinition = "varchar(32) comment '账户名称'")
    private String accName;

    @Column(name = "acc_code", columnDefinition = "varchar(32) comment '账户编码'")
    private String accCode;

    @Column(name = "remitter", columnDefinition = "varchar(32) comment '汇款主体名称'")
    private String remitter;

    @Column(name = "remitter_bank_code", columnDefinition = "varchar(32) comment '汇款银行编码'")
    private String remitterBankCode;

    @Column(name = "remitter_bank_name", columnDefinition = "varchar(32) comment '汇款银行名称'")
    private String remitterBankName;

    @Column(name = "remitter_account", columnDefinition = "varchar(32) comment '汇款银行账号'")
    private String remitterAccount;

    @Column(name = "remitter_account_code", columnDefinition = "varchar(32) comment '账户编码'")
    private String remitterAccountCode;

    @Column(name = "remitter_amt", columnDefinition = "decimal(18,8) comment '汇款金额'")
    private BigDecimal remitterAmt;

    @Column(name = "remitter_date", columnDefinition = "datetime(6) comment '汇款日期'")
    private LocalDate remitterDate;

    @Column(name = "pay_mode", columnDefinition = "varchar(32) comment '支付方式'")
    private String payMode;

    @Column(name = "pay_order_id",columnDefinition = "varchar(32) comment '支付流水号'")
    private String payOrderId;

    @Column(name = "pay_message",columnDefinition = "varchar(128) comment '支付信息'")
    private String payMessage;

    @Column(name = "abstract_info", columnDefinition = "varchar(128) comment '银联回调信息'")
    private String abstractInfo;

    @Column(name = "ori_msg", columnDefinition = "varchar(1024) comment '支付原始报文'")
    private String oriMsg;

    @Column(name = "apply_file", columnDefinition = "varchar(256) comment '支付凭证'")
    private String applyFile;

    @Column(name = "account_holder_name", columnDefinition = "varchar(32) comment '开户主体名称'")
    private String accountHolderName;

    @Column(name = "account_holder_code", columnDefinition = "varchar(32) comment '开户主体编码'")
    private String accountHolderCode;

}
