package com.elitesland.fin.entity.creditaccountflow;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.boot.jpa.common.PartitionField;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : gyj
 * @date : 2023-2-24
 * @desc : 信用账户流水
 */
@Entity
@Table(name = "credit_account_flow")
@org.hibernate.annotations.Table(appliesTo = "credit_account_flow", comment = "信用账户流水")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class CreditAccountFlowDO extends CustomFieldBaseModel {

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '授信组织/公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '授信组织/公司名称'")
    private String ouName;

    @Column(name = "object_code", columnDefinition = "varchar(32) comment '对象编码'")
    private String objectCode;

    @Column(name = "object_name", columnDefinition = "varchar(32) comment '对象名称'")
    private String objectName;

    @Column(name = "object_type", columnDefinition = "varchar(32) comment '对象类型'")
    private String objectType;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '部门编码'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(32) comment '部门名称'")
    private String buName;
/*
    @Column(name = "product_line", columnDefinition = "varchar(32) comment '产品线'")
    private String productLine;*/

    @Column(name = "sale_user", columnDefinition = "varchar(32) comment '业务员'")
    private String saleUser;

    @Column(name = "flow_no", columnDefinition = "varchar(32) comment '流水号'")
    private String flowNo;

    @Column(name = "transaction_type", columnDefinition = "varchar(32) comment '交易类型'")
    private String transactionType;

    @Column(name = "amount", columnDefinition = "decimal(18,8) comment '发生金额'")
    private BigDecimal amount;

    @Column(name = "transaction_time", columnDefinition = "datetime(6) comment '交易日期'")
    private LocalDateTime transactionTime;

    @Column(name = "credit_account_code", columnDefinition = "varchar(32) comment '信用账户编码'")
    private String creditAccountCode;

    @Column(name = "credit_account_name", columnDefinition = "varchar(32) comment '信用账户名称'")
    private String creditAccountName;

    @Column(name = "credit_account_rule_code", columnDefinition = "varchar(32)  comment '信用账户规则编码'")
    private String creditAccountRuleCode;

/*    @Column(name = "credit_account_rule_name", columnDefinition = "varchar(32)  comment '账户规则名称'")
    private String creditAccountRuleName;*/

    @Column(name = "credit_account_type", columnDefinition = "varchar(32) comment '信用账户类型'")
    private String creditAccountType;

    @Column(name = "source_doc", columnDefinition = "varchar(128) comment '来源单据'")
    private String sourceDoc;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源单据ID'")
    private Long sourceId;

    @Column(name = "order_status", columnDefinition = "varchar(32) comment '单据状态'")
    private String orderState;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人id'")
    private Long auditUserId;

    @Column(name = "audit_user_name", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUserName;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditDate;

    @Column(name = "priority_no", columnDefinition = "int(6)  comment '优先级'")
    private Integer priorityNo;

    @Column(name = "source_doc_status", columnDefinition = "varchar(32) comment '来源单据状态'")
    private String sourceDocStatus;

    @Column(name = "credit_account_limit", columnDefinition = "decimal(18,8) comment '账户额度'")
    private BigDecimal creditAccountLimit;

    @Column(name = "credit_account_used_limit", columnDefinition = "decimal(18,8) comment '账户使用额度'")
    private BigDecimal creditAccountUsedLimit;

    @Column(name = "credit_account_occupancy_limit", columnDefinition = "decimal(18,8) comment '占用额度'")
    private BigDecimal creditAccountOccupancyLimit;

    @Column(name = "credit_account_available_limit", columnDefinition = "decimal(18,8) comment '可用额度'")
    private BigDecimal creditAccountAvailableLimit;

    @ApiModelProperty("表分区字段：月")
    @Comment("表分区字段：月")
    @Column(updatable = false)
    @PartitionField(PartitionField.PartitionType.YEAR_MONTH)
    private Integer ym;
}
