package com.elitesland.fin.infr.repo.aporder;

import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;

import java.math.BigDecimal;
import java.util.List;

import feign.Param;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.aporder
 * @date 2022/3/16 10:40
 */
@Repository
public interface ApOrderDtlRepo extends JpaRepository<ApOrderDtlDO, Long>, QuerydslPredicateExecutor<ApOrderDtlDO> {

    List<ApOrderDtlDO> findAllByMasId(Long masId);

    List<ApOrderDtlDO> findAllByMasIdIn(List<Long> masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update ap_order_dtl set modify_time = CURRENT_TIMESTAMP, " +
            " audit_data_version = :version + 1, ver_amt = :verAmt, ver_amting = :verAmting, un_ver_amt = :unVerAmt where id =:apDtlId and " +
            " audit_data_version = :version and delete_flag != 1", nativeQuery = true)
    int updateExtVerAmt(@Param("apDtlId") Long apDtlId, @Param("version") Integer version
            , @Param("verAmt") BigDecimal verAmt, @Param("verAmting") BigDecimal verAmting, @Param("unVerAmt") BigDecimal unVerAmt);


}
