package com.elitesland.fin.infr.repo.inputinv;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.domain.entity.inputinv.QInputInvDO;
import com.elitesland.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/5/6 10:23
 */
@Component
@RequiredArgsConstructor
public class InputInvRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QInputInvDO qInputInvDO = QInputInvDO.inputInvDO;


    public PagingVO<InputInvDTO> page(InputInvPageParam inputInvPageParam, List<Long> ids) {

        List<Predicate> predicates = new ArrayList<>();

        if (null != inputInvPageParam.getOuId()) {
            predicates.add(qInputInvDO.ouId.eq(inputInvPageParam.getOuId()));
        }
        if (inputInvPageParam.getSuppId() != null) {
            predicates.add(qInputInvDO.suppId.eq(inputInvPageParam.getSuppId()));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getCreateMode())) {
            predicates.add(qInputInvDO.createMode.eq(inputInvPageParam.getCreateMode()));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getInvRegNo())) {
            predicates.add(qInputInvDO.invRegNo.like("%" + inputInvPageParam.getInvRegNo() + "%"));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getOrderState())) {
            predicates.add(qInputInvDO.orderState.eq(inputInvPageParam.getOrderState()));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getSourceNo())) {
            predicates.add(qInputInvDO.sourceNo.like("%"+inputInvPageParam.getSourceNo()+"%"));
        }
        if (inputInvPageParam.getCreateTimeStart() != null && inputInvPageParam.getCreateTimeEnd() != null) {
            predicates.add(qInputInvDO.createTime.between(inputInvPageParam.getCreateTimeStart(), inputInvPageParam.getCreateTimeEnd()));
        }
        if (inputInvPageParam.getTotalAmtStart() != null) {
            predicates.add(qInputInvDO.totalAmt.goe(inputInvPageParam.getTotalAmtStart()));
        }
        if (inputInvPageParam.getTotalAmtEnd() != null) {
            predicates.add(qInputInvDO.totalAmt.loe(inputInvPageParam.getTotalAmtEnd()));
        }
        if (CollUtil.isNotEmpty(ids)) {
            predicates.add(qInputInvDO.id.in(ids));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getInvNo())) {
            predicates.add(qInputInvDO.invNo.like("%"+inputInvPageParam.getInvNo()+"%"));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getInvCode())) {
            predicates.add(qInputInvDO.invCode.like("%"+inputInvPageParam.getInvCode()+"%"));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getInvType())) {
            predicates.add(qInputInvDO.invType.eq(inputInvPageParam.getInvType()));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getRedBlueType())) {
            predicates.add(qInputInvDO.redBlueType.eq(inputInvPageParam.getRedBlueType()));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getApOrderNo())) {
            predicates.add(qInputInvDO.apOrderNo.like("%"+inputInvPageParam.getRedBlueType()+"%"));
        }
        if (inputInvPageParam.getInvDateStart() != null && inputInvPageParam.getInvDateEnd() != null) {
            predicates.add(qInputInvDO.invDate.between(inputInvPageParam.getInvDateStart(), inputInvPageParam.getInvDateEnd()));
        }
        predicates.add(qInputInvDO.deleteFlag.eq(0));
        JPAQuery<InputInvDTO> query = select(InputInvDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        inputInvPageParam.setPaging(query);
        inputInvPageParam.fillOrders(query, qInputInvDO);
        return PagingVO.<InputInvDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<InputInvDTO> queryByIds(Collection<Long> ids) {
        return select(InputInvDTO.class)
                .where(qInputInvDO.id.in(ids))
                .fetch();
    }

    public void updateAudit(Long id, String reason, SysUserDTO user) {
        jpaQueryFactory.update(qInputInvDO)
                .set(qInputInvDO.auditDate, LocalDateTime.now())
                .set(qInputInvDO.auditRejection, reason)
                .set(qInputInvDO.auditUser, user.getUsername())
                .set(qInputInvDO.auditUserId, user.getId())
                .where(qInputInvDO.id.eq(id))
                .execute();
    }

    public InputInvDTO queryById(Long id) {
        return select(InputInvDTO.class)
                .where(qInputInvDO.id.eq(id))
                .fetchOne();
    }

    public void deleteByIds(List<Long> ids) {
        jpaQueryFactory.delete(qInputInvDO)
                .where(qInputInvDO.id.in(ids))
                .execute();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qInputInvDO.id,
                qInputInvDO.sourceNo,
                qInputInvDO.ouCode,
                qInputInvDO.ouId,
                qInputInvDO.ouName,
                qInputInvDO.currCode,
                qInputInvDO.currName,
                qInputInvDO.totalAmt,
                qInputInvDO.totalCurAmt,
                qInputInvDO.auditUserId,
                qInputInvDO.auditUser,
                qInputInvDO.auditDate,
                qInputInvDO.orderState,
                qInputInvDO.exchangeRate,
                qInputInvDO.createTime,
                qInputInvDO.updater,
                qInputInvDO.modifyTime,
                qInputInvDO.creator,
                qInputInvDO.createMode,
                qInputInvDO.suppId,
                qInputInvDO.suppCode,
                qInputInvDO.suppName,
                qInputInvDO.suppRemark,
                qInputInvDO.remark,
                qInputInvDO.localCurrCode,
                qInputInvDO.localCurrName,
                qInputInvDO.auditDataVersion,
                qInputInvDO.auditRejection,
                qInputInvDO.invRegNo,
                qInputInvDO.invUser,
                qInputInvDO.revUser,
                qInputInvDO.recUser,
                qInputInvDO.bankAccount,
                qInputInvDO.suppAddress,
                qInputInvDO.suppTel,
                qInputInvDO.openBank,
                qInputInvDO.taxRate,
                qInputInvDO.taxNumber,
                qInputInvDO.procInstId,
                qInputInvDO.procInstStatus,
                qInputInvDO.approvedTime,
                qInputInvDO.submitTime,
                qInputInvDO.invNo,
                qInputInvDO.invCode,
                qInputInvDO.redBlueType,
                qInputInvDO.invType,
                qInputInvDO.apOrderNo,
                qInputInvDO.invDate,
                qInputInvDO.untaxedAmt,
                qInputInvDO.taxAmt,
                qInputInvDO.invCheckCode,
                qInputInvDO.invVerifyStatus,
                qInputInvDO.invFileCode

        )).from(qInputInvDO);
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInputInvDO)
                .set(qInputInvDO.procInstStatus, ProcInstStatus.APPROVING)
                .set(qInputInvDO.procInstId, processInfo.getProcInstId())
                .set(qInputInvDO.submitTime, LocalDateTime.now())
                .where(qInputInvDO.id.eq(id));
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qInputInvDO.procInstStatus, ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }
    public void savaApOrderNo(String createMode,String sourceNo, String apOrderNo){
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInputInvDO)
                .set(qInputInvDO.apOrderNo, apOrderNo)
                .where(qInputInvDO.createMode.eq(createMode)
                        .and(qInputInvDO.sourceNo.eq(sourceNo))
                );
        jpaUpdateClause.execute();
    }
    public void removeApOrderNo(String createMode,String sourceNo){
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInputInvDO)
                .setNull(qInputInvDO.apOrderNo)
                .where(qInputInvDO.createMode.eq(createMode)
                        .and(qInputInvDO.sourceNo.eq(sourceNo))
                );
        jpaUpdateClause.execute();
    }
    public List<InputInvDTO> findAllByParam(InputInvPageParam inputInvPageParam) {
        List<Predicate> predicates = new ArrayList<>();
        if (!StringUtils.isEmpty(inputInvPageParam.getCreateMode())) {
            predicates.add(qInputInvDO.createMode.eq(inputInvPageParam.getCreateMode()));
        }
        if (!StringUtils.isEmpty(inputInvPageParam.getSourceNo())) {
            predicates.add(qInputInvDO.sourceNo.eq(inputInvPageParam.getSourceNo()));
        }
        predicates.add(qInputInvDO.deleteFlag.eq(0));
        JPAQuery<InputInvDTO> query = select(InputInvDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        inputInvPageParam.setPaging(query);
        inputInvPageParam.fillOrders(query, qInputInvDO);
        return query.fetch();
    }
}
