package com.elitesland.fin.application.facade.vo.flowrepair;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/25
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "creditAccountFlowRepairVO",description = "信用账户流水修复重算出参")
public class CreditAccountFlowRepairVO extends BaseModelVO {
    private static final long serialVersionUID = 5996313377762750901L;

    @ApiModelProperty(value = "流水号")
    private String flowNo;

    @ApiModelProperty(value = "实际金额")
    private BigDecimal actualAmount;

    @ApiModelProperty(value = "原流水发生金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "开户主体编码")
    private String openAccountEntityCode;

    @ApiModelProperty(value = "开户主体名称")
    private String openAccountEntityName;

    @ApiModelProperty(value = "信用账户类型")
    @SysCode(sys = "yst-fin", mod = "CREDIT_ACCOUNT_TYPE")
    private String accountType;

    @ApiModelProperty(value = "信用账户类型名称")
    private String accountTypeName;

    @ApiModelProperty(value = "账户编码")
    private String accountCode;

    @ApiModelProperty(value = "账户名称")
    private String accountName;

    @ApiModelProperty(value = "来源单号")
    private String sourceNo;

    @ApiModelProperty(value = "修复状态")
    @SysCode(sys = "yst-fin", mod = "FLOW_REPAIR_STATUS")
    private String repairStatus;

    @ApiModelProperty(value = "修复状态名称")
    private String repairStatusName;

    @ApiModelProperty(value = "重算原因")
    @SysCode(sys = "yst-fin", mod = "FLOW_RECALCUL_REASON")
    private String recalculationReason;

    @ApiModelProperty(value = "重算原因名称")
    private String recalculationReasonName;

    @ApiModelProperty(value = "重算日期")
    private LocalDateTime recalculationDate;

    @ApiModelProperty("重算人")
    private String recalculationUser;

    @ApiModelProperty("重算人ID")
    private Long recalculationUserId;
}
