package com.elitesland.fin.application.service.excel.exp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.PayOrderExportEntity;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_PAY_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class DefaultPayOrderExportServiceImpl implements DataExport<PayOrderExportEntity, PayOrderPageParam> {
    private final PayOrderDomainService payOrderDomainService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    public String getTmplCode() {
        return FIN_PAY_EXPORT_DEFAULT;
    }

    @Override
    @SysCodeProc
    public PagingVO<PayOrderExportEntity> executeExport(PayOrderPageParam queryParam) {
        PagingVO<PayOrderExportEntity> page = payOrderDomainService.exportPayOrder(queryParam);
        List<PayOrderExportEntity> records = page.getRecords();
        if (CollUtil.isEmpty(records)) {
            return new PagingVO<>();
        }
        List<String> relOuCodes = records.stream().map(PayOrderExportEntity::getRelevanceOuCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relOuCodes);
        records.forEach(row -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(row.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                row.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return new PagingVO<>(page.getTotal(), ExcelConvertUtils.convertLoosely(records, PayOrderExportEntity.class));
    }

    @Override
    public Integer pageSize() {
        return 1000;
    }

}
