package com.elitesland.fin.application.service.paymentperiod;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.*;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeComPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeOuVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangePagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeVO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
public interface AgingRangeService {

    /**
     * 新增-账龄区间
     *
     * @param saveParam 入参
     * @return
     */
    Long save(AgingRangeSaveParam saveParam);

    /**
     * 新增-账龄区间
     *
     * @param saveParam 入参
     * @return
     */
    Long update(AgingRangeSaveParam saveParam);


    /**
     * 账龄区间分页查询
     *
     * @param pageParam 入参
     * @return 账龄区间信息集合
     */
    PagingVO<AgingRangePagingVO> page(AgingRangePageParam pageParam);

    /**
     * 根据账龄区间ID查询账龄区间详情数据
     *
     * @param id 账龄区间ID
     * @return 账龄区间详情数据
     */
    AgingRangeVO findIdOne(Long id);

    /**
     * 根据账龄区间编码查询账龄区间详情数据
     *
     * @param code 账龄区间编码
     * @return 账龄区间详情数据
     */
    AgingRangeVO findCodeOne(String code);

    /**
     * 根据账龄区间ID批量删除
     *
     * @param ids 账龄区间ID集合
     * @return
     */
    void deleteBatch(List<Long> ids);


    /**
     * 根据账龄区间ID批量启用
     *
     * @param ids 账龄区间ID集合
     * @return
     */
    void enableBatch(List<Long> ids);

    /**
     * 根据账龄区间ID批量停用
     *
     * @param ids 账龄区间ID集合
     * @return
     */
    void disableBatch(List<Long> ids);


    /**
     * 账龄区间公共分页查询
     *
     * @param pageParam 入参
     * @return 账龄区间信息集合
     */
    PagingVO<AgingRangeComPagingVO> commonPage(AgingRangeComPageParam pageParam);

    /**
     * 分页查询账龄区间的分配公司
     *
     * @param pageParam 入参
     * @return 账龄区间的分配公司集合
     */
    PagingVO<AgingRangeOuVO> ouPage(AgingRangeOuPageParam pageParam);

    /**
     * 账龄区间添加分配公司
     *
     * @param saveParam 入参
     * @return
     */
    void addOu(AgingRangeOuMainSaveParam saveParam);

    /**
     * 账龄区间取消分配公司
     *
     * @param ids 入参
     * @return
     */
    void cancelOu(List<Long> ids);
}
