package com.elitesland.fin.application.service.redis;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedLockUtils;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.fin.common.FinRedisConstant;
import lombok.extern.slf4j.Slf4j;
import org.redisson.RedissonRedLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
@Slf4j
@Service
public class MyRedisServiceImpl implements MyRedisService {
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private RedLockUtils redLockUtils;
    @Override
    public <T> T getDataFromRedis(String dataKey,Class<T> cla,String msg, Supplier<T> supplier){
        String nullString="NULL";
        T obj=null;
        Object objStr = redisUtils.get(dataKey);
        if(objStr!=null){
            if(nullString.equals(objStr)){
                return null;
            }
            obj=JSON.parseObject((String)objStr,cla);
            return obj;
        }else{
            //加锁begin
            RedissonRedLock redLock=null;
            String lockKey = dataKey + ":LOCK";
            try {
                redLock = redLockUtils.getRedLock(lockKey);
                boolean lockFlag = redLock.tryLock(5, 300, TimeUnit.SECONDS);
                if (!lockFlag) {
                    log.error("{},dataKey:{}，获取锁失败",msg,dataKey);
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, msg+"，dataKey:"+dataKey+",获取锁失败,请稍后再试！");
                }
                objStr = redisUtils.get(dataKey);
                if(objStr!=null){
                    if(nullString.equals(objStr)){
                        return null;
                    }
                    obj=JSON.parseObject((String)objStr,cla);
                    return obj;
                }
                obj=supplier.get();
                if(obj==null){
                    redisUtils.set(dataKey, nullString);
                    return null;
                }else{
                    redisUtils.set(dataKey, JSON.toJSONString(obj));
                    return obj;
                }
            } catch (Exception e){
                log.error("{},dataKey:{}，获取锁异常",msg,dataKey);
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, msg+"，dataKey:"+dataKey+",获取锁异常,请稍后再试！");
            }finally {
                redLock.unlock();
            }
            //加锁end
        }
    }
    @Override
    public <T> List<T> getListDataFromRedis(String dataKey,Class<T> cla,String msg, Supplier<List<T>> supplier){
        String nullString="NULL";
        List<T> obj=null;
        Object objStr = redisUtils.get(dataKey);
        if(objStr!=null){
            if(nullString.equals(objStr)){
                return null;
            }
            obj=JSON.parseArray((String)objStr,cla);
            return obj;
        }else{
            //加锁begin
            RedissonRedLock redLock=null;
            String lockKey = dataKey + ":LOCK";
            try {
                redLock = redLockUtils.getRedLock(lockKey);
                boolean lockFlag = redLock.tryLock(5, 300, TimeUnit.SECONDS);
                if (!lockFlag) {
                    log.error("{},dataKey:{}，获取锁失败",msg,dataKey);
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, msg+"，dataKey:"+dataKey+",获取锁失败,请稍后再试！");
                }
                objStr = redisUtils.get(dataKey);
                if(objStr!=null){
                    if(nullString.equals(objStr)){
                        return null;
                    }
                    obj=JSON.parseArray((String)objStr,cla);
                    return obj;
                }
                obj=supplier.get();
                if(obj==null){
                    redisUtils.set(dataKey, nullString);
                    return null;
                }else{
                    redisUtils.set(dataKey, JSON.toJSONString(obj));
                    return obj;
                }
            } catch (Exception e){
                log.error("{},dataKey:{}，获取锁异常",msg,dataKey);
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, msg+"，dataKey:"+dataKey+",获取锁异常,请稍后再试！");
            }finally {
                redLock.unlock();
            }
            //加锁end
        }
    }
}
