package com.elitesland.fin.application.service.workflow.aporder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.entity.aporder.QApOrderDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.provider.PurAccountProvider;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * @author Jason.zhao
 * @date 2022/5/7 10:23
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ApOrderProcessServiceImpl implements ApOrderProcessService {

    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;

    private final FinApPayVerApplyService finApPayVerApplyService;

    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderRepo apOrderRepo;

    private final ApOrderDtlRepoProc apOrderDtlRepoProc;

    private final JPAQueryFactory jpaQueryFactory;

    private final PurAccountProvider purAccountProvider;
    private final TaskExecutor taskExecutor;


    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        ApOrderDTO apOrderDTO = apOrderRepoProc.get(id);
        //ApOrderDO newApOrderDO = apOrderRepo.findById(id).get();
        if (apOrderDTO == null) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        //ApOrderDTO apOrderDTO = ApOrderConvert.INSTANCE.doConvertToDto(newApOrderDO);

        QApOrderDO apOrderDO = QApOrderDO.apOrderDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(apOrderDO)
                .set(apOrderDO.procInstStatus, procInstStatus)
                .where(apOrderDO.id.eq(id));

        //单据状态
        switch (procInstStatus) {
            case NOTSUBMIT: // 未提交
                //一般情况将单据状态变成"草稿"
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            case INTERRUPT: // 中断执行
                //一般情况将单据状态变成"草稿",并且将单据上的"流程实例状态"，"流程实例ID"清成null(不是空字符串)
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(apOrderDO.procInstId, (String) null);
                break;
            case REJECTED: // 审批拒绝
                //一般情况将单据状态变成"草稿"或"拒绝"
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(apOrderDO.approvedTime, LocalDateTime.now())
                        .set(apOrderDO.auditDate, LocalDateTime.now())
                        .set(apOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(apOrderDO.auditRejection, commentInfo.getComment())
                        .set(apOrderDO.auditUser, commentInfo.getUserName());
                break;
            case INVALID: // 作废
                //一般情况将单据状态变成"作废" ，或直接删除单据
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_VOID.getValueCode())
                        .set(apOrderDO.auditDate, LocalDateTime.now())
                        .set(apOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(apOrderDO.auditRejection, commentInfo.getComment())
                        .set(apOrderDO.auditUser, commentInfo.getUserName())
                        .set(apOrderDO.procInstId, (String) null);
                break;
            case APPROVING: // 审批中
                //一般情况将单据状态变成"审批中
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_DOING.getValueCode())
                        .set(apOrderDO.submitTime,LocalDateTime.now());
                break;
            case APPROVED: // 最终节点审批通过
                //一般情况将单据状态变成"审批通过"
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())
                    .set(apOrderDO.proposedStatus, UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode())
                        .set(apOrderDO.approvedTime, LocalDateTime.now())
                        .set(apOrderDO.auditDate, LocalDateTime.now())
                        .set(apOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(apOrderDO.auditUser, commentInfo.getUserName());
                break;
            default:
                break;
        }
        //执行
        jpaUpdateClause.execute();
        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            // 回写采购对账单开票数量
            if (UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode().equals(apOrderDTO.getCreateMode())) {
                List<ApOrderDtlDTO> apOrderDtlDTOList = apOrderDtlRepoProc.listByMisId(id);
                if (!CollectionUtils.isEmpty(apOrderDtlDTOList)) {
                    List<PurAccountCheckQtyDTO> purAccountCheckQtyDTOList = apOrderDtlDTOList.stream().map(d -> {
                        PurAccountCheckQtyDTO purAccountCheckQtyDTO = new PurAccountCheckQtyDTO();
                        purAccountCheckQtyDTO.setDocNo(d.getSourceNo());
                        purAccountCheckQtyDTO.setInvoiceQty(d.getQty());
                        purAccountCheckQtyDTO.setLineNo(BigDecimal.valueOf(d.getSourceLine()));
                        return purAccountCheckQtyDTO;
                    }).collect(Collectors.toList());
                    purAccountProvider.addInvoiceQty(purAccountCheckQtyDTOList);
                }
            }

            //异步
            CompletableFuture.runAsync(() ->{
                //自动核销
                log.info("应付单审批通过，开始自动核销");
                finApPayVerApplyService.autoWriteoffAp(apOrderDTO);
                //处理核销状态
                updateVerState(id);
            }, taskExecutor);


        }
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        ApOrderDTO apOrderDTO = apOrderRepoProc.get(businessId);
        //ApOrderDO newApOrderDO = apOrderRepo.findById(businessId).get();

        if (apOrderDTO == null) {
            throw new BusinessException("单据(id:" + businessId + ")不存在,无法审批");
        }
        //ApOrderDTO apOrderDTO = ApOrderConvert.INSTANCE.doConvertToDto(newApOrderDO);

        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder()
                .ouIds(Collections.singletonList(apOrderDTO.getOuId()))
                .flowRoleCodes(Collections.singletonList(customParams))
                .build();
        List<Long> userIdsByFlowRoles = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> e + "").collect(Collectors.toCollection(ArrayList::new));

    }

    private void updateVerState(Long id){
        //处理核销状态
        ApOrderDTO newApOrderDTO = apOrderRepoProc.get(id);
        List<ApOrderDtlDTO> newApOrderDtlDTOList = apOrderDtlRepoProc.listByMisId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;//已核销金额
        BigDecimal verAmtingSum = BigDecimal.ZERO;//核销中金额
        BigDecimal unVerAmtSum = BigDecimal.ZERO;//未核销金额
        if (CollUtil.isNotEmpty(newApOrderDtlDTOList)) {
            for (ApOrderDtlDTO apOrderDtlDTO : newApOrderDtlDTOList) {
                if(null != apOrderDtlDTO.getVerAmt()){
                    verAmtSum = verAmtSum.add(apOrderDtlDTO.getVerAmt());
                }
                if(apOrderDtlDTO.getApplyVerAmTing()!=null){
                    verAmtingSum = verAmtingSum.add(apOrderDtlDTO.getApplyVerAmTing());
                }
                if(apOrderDtlDTO.getUnVerAmt()!=null){
                    unVerAmtSum = unVerAmtSum.add(apOrderDtlDTO.getUnVerAmt());
                }
            }
        }

        String verState = null;
        /*if (Objects.nonNull(newApOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newApOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) != 0 &&
                Objects.nonNull(newApOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newApOrderDTO.getTotalAmt()) != 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();

        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) == 0){
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        }*/
        if (unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (Objects.nonNull(newApOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newApOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        } else {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();
        }

        if (StringUtils.isNotBlank(verState)){
            apOrderRepoProc.updateVerState(verState,id);
        }

    }

}
