package com.elitesland.fin.application.service.workflow.arorder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;


/**
 * @author zhiyu.he
 * @date 2022/5/7 13:25
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ArOrderProcessServiceImpl implements ArOrderProcessService {


    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;

    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderRepo arOrderRepo;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;

    private final JPAQueryFactory jpaQueryFactory;
    private final FinArRecVerApplyService finArRecVerApplyService;
    private final TaskExecutor taskExecutor;


    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        ArOrderDTO arOrderDTO = arOrderRepoProc.get(id);
        //ArOrderDO newArOrderDO = arOrderRepo.findById(id).get();
        if (arOrderDTO == null) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        //ArOrderDTO arOrderDTO = ArOrderConvert.INSTANCE.doConvertToDto(newArOrderDO);

        QArOrderDO qRecOrderDO = QArOrderDO.arOrderDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderDO)
                .set(qRecOrderDO.procInstStatus, procInstStatus)
                .where(qRecOrderDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            // 未提交   状态为草稿
            case NOTSUBMIT:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            // 中断执行 业务转会草稿
            case INTERRUPT:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(qRecOrderDO.procInstId, (String) null);
                break;
                //审批中
            case APPROVING:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DOING.getValueCode())
                        .set(qRecOrderDO.submitTime,LocalDateTime.now());
                break;
            // 审批拒绝 业务数据为草稿
            case REJECTED:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(qRecOrderDO.approvedTime, LocalDateTime.now())
                        .set(qRecOrderDO.auditDate, LocalDateTime.now())
                        .set(qRecOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(qRecOrderDO.auditRejection, commentInfo.getComment())
                        .set(qRecOrderDO.auditUser, commentInfo.getUserName());
                break;
            // 作废
            case INVALID:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_VOID.getValueCode())
                        .set(qRecOrderDO.approvedTime, LocalDateTime.now())
                        .set(qRecOrderDO.auditDate, LocalDateTime.now())
                        .set(qRecOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(qRecOrderDO.auditRejection, commentInfo.getComment())
                        .set(qRecOrderDO.procInstId, (String) null)
                        .set(qRecOrderDO.auditUser, commentInfo.getUserName())
                        .set(qRecOrderDO.procInstId, (String) null);

                break;
            // 审批通过 //已审批
            case APPROVED:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())
                    .set(qRecOrderDO.proposedStatus, UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode())
                    .set(qRecOrderDO.approvedTime, LocalDateTime.now())
                        .set(qRecOrderDO.auditDate, LocalDateTime.now())
                        .set(qRecOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(qRecOrderDO.auditUser, commentInfo.getUserName());
                //触发自动核销
                break;
            default:
                break;
        }
        //执行
        jpaUpdateClause.execute();
        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            //异步
            CompletableFuture.runAsync(() ->{
                //自动核销
                log.info("应收单审批通过，开始自动核销");
                finArRecVerApplyService.autoWriteoffAr(arOrderDTO);
                //处理核销状态
                updateVerState(id);
            }, taskExecutor);

        }

    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        ArOrderDTO arOrderDTO = arOrderRepoProc.get(businessId);
        //ArOrderDO newArOrderDO = arOrderRepo.findById(businessId).get();
        if (arOrderDTO == null) {
            throw new BusinessException("单据(id:" + businessId + ")不存在,无法审批");
        }
       // ArOrderDTO arOrderDTO = ArOrderConvert.INSTANCE.doConvertToDto(newArOrderDO);

        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder()
                .ouIds(Collections.singletonList(arOrderDTO.getOuId()))
                .flowRoleCodes(Collections.singletonList(customParams))
                .build();
        List<Long> userIdsByFlowRoles = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> e + "").collect(Collectors.toCollection(ArrayList::new));
    }


    private void updateVerState(Long id){
        //处理核销状态
        ArOrderDTO newArOrderDTO = arOrderRepoProc.get(id);
        List<ArOrderDtlDTO> newArOrderDtlDTOList = arOrderDtlRepoProc.listByMisId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;//已核销金额
        BigDecimal verAmtingSum = BigDecimal.ZERO;//核销中金额
        BigDecimal unVerAmtSum = BigDecimal.ZERO;//未核销金额
        if (CollUtil.isNotEmpty(newArOrderDtlDTOList)) {
            for (ArOrderDtlDTO arOrderDtlDTO : newArOrderDtlDTOList) {
                if(null != arOrderDtlDTO.getVerAmt()){
                    verAmtSum = verAmtSum.add(arOrderDtlDTO.getVerAmt());
                }
                if(arOrderDtlDTO.getApplyVerAmTing()!=null){
                    verAmtingSum = verAmtingSum.add(arOrderDtlDTO.getApplyVerAmTing());
                }
                if(arOrderDtlDTO.getUnVerAmt()!=null){
                    unVerAmtSum = unVerAmtSum.add(arOrderDtlDTO.getUnVerAmt());
                }
            }
        }

        String verState = null;
        /*if (Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newArOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) != 0 &&
                Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newArOrderDTO.getTotalAmt()) != 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();

        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) == 0){
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        }*/

        if (unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newArOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        } else {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();
        }

        if (StringUtils.isNotBlank(verState)){
            arOrderRepoProc.updateVerState(verState,id);
        }

    }

}
