package com.elitesland.fin.application.web.creditaccount;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSaveParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSnapshotParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountStatusParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountDetailVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountSnapshotVo;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/fin/credit/account")
@RequiredArgsConstructor
@Api(value = "信用账户", tags = {"信用账户"})
public class CreditAccountController {

    private final CreditAccountService creditAccountService;

    @PostMapping("/page")
    @ApiOperation("信用账户列表查询")
    public ApiResult<PagingVO<CreditAccountPageVO>> pageSearch(@RequestBody CreditAccountPageParam accountPageParam) {
        PagingVO<CreditAccountPageVO> res = creditAccountService.pageSearch(accountPageParam);
        return ApiResult.ok(res);
    }

    @PostMapping("/save")
    @ApiOperation("新增/修改信用账户信息")
    public ApiResult<?> saveOrUpdate(@RequestBody CreditAccountSaveParam param) {
        return ApiResult.ok(creditAccountService.saveOrUpdate(param));
    }

    @PostMapping("/status")
    @ApiOperation("禁用/启用 信用账户信息")
    public ApiResult<?> updateStatus(@RequestBody CreditAccountStatusParam param) {
        creditAccountService.updateStatus(param);
        return ApiResult.ok();
    }

    //
////    @ApiOperation("账户导入")
////    @PostMapping(value = "/import", headers = "content-type=multipart/form-data")
////    public ApiResult<Void> accountImport(MultipartFile file){
////        accountImportService.accountImport(file);
////        return ApiResult.ok();
////    }
//
    @GetMapping("/detail/{id}")
    @ApiOperation("信用账户详情")
    public ApiResult<CreditAccountDetailVO> queryDetail(@PathVariable("id") Long id) {
        CreditAccountDetailVO result = creditAccountService.queryDetailById(id);
        return ApiResult.ok(result);
    }

    @ApiOperation("信用账户快照信息查询")
    @PostMapping("/snapshot")
    public ApiResult<PagingVO<CreditAccountSnapshotVo>> querySnapshot(@RequestBody CreditAccountSnapshotParam param) {
        return ApiResult.ok(creditAccountService.querySnapshot(param));
    }


}
