package com.elitesland.fin.application.web.creditaccount;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountInitialLimitParam;
import com.elitesland.fin.application.facade.vo.creditaccount.InitialLimitPageVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountInitialLimitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/initial/limit")
@RequiredArgsConstructor
@Api(value = "期初额度余额", tags = {"期初额度余额"})
public class CreditAccountInitialLimitController {

    private final CreditAccountInitialLimitService creditAccountInitialLimitService;

    @PostMapping("/page")
    @ApiOperation("期初额度余额列表查询")
    public ApiResult<PagingVO<InitialLimitPageVO>> pageSearch(@RequestBody CreditAccountInitialLimitParam pageParam) {
        PagingVO<InitialLimitPageVO> res = creditAccountInitialLimitService.pageSearch(pageParam);
        return ApiResult.ok(res);
    }

    @PostMapping("/finished")
    @ApiOperation("结束初始化")
    public ApiResult<?> finishedInitial(@RequestBody List<Long> ids) {
        creditAccountInitialLimitService.finishedInitial(ids);
        return ApiResult.ok();
    }

    /**
     * 期初额度余额-删除
     * @param ids
     * @return
     */
    @PostMapping("/delete")
    @ApiOperation("期初额度余额-删除")
    public ApiResult delete(@RequestBody List<Long> ids) {
        creditAccountInitialLimitService.delete(ids);
        return ApiResult.ok();
    }
}
