package com.elitesland.fin.application.web.creditaccountflow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccountflow.CreditAccountFlowConvert;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowPageParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author gyj
 * @Date 2023/02/25
 */
@RestController
@RequestMapping("/creditAccountFlow")
@RequiredArgsConstructor
@Api(value = "信用账户流水", tags = {"信用账户流水"})
public class CreditAccountFlowController {

    private final CreditAccountFlowService creditAccountFlowService;
    private final FlexFieldUtilService flexFieldUtilService;

    @PostMapping("/page")
    @ApiOperation("信用账户流水分页查询")
    public ApiResult<PagingVO<CreditAccountFlowVO>> page(@RequestBody CreditAccountFlowPageParam creditAccountFlowPageParam) {

        PagingVO<CreditAccountFlowDTO> creditAccountFlowDTOPagingVO = creditAccountFlowService.page(creditAccountFlowPageParam);
        PagingVO<CreditAccountFlowVO> creditAccountFlowVOPagingVO = CreditAccountFlowConvert.INSTANCE
                .creditAccountFlowDTOPagingVO2CreditAccountFlowVOPagingVO(creditAccountFlowDTOPagingVO);
        if(!CollectionUtils.isEmpty(creditAccountFlowVOPagingVO.getRecords())){
            flexFieldUtilService.handleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.CREDIT_ACCOUNT_FLOW, creditAccountFlowVOPagingVO.getRecords());
        }
        return ApiResult.ok(creditAccountFlowVOPagingVO);
    }

    @PostMapping("/approve")
    @ApiOperation("审批通过")
    public ApiResult<List<Void>> approve(@RequestBody CreditAccountFlowParam creditAccountFlowParam) {
        creditAccountFlowService.approve(creditAccountFlowParam);
        return ApiResult.ok();
    }

    @PostMapping("/reject")
    @ApiOperation("审批拒绝")
    public ApiResult<List<Void>> reject(@RequestBody CreditAccountFlowParam creditAccountFlowParam) {
        creditAccountFlowService.reject(creditAccountFlowParam);
        return ApiResult.ok();
    }

    @DeleteMapping("del")
    @ApiOperation("删除信用账户流水")
    public ApiResult<Long> del(@RequestBody List<Long> ids) {
        creditAccountFlowService.updateDeleteFlagBatch(ids);
        return ApiResult.ok();
    }
}
