package com.elitesland.fin.domain.entity.inputinv;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/5/6 9:06
 */
@Entity
@Table(name = "input_inv")
@org.hibernate.annotations.Table(appliesTo = "input_inv", comment = "进项发票")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class InputInvDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1186356659757838062L;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "inv_reg_no", columnDefinition = "varchar(32) comment '发票登记单号'")
    private String invRegNo;

    @Column(name = "curr_code", columnDefinition = "varchar(32) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(32) comment '币种'")
    private String currName;

    @Column(name = "local_curr_code", columnDefinition = "varchar(32) comment '本位币编码'")
    private String localCurrCode;

    @Column(name = "local_curr_name", columnDefinition = "varchar(32) comment '本位币名称'")
    private String localCurrName;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "open_bank", columnDefinition = "varchar(32) comment '开户行'")
    private String openBank;

    @Column(name = "bank_account", columnDefinition = "varchar(32) comment '账号'")
    private String bankAccount;

    @Column(name = "supp_address", columnDefinition = "varchar(128) comment '详细地址'")
    private String suppAddress;

    @Column(name = "supp_remark", columnDefinition = "varchar(128) comment '供应商备注'")
    private String suppRemark;

    @Column(name = "supp_id", columnDefinition = "bigint(20) comment '供应商ID'")
    private Long suppId;

    @Column(name = "supp_name", columnDefinition = "varchar(32) comment '供应商名称'")
    private String suppName;

    @Column(name = "supp_code", columnDefinition = "varchar(32) comment '供应商编码'")
    private String suppCode;

    @Column(name = "inv_user", columnDefinition = "varchar(32) comment '开票人'")
    private String invUser;

    @Column(name = "rec_user", columnDefinition = "varchar(32) comment '收款人'")
    private String recUser;

    @Column(name = "rev_user", columnDefinition = "varchar(32) comment '复核人'")
    private String revUser;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "audit_user", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditDate;

    @Column(name = "order_state", columnDefinition = "varchar(32) comment '单据状态'")
    private String orderState;

    @Column(name = "exchange_rate", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal exchangeRate;

    @Column(name = "audit_rejection", columnDefinition = "varchar(128) comment '审核拒绝理由'")
    private String auditRejection;

    @Column(name = "create_mode", columnDefinition = "varchar(32) comment '单据来源'")
    private String createMode;

    @Column(name = "tax_number", columnDefinition = "varchar(32) comment '纳税人识别号'")
    private String taxNumber;

    @Column(name = "supp_tel", columnDefinition = "varchar(32) comment '供应商电话'")
    private String suppTel;

    @Column(name = "proc_inst_id", columnDefinition = "varchar(64) comment '流程实例ID'")
    private String procInstId;

    @Column(name = "proc_inst_status", columnDefinition = "varchar(32) comment '流程实例状态'")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Column(name = "submit_time", columnDefinition = "datetime(6) comment '提交时间'")
    private LocalDateTime submitTime;

    @Column(name = "approved_time", columnDefinition = "datetime(6) comment '审批通过时间'")
    private LocalDateTime approvedTime;

    @Column
    @Comment("发票号码")
    private String invNo;

    @Column
    @Comment("发票代码")
    private String invCode;

    @Column
    @Comment("红蓝票类型,UDC")
    private String redBlueType;

    @Column
    @Comment("发票类型,UDC")
    private String invType;

    @Column
    @Comment("应付单号")
    private String apOrderNo;

    @Column
    @Comment("开票日期")
    private LocalDateTime invDate;

    @Column
    @Comment("未税金额")
    private BigDecimal untaxedAmt;

    @Column
    @Comment("税额")
    private BigDecimal taxAmt;

    @Column
    @Comment("发票校验码")
    private String invCheckCode;

    @Column
    @Comment("发票查验状态,UDC")
    private String invVerifyStatus;

    @Column
    @Comment("附件标识")
    private String invFileCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputInvDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InputInvDO entity = (InputInvDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}
