package com.elitesland.fin.domain.service.payorder;


import com.elitesland.fin.application.service.excel.entity.PayOrderExportEntity;
import com.elitesland.fin.domain.entity.payorder.PayOrder;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderExcelDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:52
 */
public interface PayOrderDomainService {

    /**
     * 分页查询付款单信息
     *
     * @param param 查询条件
     * @return 付款单数据
     */
    PagingVO<PayOrderDTO> page(PayOrderPageParam param);

    /**
     * 根据主键ID查询详细信息
     * @param  flag true 表示查询明细，false不查询明细
     * @param id 主键ID
     * @return 详细信息
     */
    PayOrderDTO queryById(Long id,Boolean flag);

    /**
     * 根据ID删除付款单
     *
     * @param ids
     * @return
     */
    List<Long> deleteByIds(List<Long> ids);

    /**
     * 保存付款单数据
     *
     * @param payOrder 实体付款单
     * @return 更新ID
     */
    Long save(PayOrder payOrder);

    /**
     * 提交付款单数据
     *
     * @param payOrder 实体付款单
     * @return 更新ID
     */
    Long submit(PayOrder payOrder);

    /**
     * 根据类型定义查询是否有关联数据
     * @param ids
     * @return
     */
    List<PayOrderDTO> queryByPayTypeId(List<Long> ids);

    /**
     *
     * @param ids
     * @return
     */
    List<PayOrderDO> queryByIds(List<Long> ids);


    void saveAll(List<PayOrderDO> payOrderDOS);


    /**
     * 根据参数查询付款单数据
     * @param payOrderParam 查询参数
     * @return 付款单信息
     */
    List<PayOrderDTO> queryByParam(PayOrderParam payOrderParam);

    List<PayOrderDTO> selectPayOrderByParam(PayOrderParam payOrderParam);

    /**
     * 更新付款单已核销金额
     * @param id 付款单ID
     * @param amt 本次核销金额
     */
    void updateVerAmt(Long id, BigDecimal amt);

    void updateWorkInfo(ProcessInfo processInfo, Long id);

    /**
     * 红冲单据创建
     * @param id
     * @return
     */
    PayOrder redPunchCreate(Long id);

    public PagingVO<PayOrderDTO> writeoffPage(PayOrderPageParam param);

    /**
     * 导出付款单
     * @param param
     * @return
     */
    PagingVO<PayOrderExportEntity> exportPayOrder(PayOrderPageParam param);
}
