package com.elitesland.fin.infr.repo.apverrec;

import com.elitesland.fin.domain.entity.apverrec.QApVerRecDtlDO;
import com.elitesland.fin.domain.param.apverrec.ApVerRecPageParam;
import com.elitesland.fin.infr.dto.apverrec.ApVerRecDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/25 11:35
 */
@Component
@RequiredArgsConstructor
public class ApVerRecDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QApVerRecDtlDO qApVerRecDtlDO = QApVerRecDtlDO.apVerRecDtlDO;

    //根据核销方案ID查询是否有核销记录关联数据
    public Boolean queryByScId(Long scId) {
        return jpaQueryFactory.select(qApVerRecDtlDO.id)
                .from(qApVerRecDtlDO)
                .where(qApVerRecDtlDO.schemeId.eq(scId))
                .where(qApVerRecDtlDO.deleteFlag.eq(0))
                .fetchCount() > 0;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qApVerRecDtlDO.id,
                qApVerRecDtlDO.amt,
                qApVerRecDtlDO.buDate,
                qApVerRecDtlDO.currCode,
                qApVerRecDtlDO.currName,
                qApVerRecDtlDO.masId,
                qApVerRecDtlDO.orderId,
                qApVerRecDtlDO.orderName,
                qApVerRecDtlDO.orderNo,
                qApVerRecDtlDO.orderType,
                qApVerRecDtlDO.ouId,
                qApVerRecDtlDO.ouCode,
                qApVerRecDtlDO.ouName,
                qApVerRecDtlDO.suppCode,
                qApVerRecDtlDO.suppName,
                qApVerRecDtlDO.suppId,
                qApVerRecDtlDO.verNo,
                qApVerRecDtlDO.verDate,
                qApVerRecDtlDO.schemeName,
                qApVerRecDtlDO.schemeNo,
                qApVerRecDtlDO.schemeId,
                qApVerRecDtlDO.verifyType,
                qApVerRecDtlDO.remark,
                qApVerRecDtlDO.createTime,
                qApVerRecDtlDO.creator,
                qApVerRecDtlDO.createUserId,
                qApVerRecDtlDO.modifyTime,
                qApVerRecDtlDO.modifyUserId,
                qApVerRecDtlDO.updater)
        ).from(qApVerRecDtlDO);
    }

    public PagingVO<ApVerRecDtlDTO> page(ApVerRecPageParam pageParam){
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(pageParam.getVerNo())) {
            predicates.add(qApVerRecDtlDO.verNo.like("%" + pageParam.getVerNo() + "%"));
        }
        if (null != pageParam.getOuId()) {
            predicates.add(qApVerRecDtlDO.ouId.eq(pageParam.getOuId()));
        }
        if (null != pageParam.getSuppId()) {
            predicates.add(qApVerRecDtlDO.suppId.eq(pageParam.getSuppId()));
        }
        if (StringUtils.isNotBlank(pageParam.getCurrCode())) {
            predicates.add(qApVerRecDtlDO.currCode.eq(pageParam.getCurrCode()));
        }
        if (StringUtils.isNotBlank(pageParam.getVerifyType())) {
            predicates.add(qApVerRecDtlDO.verifyType.eq(pageParam.getVerifyType()));
        }
        if (null != pageParam.getVerDateStart() && null != pageParam.getVerDateEnd()) {
            predicates.add(qApVerRecDtlDO.verDate.between(pageParam.getVerDateStart(), pageParam.getVerDateEnd()));
        }
        predicates.add(qApVerRecDtlDO.deleteFlag.eq(0));
        JPAQuery<ApVerRecDtlDTO> query = select(ApVerRecDtlDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qApVerRecDtlDO);
        return PagingVO.<ApVerRecDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<ApVerRecDtlDTO> queryDtlByMasIds(Collection<Long> masIds) {
       return select(ApVerRecDtlDTO.class).where(qApVerRecDtlDO.masId.in(masIds).and(qApVerRecDtlDO.deleteFlag.eq(0))).fetch();
    }

    public Long logicDelByIds(Collection<Long> ids){
        return jpaQueryFactory.update(qApVerRecDtlDO).set(qApVerRecDtlDO.deleteFlag,1)
                .where(qApVerRecDtlDO.id.in(ids).and(qApVerRecDtlDO.deleteFlag.eq(0))).execute();
    }

}
