package com.elitesland.fin.repo.writeoff;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.common.WriteoffUdcEnum;
import com.elitesland.fin.domain.entity.writeoff.*;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
public class FinApPayVerApplyRepoProc extends BaseRepoProc<FinApPayVerApplyDO> {

    private static final QFinApPayVerApplyDO QDO = QFinApPayVerApplyDO.finApPayVerApplyDO;
    private static final QFinApPayVerApplyApDO QApDO = QFinApPayVerApplyApDO.finApPayVerApplyApDO;
    private static final QFinApPayVerApplyPayDO QPayDO = QFinApPayVerApplyPayDO.finApPayVerApplyPayDO;
    private static final QFinApPayVerApplyApHeadDO QApHeadDO = QFinApPayVerApplyApHeadDO.finApPayVerApplyApHeadDO;
    private static final QFinApPayVerApplyPayHeadDO QPayHeadDO = QFinApPayVerApplyPayHeadDO.finApPayVerApplyPayHeadDO;

    protected FinApPayVerApplyRepoProc() {
        super(QDO);
    }

    public List<FinApPayVerApplyDO> findAllByIds(List<Long> ids) {
        return jpaQueryFactory.selectFrom(QDO).where(QDO.id.in(ids)).fetch();
    }
    /**
     * 分页查询.
     *
     * @param query 查询参数
     * @return 记录列表
     */
    public PagingVO<FinApPayVerApplyDO> page(FinApPayVerApplyQuery query) {
        // 查询条件
        Predicate predicate = PredicateBuilder.builder()
                .andEq(QDO.state, query.getState())
                .andEq(QDO.verState, query.getVerState())
                .build();

        return super.queryByPage(predicate, query.getPageRequest(), QDO.createTime.desc());
    }
    private final QBean<FinApPayVerApplyVO> applyDOQBean = Projections.bean(
            FinApPayVerApplyVO.class,
            QDO.id,
            QDO.inOutCust,
            //QDO.relevanceOuCode,
            QDO.applyDocNo,
            QDO.state,
            QDO.verState,
            QDO.verAmt,
            QDO.apprStatus,
            QDO.applyDate,
            QDO.applyUserId,
            QDO.applyUserCode,
            QDO.applyUserName,
            QDO.approvalDate,
            QDO.approvalUserId,
            QDO.approvalUserCode,
            QDO.approvalUserName,
            QDO.approvalRemark,
            QDO.headFlag,
            QDO.proposedStatus,
            QDO.ouCode,
            QDO.ouName,
            QDO.ouId,
            QDO.schemeId,
            QDO.verMode,
            QDO.createTime,
            QDO.modifyTime,
            QDO.creator,
            QDO.updater,
            QDO.createUserId,
            QDO.modifyUserId);

    /**
     * 分页查询.
     *
     * @param query 查询参数
     * @return 记录列表
     */
    public PagingVO<FinApPayVerApplyVO> joinPage(FinApPayVerApplyQuery query) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(QDO.state, query.getState())
                .andEq(QDO.verState, query.getVerState())
                .andLike(QDO.applyDocNo, query.getApplyDocNo())
                .andEq(QDO.applyUserId, query.getApplyUserId())
                .andLike(QDO.applyUserName, query.getApplyUserName())
                .andEq(QDO.approvalUserId, query.getApprovalUserId())
                .andLike(QDO.approvalUserName, query.getApprovalUserName())
                .andBetween(QDO.applyDate, query.getApplyDateS(), query.getApplyDateE())
                .andBetween(QDO.approvalDate, query.getApprovalDateS(), query.getApprovalDateE())
                .andEq(QDO.proposedStatus, query.getProposedStatus())
                /*     .andEq(QApDO.custId, query.getApCustId())*/
             /*   .andEq(QApDO.custCode, query.getApCustCode())*/
              /*  .andEq(QApDO.subCustId, query.getApSubCustId())*/
              /*  .andEq(QApDO.subCustCode, query.getApSubCustCode())*/
                .andEq(QApDO.ouId, query.getApOuId())
                .andEq(QApDO.ouCode, query.getApOuCode())
                .andEq(QApDO.salesmanId, query.getApSalesmanId())
                .andEq(QApDO.salesmanCode, query.getApSalesmanCode())
                .andLike(QApDO.invoiceNumber, query.getApInvoiceNumber())
                .andEq(QPayDO.ouId, query.getPayOuId())
                .andEq(QPayDO.ouCode, query.getPayOuCode())
               /* .andEq(QPayDO.custId, query.getPayCustId())*/
               /* .andEq(QPayDO.custCode, query.getPayCustCode())*/
                .andEq(QPayDO.salesmanId, query.getPaySalesmanId())
                .andEq(QPayDO.salesmanCode, query.getPaySalesmanCode())
                .andLike(QPayDO.invoiceNumber, query.getPayInvoiceNumber())
                .andIsNull(query.getHeadFlag() == null, QDO.headFlag)
                .andEq(QDO.headFlag, query.getHeadFlag())
                .build();

		// id 查询
		if(CollUtil.isNotEmpty(query.getIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.id.in(query.getIds())
			);
		}
        if (CollUtil.isNotEmpty(query.getPayInOutCustList())) {
            predicate = ExpressionUtils.and(
                    predicate, QPayHeadDO.inOutCust.in(query.getPayInOutCustList())
            );
        }

        if (CollUtil.isNotEmpty(query.getApInOutCustList())) {
            predicate = ExpressionUtils.and(
                    predicate, QApHeadDO.inOutCust.in(query.getApInOutCustList())
            );
        }

        if (CollUtil.isNotEmpty(query.getPayRelevanceOuCodeList())) {
            predicate = ExpressionUtils.and(
                    predicate, QPayHeadDO.relevanceOuCode.in(query.getPayRelevanceOuCodeList())
            );
        }

        if (CollUtil.isNotEmpty(query.getApRelevanceOuCodeList())) {
            predicate = ExpressionUtils.and(
                    predicate, QApHeadDO.relevanceOuCode.in(query.getApRelevanceOuCodeList())
            );
        }

        JPAQuery<FinApPayVerApplyVO> select = jpaQueryFactory.select(applyDOQBean)
                .from(QDO)
                .leftJoin(QApDO).on(QDO.id.eq(QApDO.masId))
                .leftJoin(QPayDO).on(QDO.id.eq(QPayDO.masId))
                .where(predicate)
                .groupBy(QDO.id,
                        QDO.inOutCust,
                        QDO.applyDocNo,
                        QDO.state,
                        QDO.verState,
                        QDO.verAmt,
                        QDO.apprStatus,
                        QDO.applyDate,
                        QDO.applyUserId,
                        QDO.applyUserCode,
                        QDO.applyUserName,
                        QDO.approvalDate,
                        QDO.approvalUserId,
                        QDO.approvalUserCode,
                        QDO.approvalUserName,
                        QDO.approvalRemark,
                        QDO.headFlag,
                        QDO.proposedStatus,
                        QDO.ouCode,
                        QDO.ouName,
                        QDO.ouId,
                        QDO.schemeId,
                        QDO.verMode,
                        QDO.createTime,
                        QDO.modifyTime,
                        QDO.creator,
                        QDO.updater,
                        QDO.createUserId,
                        QDO.modifyUserId);
        return super.queryByPage(select, query.getPageRequest(), QDO.createTime.desc());
    }

    public PagingVO<FinApPayVerApplyVO> writeOffJoinPage(FinApPayVerApplyQuery query) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(QDO.state, query.getState())
                .andEq(QDO.verState, query.getVerState())
                .andLike(QDO.applyDocNo, query.getApplyDocNo())
                .andEq(QDO.applyUserId, query.getApplyUserId())
                .andLike(QDO.applyUserName, query.getApplyUserName())
                .andEq(QDO.approvalUserId, query.getApprovalUserId())
                .andLike(QDO.approvalUserName, query.getApprovalUserName())
                .andBetween(QDO.applyDate, query.getApplyDateS(), query.getApplyDateE())
                .andBetween(QDO.approvalDate, query.getApprovalDateS(), query.getApprovalDateE())
                .andEq(QDO.proposedStatus, query.getProposedStatus())

                .andEq(QApHeadDO.ouCode, query.getWriteOffApOuCode())
            /*    .andEq(QApHeadDO.custCode, query.getWriteOffApCustCode())*/
                .andEq(QApHeadDO.salesmanCode, query.getWriteOffApSalesmanCode())
              /*  .andEq(QPayHeadDO.custCode, query.getWriteOffPayCustCode())*/
                .andEq(QPayHeadDO.ouCode, query.getWriteOffPayOuCode())
                .andEq(QPayHeadDO.salesmanCode, query.getWriteOffPaySalesmanCode())

                .andIsNull(query.getHeadFlag() == null, QDO.headFlag)
                .andEq(QDO.headFlag, query.getHeadFlag())
                .andEq(QDO.proposedStatus, query.getProposedStatus())
                .andBefore(query.getApplyDateE()!=null,QDO.applyDate,query.getApplyDateE())
                .andAfter(query.getApplyDateS()!=null,QDO.applyDate,query.getApplyDateS())
                .build();

		// id 查询
		if(CollUtil.isNotEmpty(query.getIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.id.in(query.getIds())
			);
		}
        if (CollUtil.isNotEmpty(query.getApprStatusList())) {
            predicate = ExpressionUtils.and(
                    predicate, QDO.apprStatus.in(query.getApprStatusList())
            );
        }
        if (CollUtil.isNotEmpty(query.getPayInOutCustList())) {
            predicate = ExpressionUtils.and(
                    predicate, QPayHeadDO.inOutCust.in(query.getPayInOutCustList())
            );
        }

        if (CollUtil.isNotEmpty(query.getApInOutCustList())) {
            predicate = ExpressionUtils.and(
                    predicate, QApHeadDO.inOutCust.in(query.getApInOutCustList())
            );
        }
        if (CollUtil.isNotEmpty(query.getPayRelevanceOuCodeList())) {
            predicate = ExpressionUtils.and(
                    predicate, QPayHeadDO.relevanceOuCode.in(query.getPayRelevanceOuCodeList())
            );
        }

        if (CollUtil.isNotEmpty(query.getApRelevanceOuCodeList())) {
            predicate = ExpressionUtils.and(
                    predicate, QApHeadDO.relevanceOuCode.in(query.getApRelevanceOuCodeList())
            );
        }


        JPAQuery<FinApPayVerApplyVO> select = jpaQueryFactory.select(applyDOQBean)
                .from(QDO)
                .leftJoin(QApHeadDO).on(QDO.id.eq(QApHeadDO.masId))
                .leftJoin(QPayHeadDO).on(QDO.id.eq(QPayHeadDO.masId))
                .where(predicate)
                .groupBy(QDO.id,
                        QDO.inOutCust,
                        //QDO.relevanceOuCode,
                        QDO.applyDocNo,
                        QDO.state,
                        QDO.verState,
                        QDO.verAmt,
                        QDO.apprStatus,
                        QDO.applyDate,
                        QDO.applyUserId,
                        QDO.applyUserCode,
                        QDO.applyUserName,
                        QDO.approvalDate,
                        QDO.approvalUserId,
                        QDO.approvalUserCode,
                        QDO.approvalUserName,
                        QDO.approvalRemark,
                        QDO.headFlag,
                        QDO.proposedStatus,
                        QDO.ouCode,
                        QDO.ouName,
                        QDO.ouId,
                        QDO.schemeId,
                        QDO.verMode,
                        QDO.createTime,
                        QDO.modifyTime,
                        QDO.creator,
                        QDO.updater,
                        QDO.createUserId,
                        QDO.modifyUserId);
        return super.queryByPage(select, query.getPageRequest(), QDO.createTime.desc());
    }

    /**
     * 根据单号集合查询数据信息.
     *
     * @param applyDocNos 查询参数
     * @return 查询结果
     */
    public List<FinApPayVerApplyDO> getListByApplyNos(Collection<String> applyDocNos) {
        return super.getListByValue(QDO.applyDocNo, applyDocNos);
    }

    public void updateStatusById(Long id) {
        jpaQueryFactory.update(QDO).set(QDO.verState, WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_NOT.getValueCode()).set(QDO.apprStatus, UdcEnum.COM_APPR_STATUS_APPROVING.getValueCode()).where(QDO.id.eq(id)).execute();
    }

    public void approvedApprStatusById(Long id) {
        jpaQueryFactory.update(QDO).set(QDO.apprStatus, UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode()).where(QDO.id.eq(id)).execute();
    }

    public void deleteByIds(List<Long> ids) {
        jpaQueryFactory.update(QDO).set(QDO.deleteFlag, 1).where(QDO.id.in(ids)).execute();
    }

    public void ApproveById(Long id) {
        jpaQueryFactory.update(QDO).set(QDO.verState,
                WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode()).set(QDO.apprStatus,
                UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode()).where(QDO.id.eq(id)).execute();
    }

    public void approveByDocNos(List<String> docNos) {
        jpaQueryFactory.update(QDO).set(QDO.verState,
                WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode()).set(QDO.apprStatus,
                UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode()).where(QDO.applyDocNo.in(docNos)).execute();
    }

    public List<FinApPayVerApplyDO> finApPayVerApplyByPayId(Long payId){
        var jpaQuery = jpaQueryFactory.select(QDO)
                .from(QPayDO)
                .leftJoin(QPayHeadDO).on(QPayDO.masId.eq(QPayHeadDO.id))
                .leftJoin(QDO).on(QDO.id.eq(QPayHeadDO.masId));
        jpaQuery.where(QDO.state.eq(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode()));
        jpaQuery.where(QPayDO.payId.eq(payId));
        return jpaQuery.fetch();
    }

}
