package com.elitesland.fin.application.web.payment;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigQueryVO;
import com.elitesland.fin.application.service.payment.PaymentRuleConfigService;
import com.elitesland.fin.dto.generateaccountflow.GenerateAccountFlowRpcDTO;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigDtlRpcDTO;
import com.elitesland.fin.param.paymentruleconfig.PaymentRuleConfigRpcParam;
import com.elitesland.fin.param.generateaccountflow.GenerateAccountFlowRpcParam;
import com.elitesland.fin.service.paymentruleconfig.PaymentRuleConfigRpcService;
import com.elitesland.fin.service.generateaccountflow.GenerateAccountFlowRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/payment/rule/config")
@Api(value = "支付配置", tags = {"支付配置"})
@AllArgsConstructor
public class PaymentRuleConfigController {

    private final PaymentRuleConfigService paymentRuleConfigService;
    private final PaymentRuleConfigRpcService paymentRuleConfigRpcService;
    private final GenerateAccountFlowRpcService generateAccountFlowRpcService;

    @PostMapping("/page")
    @ApiOperation("支付配置-分页查询")
    public ApiResult<PagingVO<PaymentRuleConfigPageVO>> page(@RequestBody PaymentRuleConfigParam param) {
        val ret = paymentRuleConfigService.searchPage(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/byRuleCode")
    @ApiOperation("支付配置主表-按编码查询")
    public ApiResult<Optional<PaymentRuleConfigQueryVO>> byRuleCode(@RequestParam("ruleCode") String ruleCode) {
        val ret = paymentRuleConfigService.byRuleCode(ruleCode);
        return ApiResult.ok(ret);
    }

    @PostMapping("/dtlsByRuleCode")
    @ApiOperation("支付配置详情-按编码查询")
    public ApiResult<List<PaymentRuleConfigDtlDTO>> dtlsByRuleCode(@RequestParam("ruleCode") String ruleCode) {
        val ret = paymentRuleConfigService.dtlsByRuleCode(ruleCode);
        return ApiResult.ok(ret);
    }

    @PostMapping("/detail/{masId}")
    @ApiOperation("支付配置-详情")
    public ApiResult<PaymentRuleConfigQueryVO> detail(@PathVariable("masId") Long masId) {
        val ret = paymentRuleConfigService.detail(masId);
        return ApiResult.ok(ret);
    }

    @PostMapping("/save")
    @ApiOperation("支付配置-保存/更新")
    public ApiResult<Void> save(@RequestBody PaymentRuleConfigParam param) {
        paymentRuleConfigService.saveOrUpdate(param);
        return ApiResult.ok();
    }

    @GetMapping("/del/{masId}")
    @ApiOperation("支付配置-删除")
    public ApiResult<Void> del(@PathVariable("masId") Long masId) {
        paymentRuleConfigService.del(masId);
        return ApiResult.ok();
    }

    @PostMapping("/queryAccountAmount")
    @ApiOperation("查询账户金额")
    public ApiResult<List<PaymentRuleConfigDtlRpcDTO>> queryAccountAmount(@RequestBody PaymentRuleConfigRpcParam param) {
        return paymentRuleConfigRpcService.queryAccountAmount(param);
    }

    @PostMapping("/pay")
    @ApiOperation("支付")
    public ApiResult<List<PaymentRuleConfigDtlRpcDTO>> pay(@RequestBody PaymentRuleConfigRpcParam param) {
        return paymentRuleConfigRpcService.pay(param);
    }

    @PostMapping("/generateAccountFlow")
    @ApiOperation("生成流水")
    public ApiResult<Void> generateAccountFlow(@RequestBody List<GenerateAccountFlowRpcParam> param) {
        generateAccountFlowRpcService.generateAccountFlow(param);
        return ApiResult.ok();
    }

    @PostMapping("/generateFlow")
    @ApiOperation("生成流水")
    public ApiResult<List<GenerateAccountFlowRpcDTO>>  generateFlow(@RequestBody GenerateAccountFlowRpcParam param) {

        return generateAccountFlowRpcService.generateFlow(param);
    }

}

