package com.elitesland.fin.domain.service.paymentperiod;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.paymentperiod.AgingRangeDtlConvert;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeDtlPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeDtlSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeDtlVO;
import com.elitesland.fin.domain.entity.paymentperiod.AgingRangeDtlDO;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeDtlRepo;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeDtlRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
@Service
@RequiredArgsConstructor
public class AgingRangeDtlDomainServiceImpl implements AgingRangeDtlDomainService{
    private final AgingRangeDtlRepo agingRangeDtlRepo;
    private final AgingRangeDtlRepoProc agingRangeDtlRepoProc;



    /**
     * 账龄区间明细保存
     *
     * @param saveParamList 入参
     * @return 账龄区间明细明细ID
     */
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public List<Long> saveDtl(List<AgingRangeDtlSaveParam> saveParamList) {
        List<AgingRangeDtlDO> dtlDOList = saveParamList.stream().map(AgingRangeDtlConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());

        return agingRangeDtlRepo.saveAll(dtlDOList).stream().map(AgingRangeDtlDO::getId).collect(Collectors.toList());
    }

    /**
     * 根据主表ID删除账龄区间明细
     *
     * @param masId 主表ID
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        agingRangeDtlRepo.deleteByMasId(masId);
    }

    /**
     * 根据主表ID查询账龄区间明细
     *
     * @param masId 主表ID
     * @return 账龄区间明细
     */
    @Override
    @SysCodeProc
    public List<AgingRangeDtlVO> selectByMasId(Long masId) {
        if (Objects.isNull(masId)) {
            return Collections.EMPTY_LIST;
        }
        AgingRangeDtlPageParam queryVO = new AgingRangeDtlPageParam();
        queryVO.setMasId(masId);
        List<AgingRangeDtlVO> dtlVOList = agingRangeDtlRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }

        return dtlVOList;
    }

    /**
     * 根据入参查询账龄区间明细
     *
     * @param queryVO 入参
     * @return 账龄区间明细数据
     */
    @Override
    @SysCodeProc
    public List<AgingRangeDtlVO> selectByParam(AgingRangeDtlPageParam queryVO) {
        List<AgingRangeDtlVO> dtlVOList = agingRangeDtlRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlVOList;
    }

    /**
     * 根据主表ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masIds     主表ID
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds) {
        agingRangeDtlRepoProc.updateDeleteFlagBatch(deleteFlag, masIds);
    }
}
