package com.elitesland.fin.entity.adjustorder;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.domain.entity.base.BaseWorkflowModel;
import com.elitesland.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/2/25 9:56
 */
@Entity
@org.hibernate.annotations.Table(appliesTo = "adjust_order", comment = "调整单")
@Table(name="adjust_order")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0")
public class AdjustOrderDO extends BaseWorkflowModel {

    private static final long serialVersionUID = 4995534289008819053L;
    @Column(name = "doc_no", columnDefinition = "varchar(32) comment '单号'")
    private String docNo;

    @Column(name = "state", columnDefinition = "varchar(32) comment '状态'")
    private String state;

    @Column(name = "type", columnDefinition = "varchar(32) comment '单据类型'")
    private String type;

    @Column(name = "rec_acc_time", columnDefinition = "datetime(6) comment '记账日期'")
    private LocalDateTime recAccTime;

    @Column(name = "acc_name", columnDefinition = "varchar(32) comment '账户名称'")
    private String accName;

    @Column(name = "acc_code", columnDefinition = "varchar(32) comment '账户编码'")
    private String accCode;

    @Column(name = "acc_type", columnDefinition = "varchar(32) comment '账户类型'")
    private String accType;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) DEFAULT 0 comment '总金额'")
    private BigDecimal totalAmt;

    @Column(name = "audit_user", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人id'")
    private Long auditUserId;

    @Column(name = "audit_time", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditTime;

    @Column(name = "audit_reject_reason", columnDefinition = "varchar(255) comment '审核拒绝理由'")
    private String auditRejectReason;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司id'")
    private Long ouId;

    @Column(name = "adj_reason", columnDefinition = "varchar(255) comment '调整原因'")
    private String adjReason;

    @Column(name = "adj_type", columnDefinition = "varchar(32) comment '调整类型'")
    private String adjType;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源id'")
    private Long sourceId;

    @ApiModelProperty("开户主体名称")
    @Column(name = "account_holder_name", columnDefinition = "varchar(32) comment '开户主体名称'")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    @Column(name = "account_holder_code", columnDefinition = "varchar(32) comment '开户主体编码'")
    private String accountHolderCode;

}
