package com.elitesland.fin.infr.repo.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.service.excel.entity.RecOrderEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDtlDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderRpcFiledDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderParam;
import com.elitesland.fin.infr.dto.common.ArVerDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/4/13 10:39
 */
@Component
@RequiredArgsConstructor
public class RecOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QRecOrderDO qRecOrderDO = QRecOrderDO.recOrderDO;
    private final QRecOrderDtlDO qRecOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;
    private final QRecOrderRpcFiledDO Q_REC_ORDER_FILE_DO = QRecOrderRpcFiledDO.recOrderRpcFiledDO;

    public List<RecOrderDO> findBySourceNo(String sourceNo) {
        return jpaQueryFactory.selectFrom(qRecOrderDO).where(qRecOrderDO.sourceNo.eq(sourceNo)).fetch();
    }

    public List<RecOrderDO> findBySourceNoList(List<String> sourceNoList) {
        return jpaQueryFactory.selectFrom(qRecOrderDO).where(qRecOrderDO.sourceNo.in(sourceNoList)).fetch();
    }


    public PagingVO<RecOrderDTO> page(RecOrderPageParam param, List<Long> ids) {
        // 条件拼接
        var predicates = new ArrayList<Predicate>();
        buildPredicates(param, ids, predicates);
        pageWhere(param, predicates);

        JPAQuery<RecOrderDTO> query = select(RecOrderDTO.class).where(ExpressionUtils.allOf(predicates));
        //数据权限
        BusinessSecurityUtil.where(query, RecOrderDO.class);
        param.setPaging(query);
        param.fillOrders(query, qRecOrderDO);
        return PagingVO.<RecOrderDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private void pageWhere(RecOrderPageParam param, List<Predicate> predicates) {
        if (param.getId() != null) {
            predicates.add(qRecOrderDO.id.eq(param.getId()));
        }
        if (param.getBuDateStart() != null && param.getBuDateEnd() != null) {
            predicates.add(qRecOrderDO.reDate.between(param.getReDateStart(), param.getReDateEnd()));
        }
        if (param.getBuId() != null) {
            predicates.add(qRecOrderDO.buId.eq(param.getBuId()));
        }
        if (CollectionUtils.isNotEmpty(param.getBuIdList())) {
            predicates.add(qRecOrderDO.buId.in(param.getBuIdList()));
        }
        if (param.getOrgId() != null) {
            predicates.add(qRecOrderDO.orgId.eq(param.getOrgId()));
        }
        if (param.getRedState() != null) {
            predicates.add(qRecOrderDO.redState.eq(param.getRedState()));
        }
        if (param.getProposedStatus() != null) {
            predicates.add(qRecOrderDO.proposedStatus.like("%" + param.getProposedStatus() + "%"));
        }
        if (param.getRedSourceNo() != null) {
            predicates.add(qRecOrderDO.redSourceNo.like("%" + param.getRedSourceNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(param.getOrgIdList())) {
            predicates.add(qRecOrderDO.orgId.in(param.getOrgIdList()));
        }
        if (!StringUtils.isEmpty(param.getRecOrderNo())) {
            predicates.add(qRecOrderDO.recOrderNo.like("%" + param.getRecOrderNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(param.getRecOrderNoList())) {
            predicates.add(qRecOrderDO.recOrderNo.in(param.getRecOrderNoList()));
        }
        if (!StringUtils.isEmpty(param.getAuditUser())) {
            predicates.add(qRecOrderDO.auditUser.like("%" + param.getAuditUser() + "%"));
        }
        if (!StringUtils.isEmpty(param.getAuditRejection())) {
            predicates.add(qRecOrderDO.auditRejection.like("%" + param.getAuditRejection() + "%"));
        }
        if (param.getTotalAmtFrom() != null) {
            predicates.add(qRecOrderDO.totalAmt.goe(param.getTotalAmtFrom()));
        }
        if (param.getTotalAmtTo() != null) {
            predicates.add(qRecOrderDO.totalAmt.loe(param.getTotalAmtTo()));
        }
        if (param.getCustId() != null) {
            predicates.add(qRecOrderDO.custId.eq(param.getCustId()));
        }
        if (CollectionUtils.isNotEmpty(param.getCustIdList())) {
            predicates.add(qRecOrderDO.custId.in(param.getCustIdList()));
        }
        if (StringUtils.isNotEmpty(param.getCustCode())) {
            predicates.add(qRecOrderDO.custCode.eq(param.getCustCode()));
        }
        if (CollectionUtil.isNotEmpty(param.getCustCodeList())) {
            predicates.add(qRecOrderDO.custCode.in(param.getCustCodeList()));
        }
        if (StringUtils.isNotBlank(param.getCustName())) {
            predicates.add(qRecOrderDO.custName.like("%" + param.getCustName() + "%"));
        }
        if (CollectionUtils.isNotEmpty(param.getCustNameList())) {
            predicates.add(qRecOrderDO.custName.in(param.getCustNameList()));
        }
        if (param.getRecTypeId() != null) {
            predicates.add(qRecOrderDO.recTypeId.eq(param.getRecTypeId()));
        }
        if (CollectionUtils.isNotEmpty(param.getRecTypeIdList())) {
            predicates.add(qRecOrderDO.recTypeId.in(param.getRecTypeIdList()));
        }
        if (!StringUtils.isEmpty(param.getCreateMode())) {
            predicates.add(qRecOrderDO.createMode.eq(param.getCreateMode()));
        }
        if (ObjectUtil.isNotNull(param.getRecOuId())) {
            predicates.add(qRecOrderDO.recOuId.eq(param.getRecOuId()));
        }
        if (CollectionUtils.isNotEmpty(param.getRecOuIdList())) {
            predicates.add(qRecOrderDO.recOuId.in(param.getRecOuIdList()));
        }
        if (CollectionUtils.isNotEmpty(param.getIds())) {
            predicates.add(qRecOrderDO.id.in(param.getIds()));
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate(param.getConditions(), RecOrderDO.class);
        if (customFieldPredicate != null) {
            predicates.add(customFieldPredicate);
            //predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
        //增加扩展字段查询条件end
        predicates.add(qRecOrderDO.deleteFlag.eq(0));
    }

    private void buildPredicates(RecOrderPageParam param, List<Long> ids, List<Predicate> predicates) {
        if (CollUtil.isNotEmpty(param.getInOutCustList())) {
            predicates.add(qRecOrderDO.inOutCust.in(param.getInOutCustList()));
        }
        if (CollUtil.isNotEmpty(param.getRelevanceOuCodeList())) {
            predicates.add(qRecOrderDO.relevanceOuCode.in(param.getRelevanceOuCodeList()));
        }
        if (!CollUtil.isEmpty(ids)) {
            predicates.add(qRecOrderDO.id.in(ids));
        }
        //是否期初
        if (param.getInitFlag() != null) {
            predicates.add(qRecOrderDO.initFlag.eq(param.getInitFlag()));
        }
        if (param.getReFlag() != null) {
            predicates.add(qRecOrderDO.reFlag.eq(param.getReFlag()));
        }
        if (param.getAuditDateStart() != null && param.getAuditDateEnd() != null) {
            predicates.add(qRecOrderDO.auditDate.between(param.getAuditDateStart(), param.getAuditDateEnd()));
        }
        if (!StringUtils.isEmpty(param.getCurrCode())) {
            predicates.add(qRecOrderDO.currCode.eq((param.getCurrCode())));
        }
        if (CollectionUtils.isNotEmpty(param.getCurrCodeList())) {
            predicates.add(qRecOrderDO.currCode.in(param.getCurrCodeList()));
        }
        if (!StringUtils.isEmpty(param.getSaleUser())) {
            predicates.add(qRecOrderDO.saleUser.like(("%" + param.getSaleUser() + "%")));
        }
        if (CollectionUtils.isNotEmpty(param.getSaleUserList())) {
            predicates.add(qRecOrderDO.saleUser.in(param.getSaleUserList()));
        }
        if (CollectionUtils.isNotEmpty(param.getSaleUserIdList())) {
            predicates.add(qRecOrderDO.saleUserId.in(param.getSaleUserIdList()));
        }
        if (!StringUtils.isEmpty(param.getOrderState())) {
            predicates.add(qRecOrderDO.orderState.eq(param.getOrderState()));
        }
        if (CollectionUtils.isNotEmpty(param.getOrderStateList())) {
            predicates.add(qRecOrderDO.orderState.in(param.getOrderStateList()));
        }
        if (param.getOuId() != null) {
            predicates.add(qRecOrderDO.ouId.eq(param.getOuId()));
        }
        if (CollectionUtils.isNotEmpty(param.getOuIdList())) {
            predicates.add(qRecOrderDO.ouId.in(param.getOuIdList()));
        }
        if (param.getExchangeRate() != null) {
            predicates.add(qRecOrderDO.exchangeRate.eq(param.getExchangeRate()));
        }
        if (param.getRecOuId() != null) {
            predicates.add(qRecOrderDO.recOuId.eq(param.getRecOuId()));
        }
        if (CollectionUtils.isNotEmpty(param.getRecOuIdList())) {
            predicates.add(qRecOrderDO.recOuId.in(param.getRecOuIdList()));
        }
        if (!StringUtils.isEmpty(param.getVerState())) {
            predicates.add(qRecOrderDO.verState.eq(param.getVerState()));
        }
        if (CollectionUtils.isNotEmpty(param.getVerStateList())) {
            predicates.add(qRecOrderDO.verState.in(param.getVerStateList()));
        }
        if (param.getAuditDateEnd() != null && param.getAuditDateStart() != null) {
            predicates.add(qRecOrderDO.auditDate.between(param.getAuditDateStart(), param.getAuditDateEnd()));
        }
        if (StringUtils.isNotEmpty(param.getOuCode())) {
            predicates.add(qRecOrderDO.ouCode.eq(param.getOuCode()));
        }
        if (CollectionUtil.isNotEmpty(param.getOuCodeList())) {
            predicates.add(qRecOrderDO.ouCode.in(param.getOuCodeList()));
        }
        if (StringUtils.isNotEmpty(param.getSourceNo())) {
            predicates.add(qRecOrderDO.sourceNo.eq(param.getSourceNo()));
        }
    }

    public RecOrderDTO queryById(Long id) {
        return select(RecOrderDTO.class)
                .where(qRecOrderDO.id.eq(id))
                .fetchOne();
    }

    public Long audit(List<Long> ids, String auditRejection, SysUserDTO user) {
        return jpaQueryFactory.update(qRecOrderDO)
                .set(qRecOrderDO.auditDate, LocalDateTime.now())
                .set(qRecOrderDO.auditRejection, auditRejection)
                .set(qRecOrderDO.auditUser, user.getUsername())
                .set(qRecOrderDO.auditUserId, user.getId())
                .where(qRecOrderDO.id.in(ids))
                .execute();
    }

    public List<RecOrderDTO> queryByIds(List<Long> ids) {
        return select(RecOrderDTO.class)
                .where(qRecOrderDO.id.in(ids))
                .fetch();
    }

    public void deleteById(List<Long> ids) {
        jpaQueryFactory.delete(qRecOrderDO)
                .where(qRecOrderDO.id.in(ids))
                .execute();
    }

    public List<RecOrderDTO> queryByRecTypeId(List<Long> recTypeId) {
        return select(RecOrderDTO.class)
                .where(qRecOrderDO.recTypeId.in(recTypeId))
                .fetch();
    }

    public List<RecOrderDTO> getRecOrderList(RecOrderParam recOrderParam) {
        List<Predicate> predicates = new ArrayList<>();
        // 公司
//        if (null != recOrderParam.getOuId()) {
//            predicates.add(qRecOrderDO.ouId.eq(recOrderParam.getOuId()));
//        }
//        if (recOrderParam.getCustId() != null) {
//            predicates.add(qRecOrderDO.custId.eq(recOrderParam.getCustId()));
//        }
        if (StrUtil.isNotBlank(recOrderParam.getOuCode())) {
            predicates.add(qRecOrderDO.ouCode.eq(recOrderParam.getOuCode()));
        }
        if (StrUtil.isNotBlank(recOrderParam.getCustCode())) {
            predicates.add(qRecOrderDO.custCode.eq(recOrderParam.getCustCode()));
        }
        // 币种
        if (CharSequenceUtil.isNotBlank(recOrderParam.getCurrCode())) {
            predicates.add(qRecOrderDO.currCode.eq(recOrderParam.getCurrCode()));
        }
        // 业务日期
        if (null != recOrderParam.getBuDateStart() && null != recOrderParam.getBuDateEnd()) {
            predicates.add(qRecOrderDO.reDate.between(recOrderParam.getBuDateStart(), recOrderParam.getBuDateEnd()));
        }
        predicates.add(qRecOrderDO.orderState.eq(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()));
        List<RecOrderDTO> fetch = select(RecOrderDTO.class).where(ExpressionUtils.allOf(predicates)).fetch();
        return fetch;
    }

    public ArVerDTO queryVerAmtById(Long id) {
        return jpaQueryFactory.select(Projections.bean(ArVerDTO.class,
                qRecOrderDO.id,
                qRecOrderDO.totalAmt,
                qRecOrderDO.verAmt,
                qRecOrderDO.auditDataVersion)).from(qRecOrderDO).where(qRecOrderDO.id.eq(id)).fetchOne();
    }

    public long updateVerAmt(ArVerDTO arVerDTO) {
        return jpaQueryFactory.update(qRecOrderDO).set(qRecOrderDO.verState, arVerDTO.getVerState())
                .set(qRecOrderDO.verAmt, arVerDTO.getVerAmt())
                .set(qRecOrderDO.auditDataVersion, arVerDTO.getAuditDataVersion() + 1)
                .where(qRecOrderDO.id.eq(arVerDTO.getId())
                        .and(qRecOrderDO.totalAmt.goe(arVerDTO.getVerAmt()))
                        .and(qRecOrderDO.auditDataVersion.eq(arVerDTO.getAuditDataVersion())))
                .execute();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qRecOrderDO.id,
                qRecOrderDO.sourceNo,
                qRecOrderDO.ouCode,
                qRecOrderDO.ouId,
                qRecOrderDO.ouName,
                qRecOrderDO.arTypeId,
                qRecOrderDO.arTypeName,
                qRecOrderDO.arTypeCode,
                qRecOrderDO.recTypeId,
                qRecOrderDO.recTypeCode,
                qRecOrderDO.recTypeName,
                qRecOrderDO.recOrderNo,
                qRecOrderDO.currCode,
                qRecOrderDO.currName,
                qRecOrderDO.localCurrCode,
                qRecOrderDO.localCurrName,
                qRecOrderDO.totalAmt,
                qRecOrderDO.totalCurAmt,
                qRecOrderDO.auditUserId,
                qRecOrderDO.auditUser,
                qRecOrderDO.auditDate,
                qRecOrderDO.orderState,
                qRecOrderDO.exchangeRate,
                qRecOrderDO.initFlag,
                qRecOrderDO.realRecAmt,
                qRecOrderDO.realRecCurAmt,
                qRecOrderDO.reDate,
                qRecOrderDO.reFlag,
                qRecOrderDO.auditRejection,
                qRecOrderDO.createMode,
                qRecOrderDO.verState,
                qRecOrderDO.verAmt,
                qRecOrderDO.custId,
                qRecOrderDO.custCode,
                qRecOrderDO.custName,
                qRecOrderDO.buId,
                qRecOrderDO.buCode,
                qRecOrderDO.buName,
                qRecOrderDO.recOuCode,
                qRecOrderDO.recOuId,
                qRecOrderDO.recOuName,
                qRecOrderDO.orgCode,
                qRecOrderDO.orgId,
                qRecOrderDO.orgName,
                qRecOrderDO.taxAmt,
                qRecOrderDO.recOrderType,
                qRecOrderDO.saleUserId,
                qRecOrderDO.saleUser,
                qRecOrderDO.creator,
                qRecOrderDO.remark,
                qRecOrderDO.createUserId,
                qRecOrderDO.taxCurAmt,
                qRecOrderDO.createTime,
                qRecOrderDO.modifyTime,
                qRecOrderDO.updater,
                qRecOrderDO.auditDataVersion,
                qRecOrderDO.procInstId,
                qRecOrderDO.procInstStatus,
                qRecOrderDO.approvedTime,
                qRecOrderDO.submitTime,
                qRecOrderDO.addrNo,
                qRecOrderDO.suppAddrNo,
                qRecOrderDO.docType,
                qRecOrderDO.docType2,
                qRecOrderDO.workflowProcInstId,
                qRecOrderDO.workflowProcInstStatus,
                Q_REC_ORDER_FILE_DO.applyFile,
                qRecOrderDO.docCls,
                qRecOrderDO.redState,
                qRecOrderDO.redSourceId,
                qRecOrderDO.redSourceNo,
                qRecOrderDO.proposedStatus,
                qRecOrderDO.inOutCust,
                qRecOrderDO.relevanceOuCode,
                qRecOrderDO.custType2,
                qRecOrderDO.extensionInfo)

        ).from(qRecOrderDO).leftJoin(Q_REC_ORDER_FILE_DO).on(qRecOrderDO.id.eq(Q_REC_ORDER_FILE_DO.masId));
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderDO)
                .set(qRecOrderDO.procInstStatus, ProcInstStatus.APPROVING)
                .set(qRecOrderDO.procInstId, processInfo.getProcInstId())
                .set(qRecOrderDO.submitTime, LocalDateTime.now())
                .where(qRecOrderDO.id.eq(id));
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qRecOrderDO.procInstStatus, ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }

    public void setNullRedFlag(Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderDO).setNull(qRecOrderDO.redState)
                .where(qRecOrderDO.id.eq(id));
        jpaUpdateClause.execute();
    }

    public void setRedFlag(Long id, Boolean flag) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderDO).set(qRecOrderDO.redState, flag)
                .where(qRecOrderDO.id.eq(id));
        jpaUpdateClause.execute();
    }

    public PagingVO<RecOrderEntity> defaultExport(RecOrderPageParam param) {
        var predicates = new ArrayList<Predicate>();
        buildPredicates(param, null, predicates);
        pageWhere(param, predicates);
        if (StringUtils.isNotBlank(param.getSourceNoDtl())) {
            var recOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;
            predicates.add(qRecOrderDO.id.in(
                    jpaQueryFactory
                            .select(recOrderDtlDO.masId)
                            .from(recOrderDtlDO)
                            .where(recOrderDtlDO.sourceNo.like("%" + param.getSourceNoDtl() + "%"))
                            .groupBy(recOrderDtlDO.masId)
            ));
        }
        var query = jpaQueryFactory.select(Projections.bean(
                        RecOrderEntity.class,
                        qRecOrderDO.sourceNo,
                        qRecOrderDO.ouCode,
                        qRecOrderDO.ouName,
                        qRecOrderDO.arTypeName,
                        qRecOrderDO.arTypeCode,
                        qRecOrderDO.recTypeCode,
                        qRecOrderDO.recTypeName,
                        qRecOrderDO.recOrderNo,
                        qRecOrderDO.currCode,
                        qRecOrderDO.currName,
                        qRecOrderDO.localCurrCode,
                        qRecOrderDO.localCurrName,
                        qRecOrderDO.totalAmt,
                        qRecOrderDO.totalCurAmt,
                        qRecOrderDO.auditUserId,
                        qRecOrderDO.auditUser,
                        qRecOrderDO.auditDate,
                        qRecOrderDO.orderState,
                        qRecOrderDO.exchangeRate,
                        qRecOrderDO.initFlag,
                        qRecOrderDO.realRecAmt,
                        qRecOrderDO.realRecCurAmt,
                        qRecOrderDO.reDate,
                        qRecOrderDO.reFlag,
                        qRecOrderDO.auditRejection,
                        qRecOrderDO.createMode,
                        qRecOrderDO.verState,
                        qRecOrderDO.verAmt,
                        qRecOrderDO.custId,
                        qRecOrderDO.custCode,
                        qRecOrderDO.custName,
                        qRecOrderDO.buCode,
                        qRecOrderDO.buName,
                        qRecOrderDO.recOuCode,
                        qRecOrderDO.recOuName,
                        qRecOrderDO.orgCode,
                        qRecOrderDO.orgName,
                        qRecOrderDO.taxAmt,
                        qRecOrderDO.recOrderType,
                        qRecOrderDO.saleUser,
                        qRecOrderDO.creator,
                        qRecOrderDO.remark,
                        qRecOrderDO.taxCurAmt,
                        qRecOrderDO.createTime,
                        qRecOrderDO.modifyTime,
                        qRecOrderDO.updater,
                        qRecOrderDO.auditDataVersion,
                        qRecOrderDO.procInstStatus,
                        qRecOrderDO.approvedTime,
                        qRecOrderDO.submitTime,
                        qRecOrderDO.addrNo,
                        qRecOrderDO.suppAddrNo,
                        qRecOrderDO.docType,
                        qRecOrderDO.docType2,
                        Q_REC_ORDER_FILE_DO.applyFile,
                        qRecOrderDO.docCls,
                        qRecOrderDO.redState,
                        qRecOrderDO.redSourceNo,
                        qRecOrderDO.proposedStatus,
                        qRecOrderDO.totalAmt.subtract(qRecOrderDO.verAmt).as("unVerAmt"),
                        qRecOrderDO.extensionInfo
                ))
                .from(qRecOrderDO)
                .leftJoin(Q_REC_ORDER_FILE_DO)
                .on(qRecOrderDO.id.eq(Q_REC_ORDER_FILE_DO.masId))
                .where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, qRecOrderDO);
        param.setPaging(query);
        return new PagingVO<>(
                query.fetchCount(), query.fetch()
        );
    }


    public List<RecOrderDTO> selectInOutCustByRecOrderNo(List<String> recOrderNoList) {
        if (CollectionUtil.isEmpty(recOrderNoList)) {
            return Collections.EMPTY_LIST;
        }
        List<RecOrderDTO> recOrderDTOList = jpaQueryFactory.select(
                        Projections.bean(RecOrderDTO.class,
                                qRecOrderDO.recOrderNo,
                                qRecOrderDO.inOutCust,
                                qRecOrderDO.relevanceOuCode))
                .from(qRecOrderDO)
                .where(qRecOrderDO.recOrderNo.in(recOrderNoList))
                .fetch();

        return recOrderDTOList;
    }

    public void updateVerState(String verState, Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderDO)
                .set(qRecOrderDO.verState, verState)
                .where(qRecOrderDO.id.eq(id));
        jpaUpdateClause.execute();
    }


    public Long countExportRecOrder(RecOrderPageParam param) {
        var jpaQuery = jpaQueryFactory.select(qRecOrderDtlDO.count()).from(qRecOrderDtlDO)
                .leftJoin(qRecOrderDO).on(qRecOrderDtlDO.masId.eq(qRecOrderDO.id));
        List<Predicate> predicates = new ArrayList<>();
        pageWhere(param, predicates);
        buildPredicates(param, null, predicates);
        if (StrUtil.isNotBlank(param.getSourceNoDtl())) {
            predicates.add(qRecOrderDtlDO.sourceNo.eq(param.getSourceNoDtl()));
        }
        if (CollUtil.isNotEmpty(param.getDtlSourceNoList())) {
            predicates.add(qRecOrderDtlDO.sourceNo.in(param.getDtlSourceNoList()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetchCount();
    }

    public List<RecOrderEntity> exportRecOrder(RecOrderPageParam param) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        RecOrderEntity.class,
                        qRecOrderDO.id,
                        qRecOrderDO.sourceNo,
                        qRecOrderDO.ouCode,
                        qRecOrderDO.ouId,
                        qRecOrderDO.ouName,
                        qRecOrderDO.arTypeName,
                        qRecOrderDO.arTypeCode,
                        qRecOrderDO.recTypeCode,
                        qRecOrderDO.recTypeName,
                        qRecOrderDO.recOrderNo,
                        qRecOrderDO.currCode,
                        qRecOrderDO.currName,
                        qRecOrderDO.totalAmt,
                        qRecOrderDO.totalCurAmt,
                        qRecOrderDO.auditUserId,
                        qRecOrderDO.auditUser,
                        qRecOrderDO.auditDate,
                        qRecOrderDO.orderState,
                        qRecOrderDO.exchangeRate,
                        qRecOrderDO.initFlag,
                        qRecOrderDO.realRecAmt,
                        qRecOrderDO.reDate,
                        qRecOrderDO.reFlag,
                        qRecOrderDO.createMode,
                        qRecOrderDO.verState,
                        qRecOrderDO.verAmt,
                        qRecOrderDO.custCode,
                        qRecOrderDO.custName,
                        qRecOrderDO.buCode,
                        qRecOrderDO.buName,
                        qRecOrderDO.recOuCode,
                        qRecOrderDO.recOuName,
                        qRecOrderDO.orgCode,
                        qRecOrderDO.orgName,
                        qRecOrderDO.taxAmt,
                        qRecOrderDO.recOrderType,
                        qRecOrderDO.saleUser,
                        qRecOrderDO.creator,
                        qRecOrderDO.remark,
                        qRecOrderDO.taxCurAmt,
                        qRecOrderDO.createTime,
                        qRecOrderDO.modifyTime,
                        qRecOrderDO.updater,
                        qRecOrderDO.procInstStatus,
                        qRecOrderDO.approvedTime,
                        qRecOrderDO.submitTime,
                        qRecOrderDO.docType,
                        qRecOrderDO.docCls,
                        qRecOrderDO.redState,
                        qRecOrderDO.redSourceNo,
                        qRecOrderDO.proposedStatus,
                        qRecOrderDO.inOutCust,
                        qRecOrderDO.relevanceOuCode,
                        qRecOrderDO.custType2,
                        qRecOrderDtlDO.sourceNo.as("detailSourceNo"),
                        qRecOrderDtlDO.sourceLine,
                        qRecOrderDtlDO.recKind,
                        qRecOrderDtlDO.recType,
                        qRecOrderDtlDO.recAccount,
                        qRecOrderDtlDO.es16,
                        qRecOrderDtlDO.es17,
                        qRecOrderDtlDO.recBank,
                        qRecOrderDtlDO.recAccount,
                        qRecOrderDtlDO.totalAmt.as("detailTotalAmt"),
                        qRecOrderDtlDO.realRecAmt.as("detailRealRecAmt"),
                        qRecOrderDtlDO.verAmt,
                        qRecOrderDtlDO.unVerAmt,
                        qRecOrderDtlDO.applyVerAmTing
                )).from(qRecOrderDtlDO)
                .leftJoin(qRecOrderDO).on(qRecOrderDtlDO.masId.eq(qRecOrderDO.id));
        List<Predicate> predicates = new ArrayList<>();
        pageWhere(param, predicates);
        buildPredicates(param, null, predicates);
        if (StrUtil.isNotBlank(param.getSourceNoDtl())) {
            predicates.add(qRecOrderDtlDO.sourceNo.eq(param.getSourceNoDtl()));
        }
        if (CollUtil.isNotEmpty(param.getDtlSourceNoList())) {
            predicates.add(qRecOrderDtlDO.sourceNo.in(param.getDtlSourceNoList()));
        }
        param.setPaging(jpaQuery);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        jpaQuery.orderBy(qRecOrderDO.id.desc(), qRecOrderDtlDO.id.desc());
        return jpaQuery.fetch();
    }

}
