/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAccEngDetConditionConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccEngDetDataConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccEngDetDataLineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccountEngineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccountEngineDetailsConvert;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccEngDetConditionParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccEngDetDataLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccEngDetDataParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineDetailsParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetConditionVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetDataLineVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetDataVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineDetailsVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleValueVO;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineJdbcService;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineService;
import com.elitesland.fin.application.service.accountingengine.FinFlexibleValueService;
import com.elitesland.fin.application.service.accountingengine.FinJournalLogService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetConditionDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetDataDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetDataLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDetailsDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookLineDO;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetConditionRepo;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetDataLineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetDataRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineDetailsRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineRepoProc;
import com.elitesland.fin.repo.accountingengine.FinEventTableConditionRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableLineRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import com.elitesland.fin.repo.accountingengine.FinJournalLogRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookOuRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepoProc;
import com.elitesland.fin.repo.accountingengine.FinSobAccountPeriodRepo;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinAccountEngineServiceImpl
implements FinAccountEngineService {
    private static final Logger log = LoggerFactory.getLogger(FinAccountEngineServiceImpl.class);
    private final FinAccountEngineRepo finAccountEngineRepo;
    private final FinAccountEngineRepoProc finAccountEngineRepoProc;
    private final FinAccountEngineDetailsRepo finAccountEngineDetailsRepo;
    private final FinAccEngDetConditionRepo finAccEngDetConditionRepo;
    private final FinAccEngDetDataRepo finAccEngDetDataRepo;
    private final FinAccEngDetDataLineRepo finAccEngDetDataLineRepo;
    private final FinEventTableRepo finEventTableRepo;
    private final FinEventTableLineRepo finEventTableLineRepo;
    private final FinEventTableConditionRepo finEventTableConditionRepo;
    private final FinJournalLogService finJournalLogService;
    private final FinJournalLogRepo finJournalLogRepo;
    private final FinSetOfBookOuRepo finSetOfBookOuRepo;
    private final FinSetOfBookRepo finSetOfBookRepo;
    private final FinSetOfBookRepoProc finSetOfBookRepoProc;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;
    private final FinFastCodeRepo finFastCodeRepo;
    private final FinFastCodeLineRepo finFastCodeLineRepo;
    private final FinFastCodeLineRepoProc finFastCodeLineRepoProc;
    private final FinFastCodeRepoProc finFastCodeRepoProc;
    private final FinFlexibleRepo finFlexibleRepo;
    private final FinFlexibleRepoProc finFlexibleRepoProc;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;
    private final FinSobAccountPeriodRepo finSobAccountPeriodRepo;
    private final FinJournalRepo finJournalRepo;
    private final UdcProvider udcProvider;
    private final TenantClientProvider tenantClientProvider;
    private final FinAccountEngineJdbcService finAccountEngineJdbcService;
    private final FinFlexibleValueService finFlexibleValueService;

    @Override
    @SysCodeProc
    public PagingVO<FinAccountEngineVO> page(FinAccountEngineParam finAccountEngineParam) {
        return FinAccountEngineConvert.INSTANCE.DTOToVO(this.finAccountEngineRepoProc.page(finAccountEngineParam));
    }

    @Override
    @SysCodeProc
    public FinAccountEngineVO queryFinAccountEngineDetails(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getId(), (String)"\u4e3b\u8868id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional optional = this.finAccountEngineRepo.findById(param.getId());
        Assert.isTrue((boolean)optional.isPresent(), (String)"\u67e5\u8be2\u7684\u4f1a\u8ba1\u5f15\u64ce\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        FinAccountEngineVO engineVO = FinAccountEngineConvert.INSTANCE.DOToVo((FinAccountEngineDO)optional.get());
        List<FinAccountEngineDetailsDO> detailsDOList = this.finAccountEngineDetailsRepo.findAllByMasIdIn(List.of(param.getId()));
        List<FinAccountEngineDetailsVO> detailsVOList = FinAccountEngineDetailsConvert.INSTANCE.DOsToVOs(detailsDOList);
        engineVO.setFinAccountEngineDetails(detailsVOList);
        return engineVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableOrDisable(FinAccountEngineParam finAccountEngineParam) {
        this.checkEnableOrDisableParam(finAccountEngineParam);
        List finAccountEngineDOList = this.finAccountEngineRepo.findAllById(finAccountEngineParam.getIds());
        finAccountEngineDOList.stream().forEach(item -> Assert.isFalse((boolean)finAccountEngineParam.getStatus().equals(item.getStatus()), (String)"\u6570\u636e\u5df2\u7ecf\u542f\u7528/\u7981\u7528", (Object[])new Object[0]));
        finAccountEngineDOList.stream().forEach(item -> item.setStatus(finAccountEngineParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notEmpty(finAccountEngineParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateFinAccEngDetCondition(FinAccountEngineDetailsParam param) {
        this.checkSaveOrUpdateFinAccEngDetConditionParam(param);
        FinAccountEngineDetailsDO finAccountEngineDetailsDO = (FinAccountEngineDetailsDO)this.finAccountEngineDetailsRepo.save(FinAccountEngineDetailsConvert.INSTANCE.paramToDO(param));
        this.finAccEngDetConditionRepo.deleteAllByMasId(finAccountEngineDetailsDO.getId());
        List<FinAccEngDetConditionParam> finAccEngDetConditionParamList = param.getFinAccEngDetConditionDetailList();
        finAccEngDetConditionParamList.stream().forEach(item -> item.setMasId(finAccountEngineDetailsDO.getId()));
        this.finAccEngDetConditionRepo.saveAll(FinAccEngDetConditionConvert.INSTANCE.paramToDO(finAccEngDetConditionParamList));
        return finAccountEngineDetailsDO.getId();
    }

    @Override
    public Long saveOrUpdateFinAccEngDetDataLine(FinAccEngDetDataParam finAccEngDetDataParam) {
        this.finAccEngDetDataLineRepo.deleteAllByMasId(finAccEngDetDataParam.getId());
        List<FinAccEngDetDataLineParam> finAccEngDetDataLineList = finAccEngDetDataParam.getFinAccEngDetDataLineList();
        finAccEngDetDataLineList.stream().forEach(item -> item.setMasId(finAccEngDetDataParam.getId()));
        this.finAccEngDetDataLineRepo.saveAll(FinAccEngDetDataLineConvert.INSTANCE.param2DO(finAccEngDetDataLineList));
        return finAccEngDetDataParam.getId();
    }

    @Override
    public Long saveOrUpdateFinAccEngDetData(FinAccountEngineDetailsParam finAccountEngineDetailsParam) {
        this.checkSaveOrUpdateFinAccEngDetDataParam(finAccountEngineDetailsParam);
        List<FinAccEngDetDataDO> finAccEngDetDataDOList = this.finAccEngDetDataRepo.findAllByMasId(finAccountEngineDetailsParam.getId());
        List<FinAccEngDetDataParam> finAccEngDetDataParamList = finAccountEngineDetailsParam.getFinAccEngDetDataDetailList();
        List ids = finAccEngDetDataDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<Long> deleteIds = finAccEngDetDataParamList.stream().filter(item -> item.getId() != null && !ids.contains(item.getId())).map(BaseModelParam::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteIds)) {
            this.finAccEngDetDataRepo.deleteByIdIn(deleteIds);
        }
        finAccEngDetDataParamList.stream().forEach(item -> item.setMasId(finAccountEngineDetailsParam.getId()));
        this.finAccEngDetDataRepo.saveAll(FinAccEngDetDataConvert.INSTANCE.param2DO(finAccEngDetDataParamList));
        return finAccountEngineDetailsParam.getId();
    }

    private void checkSaveOrUpdateFinAccEngDetDataParam(FinAccountEngineDetailsParam finAccountEngineDetailsParam) {
        Assert.notNull((Object)finAccountEngineDetailsParam.getId(), (String)"\u4e3b\u8868id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<FinAccEngDetDataParam> finAccEngDetDataDetailList = finAccountEngineDetailsParam.getFinAccEngDetDataDetailList();
        Assert.notEmpty(finAccEngDetDataDetailList, (String)"\u6570\u636e\u884c\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        finAccEngDetDataDetailList.stream().forEach(item -> {});
    }

    private void checkSaveOrUpdateFinAccEngDetConditionParam(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getId(), (String)"\u4e3b\u8868id\u5fc5\u586b", (Object[])new Object[0]);
        List<FinAccEngDetConditionParam> finAccEngDetConditionParamList = param.getFinAccEngDetConditionDetailList();
        Assert.notEmpty(finAccEngDetConditionParamList, (String)"\u4f1a\u8ba1\u5f15\u64ce\u6761\u4ef6\u5fc5\u586b", (Object[])new Object[0]);
        HashSet serialNums = new HashSet();
        finAccEngDetConditionParamList.stream().forEach(item -> {
            Assert.notNull((Object)item.getSerialNum(), (String)"\u5e8f\u53f7\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getColumnName(), (String)"\u5b57\u6bb5\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getConditionType(), (String)"\u6761\u4ef6\u5fc5\u586b", (Object[])new Object[0]);
            Assert.isFalse((boolean)serialNums.contains(item.getSerialNum()), (String)"\u5e8f\u53f7\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            serialNums.add(item.getSerialNum());
        });
    }

    private void checkFinAccountEngineDetailsParam(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getSerialNum(), (String)"\u5e8f\u53f7\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getAccountEngine(), (String)"\u4f1a\u8ba1\u5f15\u64ce\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getActiveFlag(), (String)"\u662f\u5426\u542f\u7528\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @SysCodeProc(isRecursion=true)
    public FinAccountEngineVO queryFinAccountEngine(FinAccountEngineParam finAccountEngineParam) {
        FinAccountEngineDO finAccountEngineDO = this.finAccountEngineRepoProc.findById(finAccountEngineParam.getId());
        FinAccountEngineVO finAccountEngineVO = FinAccountEngineConvert.INSTANCE.DOToVo(finAccountEngineDO);
        List<FinAccountEngineDetailsDO> finAccountEngineDetailsDOList = this.finAccountEngineDetailsRepo.findAllByMasId(finAccountEngineVO.getId());
        List<FinAccountEngineDetailsVO> finAccountEngineDetailsVOList = FinAccountEngineDetailsConvert.INSTANCE.DOsToVOs(finAccountEngineDetailsDOList);
        if (CollectionUtils.isNotEmpty(finAccountEngineDetailsVOList)) {
            finAccountEngineDetailsVOList.stream().forEach(v -> {
                if (v.getSerialNum() == null) {
                    v.setSerialNum(0);
                }
            });
            Collections.sort(finAccountEngineDetailsVOList, new Comparator<FinAccountEngineDetailsVO>(){

                @Override
                public int compare(FinAccountEngineDetailsVO o1, FinAccountEngineDetailsVO o2) {
                    return o2.getSerialNum().compareTo(o1.getSerialNum());
                }
            });
        }
        finAccountEngineVO.setFinAccountEngineDetails(finAccountEngineDetailsVOList);
        List<Long> finAccountEngineDetailsIds = finAccountEngineDetailsVOList.stream().map(BaseModelVO::getId).collect(Collectors.toList());
        List<FinAccEngDetConditionDO> finAccEngDetConditionDOList = this.finAccEngDetConditionRepo.findAllByMasIdIn(finAccountEngineDetailsIds);
        List<FinAccEngDetConditionVO> finAccEngDetConditionVOList = FinAccEngDetConditionConvert.INSTANCE.DOsToVos(finAccEngDetConditionDOList);
        List<FinAccEngDetDataDO> finAccEngDetDataDOList = this.finAccEngDetDataRepo.findAllByMasIdIn(finAccountEngineDetailsIds);
        List<FinAccEngDetDataVO> finAccEngDetDataVOList = FinAccEngDetDataConvert.INSTANCE.DOsToVOs(finAccEngDetDataDOList);
        finAccountEngineDetailsVOList.stream().forEach(item -> {
            item.setFinAccEngDetConditionDetailList(finAccEngDetConditionVOList.stream().filter(e -> item.getId().equals(e.getMasId())).collect(Collectors.toList()));
            item.setFinAccEngDetDataDetailList(finAccEngDetDataVOList.stream().filter(e -> item.getId().equals(e.getMasId())).collect(Collectors.toList()));
        });
        List<Long> finAccEngDetDataVOIds = finAccountEngineDetailsVOList.stream().flatMap(item -> item.getFinAccEngDetDataDetailList().stream().map(BaseModelVO::getId)).collect(Collectors.toList());
        List<FinAccEngDetDataLineDO> finAccEngDetDataLineDOList = this.finAccEngDetDataLineRepo.findAllByMasIdIn(finAccEngDetDataVOIds);
        List<FinAccEngDetDataLineVO> finAccEngDetDataLineVOList = FinAccEngDetDataLineConvert.INSTANCE.DOsToVOS(finAccEngDetDataLineDOList);
        List<String> sobCodes = finAccEngDetDataDOList.stream().map(FinAccEngDetDataDO::getSobCode).collect(Collectors.toList());
        List<FinSetOfBookDO> finSetOfBookDOList = this.finSetOfBookRepo.findAllBySobCodeInAndStatus(sobCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<Long> finSetOfBookDOIds = finSetOfBookDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        Map<Object, Object> setOfBookLineMap = new HashMap();
        List<FinSetOfBookLineDO> finSetOfBookLineDOList = this.finSetOfBookLineRepo.findAllByMasIdIn(finSetOfBookDOIds);
        if (CollectionUtils.isNotEmpty(finSetOfBookLineDOList)) {
            Map masFinSetOfBookLineMap = finSetOfBookLineDOList.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
            setOfBookLineMap = finSetOfBookDOList.stream().collect(Collectors.toMap(v -> v.getSobCode(), v -> masFinSetOfBookLineMap.get(v.getId()) != null ? ((List)masFinSetOfBookLineMap.get(v.getId())).stream().collect(Collectors.toMap(w -> w.getColumnName(), w -> w, (o, n) -> n)) : new HashMap()));
        }
        HashMap finalSetOfBookLineMap = setOfBookLineMap;
        FinFlexibleValueParam finFlexibleValueParam = new FinFlexibleValueParam();
        finFlexibleValueParam.setSobCodes(sobCodes);
        Map<String, Map<String, FinFlexibleValueVO>> flexCodeValueMap = this.finFlexibleValueService.listBySetOfBook(finFlexibleValueParam);
        finAccountEngineDetailsVOList.stream().forEach(item -> item.getFinAccEngDetDataDetailList().stream().forEach(e -> {
            e.setFinAccEngDetDataLineList(finAccEngDetDataLineVOList.stream().filter(v -> e.getId().equals(v.getMasId())).collect(Collectors.toList()));
            String sobCode = e.getSobCode();
            for (FinAccEngDetDataLineVO finAccEngDetDataLineVO : e.getFinAccEngDetDataLineList()) {
                FinFlexibleValueVO finFlexibleValueVO;
                String flexibleCode;
                Map flexibleValueDOMap;
                String columnName;
                FinSetOfBookLineDO finSetOfBookLineDO;
                Map finSetOfBookLineDOMap = (Map)finalSetOfBookLineMap.get(sobCode);
                if (finSetOfBookLineDOMap == null || (finSetOfBookLineDO = (FinSetOfBookLineDO)finSetOfBookLineDOMap.get(columnName = finAccEngDetDataLineVO.getColumnName())) == null || !Boolean.TRUE.equals(finSetOfBookLineDO.getFlexibleFlag()) || (flexibleValueDOMap = (Map)flexCodeValueMap.get(flexibleCode = finSetOfBookLineDO.getFlexibleCode())) == null || (finFlexibleValueVO = (FinFlexibleValueVO)flexibleValueDOMap.get(finAccEngDetDataLineVO.getFlexibleCode())) == null) continue;
                finAccEngDetDataLineVO.setFlexibleValueName(finFlexibleValueVO.getFlexibleValueName());
            }
        }));
        Map eventTableConditionUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getModel(), UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getCode());
        Map sourceTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.SOURCE_TYPE_ACCOUNT_PERIOD.getModel(), UdcEnum.SOURCE_TYPE_ACCOUNT_PERIOD.getCode());
        Map fastCodeOutputUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACC_ENG_FAST_CODE_OUTPUT_ONE.getModel(), UdcEnum.ACC_ENG_FAST_CODE_OUTPUT_ONE.getCode());
        List<FinAccountEngineDetailsVO> finAccountEngineDetails = finAccountEngineVO.getFinAccountEngineDetails();
        if (CollectionUtils.isNotEmpty(finAccountEngineDetails)) {
            finAccountEngineDetails.stream().forEach(item -> {
                List<FinAccEngDetDataVO> finAccEngDetDataDetailList;
                List<FinAccEngDetConditionVO> finAccEngDetConditionDetailList = item.getFinAccEngDetConditionDetailList();
                if (CollectionUtils.isNotEmpty(finAccEngDetConditionDetailList)) {
                    finAccEngDetConditionDetailList.stream().forEach(e -> e.setConditionTypeName((String)eventTableConditionUdc.get(e.getConditionType())));
                }
                if (CollectionUtils.isNotEmpty(finAccEngDetDataDetailList = item.getFinAccEngDetDataDetailList())) {
                    finAccEngDetDataDetailList.stream().forEach(e -> {
                        List<FinAccEngDetDataLineVO> finAccEngDetDataLineList = e.getFinAccEngDetDataLineList();
                        if (CollectionUtils.isNotEmpty(finAccEngDetDataLineList)) {
                            finAccEngDetDataLineList.stream().forEach(v -> {
                                v.setSourceTypeName((String)sourceTypeUdc.get(v.getSourceType()));
                                v.setOutputColumnName((String)fastCodeOutputUdc.get(v.getOutputColumn()));
                            });
                        }
                    });
                }
            });
        }
        ArrayList<Long> eventTableIds = new ArrayList<Long>();
        eventTableIds.add(finAccountEngineVO.getEventTableId());
        List<FinEventTableDO> eventTableDOS = this.finEventTableRepo.findAllByIdInAndStatus(eventTableIds, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        if (CollectionUtils.isNotEmpty(eventTableDOS)) {
            finAccountEngineVO.setEventTables(Arrays.asList(eventTableDOS.get(0).getMasTable(), eventTableDOS.get(0).getTableName()));
        }
        return finAccountEngineVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(FinAccountEngineParam finAccountEngineParam) {
        List<FinAccountEngineDetailsDO> finAccountEngineDetailsDOList;
        List<Long> finAccountEngineDetailIds;
        this.checkSaveOrUpdateParam(finAccountEngineParam);
        boolean add = finAccountEngineParam.getId() == null;
        this.checkEngineUnique(finAccountEngineParam, add);
        FinAccountEngineDO finAccountEngineDO = (FinAccountEngineDO)this.finAccountEngineRepo.save(FinAccountEngineConvert.INSTANCE.paramToDO(finAccountEngineParam));
        if (!add && CollectionUtils.isNotEmpty(finAccountEngineDetailIds = (finAccountEngineDetailsDOList = this.finAccountEngineDetailsRepo.findAllByMasId(finAccountEngineParam.getId())).stream().map(BaseModel::getId).collect(Collectors.toList()))) {
            this.finAccEngDetConditionRepo.deleteByMasIdIn(finAccountEngineDetailIds);
            List<FinAccEngDetDataDO> finAccEngDetDataIds = this.finAccEngDetDataRepo.findAllByMasIdIn(finAccountEngineDetailIds);
            List<Long> collect = finAccEngDetDataIds.stream().map(BaseModel::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                this.finAccEngDetDataLineRepo.deleteByMasIdIn(collect);
            }
            this.finAccEngDetDataRepo.deleteByMasIdIn(finAccountEngineDetailIds);
            this.finAccountEngineDetailsRepo.deleteByIdIn(finAccountEngineDetailIds);
        }
        List<FinAccountEngineDetailsParam> finAccountEngineDetailsParamList = finAccountEngineParam.getFinAccountEngineDetails();
        finAccountEngineDetailsParamList.stream().forEach(item -> item.setMasId(finAccountEngineDO.getId()));
        List finAccountEngineDetailsDOList2 = this.finAccountEngineDetailsRepo.saveAll(FinAccountEngineDetailsConvert.INSTANCE.paramToDO(finAccountEngineDetailsParamList));
        finAccountEngineDetailsParamList.stream().forEach(item -> {
            FinAccountEngineDetailsDO result = finAccountEngineDetailsDOList2.stream().filter(e -> e.getSerialNum().equals(item.getSerialNum())).findFirst().orElse(null);
            List<FinAccEngDetConditionParam> finAccEngDetConditionDetailList = item.getFinAccEngDetConditionDetailList();
            finAccEngDetConditionDetailList.stream().forEach(e -> e.setMasId(result.getId()));
            List<FinAccEngDetDataParam> finAccEngDetDataDetailList = item.getFinAccEngDetDataDetailList();
            finAccEngDetDataDetailList.stream().forEach(e -> e.setMasId(result.getId()));
        });
        List<FinAccEngDetConditionParam> finAccEngDetConditionParamList = finAccountEngineDetailsParamList.stream().flatMap(item -> item.getFinAccEngDetConditionDetailList().stream()).collect(Collectors.toList());
        this.finAccEngDetConditionRepo.saveAll(FinAccEngDetConditionConvert.INSTANCE.paramToDO(finAccEngDetConditionParamList));
        List<FinAccEngDetDataParam> finAccEngDetDataParamList = finAccountEngineDetailsParamList.stream().flatMap(item -> item.getFinAccEngDetDataDetailList().stream()).collect(Collectors.toList());
        List finAccEngDetDataDOS = this.finAccEngDetDataRepo.saveAll(FinAccEngDetDataConvert.INSTANCE.param2DO(finAccEngDetDataParamList));
        finAccountEngineDetailsParamList.stream().forEach(item -> {
            FinAccountEngineDetailsDO result = finAccountEngineDetailsDOList2.stream().filter(e -> e.getSerialNum().equals(item.getSerialNum())).findFirst().orElse(null);
            List<FinAccEngDetDataParam> finAccEngDetDataDetailList = item.getFinAccEngDetDataDetailList();
            finAccEngDetDataDetailList.stream().forEach(item_detData -> {
                FinAccEngDetDataDO result_detData = finAccEngDetDataDOS.stream().filter(e -> e.getMasId().equals(result.getId()) && e.getSerialNum().equals(item_detData.getSerialNum())).findFirst().orElse(null);
                List<FinAccEngDetDataLineParam> finAccEngDetDataLineList = item_detData.getFinAccEngDetDataLineList();
                finAccEngDetDataLineList.stream().forEach(e -> e.setMasId(result_detData.getId()));
            });
        });
        List<FinAccEngDetDataLineParam> finAccEngDetDataLineList = finAccEngDetDataParamList.stream().flatMap(item -> item.getFinAccEngDetDataLineList().stream()).collect(Collectors.toList());
        this.finAccEngDetDataLineRepo.saveAll(FinAccEngDetDataLineConvert.INSTANCE.param2DO(finAccEngDetDataLineList));
        return finAccountEngineDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateFinAccountEngineDetail(FinAccountEngineParam finAccountEngineParam) {
        this.checkSaveOrUpdateFinAccountEngineDetailParam(finAccountEngineParam);
        this.checkIdempotent(finAccountEngineParam);
        List<FinAccountEngineDetailsDO> finAccountEngineDetailsDOList = this.finAccountEngineDetailsRepo.findAllByMasId(finAccountEngineParam.getId());
        List<FinAccountEngineDetailsParam> finAccountEngineDetailsParamList = finAccountEngineParam.getFinAccountEngineDetails();
        List ids = finAccountEngineDetailsDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<Long> deleteIds = finAccountEngineDetailsParamList.stream().filter(item -> item.getId() != null && !ids.contains(item.getId())).map(BaseModelParam::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteIds)) {
            this.finAccountEngineDetailsRepo.deleteByIdIn(deleteIds);
        }
        finAccountEngineDetailsParamList.stream().forEach(item -> item.setMasId(finAccountEngineParam.getId()));
        this.finAccountEngineDetailsRepo.saveAll(FinAccountEngineDetailsConvert.INSTANCE.paramToDO(finAccountEngineDetailsParamList));
        return finAccountEngineParam.getId();
    }

    private void checkSaveOrUpdateFinAccountEngineDetailParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notNull((Object)finAccountEngineParam.getId(), (String)"\u4e3b\u8868id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<FinAccountEngineDetailsParam> finAccountEngineDetailsParamList = finAccountEngineParam.getFinAccountEngineDetails();
        Assert.notEmpty(finAccountEngineDetailsParamList, (String)"\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\u5fc5\u586b", (Object[])new Object[0]);
        HashSet serialNums = new HashSet();
        finAccountEngineDetailsParamList.stream().forEach(item -> {
            this.checkFinAccountEngineDetailsParam((FinAccountEngineDetailsParam)((Object)item));
            Assert.isFalse((boolean)serialNums.contains(item.getSerialNum()), (String)"\u5e8f\u53f7\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            serialNums.add(item.getSerialNum());
        });
    }

    private void checkSaveOrUpdateParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notNull((Object)finAccountEngineParam.getEventTableId(), (String)"\u4e8b\u4ef6\u8868\u5355ID\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getColumnCompany(), (String)"\u516c\u53f8\u5b57\u6bb5\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalHost(), (String)"\u4e3b\u673a\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalPort(), (String)"\u7aef\u53e3\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalUser(), (String)"\u7528\u6237\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalPassword(), (String)"\u5bc6\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalDatabase(), (String)"\u6570\u636e\u5e93\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalTable(), (String)"\u4e3b\u8868\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty(finAccountEngineParam.getFinAccountEngineDetails(), (String)"\u4f1a\u8ba1\u5f15\u64ce\u884c\u660e\u7ec6\u4e3a\u7a7a", (Object[])new Object[0]);
        finAccountEngineParam.getFinAccountEngineDetails().forEach(v -> {
            Assert.notEmpty(v.getFinAccEngDetDataDetailList(), (String)"\u4f1a\u8ba1\u5f15\u64ce\u6570\u636e\u884c\u4e3a\u7a7a", (Object[])new Object[0]);
            v.getFinAccEngDetDataDetailList().forEach(v1 -> Assert.notEmpty(v1.getFinAccEngDetDataLineList(), (String)"\u4f1a\u8ba1\u5f15\u64ce\u6570\u636e\u884c\u6570\u636e\u6620\u5c04\u4e3a\u7a7a", (Object[])new Object[0]));
        });
    }

    private void checkIdempotent(FinAccountEngineParam finAccountEngineParam) {
        FinAccountEngineDO finAccountEngineDO = this.finAccountEngineRepoProc.findByEventTable(finAccountEngineParam.getEventTable());
        if (finAccountEngineDO != null) {
            Assert.equals((Object)finAccountEngineParam.getId(), (Object)finAccountEngineDO.getId(), (String)"\u4e8b\u4ef6\u8868\u5355\u540d\u79f0\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    @Override
    @SysCodeProc
    public List<FinAccEngDetDataLineVO> queryFinAccDetDataLine(FinAccEngDetDataParam param) {
        Assert.notNull((Object)param.getId(), (String)"\u4e3b\u8868id\u5fc5\u586b", (Object[])new Object[0]);
        List<FinAccEngDetDataLineDO> dataLineDOList = this.finAccEngDetDataLineRepo.findAllByMasIdIn(List.of(param.getMasId()));
        List<FinAccEngDetDataLineVO> dataLineVOList = FinAccEngDetDataLineConvert.INSTANCE.DOsToVOS(dataLineDOList);
        return dataLineVOList;
    }

    @Override
    public FinAccountEngineDetailsVO queryFinAccEngDetCondition(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getId(), (String)"masId is not null", (Object[])new Object[0]);
        Optional optional = this.finAccountEngineDetailsRepo.findById(param.getId());
        Assert.isTrue((boolean)optional.isPresent(), (String)"\u8be6\u60c5\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        FinAccountEngineDetailsVO detailsVO = FinAccountEngineDetailsConvert.INSTANCE.DOToVO((FinAccountEngineDetailsDO)optional.get());
        List<FinAccEngDetDataDO> detDataDOList = this.finAccEngDetDataRepo.findAllByMasIdIn(List.of(param.getId()));
        List<FinAccEngDetDataVO> detDataVOList = FinAccEngDetDataConvert.INSTANCE.DOsToVOs(detDataDOList);
        detailsVO.setFinAccEngDetDataDetailList(detDataVOList);
        List<FinAccEngDetConditionDO> conditionDOList = this.finAccEngDetConditionRepo.findAllByMasIdIn(List.of(param.getId()));
        List<FinAccEngDetConditionVO> conditionVOList = FinAccEngDetConditionConvert.INSTANCE.DOsToVos(conditionDOList);
        detailsVO.setFinAccEngDetConditionDetailList(conditionVOList);
        return detailsVO;
    }

    @Override
    public List<FinAccEngDetDataVO> queryFinAccEngDetData(FinAccountEngineDetailsParam finAccountEngineDetailsParam) {
        Assert.notNull((Object)finAccountEngineDetailsParam.getId(), (String)"\u4e3b\u8868id\u5fc5\u586b", (Object[])new Object[0]);
        List<FinAccEngDetDataDO> finAccEngDetDataDOList = this.finAccEngDetDataRepo.findAllByMasId(finAccountEngineDetailsParam.getId());
        return FinAccEngDetDataConvert.INSTANCE.DOsToVOs(finAccEngDetDataDOList);
    }

    @Override
    public List<FinAccEngDetDataLineVO> loadTemplate(FinAccEngDetDataParam finAccEngDetDataParam) {
        this.checkLoadTemplateParam(finAccEngDetDataParam);
        return this.loadTemplateFromDB(finAccEngDetDataParam);
    }

    private List<FinAccEngDetDataLineVO> loadTemplateFromDB(FinAccEngDetDataParam finAccEngDetDataParam) {
        ResultSet resultSet = null;
        Connection connection = null;
        Statement preparedStatement = null;
        ArrayList<FinAccEngDetDataLineVO> finAccEngDetDataLineVOList = new ArrayList<FinAccEngDetDataLineVO>();
        try {
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection(String.format("jdbc:postgresql://%s:%s/%s", finAccEngDetDataParam.getJournalHost(), finAccEngDetDataParam.getJournalPort(), finAccEngDetDataParam.getJournalDatabase()), finAccEngDetDataParam.getJournalUser(), finAccEngDetDataParam.getJournalPassword());
            String sql = "select column_name, data_type, column_key,column_comment,character_maximum_length from information_schema.columns where table_name = '" + finAccEngDetDataParam.getJournalTable() + "' and TABLE_SCHEMA = '" + finAccEngDetDataParam.getJournalDatabase() + "'";
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                FinAccEngDetDataLineVO finAccEngDetDataLineVO = new FinAccEngDetDataLineVO();
                int columnCount = resultSet.getMetaData().getColumnCount();
                if (resultSet.getString("column_name").startsWith("segment")) continue;
                for (int i = 1; i <= columnCount; ++i) {
                    if ("column_name".equals(resultSet.getMetaData().getColumnName(i)) || "COLUMN_NAME".equals(resultSet.getMetaData().getColumnName(i))) {
                        Object columnName = resultSet.getObject(resultSet.getMetaData().getColumnName(i));
                        finAccEngDetDataLineVO.setColumnName(Optional.ofNullable(columnName).map(item -> item.toString()).orElse(null));
                    }
                    if ("data_type".equals(resultSet.getMetaData().getColumnName(i)) || "DATA_TYPE".equals(resultSet.getMetaData().getColumnName(i))) {
                        Object columnType = resultSet.getObject(resultSet.getMetaData().getColumnName(i));
                        finAccEngDetDataLineVO.setColumnType(Optional.ofNullable(columnType).map(item -> item.toString()).orElse(null));
                    }
                    if ("column_comment".equals(resultSet.getMetaData().getColumnName(i)) || "COLUMN_COMMENT".equals(resultSet.getMetaData().getColumnName(i))) {
                        Object columnComment = resultSet.getObject(resultSet.getMetaData().getColumnName(i));
                        finAccEngDetDataLineVO.setColumnComment(Optional.ofNullable(columnComment).map(item -> item.toString()).orElse(null));
                    }
                    if (!"character_maximum_length".equals(resultSet.getMetaData().getColumnName(i)) && !"CHARACTER_MAXIMUM_LENGTH".equals(resultSet.getMetaData().getColumnName(i))) continue;
                    Object columnLength = resultSet.getObject(resultSet.getMetaData().getColumnName(i));
                    finAccEngDetDataLineVO.setColumnLength(Optional.ofNullable(columnLength).map(item -> Integer.valueOf(item.toString())).orElse(null));
                }
                finAccEngDetDataLineVOList.add(finAccEngDetDataLineVO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u5e93\u5b57\u6bb5\u5f02\u5e38");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        FinSetOfBookDO finSetOfBookDO = this.finSetOfBookRepoProc.findBySobCodeAndStatus(finAccEngDetDataParam.getSobCode(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Assert.notNull((Object)finSetOfBookDO, (String)"\u8d26\u5957\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List<FinSetOfBookLineDO> finSetOfBookLineDOList = this.finSetOfBookLineRepo.findAllByMasId(finSetOfBookDO.getId());
        Assert.notEmpty(finSetOfBookLineDOList, (String)"\u8d26\u5957\u660e\u7ec6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        finSetOfBookLineDOList.stream().forEach(item -> {
            FinAccEngDetDataLineVO finAccEngDetDataLineVO = new FinAccEngDetDataLineVO();
            finAccEngDetDataLineVO.setColumnName(item.getColumnName());
            finAccEngDetDataLineVO.setColumnType("varchar");
            finAccEngDetDataLineVO.setColumnComment(item.getAccountDimenName());
            finAccEngDetDataLineVO.setColumnLength(32);
            finAccEngDetDataLineVOList.add(finAccEngDetDataLineVO);
        });
        return finAccEngDetDataLineVOList;
    }

    private void checkLoadTemplateParam(FinAccEngDetDataParam finAccEngDetDataParam) {
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalHost(), (String)"\u4e3b\u673a\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalPort(), (String)"\u7aef\u53e3\u53f7\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalDatabase(), (String)"\u6570\u636e\u5e93\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalUser(), (String)"\u7528\u6237\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalPassword(), (String)"\u5bc6\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalTable(), (String)"\u4e3b\u8868\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getSobCode(), (String)"\u8d26\u5957\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
    }

    private void checkEngineUnique(FinAccountEngineParam finAccountEngineParam, boolean add) {
        List<FinAccountEngineDO> finAccountEngineDOExists = this.finAccountEngineRepo.findAllByEventTableId(finAccountEngineParam.getEventTableId());
        if (CollectionUtils.isNotEmpty(finAccountEngineDOExists)) {
            if (add) {
                throw new BusinessException("\u4e8b\u4ef6\u8868\u5355\uff1a\u3010" + finAccountEngineParam.getEventTable() + "\u3011\u5df2\u88ab\u5176\u4ed6\u4f1a\u8ba1\u5f15\u64ce\u5173\u8054");
            }
            if (finAccountEngineDOExists.size() > 1) {
                throw new BusinessException("\u4e8b\u4ef6\u8868\u5355\uff1a\u3010" + finAccountEngineParam.getEventTable() + "\u3011\u5df2\u88ab\u5176\u4ed6\u4f1a\u8ba1\u5f15\u64ce\u5173\u8054");
            }
            if (!finAccountEngineDOExists.get(0).getId().equals(finAccountEngineParam.getId())) {
                throw new BusinessException("\u4e8b\u4ef6\u8868\u5355\uff1a\u3010" + finAccountEngineParam.getEventTable() + "\u3011\u5df2\u88ab\u5176\u4ed6\u4f1a\u8ba1\u5f15\u64ce\u5173\u8054");
            }
        }
    }

    public FinAccountEngineServiceImpl(FinAccountEngineRepo finAccountEngineRepo, FinAccountEngineRepoProc finAccountEngineRepoProc, FinAccountEngineDetailsRepo finAccountEngineDetailsRepo, FinAccEngDetConditionRepo finAccEngDetConditionRepo, FinAccEngDetDataRepo finAccEngDetDataRepo, FinAccEngDetDataLineRepo finAccEngDetDataLineRepo, FinEventTableRepo finEventTableRepo, FinEventTableLineRepo finEventTableLineRepo, FinEventTableConditionRepo finEventTableConditionRepo, FinJournalLogService finJournalLogService, FinJournalLogRepo finJournalLogRepo, FinSetOfBookOuRepo finSetOfBookOuRepo, FinSetOfBookRepo finSetOfBookRepo, FinSetOfBookRepoProc finSetOfBookRepoProc, FinSetOfBookLineRepo finSetOfBookLineRepo, FinFastCodeRepo finFastCodeRepo, FinFastCodeLineRepo finFastCodeLineRepo, FinFastCodeLineRepoProc finFastCodeLineRepoProc, FinFastCodeRepoProc finFastCodeRepoProc, FinFlexibleRepo finFlexibleRepo, FinFlexibleRepoProc finFlexibleRepoProc, FinFlexibleValueRepo finFlexibleValueRepo, FinFlexibleValueRepoProc finFlexibleValueRepoProc, FinSobAccountPeriodRepo finSobAccountPeriodRepo, FinJournalRepo finJournalRepo, UdcProvider udcProvider, TenantClientProvider tenantClientProvider, FinAccountEngineJdbcService finAccountEngineJdbcService, FinFlexibleValueService finFlexibleValueService) {
        this.finAccountEngineRepo = finAccountEngineRepo;
        this.finAccountEngineRepoProc = finAccountEngineRepoProc;
        this.finAccountEngineDetailsRepo = finAccountEngineDetailsRepo;
        this.finAccEngDetConditionRepo = finAccEngDetConditionRepo;
        this.finAccEngDetDataRepo = finAccEngDetDataRepo;
        this.finAccEngDetDataLineRepo = finAccEngDetDataLineRepo;
        this.finEventTableRepo = finEventTableRepo;
        this.finEventTableLineRepo = finEventTableLineRepo;
        this.finEventTableConditionRepo = finEventTableConditionRepo;
        this.finJournalLogService = finJournalLogService;
        this.finJournalLogRepo = finJournalLogRepo;
        this.finSetOfBookOuRepo = finSetOfBookOuRepo;
        this.finSetOfBookRepo = finSetOfBookRepo;
        this.finSetOfBookRepoProc = finSetOfBookRepoProc;
        this.finSetOfBookLineRepo = finSetOfBookLineRepo;
        this.finFastCodeRepo = finFastCodeRepo;
        this.finFastCodeLineRepo = finFastCodeLineRepo;
        this.finFastCodeLineRepoProc = finFastCodeLineRepoProc;
        this.finFastCodeRepoProc = finFastCodeRepoProc;
        this.finFlexibleRepo = finFlexibleRepo;
        this.finFlexibleRepoProc = finFlexibleRepoProc;
        this.finFlexibleValueRepo = finFlexibleValueRepo;
        this.finFlexibleValueRepoProc = finFlexibleValueRepoProc;
        this.finSobAccountPeriodRepo = finSobAccountPeriodRepo;
        this.finJournalRepo = finJournalRepo;
        this.udcProvider = udcProvider;
        this.tenantClientProvider = tenantClientProvider;
        this.finAccountEngineJdbcService = finAccountEngineJdbcService;
        this.finFlexibleValueService = finFlexibleValueService;
    }
}

