/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.cgorder;

import cn.hutool.core.lang.Assert;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.udc.UdcProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.cgorder.CgOrderConvert;
import com.elitesland.fin.application.convert.picturefile.PictureFileConvert;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderPageParam;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.SaveFlowParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.cgorder.CgOrderVO;
import com.elitesland.fin.application.facade.vo.picturefile.PictureFileVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.cgorder.CgOrderService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.application.service.picturefile.PictureFileService;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.cgorder.CgOrderDO;
import com.elitesland.fin.entity.picturefile.PictureFileDO;
import com.elitesland.fin.repo.cgorder.CgOrderRepo;
import com.elitesland.fin.repo.cgorder.CgOrderRepoProc;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CgOrderServiceImpl
implements CgOrderService {
    @Autowired
    private CgOrderRepo cgOrderRepo;
    @Autowired
    private CgOrderRepoProc cgOrderRepoProc;
    @Autowired
    private PictureFileService pictureFileService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private SysNumberGenerator sysNumberGenerator;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private AccountFlowService accountFlowService;

    @Override
    @SysCodeProc
    public PagingVO<CgOrderVO> page(CgOrderPageParam cgOrderPageParam) {
        Map cgType1 = this.udcProvider.getValueMapByUdcCode("yst-fin", "CHARGE_ORDER_TYPE1");
        Map cgType2 = this.udcProvider.getValueMapByUdcCode("yst-fin", "CHARGE_ORDER_TYPE2");
        PagingVO<CgOrderVO> page = this.cgOrderRepoProc.page(cgOrderPageParam);
        List<Long> sourceIds = page.getRecords().stream().map(BaseModelVO::getId).collect(Collectors.toList());
        Map<Long, List<PictureFileVO>> pitMap = this.pictureFileService.queryBySourceIds(sourceIds).stream().collect(Collectors.groupingBy(PictureFileVO::getSourceId));
        page.getRecords().forEach(vo -> {
            if (pitMap.get(vo.getId()) != null) {
                vo.setPictureFileVOS((List)pitMap.get(vo.getId()));
            }
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)cgType1.get(vo.getCgType())))) {
                vo.setCgTypeName((String)cgType1.get(vo.getCgType()));
            }
            if (StringUtils.isEmpty((CharSequence)vo.getCgTypeName()) && !StringUtils.isEmpty((CharSequence)((CharSequence)cgType2.get(vo.getCgType())))) {
                vo.setCgTypeName((String)cgType2.get(vo.getCgType()));
            }
        });
        return page;
    }

    @Override
    @SysCodeProc
    public CgOrderVO getOne(Long id) {
        Map cgType1 = this.udcProvider.getValueMapByUdcCode("yst-fin", "CHARGE_ORDER_TYPE1");
        Map cgType2 = this.udcProvider.getValueMapByUdcCode("yst-fin", "CHARGE_ORDER_TYPE2");
        CgOrderVO cgOrderVO = this.cgOrderRepoProc.queryById(id);
        List<PictureFileVO> pitList = this.pictureFileService.queryBySourceIds(List.of(id));
        cgOrderVO.setPictureFileVOS(pitList);
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)cgType1.get(cgOrderVO.getCgType())))) {
            cgOrderVO.setCgTypeName((String)cgType1.get(cgOrderVO.getCgType()));
        }
        if (StringUtils.isEmpty((CharSequence)cgOrderVO.getCgTypeName()) && !StringUtils.isEmpty((CharSequence)((CharSequence)cgType2.get(cgOrderVO.getCgType())))) {
            cgOrderVO.setCgTypeName((String)cgType2.get(cgOrderVO.getCgType()));
        }
        return cgOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> approve(List<Long> ids) {
        List<CgOrderVO> cgOrderVO = this.cgOrderRepoProc.queryByIds(ids);
        cgOrderVO.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.APPLY_STATUS_DOING.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u5ba1\u6279!");
            }
        });
        SysUserDTO user = this.getUser();
        this.cgOrderRepoProc.updateByIds(ids, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode(), user);
        if (!CollectionUtils.isEmpty(cgOrderVO)) {
            CgOrderVO cgOrderVO1 = cgOrderVO.get(0);
            SaveFlowParam saveFlowParam = this.VoToFlowParam(cgOrderVO1, "APPROVED");
            this.saveFlow(saveFlowParam);
        }
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> reject(CgOrderParam cgOrderParam) {
        CgOrderVO cgOrderVO1;
        List<CgOrderVO> cgOrderVO = this.cgOrderRepoProc.queryByIds(cgOrderParam.getIds());
        cgOrderVO.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.APPLY_STATUS_DOING.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u62d2\u7edd!");
            }
        });
        SysUserDTO user = this.getUser();
        this.cgOrderRepoProc.updateByReject(cgOrderParam.getIds(), UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode(), user, cgOrderParam.getAuditRejectReason());
        if (!CollectionUtils.isEmpty(cgOrderVO) && (cgOrderVO1 = cgOrderVO.get(0)).getSourceId() != null) {
            CgOrderVO cgOrderVO2 = this.cgOrderRepoProc.queryById(cgOrderVO1.getSourceId());
            BigDecimal unReturnAmt = cgOrderVO2.getUnrefundAmt().add(cgOrderVO1.getTotalAmt());
            BigDecimal returnAmt = cgOrderVO2.getRefundAmt().subtract(cgOrderVO1.getTotalAmt());
            this.cgOrderRepoProc.updateAmtById(cgOrderVO1.getSourceId(), unReturnAmt, returnAmt);
        }
        if (!CollectionUtils.isEmpty(cgOrderVO)) {
            cgOrderVO1 = cgOrderVO.get(0);
            SaveFlowParam saveFlowParam = this.VoToFlowParam(cgOrderVO1, "REJECT");
            this.saveFlow(saveFlowParam);
        }
        return cgOrderParam.getIds();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> cancel(List<Long> ids) {
        List<CgOrderVO> cgOrderVO = this.cgOrderRepoProc.queryByIds(ids);
        cgOrderVO.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.APPLY_STATUS_REJECTED.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u62d2\u7edd\u72b6\u6001\u5355\u636e\u624d\u53ef\u4f5c\u5e9f!");
            }
        });
        SysUserDTO user = this.getUser();
        this.cgOrderRepoProc.updateByIds(ids, UdcEnum.APPLY_STATUS_VOID.getValueCode(), user);
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long returnCg(CgOrderParam cgOrderParam) {
        CgOrderVO cgOrderVO = this.cgOrderRepoProc.queryById(cgOrderParam.getId());
        if (!(cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0001.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0002.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0003.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0004.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode()))) {
            throw new BusinessException("\u53ea\u80fd\u9000\u8fd8\u4fdd\u8bc1\u91d1\u7c7b\u578b\u5355\u636e!");
        }
        if (!cgOrderVO.getState().equals(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())) {
            throw new BusinessException("\u53ea\u80fd\u9000\u8fd8\u5df2\u5ba1\u6279\u7684\u5355\u636e!");
        }
        if (cgOrderParam.getReturnAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0!");
        }
        if (cgOrderParam.getReturnAmt().compareTo(cgOrderVO.getUnrefundAmt()) > 0) {
            throw new BusinessException("\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u672a\u9000\u6b3e\u91d1\u989d!");
        }
        BigDecimal unReturnAmt = cgOrderVO.getUnrefundAmt().subtract(cgOrderParam.getReturnAmt());
        BigDecimal returnAmt = cgOrderVO.getRefundAmt().add(cgOrderParam.getReturnAmt());
        this.cgOrderRepoProc.updateAmtById(cgOrderParam.getId(), unReturnAmt, returnAmt);
        CgOrderDO cgOrderDO = CgOrderConvert.INSTANCE.voToDo(cgOrderVO);
        cgOrderDO.setAuditRejectReason(null);
        cgOrderDO.setAuditTime(null);
        cgOrderDO.setAuditUserId(null);
        cgOrderDO.setAuditUser(null);
        cgOrderDO.setState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        String type = this.returnType(cgOrderVO.getType());
        cgOrderDO.setType(type);
        cgOrderDO.setCgType(this.getCgType(cgOrderDO.getType()));
        String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_CG_ORDER.getCode());
        cgOrderDO.setDocNo(docNo);
        cgOrderDO.setTotalAmt(cgOrderParam.getReturnAmt());
        cgOrderDO.setSourceNo(cgOrderVO.getDocNo());
        cgOrderDO.setSourceId(cgOrderVO.getId());
        cgOrderDO.setRemark(cgOrderVO.getRemark());
        cgOrderDO.setCreateTime(LocalDateTime.now());
        cgOrderDO.setId(null);
        cgOrderDO.setRefundAmt(BigDecimal.ZERO);
        cgOrderDO.setUnrefundAmt(BigDecimal.ZERO);
        CgOrderDO save = (CgOrderDO)((Object)this.cgOrderRepo.save((Object)cgOrderDO));
        List<PictureFileVO> fileVOS = this.pictureFileService.queryBySourceIds(List.of(cgOrderParam.getId()));
        List<PictureFileDO> pictureFileDOS = PictureFileConvert.INSTANCE.voToDo(fileVOS);
        pictureFileDOS.forEach(vo -> {
            vo.setSourceId(save.getId());
            vo.setSourceType("CG_ORDER");
            vo.setId(null);
        });
        this.pictureFileService.saveAll(pictureFileDOS);
        return save.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(CgOrderParam cgOrderParam) {
        CgOrderDO save;
        this.checkSave(cgOrderParam);
        String cgType = cgOrderParam.getCgType();
        String type1 = cgOrderParam.getType();
        if (!StringUtils.isEmpty((CharSequence)type1)) {
            cgType = this.getCgType(type1);
        }
        if (StringUtils.isEmpty((CharSequence)type1) && !StringUtils.isEmpty((CharSequence)cgType)) {
            type1 = this.getType(cgType);
        }
        cgOrderParam.setCgType(cgType);
        cgOrderParam.setType(type1);
        if (cgOrderParam.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode()) || cgOrderParam.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode()) || cgOrderParam.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode()) || cgOrderParam.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode())) {
            List<AccountVO> accountVOS = this.accountService.queryAccount(List.of(cgOrderParam.getAccCode()), null, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
            BigDecimal avaAmt = accountVOS.stream().map(AccountVO::getAccAvaAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (cgOrderParam.getTotalAmt().compareTo(avaAmt) > 0) {
                throw new BusinessException("\u5df2\u542f\u7528\u7684\u50a8\u503c\u8d26\u6237\u4f59\u989d\u4e0d\u8db3,\u8bf7\u68c0\u67e5!");
            }
        }
        CgOrderDO cgOrderDO = CgOrderConvert.INSTANCE.paramToDo(cgOrderParam);
        cgOrderDO.setUnrefundAmt(cgOrderDO.getTotalAmt());
        cgOrderDO.setRefundAmt(BigDecimal.ZERO);
        if (cgOrderParam.getId() == null) {
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_CG_ORDER.getCode());
            cgOrderDO.setDocNo(docNo);
        }
        if ((save = (CgOrderDO)((Object)this.cgOrderRepo.save((Object)cgOrderDO))).getState().equals(UdcEnum.APPLY_STATUS_DOING.getValueCode())) {
            SaveFlowParam saveFlowParam = this.DoToFlowParam(save, "SUBMIT");
            this.saveFlow(saveFlowParam);
        }
        List<PictureFileDO> pictureFileDOS = PictureFileConvert.INSTANCE.paramToDo(cgOrderParam.getImgs());
        if (cgOrderParam.getId() != null) {
            this.pictureFileService.deleteBySourceId(List.of(save.getId()));
        }
        pictureFileDOS.forEach(vo -> {
            vo.setSourceId(save.getId());
            vo.setSourceType("CG_ORDER");
        });
        this.pictureFileService.saveAll(pictureFileDOS);
        return save.getId();
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        return userDetails.getUser();
    }

    private String returnType(String type) {
        switch (type) {
            case "BZJ0001": {
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode();
            }
            case "BZJ0002": {
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode();
            }
            case "BZJ0003": {
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode();
            }
            case "BZJ0004": {
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode();
            }
            case "BZJ0005": {
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode();
            }
            case "BZJ0006": {
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode();
            }
            case "BZJ0007": {
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode();
            }
            case "BZJ0008": {
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode();
            }
        }
        throw new BusinessException("\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u5931\u8d25");
    }

    @Override
    public String getCgType(String type) {
        String cgType = "";
        switch (type) {
            case "ZC0001": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_ZCCZ.getValueCode();
                break;
            }
            case "PJ0001": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_PJCZ.getValueCode();
                break;
            }
            case "FJ0001": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_FJBCZ.getValueCode();
                break;
            }
            case "BZJ0004": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_DCBZJ.getValueCode();
                break;
            }
            case "BZJ0005": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_DCBZJ.getValueCode();
                break;
            }
            case "BZJ0001": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_ZXBZJ.getValueCode();
                break;
            }
            case "BZJ0006": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_ZXBZJ.getValueCode();
                break;
            }
            case "BZJ0002": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_DZPBZJ.getValueCode();
                break;
            }
            case "BZJ0007": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_DZPBZJ.getValueCode();
                break;
            }
            case "BZJ0003": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_XPBZJ.getValueCode();
                break;
            }
            case "BZJ0008": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_XPBZJ.getValueCode();
                break;
            }
            case "RBZJ0001": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE2_ZXBZJT.getValueCode();
                break;
            }
            case "RBZJ0002": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE2_DZPBZJT.getValueCode();
                break;
            }
            case "RBZJ0003": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE2_XPBZJT.getValueCode();
                break;
            }
            case "RBZJ0004": {
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE2_DCBZJT.getValueCode();
                break;
            }
            default: {
                throw new BusinessException("\u83b7\u53d6\u5145\u503c\u7c7b\u578b\u5931\u8d25");
            }
        }
        return cgType;
    }

    @Override
    public String getType(String cgType) {
        String type = "";
        switch (cgType) {
            case "ZCCZ": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_ZC0001.getValueCode();
                break;
            }
            case "PJCZ": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_PJ0001.getValueCode();
                break;
            }
            case "FJBCZ": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_FJ0001.getValueCode();
                break;
            }
            case "DCBZJ": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_BZJ0004.getValueCode();
                break;
            }
            case "ZXBZJ": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_BZJ0001.getValueCode();
                break;
            }
            case "DZPBZJ": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_BZJ0002.getValueCode();
                break;
            }
            case "XPBZJ": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_BZJ0003.getValueCode();
                break;
            }
            case "ZXBZJT": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode();
                break;
            }
            case "DZPBZJT": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode();
                break;
            }
            case "XPBZJT": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode();
                break;
            }
            case "DCBZJT": {
                type = UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode();
                break;
            }
            default: {
                throw new BusinessException("\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u5931\u8d25");
            }
        }
        return type;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> delete(List<Long> ids) {
        this.cgOrderRepoProc.updateDel(ids);
        return ids;
    }

    @Override
    public BigDecimal queryByUserId(CgOrderParam cgOrderParam) {
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> typesT = new ArrayList<String>();
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0001.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0002.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0003.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0004.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode());
        typesT.add(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode());
        typesT.add(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode());
        typesT.add(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode());
        typesT.add(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode());
        cgOrderParam.setState(UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode());
        BigDecimal totalAmt = this.cgOrderRepoProc.queryAmountSum(cgOrderParam, types);
        BigDecimal totalAmtT = this.cgOrderRepoProc.queryAmountSum(cgOrderParam, typesT);
        totalAmt = totalAmt == null ? BigDecimal.ZERO : totalAmt;
        totalAmtT = totalAmtT == null ? BigDecimal.ZERO : totalAmtT;
        return totalAmt.subtract(totalAmtT);
    }

    private void checkSave(CgOrderParam cgOrderParam) {
        Assert.notEmpty((CharSequence)cgOrderParam.getRecType(), (String)"\u6536\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)cgOrderParam.getRecBankAcc(), (String)"\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)cgOrderParam.getAccName(), (String)"\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)cgOrderParam.getAccCode(), (String)"\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)cgOrderParam.getAccType(), (String)"\u8d26\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notNull((Object)cgOrderParam.getTotalAmt(), (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notNull((Object)cgOrderParam.getCgTime(), (String)"\u6c47\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)cgOrderParam.getType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notNull(cgOrderParam.getImgs(), (String)"\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (cgOrderParam.getTotalAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0!");
        }
    }

    private void saveFlow(SaveFlowParam saveFlowParam) {
        ArrayList<AccountFlowParam> param = new ArrayList<AccountFlowParam>();
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam.setAccCode(saveFlowParam.getAccCode());
        accountFlowParam.setAccName(saveFlowParam.getAccName());
        accountFlowParam.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_RECEIPT.getValueCode());
        accountFlowParam.setAccType(saveFlowParam.getAccType());
        accountFlowParam.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        String transactionType = "";
        String dataSource = "";
        if ((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType()) || UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType())) && UdcEnum.FIN_CG_ORDER_TYPE_ZC0001.getValueCode().equals(saveFlowParam.getType()) && "APPROVED".equals(saveFlowParam.getScene())) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_CZ.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_SKD01.getValueCode();
        } else if ((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType()) || UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType())) && (UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode().equals(saveFlowParam.getType())) && "SUBMIT".equals(saveFlowParam.getScene())) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_BZJZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ01.getValueCode();
        } else if ((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType()) || UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType())) && (UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode().equals(saveFlowParam.getType())) && "REJECT".equals(saveFlowParam.getScene())) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_BZJSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ02.getValueCode();
        } else if ((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType()) || UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType())) && (UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode().equals(saveFlowParam.getType())) && "APPROVED".equals(saveFlowParam.getScene())) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_BZJKK.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ03.getValueCode();
        } else if ((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType()) || UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType())) && (UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode().equals(saveFlowParam.getType()) || UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode().equals(saveFlowParam.getType())) && "APPROVED".equals(saveFlowParam.getScene())) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_BZJTK.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ04.getValueCode();
        } else if (UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode().equals(saveFlowParam.getAccType()) && UdcEnum.FIN_CG_ORDER_TYPE_PJ0001.getValueCode().equals(saveFlowParam.getType()) && "APPROVED".equals(saveFlowParam.getScene())) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_CZ.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_SKD01.getValueCode();
        } else if (UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode().equals(saveFlowParam.getAccType()) && UdcEnum.FIN_CG_ORDER_TYPE_FJ0001.getValueCode().equals(saveFlowParam.getType()) && "APPROVED".equals(saveFlowParam.getScene())) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_CZ.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_SKD01.getValueCode();
        }
        accountFlowParam.setTransactionType(transactionType);
        accountFlowParam.setDataSource(dataSource);
        param.add(accountFlowParam);
        if (!StringUtils.isEmpty((CharSequence)transactionType) && !StringUtils.isEmpty((CharSequence)dataSource)) {
            this.accountFlowService.save(param);
        }
    }

    private SaveFlowParam VoToFlowParam(CgOrderVO cgOrderVO1, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAccType(cgOrderVO1.getAccType());
        saveFlowParam.setTotalAmt(cgOrderVO1.getTotalAmt());
        saveFlowParam.setAccCode(cgOrderVO1.getAccCode());
        saveFlowParam.setAccType(cgOrderVO1.getAccType());
        saveFlowParam.setAccName(cgOrderVO1.getAccName());
        saveFlowParam.setDocNo(cgOrderVO1.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setType(cgOrderVO1.getType());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }

    private SaveFlowParam DoToFlowParam(CgOrderDO save, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAccType(save.getAccType());
        saveFlowParam.setTotalAmt(save.getTotalAmt());
        saveFlowParam.setAccCode(save.getAccCode());
        saveFlowParam.setAccName(save.getAccName());
        saveFlowParam.setAccType(save.getAccType());
        saveFlowParam.setDocNo(save.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setType(save.getType());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }
}

