/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.rpc.pur;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PurSuppProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PurSuppOutServiceImpl
implements PurSuppOutService {
    private static final Logger log = LoggerFactory.getLogger(PurSuppOutServiceImpl.class);
    private final PurSuppProvider purSuppProvider;

    @Override
    public List<PurSuppBaseRpcDTO> findBaseSuppByCodes(List<String> suppCodes) {
        block5: {
            if (CollectionUtil.isEmpty(suppCodes)) {
                return Collections.EMPTY_LIST;
            }
            try {
                PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
                purSuppBaseRpcParam.setSuppCodes(suppCodes);
                ApiResult apiResult = this.purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam);
                if (apiResult.isSuccess()) {
                    List rpcDTOList = (List)apiResult.getData();
                    if (CollectionUtil.isNotEmpty((Collection)rpcDTOList)) {
                        return rpcDTOList;
                    }
                    break block5;
                }
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u91c7\u8d2d\u57df(findBaseSuppByCodes)\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25\uff1a" + apiResult.getErrorMsg());
            }
            catch (Exception e) {
                log.error("findBaseSuppByCodes error:", (Throwable)e);
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u91c7\u8d2d\u4e2d\u5fc3dubbo\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<PurSuppBaseRpcDTO> findBaseSuppByParam(PurSuppBaseRpcParam purSuppBaseRpcParam) {
        log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)purSuppBaseRpcParam));
        ArrayList<PurSuppBaseRpcDTO> data = new ArrayList();
        try {
            data = (List)this.purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam).computeData();
            log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(data));
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return data;
    }

    @Override
    public Map<String, PurSuppBaseRpcDTO> findBaseSuppMapByCodes(List<String> suppCodes) {
        List<PurSuppBaseRpcDTO> rpcDTOList = this.findBaseSuppByCodes(suppCodes);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<String, PurSuppBaseRpcDTO>();
        }
        Map<String, PurSuppBaseRpcDTO> suppMap = rpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, t -> t, (t1, t2) -> t1));
        return suppMap;
    }

    @Override
    public List<PurSuppBaseRpcDTO> findSimpleRpcDtoByParam(List<String> suppCodes) {
        block5: {
            if (CollectionUtil.isEmpty(suppCodes)) {
                return Collections.EMPTY_LIST;
            }
            try {
                PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
                purSuppBaseRpcParam.setSuppCodes(suppCodes);
                ApiResult apiResult = this.purSuppProvider.findSimpleRpcDtoByParam(purSuppBaseRpcParam);
                if (apiResult.isSuccess()) {
                    List rpcDTOList = (List)apiResult.getData();
                    if (CollectionUtil.isNotEmpty((Collection)rpcDTOList)) {
                        return rpcDTOList;
                    }
                    break block5;
                }
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u91c7\u8d2d\u57df(findSimpleRpcDtoByParam)\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25\uff1a" + apiResult.getErrorMsg());
            }
            catch (Exception e) {
                log.error("findSimpleRpcDtoByParam error:", (Throwable)e);
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u91c7\u8d2d\u4e2d\u5fc3dubbo\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String, PurSuppBaseRpcDTO> findSimpleSuppMapByCodes(List<String> suppCodes) {
        List<PurSuppBaseRpcDTO> rpcDTOList = this.findSimpleRpcDtoByParam(suppCodes);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<String, PurSuppBaseRpcDTO>();
        }
        Map<String, PurSuppBaseRpcDTO> suppMap = rpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, t -> t, (t1, t2) -> t1));
        return suppMap;
    }

    @Override
    public List<PurSuppBaseRpcDTO> findSimpleRpcDtoBySuppId(List<Long> suppIds) {
        block5: {
            if (CollectionUtil.isEmpty(suppIds)) {
                return Collections.EMPTY_LIST;
            }
            try {
                PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
                purSuppBaseRpcParam.setSuppIds(suppIds);
                ApiResult apiResult = this.purSuppProvider.findSimpleRpcDtoByParam(purSuppBaseRpcParam);
                if (apiResult.isSuccess()) {
                    List rpcDTOList = (List)apiResult.getData();
                    if (CollectionUtil.isNotEmpty((Collection)rpcDTOList)) {
                        return rpcDTOList;
                    }
                    break block5;
                }
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u91c7\u8d2d\u57df(findSimpleRpcDtoBySuppId)\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25\uff1a" + apiResult.getErrorMsg());
            }
            catch (Exception e) {
                log.error("findSimpleRpcDtoBySuppId error:", (Throwable)e);
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u91c7\u8d2d\u4e2d\u5fc3dubbo\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<Long, PurSuppBaseRpcDTO> findSimpleSuppMapBySuppId(List<Long> suppIds) {
        List<PurSuppBaseRpcDTO> rpcDTOList = this.findSimpleRpcDtoBySuppId(suppIds);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<Long, PurSuppBaseRpcDTO>();
        }
        Map<Long, PurSuppBaseRpcDTO> suppMap = rpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getId, t -> t, (t1, t2) -> t1));
        return suppMap;
    }

    public PurSuppOutServiceImpl(PurSuppProvider purSuppProvider) {
        this.purSuppProvider = purSuppProvider;
    }
}

