/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlRecordConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderRecordConvert;
import com.elitesland.fin.application.facade.dto.writeoff.ArOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.arorder.ArAgingReportParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuPageParam;
import com.elitesland.fin.application.facade.vo.arorder.ArAgingReportDtlVO;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeDtlVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderRecordParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderRecordDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.domain.service.paymentperiod.AgingRangeDomainService;
import com.elitesland.fin.domain.service.paymentperiod.AgingRangeDtlDomainService;
import com.elitesland.fin.domain.service.paymentperiod.AgingRangeOuDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderHandleDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderRecordDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeOuDTO;
import com.elitesland.fin.infr.factory.arorder.ArOrderFactory;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.repo.writeoff.ArOrderDetailRepoProc;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.TransactionCommitHandler;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import com.elitesland.inv.dto.invIo.InvIoParamRpcDTO;
import com.elitesland.inv.dto.invIo.InvIoRpcDTO;
import com.elitesland.inv.provider.InvIoProvider;
import com.elitesland.order.service.SalDoRpcService;
import com.elitesland.sale.api.vo.param.salesman.SalesmanInfoSimpleQueryVO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.api.vo.resp.salesman.SalesmanInfoSimpleRespVO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.sale.service.SalesmanRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.param.OrgBuRpcDtoParam;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgBuRpcService;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Service
public class ArOrderServiceImpl
implements ArOrderService {
    private static final Logger log = LoggerFactory.getLogger(ArOrderServiceImpl.class);
    private final ArOrderDomainService arOrderDomainService;
    private final ArTypeDomainService arTypeDomainService;
    private final SystemRpcService systemRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final ArTypeOuDomainService arTypeOuDomainService;
    private final ArOrderRecordDomainService arOrderRecordDomainService;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderFactory arOrderFactory;
    @Autowired
    private TaskExecutor taskExecutor;
    private final TransactionTemplate transactionTemplate;
    private final UdcProvider sysUdcRpcService;
    private final SalDoRpcService salDoRpcService;
    private final ItmItemRpcService itmItemRpcService;
    private final OrgBuRpcService orgBuRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final UdcProvider udcProvider;
    private final CrmCustRpcService crmCustRpcService;
    private final SalesmanRpcService salesmanRpcService;
    private final SaleInvDomainService saleInvDomainService;
    private final ArOrderDtlRepo arOrderDtlRepo;
    private final ArOrderDetailRepoProc arOrderDetailRepoProc;
    private final FinArRecVerApplyService finArRecVerApplyService;
    private final NamedParameterJdbcTemplate namedTemplate;
    private final AgingRangeOuDomainService agingRangeOuDomainService;
    private final AgingRangeDtlDomainService agingRangeDtlDomainService;
    private final AgingRangeDomainService agingRangeDomainService;
    private final TenantClientProvider tenantClientProvider;
    private final FlexFieldUtilService flexFieldUtilService;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final InvIoProvider invIoProvider;
    private final TransactionCommitHandler transactionCommitHandler;
    private final ArOrderRepoProc arOrderRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ArOrderVO> page(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> page = this.arOrderDomainService.page(arOrderPageParam);
        PagingVO<ArOrderVO> arOrderVOPagingVO = ArOrderConvert.INSTANCE.convertPage(page);
        List<String> relevanceOuCodeList = arOrderVOPagingVO.getRecords().stream().map(ArOrderVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        arOrderVOPagingVO.getRecords().forEach(arOrderVO -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(arOrderVO.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                arOrderVO.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        String flexFieldCode = "AR_ORDER";
        this.flexFieldUtilService.handleFlexFieldShowName(flexFieldCode, arOrderVOPagingVO.getRecords());
        return arOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<ArOrderVO> writeoffPage(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> page = this.arOrderDomainService.writeoffPage(arOrderPageParam);
        PagingVO<ArOrderVO> arOrderVOPagingVO = ArOrderConvert.INSTANCE.convertPage(page);
        if (arOrderVOPagingVO.isEmpty()) {
            return arOrderVOPagingVO;
        }
        List<Long> masIds = arOrderVOPagingVO.getRecords().stream().map(ArOrderVO::getId).collect(Collectors.toList());
        List<ArOrderDtlDTO> arOrderDtlDTOS = this.arOrderDtlRepoProc.listByMasIds(masIds);
        Map arOrderDtlDTOMap = arOrderDtlDTOS.stream().collect(Collectors.groupingBy(ArOrderDtlDTO::getMasId, Collectors.toList()));
        List<String> relevanceOuCodeList = arOrderVOPagingVO.getRecords().stream().map(ArOrderVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        arOrderVOPagingVO.getRecords().stream().forEach(v -> {
            BigDecimal verAmt = BigDecimal.ZERO;
            BigDecimal verAmting = BigDecimal.ZERO;
            BigDecimal unVerAmt = BigDecimal.ZERO;
            List arOrderDtlDTOS1 = (List)arOrderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty((Collection)arOrderDtlDTOS1)) {
                for (ArOrderDtlDTO arOrderDtlDTO : arOrderDtlDTOS1) {
                    if (arOrderDtlDTO.getVerAmt() != null) {
                        verAmt = verAmt.add(arOrderDtlDTO.getVerAmt());
                    }
                    if (arOrderDtlDTO.getApplyVerAmTing() != null) {
                        verAmting = verAmting.add(arOrderDtlDTO.getApplyVerAmTing());
                    }
                    if (arOrderDtlDTO.getUnVerAmt() == null) continue;
                    unVerAmt = unVerAmt.add(arOrderDtlDTO.getUnVerAmt());
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return arOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public ArOrderVO get(Long id) {
        HashMap ouMap;
        OrgOuRpcSimpleDTO ouRpcSimpleDTO;
        ReceiptPaymentAgreementVO agreementVO;
        ArOrderDTO arOrderDTO = this.arOrderDomainService.get(id);
        ArOrderVO res = ArOrderConvert.INSTANCE.convert(arOrderDTO);
        Map<String, ReceiptPaymentAgreementVO> agreementMap = this.receiptPaymentAgreementDomainService.selectReceiptAgreementByCodes(Collections.singletonList(res.getProtocolCode()));
        if (MapUtil.isNotEmpty(agreementMap) && agreementMap.containsKey(res.getProtocolCode()) && Objects.nonNull(agreementVO = agreementMap.get(res.getProtocolCode()))) {
            res.setProtocolName(agreementVO.getProtocolName());
        }
        if (Objects.nonNull(ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)(ouMap = StringUtils.isBlank((CharSequence)res.getRelevanceOuCode()) ? new HashMap() : this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(Collections.singletonList(res.getRelevanceOuCode()))).get(res.getRelevanceOuCode()))) {
            res.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
        }
        String flexFieldCode = "AR_ORDER";
        this.flexFieldUtilService.handleSingleFlexFieldShowName(flexFieldCode, (CustomFieldAbstractVo)res);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> audit(Long id) {
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> refush(List<Long> ids, String content) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long res = this.arOrderDomainService.audit(ids, content, user);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> del(List<Long> ids) {
        Long res = this.arOrderDomainService.del(ids);
        return ApiResult.ok((Object)res);
    }

    @Override
    @SysCodeProc
    public ArOrderVO getArOrderAndDtl(Long id) {
        ArOrderDTO arOrderAndDtl = this.arOrderDomainService.getArOrderAndDtl(id);
        ArOrderVO res = ArOrderConvert.INSTANCE.convert(arOrderAndDtl);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ArOrderSaveParam apOrderSaveParam) {
        if (!apOrderSaveParam.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("\u65b0\u589e\u7684\u5355\u636e\u6765\u6e90\u9700\u4e3a\u624b\u5de5");
        }
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long res = this.arOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<Long> commit(ArOrderSaveParam apOrderSaveParam) {
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Boolean isAuto = this.arTypeDomainService.queryIsAuto(apOrderSaveParam.getArTypeId());
        if (isAuto.booleanValue()) {
            apOrder.setAuditDate(LocalDateTime.now());
            apOrder.setAuditUser("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
            SysUserDTO user = this.systemRpcService.getUserByName("admin");
            apOrder.setAuditUserId(user.getId());
        }
        this.transactionTemplate.setPropagationBehavior(3);
        Long resId = (Long)this.transactionTemplate.execute(trans -> {
            try {
                return this.arOrderDomainService.commit(apOrder, isAuto);
            }
            catch (Exception e) {
                trans.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, e.toString());
            }
        });
        if (!isAuto.booleanValue()) {
            this.startWorkFlow(apOrder, resId);
        } else {
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(trans -> {
                try {
                    ArOrderDTO arOrder = this.arOrderRepoProc.get(resId);
                    if ("OUT".equals(arOrder.getInOutCust()) && "MANU".equals(arOrder.getCreateMode())) {
                        log.info("\u5916\u90e8\u5ba2\u6237,\u5ba1\u6279\u5b8c\u6210\u81ea\u52a8\u521b\u5efa\u8d26\u6237\u6d41\u6c34");
                        this.arOrderDomainService.createFinFlow(arOrder);
                    }
                    return "OK";
                }
                catch (Exception e) {
                    trans.setRollbackOnly();
                    throw new BusinessException(ApiCode.FAIL, e.toString());
                }
            });
            CompletableFuture.runAsync(() -> {
                log.info("\u5e94\u6536\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5f00\u59cb\u81ea\u52a8\u6838\u9500");
                ArOrderDTO arOrderDTO = new ArOrderDTO();
                arOrderDTO.setId(resId);
                this.finArRecVerApplyService.autoWriteoffAr(arOrderDTO);
            }, (Executor)this.taskExecutor);
        }
        return ApiResult.ok((Object)resId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> cancelApprove(List<Long> ids) {
        this.arOrderDomainService.restDocState(ids);
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> redPunch(Long id) {
        ArOrderDTO arOrderDTO = this.arOrderDomainService.get(id);
        this.checkRedPunch(arOrderDTO);
        ArOrderSaveParam saveParam = this.arOrderDomainService.redPunchCreate(id);
        saveParam.setCheck(false);
        return this.commit(saveParam);
    }

    void checkRedPunch(ArOrderDTO arOrderDTO) {
        BigDecimal verAmt;
        if (Objects.isNull(arOrderDTO)) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(arOrderDTO.getRedState())) {
            throw new BusinessException("\u5355\u636e\u5df2\u7ea2\u51b2");
        }
        if (Objects.nonNull(arOrderDTO.getRedSourceNo())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u4e0d\u53ef\u4e3a\u7ea2\u51b2\u5355\u636e");
        }
        if (CollUtil.isNotEmpty(arOrderDTO.getArOrderDtlDTOList()) && BigDecimal.ZERO.compareTo(verAmt = arOrderDTO.getArOrderDtlDTOList().stream().map(ArOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
            throw new BusinessException("\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
        }
        if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(arOrderDTO.getOrderState())) {
            throw new BusinessException("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
        }
        if (!UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode().equals(arOrderDTO.getCreateMode())) {
            throw new BusinessException("\u53ea\u5141\u8bb8\u7ea2\u51b2\u624b\u5de5\u751f\u6210\u7684\u5e94\u6536\u5355");
        }
        this.checkVerAmtEqualZero(arOrderDTO.getId());
    }

    private void checkVerAmtEqualZero(long id) {
        BigDecimal verAmt;
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        List<ArOrderDtlDTO> arOrderDtlDTOS = this.arOrderDtlRepoProc.listByMasIds(ids);
        if (CollectionUtils.isNotEmpty(arOrderDtlDTOS) && !BigDecimal.ZERO.equals(verAmt = arOrderDtlDTOS.stream().map(ArOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add))) {
            throw new BusinessException("\u5df2\u6838\u9500\u91d1\u989d\u4e0d\u4e3a0");
        }
    }

    @Override
    public void startWorkFlow(ArOrder apOrder, Long resId) {
        if (apOrder.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(apOrder.getProcInstStatus())) {
            String procInstName = "\u5e94\u6536\u5355\u5ba1\u6838-" + apOrder.getArOrderNo();
            String procKey = WorkFlowDefKey.FIN_AR_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<String, Object>());
            this.transactionTemplate.execute(trans -> {
                this.arOrderDomainService.updateWorkInfo(processInfo, resId);
                return "OK";
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(ArOrderSaveParam apOrderSaveParam) {
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        apOrder.checkUpdate();
        Long res = this.arOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<Void> autoCreate(ArOrderRecordSaveParam arOrderRecordSaveParam) {
        log.info("\u81ea\u52a8\u751f\u6210\u5e94\u6536\u5355\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)arOrderRecordSaveParam));
        Long arOrderRecordId = this.saveArOrderRecord(arOrderRecordSaveParam);
        ArTypeDTO arTypeDTO = this.selectArType(arOrderRecordSaveParam, arOrderRecordId);
        this.autoCreateArOrder(arOrderRecordSaveParam, arTypeDTO, arOrderRecordId);
        return ApiResult.ok();
    }

    private ArTypeDTO selectArType(ArOrderRecordSaveParam arOrderRecordSaveParam, Long arOrderRecordId) {
        this.checkRequired(arOrderRecordSaveParam, arOrderRecordId);
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setSourceDoc(arOrderRecordSaveParam.getCreateMode());
        arTypePageParam.setSourceDocType(arOrderRecordSaveParam.getSourceDocType());
        arTypePageParam.setSourceDocStatus(arOrderRecordSaveParam.getSourceDocStatus());
        List<ArTypeDTO> arTypeDTOList = this.arTypeDomainService.arOrderAutoSelectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)) {
            log.error("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{arOrderRecordSaveParam.getCreateMode(), arOrderRecordSaveParam.getSourceDocType(), arOrderRecordSaveParam.getSourceDocStatus()});
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1) {
            log.error("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{arOrderRecordSaveParam.getCreateMode(), arOrderRecordSaveParam.getSourceDocType(), arOrderRecordSaveParam.getSourceDocStatus()});
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        Long arTypeId = arTypeDTOList.get(0).getId();
        List<ArTypeOuDTO> arTypeOuDTOList = this.arTypeOuDomainService.queryByArTypeId(arTypeId);
        if (CollectionUtil.isEmpty(arTypeOuDTOList)) {
            log.error("\u5e94\u6536\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a, \u5e94\u6536\u5355\u7f16\u7801: {}", (Object)arTypeDTOList.get(0).getArTypeCode());
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u5e94\u6536\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a");
            throw new BusinessException("\u5e94\u6536\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a");
        }
        List arTypeOuCodeList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List arTypeOuIdList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!arTypeOuIdList.contains(arOrderRecordSaveParam.getOuId()) && !arTypeOuCodeList.contains(arOrderRecordSaveParam.getOuCode())) {
            log.error("\u5e94\u6536\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8, \u5e94\u6536\u5355\u7f16\u7801: {},\u516c\u53f8ID: {},\u516c\u53f8\u7f16\u7801: {}", new Object[]{arTypeDTOList.get(0).getArTypeCode(), arOrderRecordSaveParam.getOuId(), arOrderRecordSaveParam.getOuCode()});
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u5e94\u6536\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8");
            throw new BusinessException("\u5e94\u6536\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8");
        }
        return arTypeDTOList.get(0);
    }

    private void checkRepeat(ArOrderRecordSaveParam arOrderRecordSaveParam, Long arOrderRecordId) {
        ArOrderRecordParam arOrderRecordParam = new ArOrderRecordParam();
        arOrderRecordParam.setSourceNoList(Collections.singletonList(arOrderRecordSaveParam.getSourceNo()));
        List<ArOrderRecordDTO> arOrderRecordDTOList = this.arOrderRecordDomainService.selectByParam(arOrderRecordParam);
        if (CollectionUtil.isNotEmpty(arOrderRecordDTOList) && arOrderRecordDTOList.size() > 1) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u5b58\u5728\u5355\u53f7\u91cd\u590d\u6570\u636e,\u4e0d\u5141\u8bb8\u751f\u6210");
            throw new BusinessException("\u5b58\u5728\u5355\u53f7\u91cd\u590d\u6570\u636e,\u4e0d\u5141\u8bb8\u751f\u6210");
        }
    }

    private void checkRequired(ArOrderRecordSaveParam arOrderRecordSaveParam, Long arOrderRecordId) {
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getCreateMode())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u5355\u636e\u6765\u6e90\u4e3a\u7a7a");
            throw new BusinessException("\u5355\u636e\u6765\u6e90\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getSourceDocType())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a");
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getSourceDocStatus())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u6765\u6e90\u5355\u636e\u72b6\u6001\u4e3a\u7a7a");
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u72b6\u6001\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getOuId()) && StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getOuCode())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u516c\u53f8\u4e3a\u7a7a");
            throw new BusinessException("\u516c\u53f8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getSourceNo())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a");
            throw new BusinessException("\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getBuDate())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a");
            throw new BusinessException("\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getTotalAmt())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u542b\u7a0e\u603b\u91d1\u989d\u4e3a\u7a7a");
            throw new BusinessException("\u542b\u7a0e\u603b\u91d1\u989d\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getExclTaxAmt())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u4e0d\u542b\u7a0e\u603b\u91d1\u989d\u4e3a\u7a7a");
            throw new BusinessException("\u4e0d\u542b\u7a0e\u603b\u91d1\u989d\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getTaxAmt())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u7a0e\u989d\u4e3a\u7a7a");
            throw new BusinessException("\u7a0e\u989d\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getTotalCurAmt())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u542b\u7a0e\u603b\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e3a\u7a7a");
            throw new BusinessException("\u542b\u7a0e\u603b\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getExclTaxCurAmt())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u4e0d\u542b\u7a0e\u603b\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e3a\u7a7a");
            throw new BusinessException("\u4e0d\u542b\u7a0e\u603b\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getTaxCurAmt())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u7a0e\u989d(\u672c\u4f4d\u5e01)\u4e3a\u7a7a");
            throw new BusinessException("\u7a0e\u989d(\u672c\u4f4d\u5e01)\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getCurrCode())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u5e01\u79cd\u7f16\u7801\u4e3a\u7a7a");
            throw new BusinessException("\u5e01\u79cd\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getLocalCurrCode())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u672c\u4f4d\u5e01\u7f16\u7801\u4e3a\u7a7a");
            throw new BusinessException("\u672c\u4f4d\u5e01\u7f16\u7801\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getExchangeRate())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u6c47\u7387\u4e3a\u7a7a");
            throw new BusinessException("\u6c47\u7387\u4e3a\u7a7a");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getCustId()) && StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getCustCode())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u5ba2\u6237\u4e3a\u7a7a");
            throw new BusinessException("\u5ba2\u6237\u4e3a\u7a7a");
        }
        List<String> createModeList = Arrays.asList(UdcEnum.DOC_CLS_SAINV.getValueCode(), UdcEnum.DOC_CLS_SACCK.getValueCode());
        if (!createModeList.contains(arOrderRecordSaveParam.getCreateMode()) && Objects.isNull(arOrderRecordSaveParam.getBuId()) && StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getBuCode())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u90e8\u95e8\u4e3a\u7a7a");
            throw new BusinessException("\u90e8\u95e8\u4e3a\u7a7a");
        }
        if (!createModeList.contains(arOrderRecordSaveParam.getCreateMode()) && Objects.isNull(arOrderRecordSaveParam.getSaleUserId()) && StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getSaleUserCode())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u9500\u552e\u4e1a\u52a1\u5458\u4e3a\u7a7a");
            throw new BusinessException("\u9500\u552e\u4e1a\u52a1\u5458\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getLocalCurrCode())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u672c\u4f4d\u5e01\u7f16\u7801\u4e3a\u7a7a");
            throw new BusinessException("\u672c\u4f4d\u5e01\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getEs1())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u8ba2\u5355\u5ba2\u6237\u4e3a\u7a7a");
            throw new BusinessException("\u8ba2\u5355\u5ba2\u6237\u4e3a\u7a7a");
        }
        List<ArOrderDtlRecordSaveParam> dtlRecordSaveParams = arOrderRecordSaveParam.getArOrderDtlRecordSaveParams();
        dtlRecordSaveParams.forEach(dtlRecordSaveParam -> {
            if (StringUtils.isBlank((CharSequence)dtlRecordSaveParam.getSourceNo())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a");
            }
            if (Objects.isNull(dtlRecordSaveParam.getSourceLine())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dtlRecordSaveParam.getItemCode())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dtlRecordSaveParam.getUom())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a");
            }
            if (Objects.isNull(dtlRecordSaveParam.getQty())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u6570\u91cf\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u6570\u91cf\u4e3a\u7a7a");
            }
            if (Objects.isNull(dtlRecordSaveParam.getExclTaxPrice())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u5355\u4ef7\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u5355\u4ef7\u4e3a\u7a7a");
            }
            if (Objects.isNull(dtlRecordSaveParam.getPrice())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
            }
            if (Objects.isNull(dtlRecordSaveParam.getTaxRate())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u7a0e\u7387\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u7a0e\u7387\u4e3a\u7a7a");
            }
            if (Objects.isNull(dtlRecordSaveParam.getTotalAmt())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a");
            }
            if (Objects.isNull(dtlRecordSaveParam.getExclTaxAmt())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a");
            }
            if (Objects.isNull(dtlRecordSaveParam.getTaxAmt())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u7a0e\u989d\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u7a0e\u989d\u4e3a\u7a7a");
            }
            if (!createModeList.contains(arOrderRecordSaveParam.getCreateMode()) && Objects.isNull(arOrderRecordSaveParam.getBuId()) && StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getBuCode())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u8d39\u7528\u90e8\u95e8\u7f16\u7801\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u8d39\u7528\u90e8\u95e8\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dtlRecordSaveParam.getEs11())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u53d1\u8d27\u5355\u53f7\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u53d1\u8d27\u5355\u53f7\u4e3a\u7a7a");
            }
            if (Objects.isNull(dtlRecordSaveParam.getEs12())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u53d1\u8d27\u5355\u660e\u7ec6ID\uff08\u5f00\u7968\u7533\u8bf7\u5355\uff09\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u53d1\u8d27\u5355\u660e\u7ec6ID\uff08\u5f00\u7968\u7533\u8bf7\u5355\uff09\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dtlRecordSaveParam.getEs13())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u4e3b\u5ba2\u6237\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u4e3b\u5ba2\u6237\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dtlRecordSaveParam.getEs14())) {
                this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "\u660e\u7ec6\u5b50\u5ba2\u6237\u4e3a\u7a7a");
                throw new BusinessException("\u660e\u7ec6\u5b50\u5ba2\u6237\u4e3a\u7a7a");
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveArOrderRecord(ArOrderRecordSaveParam arOrderRecordSaveParam) {
        Long arOrderRecordId = this.arOrderRecordDomainService.save(arOrderRecordSaveParam);
        return arOrderRecordId;
    }

    public void autoCreateArOrder(ArOrderRecordSaveParam arOrderRecordSaveParam, ArTypeDTO arTypeDTO, Long arOrderRecordId) {
        this.transactionTemplate.setPropagationBehavior(3);
        ArOrderHandleDTO orderHandleDTO = (ArOrderHandleDTO)this.transactionTemplate.execute(trans -> {
            ArOrderHandleDTO arOrderHandleDTO = new ArOrderHandleDTO();
            Long arOrderId = null;
            try {
                Boolean isAuto = arTypeDTO.getAutoAudit();
                ArOrder arOrder = ArOrderConvert.INSTANCE.convertRecord(arOrderRecordSaveParam);
                arOrder.setArTypeCode(arTypeDTO.getArTypeCode());
                arOrder.setArTypeId(arTypeDTO.getId());
                arOrder.setArTypeName(arTypeDTO.getArTypeName());
                this.autoCreateArOrderHandle(arOrder);
                if (Objects.isNull(SecurityContextUtil.currentUser())) {
                    arOrder.setCreator("\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa");
                    arOrder.setCreateUserId(0L);
                }
                if (isAuto.booleanValue()) {
                    arOrder.setAuditDate(LocalDateTime.now());
                    arOrder.setAuditUser("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
                    SysUserDTO user = this.systemRpcService.getUserByName("admin");
                    arOrder.setAuditUserId(user.getId());
                    arOrderId = this.arOrderDomainService.newCommit(arOrder, isAuto);
                } else {
                    arOrderId = this.arOrderDomainService.save(arOrder);
                }
            }
            catch (Exception e) {
                log.error("\u5355\u636e: {}\u81ea\u52a8\u751f\u6210\u5e94\u6536\u5355\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u539f\u56e0: {}", (Object)arOrderRecordSaveParam.getSourceNo(), (Object)e.getMessage());
                arOrderHandleDTO.setErrorMsg(e.getMessage());
                trans.setRollbackOnly();
            }
            arOrderHandleDTO.setId(arOrderId);
            return arOrderHandleDTO;
        });
        if (Objects.isNull(orderHandleDTO.getId())) {
            this.arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_2.getValueCode(), orderHandleDTO.getErrorMsg());
        } else {
            this.arOrderRecordDomainService.updateArFlagById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_1.getValueCode());
            ArOrderRecordDTO arOrderRecordDTO = this.arOrderRecordDomainService.selectById(arOrderRecordId);
            if (Objects.equals(arOrderRecordSaveParam.getCreateMode(), UdcEnum.DOC_TYPE_DO.getValueCode())) {
                this.salDoRpcService.updateArOrderFlag(Collections.singletonList(arOrderRecordDTO.getSourceNo()));
            } else if (Objects.equals(arOrderRecordSaveParam.getCreateMode(), UdcEnum.DOC_CLS_SAINV.getValueCode())) {
                this.saleInvDomainService.updateArFlagByApplyNo(arOrderRecordDTO.getSourceNo(), UdcEnum.AR_FLAG_TYPE_1.getValueCode());
            }
            this.arOrderRecordDomainService.softDeleteByIds(Collections.singletonList(arOrderRecordId));
        }
    }

    private void autoCreateArOrderHandle(ArOrder arOrder) {
        List<SalesmanInfoSimpleRespVO> salesmanVOS;
        Map<Long, SalesmanInfoSimpleRespVO> salesmanMap;
        Map<Long, OrgBuRpcDTO> buIdMap;
        List<OrgBuRpcDTO> orgBuRpcDTOList;
        Map<String, OrgBuRpcDTO> buCodeMap;
        arOrder.setTaxFlag(true);
        arOrder.setInitFlag(false);
        List<OrgOuRpcDTO> orgOuRpcDTOList = this.selectOu(arOrder);
        if (CollectionUtil.isEmpty(orgOuRpcDTOList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f");
        }
        OrgOuRpcDTO orgOuRpcDTO = orgOuRpcDTOList.get(0);
        arOrder.setOuName(orgOuRpcDTO.getOuName());
        arOrder.setOuCode(orgOuRpcDTO.getOuCode());
        arOrder.setOuId(orgOuRpcDTO.getId());
        Map<String, String> currMap = this.selectCurr(arOrder);
        arOrder.setCurrName(currMap.getOrDefault(arOrder.getCurrCode(), null));
        arOrder.setLocalCurrName(currMap.getOrDefault(arOrder.getLocalCurrCode(), null));
        List<CustBaseDTO> crmCustBaseDTOList = this.selectCust(arOrder);
        Map<String, CustBaseDTO> custMap = crmCustBaseDTOList.stream().collect(Collectors.toMap(CustBaseDTO::getCustCode, t -> t));
        if (MapUtil.isNotEmpty(custMap) && Objects.nonNull(custMap.get(arOrder.getCustCode()))) {
            arOrder.setCustId(custMap.get(arOrder.getCustCode()).getId());
            arOrder.setCustName(custMap.get(arOrder.getCustCode()).getCustName());
            arOrder.setInOutCust(custMap.get(arOrder.getCustCode()).getInOutCust());
            if (Objects.equals(custMap.get(arOrder.getCustCode()).getCustType2(), "C")) {
                arOrder.setRelevanceOuCode(custMap.get(arOrder.getCustCode()).getCorBusinCode());
            }
        }
        if (MapUtil.isNotEmpty(custMap) && Objects.nonNull(custMap.get(arOrder.getEs1()))) {
            CustBaseDTO custBaseDTO = custMap.get(arOrder.getEs1());
            arOrder.setInOutCust(custBaseDTO.getInOutCust());
            if (Objects.equals(custBaseDTO.getCustType2(), "C")) {
                arOrder.setRelevanceOuCode(custBaseDTO.getCorBusinCode());
            }
            arOrder.setEs1(custBaseDTO.getCustName());
        }
        if (MapUtil.isNotEmpty(buCodeMap = (orgBuRpcDTOList = this.selectBu(arOrder)).stream().collect(Collectors.toMap(OrgBuRpcDTO::getBuCode, t -> t))) && Objects.nonNull(buCodeMap.get(arOrder.getBuCode()))) {
            arOrder.setBuId(buCodeMap.get(arOrder.getBuCode()).getId());
            arOrder.setBuName(buCodeMap.get(arOrder.getBuCode()).getBuName());
        }
        if (MapUtil.isNotEmpty(buIdMap = orgBuRpcDTOList.stream().collect(Collectors.toMap(OrgBuRpcDTO::getId, t -> t))) && Objects.nonNull(buIdMap.get(arOrder.getBuId()))) {
            arOrder.setBuId(buIdMap.get(arOrder.getBuId()).getId());
            arOrder.setBuName(buIdMap.get(arOrder.getBuId()).getBuName());
        }
        if (MapUtil.isNotEmpty(salesmanMap = (salesmanVOS = this.selectSalesman(arOrder)).stream().collect(Collectors.toMap(SalesmanInfoSimpleRespVO::getId, t -> t))) && Objects.nonNull(salesmanMap.get(arOrder.getSaleUserId()))) {
            arOrder.setSaleUser(salesmanMap.get(arOrder.getSaleUserId()).getFullName());
        }
        List<ArOrderDtl> dtlList = arOrder.getDtlList();
        List dtlItemCodes = dtlList.stream().map(ArOrderDtl::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(dtlItemCodes);
        List itmItemRpcDTOList = this.itmItemRpcService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        Map<String, ItmItemRpcDTO> itmItemMap = itmItemRpcDTOList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, t -> t));
        Map uomMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        Map<String, InvIoRpcDTO> invIoMap = this.getInvIoMap(arOrder.getCreateMode(), dtlList);
        dtlList.forEach(arOrderDtl -> {
            BigDecimal totalCurAmt = arOrderDtl.getTotalAmt().multiply(arOrder.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
            if (Objects.isNull(arOrderDtl.getTotalCurAmt())) {
                arOrderDtl.setTotalCurAmt(totalCurAmt);
            }
            BigDecimal exclTaxCurAmt = arOrderDtl.getExclTaxAmt().multiply(arOrder.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
            if (Objects.isNull(arOrderDtl.getExclTaxCurAmt())) {
                arOrderDtl.setExclTaxCurAmt(exclTaxCurAmt);
            }
            BigDecimal taxCurAmt = totalCurAmt.subtract(exclTaxCurAmt).setScale(2, RoundingMode.HALF_UP);
            if (Objects.isNull(arOrderDtl.getTaxCurAmt())) {
                arOrderDtl.setTaxCurAmt(taxCurAmt);
            }
            if (MapUtil.isNotEmpty((Map)custMap) && Objects.nonNull(custMap.get(arOrderDtl.getEs13()))) {
                arOrderDtl.setEs13(((CustBaseDTO)custMap.get(arOrderDtl.getEs13())).getCustName());
            }
            if (MapUtil.isNotEmpty((Map)custMap) && Objects.nonNull(custMap.get(arOrderDtl.getEs14()))) {
                arOrderDtl.setEs14(((CustBaseDTO)custMap.get(arOrderDtl.getEs14())).getCustName());
            }
            if (MapUtil.isNotEmpty((Map)buCodeMap) && Objects.nonNull(buCodeMap.get(arOrderDtl.getBuCode()))) {
                arOrderDtl.setBuId(((OrgBuRpcDTO)buCodeMap.get(arOrderDtl.getBuCode())).getId());
                arOrderDtl.setBuName(((OrgBuRpcDTO)buCodeMap.get(arOrderDtl.getBuCode())).getBuName());
            }
            if (MapUtil.isNotEmpty((Map)buIdMap) && Objects.nonNull(buIdMap.get(arOrderDtl.getBuId()))) {
                arOrderDtl.setBuId(((OrgBuRpcDTO)buIdMap.get(arOrderDtl.getBuId())).getId());
                arOrderDtl.setBuName(((OrgBuRpcDTO)buIdMap.get(arOrderDtl.getBuId())).getBuName());
            }
            if (MapUtil.isNotEmpty((Map)salesmanMap) && Objects.nonNull(salesmanMap.get(arOrder.getSaleUserId()))) {
                arOrderDtl.setEs20(((SalesmanInfoSimpleRespVO)salesmanMap.get(arOrder.getSaleUserId())).getSalesmanNo());
            }
            if (MapUtil.isNotEmpty((Map)itmItemMap) && Objects.nonNull(itmItemMap.get(arOrderDtl.getItemCode()))) {
                ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itmItemMap.get(arOrderDtl.getItemCode());
                arOrderDtl.setItemName(itmItemRpcDTO.getItemName());
                if (StringUtils.isNotBlank((CharSequence)arOrderDtl.getItemType())) {
                    arOrderDtl.setItemType(itmItemRpcDTO.getSpec());
                }
                if (StringUtils.isNotBlank((CharSequence)arOrderDtl.getSmallCateCode())) {
                    arOrderDtl.setSmallCateCode(itmItemRpcDTO.getItemCateCode());
                }
                if (StringUtils.isNotBlank((CharSequence)arOrderDtl.getSmallCateName())) {
                    arOrderDtl.setSmallCateName(itmItemRpcDTO.getItemCateFullName());
                }
            }
            arOrderDtl.setUomName((String)uomMap.get(arOrderDtl.getUom()));
            String key = arOrderDtl.getEs12() + "@" + arOrderDtl.getSourceNo();
            if (invIoMap.containsKey(key)) {
                InvIoRpcDTO invIoRpcDTO = (InvIoRpcDTO)invIoMap.get(key);
                arOrderDtl.setInvIoId(invIoRpcDTO.getId());
            }
        });
        arOrder.setDtlList(dtlList);
    }

    private Map<String, InvIoRpcDTO> getInvIoMap(String createMode, List<ArOrderDtl> dtlList) {
        if (UdcEnum.DOC_CLS_SACCK.getValueCode().equals(createMode)) {
            List sourceNos = dtlList.stream().map(ArOrderDtl::getSourceNo).collect(Collectors.toList());
            List docDids = dtlList.stream().map(ArOrderDtl::getEs12).collect(Collectors.toList());
            InvIoParamRpcDTO invIoParamRpcDTO = new InvIoParamRpcDTO();
            invIoParamRpcDTO.setSrcDocNos(sourceNos);
            invIoParamRpcDTO.setSrcDocDids(docDids);
            invIoParamRpcDTO.setSceneCodes(List.of("SO_OUT", "SO_RETURN"));
            ApiResult result = this.invIoProvider.findInvIoByParam(invIoParamRpcDTO);
            if (result.isSuccess()) {
                if (CollUtil.isNotEmpty((Collection)((Collection)result.getData()))) {
                    return ((List)result.getData()).stream().collect(Collectors.toMap(row -> row.getSrcDocDid() + "@" + row.getSourceNo(), Function.identity()));
                }
                return new HashMap<String, InvIoRpcDTO>();
            }
            return new HashMap<String, InvIoRpcDTO>();
        }
        return new HashMap<String, InvIoRpcDTO>();
    }

    @Override
    public void jobAutoCreate(String param) {
        JSONObject jsonObject;
        ArOrderRecordParam arOrderRecordJobParam;
        ArOrderRecordParam arOrderRecordParam = new ArOrderRecordParam();
        if (StringUtils.isNotBlank((CharSequence)param) && Objects.nonNull(arOrderRecordJobParam = (ArOrderRecordParam)JSONObject.toJavaObject((JSON)(jsonObject = JSONObject.parseObject((String)param)), ArOrderRecordParam.class))) {
            ArOrderRecordConvert.INSTANCE.oldToNewParam(arOrderRecordJobParam, arOrderRecordParam);
        }
        this.jobAutoCreateArOrder(arOrderRecordParam);
    }

    @Override
    public void jobAutoCreateArOrder(ArOrderRecordParam arOrderRecordParam) {
        log.info("\u767b\u5f55\u4eba\u4fe1\u606f\uff1a{}", (Object)SecurityContextUtil.currentUser());
        log.info("\u81ea\u52a8\u751f\u6210\u5e94\u6536\u5355\u5b9a\u65f6\u4efb\u52a1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)arOrderRecordParam));
        ArrayList<String> arFlagList = new ArrayList<String>();
        arFlagList.add(UdcEnum.AR_FLAG_TYPE_0.getValueCode());
        arOrderRecordParam.setArFlagList(arFlagList);
        List<ArOrderRecordDTO> arOrderRecordDTOList = this.arOrderRecordDomainService.selectDetailsByParam(arOrderRecordParam);
        if (CollectionUtil.isEmpty(arOrderRecordDTOList)) {
            log.info("\u67e5\u8be2\u5f85\u751f\u6210\u5e94\u6536\u5355\u8bb0\u5f55\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        arOrderRecordDTOList.forEach(arOrderRecordDTO -> {
            Long arOrderRecordId = arOrderRecordDTO.getId();
            ArOrderRecordSaveParam arOrderRecordSaveParam = ArOrderRecordConvert.INSTANCE.dtoToSaveParam((ArOrderRecordDTO)arOrderRecordDTO);
            List<ArOrderDtlRecordSaveParam> arOrderDtlRecordSaveParams = ArOrderDtlRecordConvert.INSTANCE.dtoToSaveParamBatch(arOrderRecordDTO.getArOrderDtlRecordDTOS());
            arOrderRecordSaveParam.setArOrderDtlRecordSaveParams(arOrderDtlRecordSaveParams);
            this.transactionTemplate.setPropagationBehavior(3);
            ArTypeDTO arTypeDTO = (ArTypeDTO)this.transactionTemplate.execute(trans -> {
                ArTypeDTO arTypeDto = null;
                try {
                    arTypeDto = this.selectArType(arOrderRecordSaveParam, arOrderRecordId);
                }
                catch (Exception e) {
                    trans.setRollbackOnly();
                }
                return arTypeDto;
            });
            if (Objects.nonNull(arTypeDTO)) {
                this.autoCreateArOrder(arOrderRecordSaveParam, arTypeDTO, arOrderRecordId);
            }
        });
    }

    private List<OrgOuRpcDTO> selectOu(ArOrder arOrder) {
        List orgOuRpcDTOList;
        ArrayList<OrgOuRpcDTO> orgOuAllList = new ArrayList<OrgOuRpcDTO>();
        if (Objects.nonNull(arOrder.getOuId()) && StringUtils.isBlank((CharSequence)arOrder.getOuCode())) {
            OrgOuRpcDtoParam orgOuByIdParam = new OrgOuRpcDtoParam();
            orgOuByIdParam.setOuIds(Collections.singletonList(arOrder.getOuId()));
            orgOuRpcDTOList = this.orgOuRpcService.findOuDtoByParam(orgOuByIdParam);
            if (CollectionUtil.isNotEmpty((Collection)orgOuRpcDTOList)) {
                orgOuAllList.addAll(orgOuRpcDTOList);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)arOrder.getOuCode())) {
            OrgOuRpcDtoParam orgOuByCodeParam = new OrgOuRpcDtoParam();
            orgOuByCodeParam.setOuCodes(Collections.singletonList(arOrder.getOuCode()));
            orgOuRpcDTOList = this.orgOuRpcService.findOuDtoByParam(orgOuByCodeParam);
            if (CollectionUtil.isNotEmpty((Collection)orgOuRpcDTOList)) {
                orgOuAllList.addAll(orgOuRpcDTOList);
            }
        }
        return orgOuAllList;
    }

    private Map<String, String> selectCurr(ArOrder arOrder) {
        HashSet<String> currCodes = new HashSet<String>();
        currCodes.add(arOrder.getCurrCode());
        currCodes.add(arOrder.getLocalCurrCode());
        List<SysCurrencyRespDTO> currencyRespDTOS = this.systemRpcService.findCurrByCodes(currCodes);
        if (CollectionUtil.isEmpty(currencyRespDTOS)) {
            return new HashMap<String, String>();
        }
        return currencyRespDTOS.stream().collect(Collectors.toMap(i -> i.getCurrCode(), i -> i.getCurrName(), (o, n) -> n));
    }

    private List<CustBaseDTO> selectCust(ArOrder arOrder) {
        ArrayList<String> custCodeAllList = new ArrayList<String>();
        custCodeAllList.add(arOrder.getCustCode());
        custCodeAllList.add(arOrder.getEs1());
        List es13s = arOrder.getDtlList().stream().map(ArOrderDtl::getEs13).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        custCodeAllList.addAll(es13s);
        List es14s = arOrder.getDtlList().stream().map(ArOrderDtl::getEs14).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        custCodeAllList.addAll(es14s);
        List<CustBaseDTO> crmCustBaseDTOList = this.findCustByCode(custCodeAllList);
        return crmCustBaseDTOList;
    }

    public List<CustBaseDTO> findCustByCode(List<String> custCodeList) {
        if (CollectionUtil.isEmpty(custCodeList)) {
            return Collections.emptyList();
        }
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(custCodeList);
        List<CustBaseDTO> crmCustBaseDTOList = this.rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollectionUtils.isNotEmpty(crmCustBaseDTOList)) {
            return crmCustBaseDTOList;
        }
        return Collections.emptyList();
    }

    private List<OrgBuRpcDTO> selectBu(ArOrder arOrder) {
        List dtlBuCodes;
        ArrayList<OrgBuRpcDTO> orgBuAllList = new ArrayList<OrgBuRpcDTO>();
        List dtlBuIds = arOrder.getDtlList().stream().filter(arOrderDtl -> Objects.nonNull(arOrderDtl.getBuId()) && StringUtils.isBlank((CharSequence)arOrderDtl.getBuCode())).map(ArOrderDtl::getBuId).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(dtlBuIds)) {
            OrgBuRpcDtoParam orgBuIdParam = new OrgBuRpcDtoParam();
            orgBuIdParam.setBuIds(dtlBuIds);
            List orgBuIdDTOList = this.orgBuRpcService.findBuDtoByParam(orgBuIdParam);
            if (CollectionUtil.isNotEmpty((Collection)orgBuIdDTOList)) {
                orgBuAllList.addAll(orgBuIdDTOList);
            }
        }
        if (CollectionUtil.isNotEmpty(dtlBuCodes = arOrder.getDtlList().stream().filter(arOrderDtl -> StringUtils.isNotEmpty((CharSequence)arOrderDtl.getBuCode())).map(ArOrderDtl::getBuCode).distinct().collect(Collectors.toList()))) {
            OrgBuRpcDtoParam orgBuCodeParam = new OrgBuRpcDtoParam();
            orgBuCodeParam.setBuCodes(dtlBuCodes);
            List orgBuCodeDTOList = this.orgBuRpcService.findBuDtoByParam(orgBuCodeParam);
            if (CollectionUtil.isNotEmpty((Collection)orgBuCodeDTOList)) {
                orgBuAllList.addAll(orgBuCodeDTOList);
            }
        }
        return orgBuAllList;
    }

    private List<SalesmanInfoSimpleRespVO> selectSalesman(ArOrder arOrder) {
        if (Objects.isNull(arOrder.getSaleUserId())) {
            return Collections.emptyList();
        }
        SalesmanInfoSimpleQueryVO salesmanInfoSimpleQueryVO = new SalesmanInfoSimpleQueryVO();
        salesmanInfoSimpleQueryVO.setIds(Collections.singletonList(arOrder.getSaleUserId()));
        List salesmanInfoSimpleRespVOS = this.salesmanRpcService.simpleQuery(salesmanInfoSimpleQueryVO);
        if (CollectionUtil.isEmpty((Collection)salesmanInfoSimpleRespVOS)) {
            return Collections.emptyList();
        }
        return salesmanInfoSimpleRespVOS;
    }

    @Override
    public PagingVO<ArExportEntity> defaultExport(ArOrderPageParam arOrderPageParam) {
        List<ArExportEntity> arExportEntities;
        PagingVO<ArOrderDTO> page = this.arOrderDomainService.page(arOrderPageParam);
        if (page.isEmpty()) {
            return new PagingVO(page.getTotal(), List.of());
        }
        Map arDocClsMap = this.sysUdcRpcService.getValueMapByUdcCode("yst-fin", "AR_DOC_CLS");
        Map applyStatusMap = this.sysUdcRpcService.getValueMapByUdcCode("yst-supp", "APPLY_STATUS");
        Map verifyStatusMap = this.sysUdcRpcService.getValueMapByUdcCode("yst-fin", "VERIFY_STATUS");
        Map settlementTypeMap = this.sysUdcRpcService.getValueMapByUdcCode("yst-fin", "SETTLEMENT_TYPE");
        HashMap<Long, ArOrderDTO> arOrderHashMap = new HashMap<Long, ArOrderDTO>();
        List records = page.getRecords();
        HashSet<Long> ids = new HashSet<Long>(records.size());
        for (ArOrderDTO record : records) {
            record.setCreateMode((String)arDocClsMap.get(record.getCreateMode()));
            record.setOrderState((String)applyStatusMap.get(record.getOrderState()));
            record.setVerState((String)verifyStatusMap.get(record.getVerState()));
            record.setSettlementType((String)settlementTypeMap.get(record.getSettlementType()));
            Long id = record.getId();
            arOrderHashMap.put(id, record);
            ids.add(id);
        }
        List<ArOrderDtlDTO> arOrderDtlDTOS = this.arOrderDtlRepoProc.listByMasIds(ids);
        if (CollectionUtils.isEmpty(arOrderDtlDTOS)) {
            arExportEntities = ExcelConvertUtils.convertLoosely(records, ArExportEntity.class);
            return new PagingVO(page.getTotal(), arExportEntities);
        }
        ExcelConverterManager.refresh();
        arExportEntities = new ArrayList<ArExportEntity>();
        for (ArOrderDtlDTO arOrderDtlDTO : arOrderDtlDTOS) {
            ArExportEntity arExportEntity = new ArExportEntity();
            ExcelConvertUtils.convertLoosely(arOrderDtlDTO, arExportEntity);
            ExcelConvertUtils.convertLoosely((ArOrderDTO)arOrderHashMap.get(arOrderDtlDTO.getMasId()), arExportEntity);
            ((ArrayList)arExportEntities).add(arExportEntity);
        }
        return new PagingVO(this.arOrderFactory.pageCount(arOrderPageParam).longValue(), arExportEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMiddleVerAmt(Long arDId, BigDecimal amt) {
        ArOrderDtlDO detail = this.findDetail(arDId);
        this.doUpdateVerAmt(this.getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    @NotNull
    private ArOrderDtlDO findDetail(Long arDId) {
        ArOrderDtlDO detail = this.arOrderDetailRepoProc.getExtArOrderDetailAmt(arDId);
        log.error("\u672a\u67e5\u8be2\u5230\u5e94\u6536\u5355\u660e\u7ec6\u884c\uff0c\u660e\u7ec6ID:" + arDId);
        Assert.notNull((Object)detail, (String)"\u672a\u67e5\u8be2\u5230\u5e94\u6536\u5355\u660e\u7ec6\u884c");
        return detail;
    }

    private void doUpdateVerAmt(ArOrderAmtUpdateDTO update) {
        if (this.arOrderDetailRepoProc.updateExtVerAmt(update) == 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private void repoUpdateVerAmt(ArOrderAmtUpdateDTO update) {
        if (this.arOrderDtlRepo.updateExtVerAmt(update.getArDId(), update.getVersion(), update.getVerAmt(), update.getVerAmting(), update.getUnVerAmt()) == 0) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private ArOrderAmtUpdateDTO.ArOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, ArOrderDtlDO detail) {
        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);
        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return ArOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(unVerAmt).verAmting(verAmting).verAmt(detail.getVerAmt()).version(detail.getAuditDataVersion());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long arDId, BigDecimal amt, String verType) {
        ArOrderDtlDO detail = this.findDetail(arDId);
        this.doUpdateVerAmt(this.getUpdateVerAmtBuilder(amt, detail, verType).build());
    }

    @Override
    public PagingVO<ArAgingReportDtlVO> agingReportDetail(ArAgingReportParam arAgingReportParam) {
        if (StringUtils.isBlank((CharSequence)arAgingReportParam.getOuCode())) {
            throw new BusinessException("\u516c\u53f8\u53c2\u6570\u4e3a\u7a7a");
        }
        AgingRangeOuPageParam pageParam = new AgingRangeOuPageParam();
        pageParam.setOuCode(arAgingReportParam.getOuCode());
        PagingVO<AgingRangeOuDTO> agingRangeOuDTOPagingVO = this.agingRangeOuDomainService.ouPage(pageParam);
        if (agingRangeOuDTOPagingVO == null || CollectionUtils.isEmpty((Collection)agingRangeOuDTOPagingVO.getRecords())) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u516c\u53f8\u8d26\u9f84\u914d\u7f6e");
        }
        AgingRangeOuDTO agingRangeOuDTO = (AgingRangeOuDTO)agingRangeOuDTOPagingVO.getRecords().get(0);
        AgingRangeVO agingRangeVO = this.agingRangeDomainService.findById(agingRangeOuDTO.getMasId());
        if (agingRangeVO == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8d26\u9f84\u914d\u7f6e");
        }
        List<AgingRangeDtlVO> agingRangeDtlVOS = this.agingRangeDtlDomainService.selectByMasId(agingRangeOuDTO.getMasId());
        if (CollectionUtils.isEmpty(agingRangeDtlVOS)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8d26\u9f84\u914d\u7f6e\u660e\u7ec6");
        }
        Collections.sort(agingRangeDtlVOS, new Comparator<AgingRangeDtlVO>(){

            @Override
            public int compare(AgingRangeDtlVO o1, AgingRangeDtlVO o2) {
                return o1.getLineNo().compareTo(o2.getLineNo());
            }
        });
        List<LocalDate[]> localDates = this.parseAgingRangeConfig(agingRangeVO, agingRangeDtlVOS);
        String selectListSql = "select ar_order0_.ou_name ,ar_order0_.sale_user ,ar_order0_.cust_name ,ar_order0_.curr_name ,\nar_order0_.ar_type_name ,ar_order0_.ar_order_no ,ar_order_dtl0_.item_name ,ar_order_dtl0_.uom_name ,ar_order0_.bu_date ,\nar_order_dtl0_.es23 ,ar_order_dtl0_.es24 ,ar_order_dtl0_.total_amt ,ar_order_dtl0_.un_ver_amt \n";
        String fromsql = "from ar_order_dtl ar_order_dtl0_,ar_order ar_order0_ \n";
        StringBuilder whereSqlBuilder = new StringBuilder();
        whereSqlBuilder.append("where ar_order_dtl0_.mas_id = ar_order0_.id and (ar_order0_.delete_flag is null or ar_order0_.delete_flag =0) \nand (ar_order_dtl0_.delete_flag is null or ar_order_dtl0_.delete_flag =0) \nand ar_order_dtl0_.tenant_id =:tenantId and ar_order0_.tenant_id =:tenantId\nand ar_order_dtl0_.un_ver_amt <>0 \nand ar_order0_.order_state ='COMPLETE' \n");
        if (StringUtils.isNotBlank((CharSequence)arAgingReportParam.getOuCode())) {
            whereSqlBuilder.append("and ar_order0_.ou_code=':ouCode'\n");
        }
        if (arAgingReportParam.getSaleUserId() != null) {
            whereSqlBuilder.append("and ar_order0_.sale_user_id = :saleUserId\n");
        }
        if (StringUtils.isNotBlank((CharSequence)arAgingReportParam.getCustCode())) {
            whereSqlBuilder.append("and ar_order0_.cust_code =':custCode'\n");
        }
        if (arAgingReportParam.getExceedPaymentPeriodFlag() != null && arAgingReportParam.getExceedPaymentPeriodFlag().booleanValue()) {
            whereSqlBuilder.append("and DATE(ar_order_dtl0_.es24)<CURDATE() \n");
        }
        if (arAgingReportParam.getStartBuDate() != null) {
            whereSqlBuilder.append("and ar_order0_.bu_date  >= :startBuDate\n");
        }
        if (arAgingReportParam.getEndBuDate() != null) {
            whereSqlBuilder.append("and ar_order0_.bu_date  <= :endBuDate\n");
        }
        StringBuilder totalCntSqlBuilder = new StringBuilder();
        totalCntSqlBuilder.append("select count(*) from ");
        totalCntSqlBuilder.append(fromsql);
        totalCntSqlBuilder.append(whereSqlBuilder.toString());
        HashMap<String, Number> arg = new HashMap<String, Number>();
        arg.put("tenantId", this.tenantClientProvider.getCurrentTenant().getId());
        arg.put("pageSize", arAgingReportParam.getPageSize());
        arg.put("offset", arAgingReportParam.getPage() * arAgingReportParam.getPageSize());
        int cnt = (Integer)this.namedTemplate.queryForObject(totalCntSqlBuilder.toString(), arg, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getFetchSize();
            }
        });
        if (cnt == 0) {
            return PagingVO.builder().total((long)cnt).records(null).build();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(selectListSql).append(fromsql).append(whereSqlBuilder.toString());
        sqlBuilder.append("order by ar_order0_.bu_date asc \n");
        sqlBuilder.append("limit :pageSize offset :offset");
        List arAgingReportDtlVOS = this.namedTemplate.queryForList(sqlBuilder.toString(), arg, ArAgingReportDtlVO.class);
        if (CollectionUtils.isNotEmpty((Collection)arAgingReportDtlVOS)) {
            for (ArAgingReportDtlVO arAgingReportDtlVO : arAgingReportDtlVOS) {
                ArrayList agingFlags = new ArrayList();
                for (int i = 0; i < localDates.size(); ++i) {
                }
            }
        }
        PagingVO pagingVO = PagingVO.builder().total((long)cnt).records(arAgingReportDtlVOS).build();
        return pagingVO;
    }

    @NotNull
    private ArOrderAmtUpdateDTO.ArOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, ArOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr((Object)detail);
        log.info("\u8ba1\u7b97\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d,{}-{}", (Object)amt, (Object)infoStr);
        if ("2".equals(verType)) {
            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("\u53d6\u6d88\u6838\u9500,{}-{}-{}", new Object[]{infoStr, verAmt, unVerAmt});
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
            }
            return ArOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(unVerAmt).verAmting(detail.getApplyVerAmTing()).verAmt(verAmt).version(detail.getAuditDataVersion());
        }
        BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
        BigDecimal verAmt = detail.getVerAmt().add(amt);
        log.info("\u6838\u9500\u901a\u8fc7,{}-{}-{}", new Object[]{infoStr, verAmting, verAmt});
        if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return ArOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(detail.getUnVerAmt()).verAmting(verAmting).verAmt(verAmt).version(detail.getAuditDataVersion());
    }

    private List<LocalDate[]> parseAgingRangeConfig(AgingRangeVO agingRangeVO, List<AgingRangeDtlVO> agingRangeDtlVOS) {
        ArrayList<LocalDate[]> agingRangeDateRangeList;
        block14: {
            LocalDate now;
            block15: {
                block16: {
                    block12: {
                        block13: {
                            if (agingRangeVO == null || CollectionUtils.isEmpty(agingRangeDtlVOS)) {
                                return null;
                            }
                            agingRangeDateRangeList = new ArrayList<LocalDate[]>();
                            now = LocalDate.now();
                            if (!UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_YEAR.getValueCode().equals(agingRangeVO.getTimeUnitType())) break block12;
                            if (!UdcEnum.TIME_UNIT_DAYS_YEAR_TYPE_360.getValueCode().equals(agingRangeVO.getUnitDays())) break block13;
                            for (int i = 0; i < agingRangeDtlVOS.size(); ++i) {
                                LocalDate[] dateRange = new LocalDate[2];
                                AgingRangeDtlVO agingRangeDtlVO = agingRangeDtlVOS.get(i);
                                Integer paymentPeriodBegin = agingRangeDtlVO.getPaymentPeriodBegin();
                                Integer paymentPeriodEnd = agingRangeDtlVO.getPaymentPeriodEnd();
                                dateRange[1] = i == 0 && paymentPeriodBegin == null ? now.minusDays(0L) : now.minusDays(360 * paymentPeriodBegin);
                                if (i != agingRangeDtlVOS.size() - 1 || paymentPeriodEnd != null) {
                                    dateRange[0] = now.minusDays(360 * paymentPeriodEnd);
                                }
                                agingRangeDateRangeList.add(dateRange);
                            }
                            break block14;
                        }
                        if (!UdcEnum.TIME_UNIT_DAYS_YEAR_TYPE_CALENDAR.getValueCode().equals(agingRangeVO.getUnitDays())) break block14;
                        for (int i = 0; i < agingRangeDtlVOS.size(); ++i) {
                            LocalDate[] dateRange = new LocalDate[2];
                            AgingRangeDtlVO agingRangeDtlVO = agingRangeDtlVOS.get(i);
                            Integer paymentPeriodBegin = agingRangeDtlVO.getPaymentPeriodBegin();
                            Integer paymentPeriodEnd = agingRangeDtlVO.getPaymentPeriodEnd();
                            dateRange[1] = i == 0 && paymentPeriodBegin == null ? now.minusYears(0L) : now.minusYears(paymentPeriodBegin.intValue());
                            if (i != agingRangeDtlVOS.size() - 1 || paymentPeriodEnd != null) {
                                dateRange[0] = now.minusYears(paymentPeriodEnd.intValue());
                            }
                            agingRangeDateRangeList.add(dateRange);
                        }
                        break block14;
                    }
                    if (!UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_MONTH.getValueCode().equals(agingRangeVO.getTimeUnitType())) break block15;
                    if (!UdcEnum.TIME_UNIT_DAYS_MONTH_TYPE_30.getValueCode().equals(agingRangeVO.getUnitDays())) break block16;
                    for (int i = 0; i < agingRangeDtlVOS.size(); ++i) {
                        LocalDate[] dateRange = new LocalDate[2];
                        AgingRangeDtlVO agingRangeDtlVO = agingRangeDtlVOS.get(i);
                        Integer paymentPeriodBegin = agingRangeDtlVO.getPaymentPeriodBegin();
                        Integer paymentPeriodEnd = agingRangeDtlVO.getPaymentPeriodEnd();
                        dateRange[1] = i == 0 && paymentPeriodBegin == null ? now.minusDays(0L) : now.minusDays(30 * paymentPeriodBegin);
                        if (i != agingRangeDtlVOS.size() - 1 || paymentPeriodEnd != null) {
                            dateRange[0] = now.minusDays(30 * paymentPeriodEnd);
                        }
                        agingRangeDateRangeList.add(dateRange);
                    }
                    break block14;
                }
                if (!UdcEnum.TIME_UNIT_DAYS_MONTH_TYPE_CALENDAR.getValueCode().equals(agingRangeVO.getUnitDays())) break block14;
                for (int i = 0; i < agingRangeDtlVOS.size(); ++i) {
                    LocalDate[] dateRange = new LocalDate[2];
                    AgingRangeDtlVO agingRangeDtlVO = agingRangeDtlVOS.get(i);
                    Integer paymentPeriodBegin = agingRangeDtlVO.getPaymentPeriodBegin();
                    Integer paymentPeriodEnd = agingRangeDtlVO.getPaymentPeriodEnd();
                    dateRange[1] = i == 0 && paymentPeriodBegin == null ? now.minusMonths(0L) : now.minusMonths(paymentPeriodBegin.intValue());
                    if (i != agingRangeDtlVOS.size() - 1 || paymentPeriodEnd != null) {
                        dateRange[0] = now.minusMonths(paymentPeriodEnd.intValue());
                    }
                    agingRangeDateRangeList.add(dateRange);
                }
                break block14;
            }
            if (UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_DAY.getValueCode().equals(agingRangeVO.getTimeUnitType()) && UdcEnum.TIME_UNIT_DAYS_DAY_TYPE_1.getValueCode().equals(agingRangeVO.getUnitDays())) {
                for (int i = 0; i < agingRangeDtlVOS.size(); ++i) {
                    LocalDate[] dateRange = new LocalDate[2];
                    AgingRangeDtlVO agingRangeDtlVO = agingRangeDtlVOS.get(i);
                    Integer paymentPeriodBegin = agingRangeDtlVO.getPaymentPeriodBegin();
                    Integer paymentPeriodEnd = agingRangeDtlVO.getPaymentPeriodEnd();
                    dateRange[1] = i == 0 && paymentPeriodBegin == null ? now.minusDays(0L) : now.minusDays(paymentPeriodBegin.intValue());
                    if (i != agingRangeDtlVOS.size() - 1 || paymentPeriodEnd != null) {
                        dateRange[0] = now.minusDays(paymentPeriodEnd.intValue());
                    }
                    agingRangeDateRangeList.add(dateRange);
                }
            }
        }
        return agingRangeDateRangeList;
    }

    public ArOrderServiceImpl(ArOrderDomainService arOrderDomainService, ArTypeDomainService arTypeDomainService, SystemRpcService systemRpcService, WorkflowRpcService workflowRpcService, ArTypeOuDomainService arTypeOuDomainService, ArOrderRecordDomainService arOrderRecordDomainService, ArOrderDtlRepoProc arOrderDtlRepoProc, ArOrderFactory arOrderFactory, TransactionTemplate transactionTemplate, UdcProvider sysUdcRpcService, SalDoRpcService salDoRpcService, ItmItemRpcService itmItemRpcService, OrgBuRpcService orgBuRpcService, OrgOuRpcService orgOuRpcService, UdcProvider udcProvider, CrmCustRpcService crmCustRpcService, SalesmanRpcService salesmanRpcService, SaleInvDomainService saleInvDomainService, ArOrderDtlRepo arOrderDtlRepo, ArOrderDetailRepoProc arOrderDetailRepoProc, FinArRecVerApplyService finArRecVerApplyService, NamedParameterJdbcTemplate namedTemplate, AgingRangeOuDomainService agingRangeOuDomainService, AgingRangeDtlDomainService agingRangeDtlDomainService, AgingRangeDomainService agingRangeDomainService, TenantClientProvider tenantClientProvider, FlexFieldUtilService flexFieldUtilService, ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService, RmiSaleRpcService rmiSaleRpcService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, InvIoProvider invIoProvider, TransactionCommitHandler transactionCommitHandler, ArOrderRepoProc arOrderRepoProc) {
        this.arOrderDomainService = arOrderDomainService;
        this.arTypeDomainService = arTypeDomainService;
        this.systemRpcService = systemRpcService;
        this.workflowRpcService = workflowRpcService;
        this.arTypeOuDomainService = arTypeOuDomainService;
        this.arOrderRecordDomainService = arOrderRecordDomainService;
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
        this.arOrderFactory = arOrderFactory;
        this.transactionTemplate = transactionTemplate;
        this.sysUdcRpcService = sysUdcRpcService;
        this.salDoRpcService = salDoRpcService;
        this.itmItemRpcService = itmItemRpcService;
        this.orgBuRpcService = orgBuRpcService;
        this.orgOuRpcService = orgOuRpcService;
        this.udcProvider = udcProvider;
        this.crmCustRpcService = crmCustRpcService;
        this.salesmanRpcService = salesmanRpcService;
        this.saleInvDomainService = saleInvDomainService;
        this.arOrderDtlRepo = arOrderDtlRepo;
        this.arOrderDetailRepoProc = arOrderDetailRepoProc;
        this.finArRecVerApplyService = finArRecVerApplyService;
        this.namedTemplate = namedTemplate;
        this.agingRangeOuDomainService = agingRangeOuDomainService;
        this.agingRangeDtlDomainService = agingRangeDtlDomainService;
        this.agingRangeDomainService = agingRangeDomainService;
        this.tenantClientProvider = tenantClientProvider;
        this.flexFieldUtilService = flexFieldUtilService;
        this.receiptPaymentAgreementDomainService = receiptPaymentAgreementDomainService;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.invIoProvider = invIoProvider;
        this.transactionCommitHandler = transactionCommitHandler;
        this.arOrderRepoProc = arOrderRepoProc;
    }
}

