/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.application.service.adjustorder.AdjustOrderService;
import com.elitesland.fin.application.service.excel.entity.AdjustExportEntity;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DefaultAdjustExportServiceImpl
implements DataExport<AdjustExportEntity, AdjustOrderPageParam> {
    private final AdjustOrderService adjustOrderService;

    public String getTmplCode() {
        return "FIN_ADJUST_EXPORT_DEFAULT";
    }

    @BusinessObjectOperation(permissionRef="fin_adjust_list", businessObjectType="Fin_Adjust:\u8d26\u6237\u8c03\u6574\u5355", operationType=OperationTypeEnum.EXPORT, operationDescription="\u8d26\u6237\u8c03\u6574\u5355\u9ed8\u8ba4\u5bfc\u51fa", operationCode="fin_adjust_export_default", dataPermissionEnabled=true, fieldPermissionAutoFilter=true)
    public PagingVO<AdjustExportEntity> executeExport(AdjustOrderPageParam param) {
        PagingVO<AdjustOrderVO> page = this.adjustOrderService.page(param);
        if (page.isNotEmpty()) {
            List records = page.getRecords();
            List<AdjustExportEntity> adjustExportEntities = ExcelConvertUtils.convertLoosely(records, AdjustExportEntity.class);
            return new PagingVO(page.getTotal(), adjustExportEntities);
        }
        return new PagingVO(0L, List.of());
    }

    public Integer pageSize() {
        return 1000;
    }

    public DefaultAdjustExportServiceImpl(AdjustOrderService adjustOrderService) {
        this.adjustOrderService = adjustOrderService;
    }
}

