/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.convert.rectype.RecTypeConvert;
import com.elitesland.fin.application.facade.dto.writeoff.RecOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.entity.recorder.RecOrderDtlDO;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.domain.service.rectype.RecTypeDomainService;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.RecOrderDetailRepoProc;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Service
public class RecOrderServiceImpl
implements RecOrderService {
    private static final Logger log = LoggerFactory.getLogger(RecOrderServiceImpl.class);
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RecOrderDomainService recOrderDomainService;
    private final RecTypeDomainService recTypeDomainService;
    private final SystemRpcService systemRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final TransactionTemplate transactionTemplate;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;
    private final RecOrderDtlRepo recOrderDtlRepo;
    private final RecOrderDetailRepoProc recOrderDetailRepoProc;
    private FinArRecVerApplyService finArRecVerApplyService;
    private final FlexFieldUtilService flexFieldUtilService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final RecOrderRepoProc recOrderRepoProc;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    @Lazy
    public void setFinArRecVerApplyService(FinArRecVerApplyService finArRecVerApplyService) {
        this.finArRecVerApplyService = finArRecVerApplyService;
    }

    @Override
    @SysCodeProc
    public PagingVO<RecOrderVO> page(RecOrderPageParam param) {
        PagingVO<RecOrderDTO> page = this.recOrderDomainService.page(param);
        PagingVO<RecOrderVO> recOrderVOPagingVO = RecOrderConvert.INSTANCE.convertPage(page);
        if (recOrderVOPagingVO != null && CollectionUtils.isNotEmpty((Collection)recOrderVOPagingVO.getRecords())) {
            List<Long> masIds = recOrderVOPagingVO.getRecords().stream().map(RecOrderVO::getId).collect(Collectors.toList());
            Map recOrderDtlDTOMap = this.recOrderDtlRepoProc.queryByMasIds(masIds).stream().collect(Collectors.groupingBy(RecOrderDtlDTO::getMasId, Collectors.toList()));
            List<String> relevanceOuCodeList = recOrderVOPagingVO.getRecords().stream().map(RecOrderVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
            recOrderVOPagingVO.getRecords().forEach(vo -> {
                BigDecimal verAmt = BigDecimal.ZERO;
                BigDecimal verAmting = BigDecimal.ZERO;
                BigDecimal unVerAmt = BigDecimal.ZERO;
                List recOrderDtlDTOS = (List)recOrderDtlDTOMap.get(vo.getId());
                if (CollUtil.isNotEmpty((Collection)recOrderDtlDTOS)) {
                    for (RecOrderDtlDTO recOrderDtlDTO : recOrderDtlDTOS) {
                        if (recOrderDtlDTO.getVerAmt() != null) {
                            verAmt = verAmt.add(recOrderDtlDTO.getVerAmt());
                        }
                        if (recOrderDtlDTO.getApplyVerAmTing() != null) {
                            verAmting = verAmting.add(recOrderDtlDTO.getApplyVerAmTing());
                        }
                        if (recOrderDtlDTO.getUnVerAmt() == null) continue;
                        unVerAmt = unVerAmt.add(recOrderDtlDTO.getUnVerAmt());
                    }
                }
                vo.setVerAmt(verAmt);
                vo.setApplyVerAmTing(verAmting);
                vo.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(vo.getTotalAmt()) == 0) {
                    vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(vo.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)) {
                    vo.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
            this.flexFieldUtilService.handleFlexFieldShowNameForVO("REC_ORDER", recOrderVOPagingVO.getRecords());
        }
        return recOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<RecOrderVO> writeoffPage(RecOrderPageParam param) {
        PagingVO<RecOrderDTO> page = this.recOrderDomainService.writeoffPage(param);
        PagingVO<RecOrderVO> recOrderVOPagingVO = RecOrderConvert.INSTANCE.convertPage(page);
        if (recOrderVOPagingVO.isEmpty()) {
            return recOrderVOPagingVO;
        }
        List<Long> masIds = recOrderVOPagingVO.getRecords().stream().map(RecOrderVO::getId).collect(Collectors.toList());
        Map recOrderDtlDTOMap = this.recOrderDtlRepoProc.queryByMasIds(masIds).stream().collect(Collectors.groupingBy(RecOrderDtlDTO::getMasId, Collectors.toList()));
        List<String> relevanceOuCodeList = recOrderVOPagingVO.getRecords().stream().map(RecOrderVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        recOrderVOPagingVO.getRecords().forEach(vo -> {
            BigDecimal verAmt = BigDecimal.ZERO;
            BigDecimal verAmting = BigDecimal.ZERO;
            BigDecimal unVerAmt = BigDecimal.ZERO;
            List recOrderDtlDTOS = (List)recOrderDtlDTOMap.get(vo.getId());
            if (CollUtil.isNotEmpty((Collection)recOrderDtlDTOS)) {
                for (RecOrderDtlDTO recOrderDtlDTO : recOrderDtlDTOS) {
                    verAmt = verAmt.add(recOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(recOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(recOrderDtlDTO.getUnVerAmt());
                }
            }
            vo.setVerAmt(verAmt);
            vo.setApplyVerAmTing(verAmting);
            vo.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(vo.getTotalAmt()) == 0) {
                vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(vo.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                vo.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return recOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public RecOrderVO queryById(Long id) {
        RecOrderDTO recOrderDTO = this.recOrderDomainService.queryById(id, false);
        RecOrderVO recOrderVO = RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO);
        Map<Object, Object> ouMap = StringUtils.isBlank((CharSequence)recOrderVO.getRelevanceOuCode()) ? new HashMap() : this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(Collections.singletonList(recOrderVO.getRelevanceOuCode()));
        OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(recOrderVO.getRelevanceOuCode());
        if (Objects.nonNull(ouRpcSimpleDTO)) {
            recOrderVO.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
        }
        this.flexFieldUtilService.handleSingleFlexFieldShowNameForVO("REC_ORDER", (CustomFieldBaseModelVo)recOrderVO);
        return recOrderVO;
    }

    @Override
    @SysCodeProc
    public RecOrderVO queryDetailsById(Long id) {
        RecOrderVO recOrderVO;
        HashMap ouMap;
        OrgOuRpcSimpleDTO ouRpcSimpleDTO;
        RecOrderDTO recOrderDTO = this.recOrderDomainService.queryById(id, true);
        if (StrUtil.isNotBlank((CharSequence)recOrderDTO.getCustCode())) {
            log.info("\u5ba2\u6237\u7f16\u7801:{}", (Object)recOrderDTO.getCustCode());
            List<RmiOrgBankAccRpcVO> bankAccByCustCode = this.rmiSaleRpcService.findBankAccByCustCode(recOrderDTO.getCustCode());
            if (CollUtil.isNotEmpty(bankAccByCustCode)) {
                recOrderDTO.setRecvAddrNo(String.valueOf(bankAccByCustCode.get(0).getAddrNo()));
            }
        }
        if (Objects.nonNull(ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)(ouMap = StringUtils.isBlank((CharSequence)(recOrderVO = RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO)).getRelevanceOuCode()) ? new HashMap() : this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(Collections.singletonList(recOrderVO.getRelevanceOuCode()))).get(recOrderVO.getRelevanceOuCode()))) {
            recOrderVO.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
        }
        return recOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> deleteByIds(List<Long> ids) {
        List<Long> deleteByIds = this.recOrderDomainService.deleteByIds(ids);
        return ApiResult.ok(deleteByIds);
    }

    @Override
    public ApiResult<RecOrderVO> defaultValue() {
        RecTypeDTO recTypeDTO = this.recTypeDomainService.defaultValue();
        RecOrderVO recOrderVO = RecTypeConvert.INSTANCE.typeToOrder(recTypeDTO);
        if (recOrderVO == null) {
            return ApiResult.ok((Object)new RecOrderVO());
        }
        return ApiResult.ok((Object)recOrderVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(RecOrderSaveParam param) {
        RecOrder order = RecOrderConvert.INSTANCE.convertParam(param);
        Long id = this.recOrderDomainService.save(order);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> submit(RecOrderSaveParam param) {
        Boolean auto = this.recTypeDomainService.getAuto(param.getRecTypeCode());
        if (auto == null) {
            throw new BusinessException("\u6536\u6b3e\u5355\u7c7b\u578b\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        RecOrder order = RecOrderConvert.INSTANCE.convertParam(param);
        if (auto.booleanValue()) {
            order.setAuditDate(LocalDateTime.now());
            order.setAuditUser("admin");
            SysUserDTO user = this.systemRpcService.getUserByName("admin");
            order.setAuditUserId(user.getId());
        }
        this.transactionTemplate.setPropagationBehavior(3);
        Long id = (Long)this.transactionTemplate.execute(transactionStatus -> this.recOrderDomainService.submit(order, auto));
        if (!auto.booleanValue()) {
            this.startWorkFlow(order, id);
        } else {
            log.info("\u6536\u6b3e\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5f00\u59cb\u81ea\u52a8\u6838\u9500");
            RecOrderDTO recOrderDTO = new RecOrderDTO();
            recOrderDTO.setId(id);
            this.finArRecVerApplyService.autoWriteoffRec(recOrderDTO);
            this.entityManager.flush();
            this.entityManager.clear();
            RecOrderDTO recOrderDTO2 = this.recOrderRepoProc.queryById(id);
            log.info("\u63d0\u4ea4\u65f6\u81ea\u52a8\u5ba1\u6838\u751f\u6210\u7684\u6536\u6b3e\u5355\u8be6\u60c5:{}", (Object)JSONUtil.toJsonStr((Object)recOrderDTO2));
            if (this.isOutterCust(recOrderDTO2)) {
                log.info("\u5916\u90e8\u5ba2\u6237,\u5ba1\u6279\u5b8c\u6210\u81ea\u52a8\u521b\u5efa\u8d26\u6237\u6d41\u6c34");
                this.recOrderDomainService.createFinFlow(recOrderDTO2);
            }
        }
        return ApiResult.ok((Object)id);
    }

    private boolean isOutterCust(RecOrderDTO recOrderDTO) {
        String inOutCust = recOrderDTO.getInOutCust();
        return "OUT".equals(inOutCust);
    }

    private void startWorkFlow(RecOrder order, Long id) {
        if (order.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(order.getProcInstStatus())) {
            String procInstName = "\u6536\u6b3e\u5355\u5ba1\u6838-" + order.getRecOrderNo();
            String procKey = WorkFlowDefKey.FIN_REC_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, id.toString(), new HashMap<String, Object>());
            this.recOrderDomainService.updateWorkInfo(processInfo, id);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMiddleVerAmt(Long recDId, BigDecimal amt) {
        RecOrderDtlDO detail = this.findDetail(recDId);
        this.doUpdateVerAmt(this.getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    private RecOrderDtlDO findDetail(Long recDId) {
        RecOrderDtlDO detail = this.recOrderDetailRepoProc.getExtRecOrderDetailAmt(recDId);
        Assert.notNull((Object)detail, (String)("\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u5355\u660e\u7ec6\uff0c\u660e\u7ec6ID:" + recDId));
        return detail;
    }

    private void doUpdateVerAmt(RecOrderAmtUpdateDTO update) {
        if (this.recOrderDetailRepoProc.updateExtVerAmt(update) == 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private void repoUpdateVerAmt(RecOrderAmtUpdateDTO update) {
        if (this.recOrderDtlRepo.updateExtVerAmt(update.getArDId(), update.getVersion(), update.getVerAmt(), update.getVerAmting(), update.getUnVerAmt()) == 0) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, RecOrderDtlDO detail) {
        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);
        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return RecOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(unVerAmt).verAmting(verAmting).verAmt(detail.getVerAmt()).version(detail.getVersion());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long recDId, BigDecimal amt, String verType) {
        RecOrderDtlDO detail = this.findDetail(recDId);
        this.doUpdateVerAmt(this.getUpdateVerAmtBuilder(amt, detail, verType).build());
    }

    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, RecOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr((Object)detail);
        log.info("\u8ba1\u7b97\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d,{}-{}", (Object)amt, (Object)infoStr);
        if ("2".equals(verType)) {
            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("\u53d6\u6d88\u6838\u9500,{}-{}-{}", new Object[]{infoStr, verAmt, unVerAmt});
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
            }
            return RecOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(unVerAmt).verAmting(detail.getApplyVerAmTing()).verAmt(verAmt).version(detail.getAuditDataVersion());
        }
        BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
        BigDecimal verAmt = detail.getVerAmt().add(amt);
        log.info("\u6838\u9500\u901a\u8fc7,{}-{}-{}", new Object[]{infoStr, verAmting, verAmt});
        if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return RecOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(detail.getUnVerAmt()).verAmting(verAmting).verAmt(verAmt).version(detail.getAuditDataVersion());
    }

    public RecOrderServiceImpl(RmiSaleRpcService rmiSaleRpcService, RecOrderDomainService recOrderDomainService, RecTypeDomainService recTypeDomainService, SystemRpcService systemRpcService, WorkflowRpcService workflowRpcService, TransactionTemplate transactionTemplate, RecOrderDtlRepoProc recOrderDtlRepoProc, RecOrderDtlRepo recOrderDtlRepo, RecOrderDetailRepoProc recOrderDetailRepoProc, FlexFieldUtilService flexFieldUtilService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, RecOrderRepoProc recOrderRepoProc) {
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.recOrderDomainService = recOrderDomainService;
        this.recTypeDomainService = recTypeDomainService;
        this.systemRpcService = systemRpcService;
        this.workflowRpcService = workflowRpcService;
        this.transactionTemplate = transactionTemplate;
        this.recOrderDtlRepoProc = recOrderDtlRepoProc;
        this.recOrderDtlRepo = recOrderDtlRepo;
        this.recOrderDetailRepoProc = recOrderDetailRepoProc;
        this.flexFieldUtilService = flexFieldUtilService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.recOrderRepoProc = recOrderRepoProc;
    }
}

