/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.report;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.facade.vo.report.IpvRespVO;
import com.elitesland.fin.application.facade.vo.report.IpvSumRespVO;
import com.elitesland.fin.application.service.report.IpvCommonService;
import com.elitesland.fin.domain.entity.report.IpvInvoiceDO;
import com.elitesland.fin.domain.param.report.IpvInvoiceComputeParam;
import com.elitesland.fin.domain.param.report.IpvInvoicePageParam;
import com.elitesland.fin.domain.param.report.IpvInvoiceParam;
import com.elitesland.fin.domain.service.report.IpvCommonDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.report.IpvInvoiceRepoProc;
import com.elitesland.fin.repo.accountingengine.InvSobAccountPeriodRepoProc;
import com.elitesland.fin.rpc.inv.RmiInvRpcService;
import com.elitesland.inv.dto.invIo.InvIoParamRpcDTO;
import com.elitesland.inv.dto.invIo.InvIoRpcDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class IpvCommonServiceImpl
implements IpvCommonService {
    private static final Logger log = LoggerFactory.getLogger(IpvCommonServiceImpl.class);
    private final IpvCommonDomainService ipvCommonDomainService;
    private final InvSobAccountPeriodRepoProc invSobAccountPeriodRepoProc;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderDtlRepo apOrderDtlRepo;
    private final IpvInvoiceRepoProc ipvInvoiceRepoProc;
    private final RmiInvRpcService rmiInvRpcService;
    private final TaskExecutor taskExecutor;
    private final RedisTemplate redisTemplate;
    private final EntityManager entityManager;
    private final TransactionTemplate transactionTemplate;

    @Override
    public PagingVO<IpvRespVO> page(IpvInvoicePageParam paramVO) {
        PagingVO<IpvRespVO> page = this.ipvCommonDomainService.page(paramVO);
        IpvSumRespVO sumRespVO = this.ipvCommonDomainService.sumIpv(paramVO);
        return page.setAggregatedData(BeanUtil.beanToMap((Object)sumRespVO, (String[])new String[0]));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void compute(IpvInvoiceComputeParam param) {
        long count = this.invSobAccountPeriodRepoProc.countAccountPeriodByParam(param.getBuDate(), param.getOuCode());
        if (count > 0L) {
            throw new BusinessException("\u5b58\u5728\u672a\u5173\u95ed\u7684\u5e93\u5b58\u4f1a\u8ba1\u671f\u95f4,\u8bf7\u68c0\u67e5\uff01");
        }
        String buDateFromStr = "2024-10-01 00:00:00";
        LocalDateTime buDateFrom = LocalDateTimeUtil.parse((CharSequence)buDateFromStr, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String buDateToStr = param.getBuDate() + "-31 23:59:59";
        LocalDateTime buDateTo = LocalDateTimeUtil.parse((CharSequence)buDateToStr, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        List unComputeArOrderDtlList = this.apOrderDtlRepo.findUnComputeArOrderDtl(buDateFrom, buDateTo, param.getOuCode()).stream().map(ApOrderDtlConvert.INSTANCE::doToDto).collect(Collectors.toList());
        if (CollUtil.isEmpty(unComputeArOrderDtlList)) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u5e94\u4ed8\u5355\u6570\u636e");
        }
        String redisKey = "IPV-COMPUTE@".concat(param.getBuDate()).concat(param.getOuCode());
        if (this.redisTemplate.hasKey((Object)redisKey).booleanValue()) {
            throw new BusinessException("\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\uff01");
        }
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)"PV-COMPUTE", 300L, TimeUnit.SECONDS);
        try {
            CompletableFuture.runAsync(() -> this.computeAndSaveIpvInvoice(unComputeArOrderDtlList, buDateFrom, buDateTo, redisKey, param.getBuDate()), (Executor)this.taskExecutor);
        }
        catch (Throwable throwable) {
            log.info("IPV\u8d26\u5355:{},\u8ba1\u7b97\u51fa\u9519:{}", (Object)param.getBuDate(), (Object)throwable);
            this.redisTemplate.delete((Object)redisKey);
        }
    }

    private void computeAndSaveIpvInvoice(List<ApOrderDtlDTO> unComputeArOrderDtlList, LocalDateTime buDateFrom, LocalDateTime buDateTo, String redisKey, String accountPeriod) {
        List<Long> masIds = unComputeArOrderDtlList.stream().map(ApOrderDtlDTO::getMasId).distinct().collect(Collectors.toList());
        List<ApOrderDTO> apOrderDTOS = this.apOrderRepoProc.queryByIds(masIds);
        Map apOrderMap = apOrderDTOS.stream().collect(Collectors.toMap(ApOrderDTO::getId, Function.identity()));
        Map<String, List<InvIoRpcDTO>> invIoBySourceNoMap = this.getInvIoBySourceNoMap(unComputeArOrderDtlList);
        Map<String, List<InvIoRpcDTO>> invIoByIdMap = this.getInvIoByIdMap(unComputeArOrderDtlList);
        ArrayList ipvInvoiceDOS = new ArrayList();
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(transactionStatus -> {
            try {
                for (ApOrderDtlDTO apOrderDtlDTO : unComputeArOrderDtlList) {
                    InvIoRpcDTO invIoRpcDTO;
                    String lotNo = "";
                    IpvInvoiceDO ipvInvoiceDO = new IpvInvoiceDO();
                    ApOrderDTO apOrderDTO = (ApOrderDTO)apOrderMap.get(apOrderDtlDTO.getMasId());
                    if (apOrderDTO == null) {
                        log.error("\u672a\u67e5\u8be2\u5230\u5e94\u6536\u5355\uff1a{}", (Object)apOrderDtlDTO.getMasId());
                        continue;
                    }
                    if (apOrderDtlDTO.getInvIoId() == null) {
                        List invIoRpcDTOs = (List)invIoBySourceNoMap.get(apOrderDtlDTO.getSourceNo() + "@" + apOrderDtlDTO.getSourceNoDid());
                        if (CollUtil.isEmpty((Collection)invIoRpcDTOs)) {
                            log.info("\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u6d41\u6c34\u4fe1\u606f[1],\u5e94\u6536\u5355\u884cID:{}", (Object)apOrderDtlDTO.getId());
                            continue;
                        }
                        invIoRpcDTO = (InvIoRpcDTO)invIoRpcDTOs.get(0);
                        ipvInvoiceDO.setWhId(invIoRpcDTO.getWhId());
                        ipvInvoiceDO.setWhCode(invIoRpcDTO.getWhCode());
                        ipvInvoiceDO.setWhName(invIoRpcDTO.getWhName());
                        lotNo = invIoRpcDTO.getLotNo();
                    } else {
                        List invIoRpcDTOS = (List)invIoByIdMap.get(apOrderDtlDTO.getSourceNo() + "@" + apOrderDtlDTO.getSourceNoDid());
                        if (CollUtil.isEmpty((Collection)invIoRpcDTOS)) {
                            log.info("\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u6d41\u6c34\u4fe1\u606f[2],\u5e94\u6536\u5355\u884cID:{}", (Object)apOrderDtlDTO.getId());
                            continue;
                        }
                        invIoRpcDTO = (InvIoRpcDTO)invIoRpcDTOS.get(0);
                        ipvInvoiceDO.setWhId(invIoRpcDTO.getWhId());
                        ipvInvoiceDO.setWhCode(invIoRpcDTO.getWhCode());
                        ipvInvoiceDO.setWhName(invIoRpcDTO.getWhName());
                        lotNo = invIoRpcDTO.getLotNo();
                    }
                    ipvInvoiceDO.setApOrderNo(apOrderDTO.getApOrderNo());
                    ipvInvoiceDO.setApOrderDid(apOrderDtlDTO.getId());
                    ipvInvoiceDO.setSourceDocNo(apOrderDtlDTO.getSourceNo());
                    ipvInvoiceDO.setSourceLineNo(apOrderDtlDTO.getSourceLine());
                    ipvInvoiceDO.setItemId(apOrderDtlDTO.getItemId());
                    ipvInvoiceDO.setItemCode(apOrderDtlDTO.getItemCode());
                    ipvInvoiceDO.setItemName(apOrderDtlDTO.getItemName());
                    ipvInvoiceDO.setItemType(apOrderDtlDTO.getItemType());
                    ipvInvoiceDO.setOuId(apOrderDTO.getOuId());
                    ipvInvoiceDO.setOuCode(apOrderDTO.getOuCode());
                    ipvInvoiceDO.setOuName(apOrderDTO.getOuName());
                    ipvInvoiceDO.setSuppId(apOrderDTO.getSuppId());
                    ipvInvoiceDO.setSuppCode(apOrderDTO.getSuppCode());
                    ipvInvoiceDO.setSuppName(apOrderDTO.getSuppName());
                    ipvInvoiceDO.setSmallCateCode(apOrderDtlDTO.getSmallCateCode());
                    ipvInvoiceDO.setSmallCateName(apOrderDtlDTO.getSmallCateName());
                    BigDecimal ipv = apOrderDtlDTO.getInvoicePriceVariance();
                    ipvInvoiceDO.setFinDate(apOrderDTO.getBuDate());
                    ipvInvoiceDO.setApQty(apOrderDtlDTO.getQty());
                    ipvInvoiceDO.setUom(apOrderDtlDTO.getUom());
                    ipvInvoiceDO.setAccountPeriod(accountPeriod);
                    ipvInvoiceDO.setIpv(ipv);
                    Boolean ipvFlag = Boolean.FALSE;
                    Boolean flag = this.buildIpvAttr(buDateFrom, buDateTo, apOrderDtlDTO, ipvInvoiceDO, apOrderDTO, lotNo, ipvFlag);
                    if (!flag.booleanValue()) continue;
                    ipvInvoiceDOS.add(ipvInvoiceDO);
                    this.apOrderDtlRepoProc.updateIpvFlagById(apOrderDtlDTO.getId(), ipvFlag);
                }
                this.batchInsert(ipvInvoiceDOS);
            }
            catch (Exception e) {
                log.error("\u3010soAutoAlloc\u3011\u6279\u91cf\u81ea\u52a8\u914d\u8d27\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                transactionStatus.setRollbackOnly();
            }
            return "ok";
        });
        this.redisTemplate.delete((Object)redisKey);
    }

    private Map<String, List<InvIoRpcDTO>> getInvIoBySourceNoMap(List<ApOrderDtlDTO> unComputeArOrderDtlList) {
        Set sourceNos = unComputeArOrderDtlList.stream().filter(row -> row.getInvIoId() == null).map(ApOrderDtlDTO::getSourceNo).distinct().collect(Collectors.toSet());
        if (CollUtil.isEmpty(sourceNos)) {
            return new HashMap<String, List<InvIoRpcDTO>>();
        }
        List<InvIoRpcDTO> invIoRpcDTOS = this.rmiInvRpcService.findWhBySourceNos(new ArrayList<String>(sourceNos));
        if (CollUtil.isEmpty(invIoRpcDTOS)) {
            return new HashMap<String, List<InvIoRpcDTO>>();
        }
        return invIoRpcDTOS.stream().collect(Collectors.groupingBy(row -> row.getSourceNo() + "@" + row.getSrcDocDid()));
    }

    private Map<String, List<InvIoRpcDTO>> getInvIoByIdMap(List<ApOrderDtlDTO> unComputeArOrderDtlList) {
        Set ioIds = unComputeArOrderDtlList.stream().filter(row -> row.getInvIoId() != null).map(ApOrderDtlDTO::getInvIoId).distinct().collect(Collectors.toSet());
        if (CollUtil.isEmpty(ioIds)) {
            return new HashMap<String, List<InvIoRpcDTO>>();
        }
        List<InvIoRpcDTO> invIoRpcDTOS = this.rmiInvRpcService.findInvIoByIds(new ArrayList<Long>(ioIds));
        if (CollUtil.isEmpty(invIoRpcDTOS)) {
            return new HashMap<String, List<InvIoRpcDTO>>();
        }
        return invIoRpcDTOS.stream().collect(Collectors.groupingBy(row -> row.getSourceNo() + "@" + row.getSrcDocDid()));
    }

    private Boolean buildIpvAttr(LocalDateTime buDateFrom, LocalDateTime buDateTo, ApOrderDtlDTO apOrderDtlDTO, IpvInvoiceDO ipvInvoiceDO, ApOrderDTO apOrderDTO, String lotNo, Boolean ipvFlag) {
        BigDecimal ipv = ipvInvoiceDO.getIpv();
        if (ipvInvoiceDO.getApQty().compareTo(BigDecimal.ZERO) < 0) {
            ipvInvoiceDO.setRatioAmt(ipvInvoiceDO.getIpv());
            ipvFlag = Boolean.TRUE;
            return Boolean.TRUE;
        }
        if (ipv.abs().compareTo(BigDecimal.ONE) <= 0) {
            ipvInvoiceDO.setRatioAmt(ipvInvoiceDO.getIpv());
            ipvFlag = Boolean.TRUE;
            return Boolean.TRUE;
        }
        IpvInvoiceParam ipvInvoiceParam = new IpvInvoiceParam();
        ipvInvoiceParam.setApOrderNo(apOrderDTO.getApOrderNo());
        ipvInvoiceParam.setSourceDocNo(apOrderDtlDTO.getSourceNo());
        ipvInvoiceParam.setSourceLineNo(apOrderDtlDTO.getSourceLine());
        IpvRespVO ipvRespVO = this.ipvInvoiceRepoProc.findIpvByParam(ipvInvoiceParam);
        BigDecimal saledQty = ipvRespVO.getSaleQty() == null ? BigDecimal.ZERO : ipvRespVO.getSaleQty();
        BigDecimal saleRatio = ipvRespVO.getSaleRatio() == null ? BigDecimal.ZERO : ipvRespVO.getSaleRatio();
        BigDecimal ratioAmt = ipvRespVO.getRatioAmt() == null ? BigDecimal.ZERO : ipvRespVO.getRatioAmt();
        InvIoParamRpcDTO invIoParamRpcDTO = new InvIoParamRpcDTO();
        invIoParamRpcDTO.setWhId(ipvInvoiceDO.getWhId());
        invIoParamRpcDTO.setOuId(apOrderDTO.getOuId());
        invIoParamRpcDTO.setLotNo(lotNo);
        invIoParamRpcDTO.setItemId(apOrderDtlDTO.getItemId());
        invIoParamRpcDTO.setIoDateFrom(buDateFrom);
        invIoParamRpcDTO.setIoDateTo(buDateTo);
        invIoParamRpcDTO.setToUom(apOrderDtlDTO.getUom());
        List<InvIoRpcDTO> saleOutList = this.rmiInvRpcService.findSaleOutByParam(invIoParamRpcDTO);
        if (CollUtil.isEmpty(saleOutList)) {
            log.info("\u67e5\u8be2\u9500\u552e\u51fa\u5e93\u6570\u636e\u4e3a\u7a7a:{}", (Object)apOrderDtlDTO.getId());
            return Boolean.FALSE;
        }
        InvIoRpcDTO salOutInfo = saleOutList.get(0);
        BigDecimal subtractQty = apOrderDtlDTO.getQty().subtract(saledQty);
        if (salOutInfo.getConvertQty().compareTo(subtractQty) >= 0) {
            ipvInvoiceDO.setSaleQty(subtractQty);
            ipvInvoiceDO.setSaleRatio(BigDecimal.ONE.subtract(saleRatio));
            ipvInvoiceDO.setRatioAmt(ipv.subtract(ratioAmt));
            ipvFlag = Boolean.TRUE;
        } else {
            ipvInvoiceDO.setSaleQty(salOutInfo.getConvertQty());
            ipvInvoiceDO.setSaleRatio(ipvInvoiceDO.getSaleQty().divide(apOrderDtlDTO.getQty(), 4, RoundingMode.HALF_UP));
            ipvInvoiceDO.setRatioAmt(ipvInvoiceDO.getSaleRatio().multiply(ipv));
            ipvFlag = Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void batchInsert(List<IpvInvoiceDO> dataList) {
        int index = 0;
        int batchSize = 500;
        for (IpvInvoiceDO data : dataList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!dataList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    public IpvCommonServiceImpl(IpvCommonDomainService ipvCommonDomainService, InvSobAccountPeriodRepoProc invSobAccountPeriodRepoProc, ApOrderDtlRepoProc apOrderDtlRepoProc, ApOrderRepoProc apOrderRepoProc, ApOrderDtlRepo apOrderDtlRepo, IpvInvoiceRepoProc ipvInvoiceRepoProc, RmiInvRpcService rmiInvRpcService, TaskExecutor taskExecutor, RedisTemplate redisTemplate, EntityManager entityManager, TransactionTemplate transactionTemplate) {
        this.ipvCommonDomainService = ipvCommonDomainService;
        this.invSobAccountPeriodRepoProc = invSobAccountPeriodRepoProc;
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.apOrderRepoProc = apOrderRepoProc;
        this.apOrderDtlRepo = apOrderDtlRepo;
        this.ipvInvoiceRepoProc = ipvInvoiceRepoProc;
        this.rmiInvRpcService = rmiInvRpcService;
        this.taskExecutor = taskExecutor;
        this.redisTemplate = redisTemplate;
        this.entityManager = entityManager;
        this.transactionTemplate = transactionTemplate;
    }
}

