/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.report;

import cn.hutool.core.util.StrUtil;
import com.elitesland.fin.application.facade.vo.report.IpvRespVO;
import com.elitesland.fin.application.facade.vo.report.IpvSumRespVO;
import com.elitesland.fin.domain.entity.report.IpvInvoiceDO;
import com.elitesland.fin.domain.entity.report.QIpvInvoiceDO;
import com.elitesland.fin.domain.param.report.IpvInvoicePageParam;
import com.elitesland.fin.domain.param.report.IpvInvoiceParam;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class IpvInvoiceRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QIpvInvoiceDO ipvInvoiceDO = QIpvInvoiceDO.ipvInvoiceDO;
    private final QBean<IpvRespVO> pageList;

    public long countIpvInvoice(IpvInvoicePageParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.ipvInvoiceDO.count()).from((EntityPath)this.ipvInvoiceDO);
        jpaQuery.where(this.whereIpvInvoice(paramVO));
        BusinessSecurityUtil.where(jpaQuery, IpvInvoiceDO.class);
        return jpaQuery.fetchCount();
    }

    public List<IpvRespVO> queryIpvInvoice(IpvInvoicePageParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)this.ipvInvoiceDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, this.ipvInvoiceDO);
        jpaQuery.where(this.whereIpvInvoice(paramVO));
        BusinessSecurityUtil.where(jpaQuery, IpvInvoiceDO.class);
        return jpaQuery.fetch();
    }

    private Predicate whereIpvInvoice(IpvInvoicePageParam paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (paramVO.getOuId() != null) {
            predicates.add(this.ipvInvoiceDO.ouId.eq((Object)paramVO.getOuId()));
        }
        if (paramVO.getWhId() != null) {
            predicates.add(this.ipvInvoiceDO.whId.eq((Object)paramVO.getWhId()));
        }
        if (paramVO.getItemId() != null) {
            predicates.add(this.ipvInvoiceDO.itemId.eq((Object)paramVO.getItemId()));
        }
        if (paramVO.getSuppId() != null) {
            predicates.add(this.ipvInvoiceDO.suppId.eq((Object)paramVO.getSuppId()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocNo())) {
            predicates.add(this.ipvInvoiceDO.sourceDocNo.like(paramVO.getDocNo() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getFinDateFrom()) && !ObjectUtils.isEmpty((Object)paramVO.getFinDateTo())) {
            predicates.add(this.ipvInvoiceDO.finDate.between((Comparable)paramVO.getFinDateFrom(), (Comparable)paramVO.getFinDateTo()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getAccountPeriod())) {
            predicates.add(this.ipvInvoiceDO.accountPeriod.eq((Object)paramVO.getAccountPeriod()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public IpvRespVO findIpvByParam(IpvInvoiceParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(IpvRespVO.class, (Expression[])new Expression[]{this.ipvInvoiceDO.saleQty.sum().as("saleQty"), this.ipvInvoiceDO.saleRatio.sum().as("saleRatio"), this.ipvInvoiceDO.ratioAmt.sum().as("ratioAmt")})).from((EntityPath)this.ipvInvoiceDO);
        if (StrUtil.isNotBlank((CharSequence)param.getApOrderNo())) {
            jpaQuery.where((Predicate)this.ipvInvoiceDO.apOrderNo.eq((Object)param.getApOrderNo()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getSourceDocNo())) {
            jpaQuery.where((Predicate)this.ipvInvoiceDO.sourceDocNo.eq((Object)param.getSourceDocNo()));
        }
        if (param.getSourceLineNo() != null) {
            jpaQuery.where((Predicate)this.ipvInvoiceDO.sourceLineNo.eq((Object)param.getSourceLineNo()));
        }
        return (IpvRespVO)jpaQuery.fetchOne();
    }

    public IpvSumRespVO sumIpvInvoice(IpvInvoicePageParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(IpvSumRespVO.class, (Expression[])new Expression[]{this.ipvInvoiceDO.apQty.sum().as("sumApQty"), this.ipvInvoiceDO.ipv.sum().as("sumIpv"), this.ipvInvoiceDO.ratioAmt.sum().as("sumRatioAmt")})).from((EntityPath)this.ipvInvoiceDO);
        jpaQuery.where(this.whereIpvInvoice(paramVO));
        BusinessSecurityUtil.where(jpaQuery, IpvInvoiceDO.class);
        return (IpvSumRespVO)jpaQuery.fetchOne();
    }

    public IpvInvoiceRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(IpvRespVO.class, (Expression[])new Expression[]{this.ipvInvoiceDO.id, this.ipvInvoiceDO.apOrderNo, this.ipvInvoiceDO.sourceDocNo, this.ipvInvoiceDO.sourceLineNo, this.ipvInvoiceDO.ouCode, this.ipvInvoiceDO.ouName, this.ipvInvoiceDO.suppCode, this.ipvInvoiceDO.suppName, this.ipvInvoiceDO.whCode, this.ipvInvoiceDO.whName, this.ipvInvoiceDO.itemCode, this.ipvInvoiceDO.itemName, this.ipvInvoiceDO.itemType, this.ipvInvoiceDO.finDate, this.ipvInvoiceDO.apQty, this.ipvInvoiceDO.saleQty, this.ipvInvoiceDO.saleRatio, this.ipvInvoiceDO.ratioAmt, this.ipvInvoiceDO.ipv, this.ipvInvoiceDO.uom, this.ipvInvoiceDO.ratioAmt, this.ipvInvoiceDO.accountPeriod, this.ipvInvoiceDO.smallCateCode, this.ipvInvoiceDO.smallCateName});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

