/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.account;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.account.AccountBalanceConvert;
import com.elitesland.fin.application.facade.param.account.AccountBalanceParam;
import com.elitesland.fin.application.facade.vo.account.AccountBalanceVO;
import com.elitesland.fin.application.service.account.AccountBalanceService;
import com.elitesland.fin.dto.account.AccountBalanceRpcDTO;
import com.elitesland.fin.param.account.AccountBalanceRpcParam;
import com.elitesland.fin.service.account.AccountBalanceRpcService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/account/balance"})
public class AccountBalanceRpcServiceImpl
implements AccountBalanceRpcService {
    private static final Logger log = LoggerFactory.getLogger(AccountBalanceRpcServiceImpl.class);
    public final AccountBalanceService accountBalanceService;

    public ApiResult<List<AccountBalanceRpcDTO>> selectAccountBalanceByParam(AccountBalanceRpcParam accountRpcParam) {
        AccountBalanceParam accountBalanceParam = AccountBalanceConvert.INSTANCE.rpcParamToParam(accountRpcParam);
        List<AccountBalanceVO> accountBalanceVOList = this.accountBalanceService.selectAccountBalanceByParam(accountBalanceParam);
        if (CollectionUtil.isEmpty(accountBalanceVOList)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List accountBalanceRpcDTOList = accountBalanceVOList.stream().map(AccountBalanceConvert.INSTANCE::voToRpcDto).collect(Collectors.toList());
        return ApiResult.ok(accountBalanceRpcDTOList);
    }

    public AccountBalanceRpcServiceImpl(AccountBalanceService accountBalanceService) {
        this.accountBalanceService = accountBalanceService;
    }
}

