package com.elitesland.fin.application.facade.param.adjustorder;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:47
 */
@Data
@ApiModel(description = "调整单保存参数")
public class AdjustOrderSaveParam extends CustomFieldBaseModel {
    private static final long serialVersionUID = 2526557077093215197L;
    @ApiModelProperty("调整单号")
    private String docNo;

    @ApiModelProperty("单据类型")
    private String type;

    @ApiModelProperty("单据状态")
    private String state;

    @ApiModelProperty("调整类型")
    private String adjType;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("开户主体类型")
    @SysCode(sys = "yst-fin", mod = "PRINCIPAL_TYPE")
    private String accountHolderType;

    @ApiModelProperty("开户主体类型名称")
    private String accountHolderTypeName;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    @SysCode(sys = "yst-fin", mod = "UNION_PAY")
    private String accountName;
    private String accountNameName;

    @ApiModelProperty("调整金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("调整原因")
    private String adjReason;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("记账时间")
    private LocalDateTime recAccTime;

    @ApiModelProperty("流程实例id")
    private String procInstId;
}
