package com.elitesland.fin.application.facade.vo.payment;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Data
@ApiModel("分页传输类")
public class PaymentRuleConfigPageVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 4212038342420493568L;

    @ApiModelProperty("编码")
    private String ruleCode;

    @ApiModelProperty("名称")
    private String ruleName;

    @ApiModelProperty("适用单据")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String optDoc;
    private String optDocName;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

//    @ApiModelProperty(value = "事务码")
//    private String ioCode;
//
//    @ApiModelProperty("事务码名称")
//    private String ioName;

    @ApiModelProperty("适用单据类型")
    private String optDocType;

    @ApiModelProperty("适用单据类型名称")
    private String optDocTypeName;

    @ApiModelProperty("适用单据状态")
    @SysCode(sys = "yst-supp",mod = "DOC_STATUS")
    private String optDocStatus;
    private String optDocStatusName;

    @ApiModelProperty("扣款账户类型")
    @SysCode(sys = "yst-fin",mod = "DEDUCTION_ACCOUNT_TYPE")
    private String optAccountType;
    private String optAccountTypeName;

    @ApiModelProperty("最高透支额度")
    private BigDecimal maxLimit;

    @ApiModelProperty(value = "优先级")
    private Integer priorityNo;

    @ApiModelProperty("最高扣款比例")
    private BigDecimal calculatePercent;

    @ApiModelProperty(value = "流水自动审核 1-是 0-否")
    private boolean automaticReview;
}