package com.elitesland.fin.application.facade.dto.invoice;


import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class InvoiceAwaitDDTO {

    @ApiModelProperty("明细表ID")
    private Long id;

    @ApiModelProperty("付款记录表头ID")
    private Long masId;

    @ApiModelProperty("明细行号")
    private BigDecimal lineNo;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("税收分类编码")
    private String taxType;

    @ApiModelProperty("应税货物或劳务、服务名称")
    private String serviceName;

    @ApiModelProperty("规格")
    private String itemSpec;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("含税单价")
    private BigDecimal originAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal tax;

    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("返利冲抵金额")
    private BigDecimal flDeductionAmt;

    @ApiModelProperty("票扣含税金额")
    private BigDecimal invDiscountAmt;

    @ApiModelProperty("折扣额")
    private BigDecimal discountAmt;

    @ApiModelProperty("可开票含税金额")
    private BigDecimal invAmt;

    @ApiModelProperty("发/收货单号")
    private String docNo;

    @ApiModelProperty("发货/收货单明细id")
    private Long relateDocDid;

    @ApiModelProperty("来源单据明细表ID")
    private Long optDocDtlId;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户姓名")
    private String custName;

    @ApiModelProperty("发货日期")
    private LocalDateTime shipTime;

    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("销/退订单号")
    private String logisDocNo;

    @ApiModelProperty("订单类型")
    private String relateDocType;

    @ApiModelProperty("订单日期")
    private LocalDateTime soDate;

    @ApiModelProperty("下单渠道类型")
    //    @SysCode(sys = "yst-order", mod = "SO_SOURCE")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String soSource;
    private String soSourceName;

    @ApiModelProperty("是否赠品")
    private String giftsFlag;

    @ApiModelProperty("本次对账数量")
    private BigDecimal soaQty;

    @ApiModelProperty("折扣后主含税单价")
    private BigDecimal discountPrice;

    @ApiModelProperty("对账含税金额")
    private BigDecimal soaAmt;

    @ApiModelProperty("发票折扣率")
    private BigDecimal invDiscount;

    @ApiModelProperty("可开票税额")
    private BigDecimal invTaxAmt;

    @ApiModelProperty("可开票未税金额")
    private BigDecimal invNetAmt;

    @ApiModelProperty("原主含税单价")
    private BigDecimal mainPrice;

    @ApiModelProperty("单品折扣")
    private BigDecimal itemDiscount;

    @ApiModelProperty("业务员员工名字")
    private String agentName;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("收货联系人")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("商品id")
    private Long itemId;

}
