package com.elitesland.fin.repo.expense;


import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerQueryParam;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerDetailRespVO;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerPageVO;
import com.elitesland.fin.entity.expense.ExpLedgerDO;
import com.elitesland.fin.entity.expense.QExpLedgerDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @Auther: Mark
 * @Date: 2024/8/13 13:23
 * @Description:
 */
@Slf4j
@Component
@AllArgsConstructor
public class ExpLedgerRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QExpLedgerDO qExpLedgerDO = QExpLedgerDO.expLedgerDO;

    public ExpLedgerDetailRespVO detail(Long id) {
        QExpLedgerDO jpaQDo = QExpLedgerDO.expLedgerDO;
        return jpaQueryFactory.select(Projections.bean(
                ExpLedgerDetailRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.ouCode,
                jpaQDo.ouName,
                jpaQDo.carrierType,
                jpaQDo.carrier,
                jpaQDo.brand,
                jpaQDo.custId,
                jpaQDo.custCode,
                jpaQDo.custName,
                jpaQDo.storeId,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.expTypeCode,
                jpaQDo.expTypeName,
                jpaQDo.docType,
                jpaQDo.sourceDocNo,
                jpaQDo.sourceDocNoDate,
                jpaQDo.amt,
                jpaQDo.netAmt,
                jpaQDo.taxAmt,
                jpaQDo.docAmt,
                jpaQDo.taxRate,
                jpaQDo.ruleName,
                jpaQDo.orderState,
                jpaQDo.calState,
                jpaQDo.calError,
                jpaQDo.finFlag,
                jpaQDo.finError,
                jpaQDo.stockNo,
                jpaQDo.stockDate,
                jpaQDo.whCode,
                jpaQDo.whName
        )).from(jpaQDo).where(jpaQDo.id.eq(id)).fetchOne();
    }

    public List<ExpLedgerDO> findBySourceNoList(List<String> sourceNoList) {
        QExpLedgerDO jpaQDo = QExpLedgerDO.expLedgerDO;
        return jpaQueryFactory.selectFrom(jpaQDo).where(jpaQDo.sourceDocNo.in(sourceNoList)).fetch();
    }

    public PagingVO<ExpLedgerPageVO> searchPage(ExpLedgerQueryParam param) {
        QExpLedgerDO jpaQDo = QExpLedgerDO.expLedgerDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(
                ExpLedgerPageVO.class,
                jpaQDo.id,
                jpaQDo.ouCode,
                jpaQDo.ouName,
                jpaQDo.carrier,
                jpaQDo.carrierName,
                jpaQDo.brand,
                jpaQDo.brandName,
                jpaQDo.custCode,
                jpaQDo.custName,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.expTypeCode,
                jpaQDo.expTypeName,
                jpaQDo.docType,
                jpaQDo.docTypeName,
                jpaQDo.sourceDocNo,
                jpaQDo.sourceDocNoDate,
                jpaQDo.amt,
                jpaQDo.netAmt,
                jpaQDo.taxAmt,
                jpaQDo.docAmt,
                jpaQDo.taxRate,
                jpaQDo.ruleName,
                jpaQDo.orderState,
                jpaQDo.finFlag,
                jpaQDo.finError,
                jpaQDo.calError,
                jpaQDo.calState,
                jpaQDo.creator,
                jpaQDo.createTime,
                jpaQDo.stockNo,
                jpaQDo.stockDate,
                jpaQDo.whCode,
                jpaQDo.whName
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return PagingVO.<ExpLedgerPageVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private Predicate where(ExpLedgerQueryParam param) {
        val jpaQDo = QExpLedgerDO.expLedgerDO;
        Predicate predicate = jpaQDo.isNotNull();

        if (StrUtil.isNotBlank(param.getOuCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouCode.eq(param.getOuCode()));
        }
        if (StrUtil.isNotBlank(param.getCarrier())) {
            predicate = ExpressionUtils.and(predicate,
                    jpaQDo.carrier.eq(param.getCarrier()));
        }
        if (StrUtil.isNotBlank(param.getCustCode())) {
            predicate = ExpressionUtils.and(predicate,
                    jpaQDo.custCode.eq(param.getCustCode()));
        }
        if (StrUtil.isNotBlank(param.getExpTypeCode())) {
            predicate = ExpressionUtils.and(predicate,
                    jpaQDo.expTypeCode.eq(param.getExpTypeCode()));
        }
        if (StrUtil.isNotBlank(param.getStoreCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeCode.eq(param.getStoreCode()));
        }
        if (StrUtil.isNotBlank(param.getDocType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.docType.eq(param.getDocType()));
        }
        if (StrUtil.isNotBlank(param.getSourceDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.sourceDocNo.eq(param.getSourceDocNo()));
        }
        if (StrUtil.isNotBlank(param.getCalState())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.calState.eq(param.getCalState()));
        }
        if (StrUtil.isNotBlank(param.getOrderState())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.orderState.eq(param.getOrderState()));
        }
        if (param.getSourceDocNoDateStart() != null && param.getSourceDocNoDateEnd() != null) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.sourceDocNoDate.between(param.getSourceDocNoDateStart()
                    , param.getSourceDocNoDateEnd()));
        }
        if (StringUtils.isNotBlank(param.getFinFlag())) {
            if (Objects.equals(param.getFinFlag(),"0")){
                predicate = ExpressionUtils.and(predicate, jpaQDo.finFlag.eq(param.getFinFlag()).or(jpaQDo.finFlag.isNull()));

            }else {
                predicate = ExpressionUtils.and(predicate, jpaQDo.finFlag.eq(param.getFinFlag()));
            }

        }

        return predicate;
    }

    public List<ExpLedgerPageVO> selectListByParam(ExpLedgerQueryParam param) {
        List<Predicate> where = expLedgerWhere(param);
        JPAQuery<ExpLedgerPageVO> query = select(ExpLedgerPageVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> expLedgerWhere(ExpLedgerQueryParam param) {
        List<Predicate> predicates = new ArrayList<>();

        if (StringUtils.isNotBlank(param.getOuCode())) {
            predicates.add(qExpLedgerDO.ouCode.eq(param.getOuCode()));
            //predicate = ExpressionUtils.and(predicate, jpaQDo.sourceDocNo.eq(param.getSourceDocNo()));
        }
        if (StringUtils.isNotBlank(param.getCarrier())) {
            predicates.add(qExpLedgerDO.carrier.eq(param.getCarrier()));
        }
        if (param.getSourceDocNoDateStart() != null && param.getSourceDocNoDateEnd() != null) {
           /* predicate = ExpressionUtils.and(predicate, jpaQDo.sourceDocNoDate.between(param.getSourceDocNoDateStart()
                    , param.getSourceDocNoDateEnd()));*/
            predicates.add(qExpLedgerDO.sourceDocNoDate.between(param.getSourceDocNoDateStart()
                    , param.getSourceDocNoDateEnd()));

        }
        /*//开始交易日期
        if (param.getSourceDocNoDateStart() != null) {
            predicates.add(qExpLedgerDO.sourceDocNoDate.goe(param.getSourceDocNoDateStart()));
        }
        //结束交易日期
        if (param.getSourceDocNoDateEnd() != null) {
            predicates.add(qExpLedgerDO.sourceDocNoDate.loe(param.getSourceDocNoDateEnd()));
        }*/

        if (StringUtils.isNotBlank(param.getExpTypeCode())) {
            predicates.add(qExpLedgerDO.expTypeCode.eq(param.getExpTypeCode()));
        }
        if (StrUtil.isNotBlank(param.getOrderState())) {
            predicates.add(qExpLedgerDO.orderState.eq(param.getOrderState()));
        }
        if (StringUtils.isNotBlank(param.getFinFlag())) {
            predicates.add(qExpLedgerDO.finFlag.eq(param.getFinFlag()));
        }
        if (Objects.nonNull(param.getNotGenerateFinFlag()) && param.getNotGenerateFinFlag()) {
            predicates.add(qExpLedgerDO.finFlag.eq("0").or(qExpLedgerDO.finFlag.isNull()));
        }

       /* //增加扩展字段查询条件begin
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate(param.getConditions(), ExpLedgerDO.class);
        if(customFieldPredicate!=null){
            predicates.add(customFieldPredicate);
        }*/
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qExpLedgerDO.id,
                qExpLedgerDO.ouCode,
                qExpLedgerDO.ouName,
                qExpLedgerDO.carrier,
                qExpLedgerDO.carrierName,
                qExpLedgerDO.brand,
                qExpLedgerDO.brandName,
                qExpLedgerDO.custCode,
                qExpLedgerDO.custName,
                qExpLedgerDO.storeCode,
                qExpLedgerDO.storeName,
                qExpLedgerDO.expTypeCode,
                qExpLedgerDO.expTypeName,
                qExpLedgerDO.docType,
                qExpLedgerDO.docTypeName,
                qExpLedgerDO.sourceDocNo,
                qExpLedgerDO.sourceDocNoDate,
                qExpLedgerDO.amt,
                qExpLedgerDO.netAmt,
                qExpLedgerDO.taxAmt,
                qExpLedgerDO.docAmt,
                qExpLedgerDO.taxRate,
                qExpLedgerDO.ruleName,
                qExpLedgerDO.orderState,
                qExpLedgerDO.finFlag,
                qExpLedgerDO.finError,
                qExpLedgerDO.calError,
                qExpLedgerDO.calState,
                qExpLedgerDO.remark,
                qExpLedgerDO.createTime,
                qExpLedgerDO.createUserId,
                qExpLedgerDO.creator,
                qExpLedgerDO.modifyTime,
                qExpLedgerDO.modifyUserId,
                qExpLedgerDO.updater,
                qExpLedgerDO.tenantId,
                qExpLedgerDO.deleteFlag
        )).from(qExpLedgerDO);
    }


    public void updateFinFlagByIds(List<Long> ids,String finFlag) {
        jpaQueryFactory.update(qExpLedgerDO)
                .set(qExpLedgerDO.finFlag, finFlag)
                .where(qExpLedgerDO.id.in(ids))
                .execute();
    }

    public void updateFinFlagBySourceDocNos(List<String> sourceDocNos,String finFlag) {
        jpaQueryFactory.update(qExpLedgerDO)
                .set(qExpLedgerDO.finFlag, finFlag)
                .where(qExpLedgerDO.sourceDocNo.in(sourceDocNos))
                .execute();
    }

    public void deleteBySourceNoList(List<String> sourceDocNos) {
        jpaQueryFactory.update(qExpLedgerDO).set(qExpLedgerDO.deleteFlag, 1).where(qExpLedgerDO.sourceDocNo.in(sourceDocNos)).execute();
    }


}
