/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.payment;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.payment.PaymentRuleConfigConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDTO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditSettingDetailVO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigQueryVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.creditaccount.CreditSettingService;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.application.service.redis.MyRedisService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.payment.PaymentRuleConfigDomainService;
import com.elitesland.fin.entity.payment.PaymentRuleConfigDO;
import com.elitesland.fin.repo.payment.PaymentRuleConfigRepo;
import com.elitesland.fin.repo.payment.PaymentRuleConfigRepoProc;
import com.elitesland.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.utils.SysUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class PaymentRuleConfigDomainServiceImpl
implements PaymentRuleConfigDomainService {
    private static final Logger log = LoggerFactory.getLogger(PaymentRuleConfigDomainServiceImpl.class);
    private final PaymentRuleConfigRepo paymentRuleConfigRepo;
    private final PaymentRuleConfigRepoProc paymentRuleConfigRepoProc;
    private final CreditAccountService creditAccountService;
    private final AccountService accountService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final CreditAccountFlowService creditAccountFlowService;
    private final AccountFlowService accountFlowService;
    private final FinSalMqProcessor finSalMqProcessor;
    private final UdcProvider udcProvider;
    private final CreditSettingService creditSettingService;
    private final ArOrderDomainService arOrderDomainService;
    private static final BigDecimal ONE_HUNDRED_BIGDECIMAL = new BigDecimal("100");
    private final UdcProvider sysUdcService;
    private final MyRedisService myRedisService;

    @Override
    @SysCodeProc
    public Optional<PaymentRuleConfigDO> findById(Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return Optional.empty();
        }
        return this.paymentRuleConfigRepo.findById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long id) {
        this.paymentRuleConfigRepo.deleteById(id);
    }

    @Override
    public void updateDynamically(PaymentRuleConfigDO invSceneConfigDO) {
        this.paymentRuleConfigRepoProc.updateDynamically(invSceneConfigDO);
    }

    @Override
    public PagingVO<PaymentRuleConfigPageVO> searchPage(PaymentRuleConfigParam param) {
        return this.paymentRuleConfigRepoProc.searchPage(param);
    }

    @Override
    public List<PaymentRuleConfigQueryVO> findRuleConfigByRuleCode(String ruleCode) {
        List<PaymentRuleConfigDO> sceneConfigDOS = this.paymentRuleConfigRepo.findAllByRuleCode(ruleCode);
        return sceneConfigDOS.stream().map(PaymentRuleConfigConvert.INSTANCE::do2VO).collect(Collectors.toList());
    }

    @Override
    public PaymentRuleConfigDTO findByRuleCode(String ruleCode) {
        List<PaymentRuleConfigDO> sceneConfigDOS = this.paymentRuleConfigRepo.findAllByRuleCode(ruleCode);
        if (!CollectionUtils.isEmpty(sceneConfigDOS)) {
            return PaymentRuleConfigConvert.INSTANCE.do2DTO(sceneConfigDOS.get(0));
        }
        return null;
    }

    @Override
    public List<PaymentRuleConfigDtlDTO> queryAccountAmount(PaymentRuleConfigParam param) {
        log.info("\u8d22\u52a1\u8d26\u6237\u67e5\u8be2\u63a5\u53e3\uff0c\u63a5\u6536\u5230\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)((Object)param)));
        this.checkQueryAccountAmountParam(param);
        PaymentRuleConfigParam paymentRuleConfigParam = PaymentRuleConfigConvert.INSTANCE.copyParam(param);
        this.buildPaymentRuleConfigParam(paymentRuleConfigParam);
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList = this.queryPaymentRuleConfigDtlWithRedis(paymentRuleConfigParam);
        Assert.notEmpty(paymentRuleConfigDtlDTOList, (String)"\u672a\u5339\u914d\u5230\u652f\u4ed8\u914d\u7f6e", (Object[])new Object[0]);
        Set<Long> ids = paymentRuleConfigParam.getPaymentRuleConfigDtlIds();
        if (CollectionUtils.isNotEmpty(ids)) {
            Assert.isTrue((paymentRuleConfigDtlDTOList.stream().filter(item -> ids.contains(item.getId())).count() == (long)ids.size() ? 1 : 0) != 0, (String)"\u8d22\u52a1\u652f\u4ed8\u914d\u7f6e\u548c\u5165\u53c2\u652f\u4ed8\u89c4\u5219\u660e\u7ec6id\u4e0d\u5339\u914d", (Object[])new Object[0]);
            this.setCalculateFlag(paymentRuleConfigDtlDTOList, ids);
        }
        this.checkRebateAmount(paymentRuleConfigParam, paymentRuleConfigDtlDTOList);
        paymentRuleConfigParam.setObjectGroupCode(this.rmiSaleRpcService.getCustGroupCodeByCustCode(paymentRuleConfigParam.getObjectCode()));
        List<PaymentRuleConfigDtlDTO> result = this.getAccountAndAmount(paymentRuleConfigParam, paymentRuleConfigDtlDTOList);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        this.buildPayList(paymentRuleConfigParam, result);
        this.setAmount(paymentRuleConfigParam, result);
        return result;
    }

    @Override
    public List<PaymentRuleConfigDtlDTO> pay(PaymentRuleConfigParam param) {
        log.info("\u8d22\u52a1\u652f\u4ed8\u63a5\u53e3\uff0c\u63a5\u6536\u5230\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)((Object)param)));
        this.checkPayParam(param);
        CreditSettingDetailVO detail = this.creditSettingService.detailNotUdc();
        if (detail != null && detail.getPaymentPeriodFlag() != null && detail.getPaymentPeriodFlag().booleanValue() && this.arOrderDomainService.countOverduePeriodPay(param.getObjectCode(), param.getOuCode()) > 0L) {
            throw new BusinessException("\u652f\u4ed8\u5931\u8d25\uff0c\u5b58\u5728\u8d85\u8d26\u671f\u672a\u4ed8\u6b3e\u5e94\u6536\u5355");
        }
        PaymentRuleConfigParam paymentRuleConfigParam = PaymentRuleConfigConvert.INSTANCE.copyParam(param);
        this.buildPaymentRuleConfigParam(paymentRuleConfigParam);
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList = this.queryPaymentRuleConfigDtlWithRedis(paymentRuleConfigParam);
        Assert.notEmpty(paymentRuleConfigDtlDTOList, (String)"\u672a\u5339\u914d\u5230\u652f\u4ed8\u914d\u7f6e", (Object[])new Object[0]);
        Set<Long> ids = paymentRuleConfigParam.getPaymentRuleConfigDtlIds();
        Assert.isTrue((paymentRuleConfigDtlDTOList.stream().filter(item -> ids.contains(item.getId())).count() == (long)ids.size() ? 1 : 0) != 0, (String)"\u8d22\u52a1\u652f\u4ed8\u914d\u7f6e\u548c\u5165\u53c2\u652f\u4ed8\u89c4\u5219\u660e\u7ec6id\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.setCalculateFlag(paymentRuleConfigDtlDTOList, ids);
        this.checkRebateAmount(paymentRuleConfigParam, paymentRuleConfigDtlDTOList);
        paymentRuleConfigParam.setObjectGroupCode(this.rmiSaleRpcService.getCustGroupCodeByCustCode(paymentRuleConfigParam.getObjectCode()));
        List<PaymentRuleConfigDtlDTO> result = this.getAccountAndAmount(paymentRuleConfigParam, paymentRuleConfigDtlDTOList);
        if (CollectionUtils.isNotEmpty(result)) {
            BigDecimal docAmount = paymentRuleConfigParam.getDocAmount();
            BigDecimal totalAvailableAmount = BigDecimal.ZERO;
            BigDecimal orderAvailableAmount = BigDecimal.ZERO;
            for (PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO : result) {
                if (paymentRuleConfigDtlDTO.getAvailableAmount() != null) {
                    totalAvailableAmount = totalAvailableAmount.add(paymentRuleConfigDtlDTO.getAvailableAmount());
                }
                if (paymentRuleConfigDtlDTO.getOrderAvailableAmount() == null) continue;
                orderAvailableAmount = orderAvailableAmount.add(paymentRuleConfigDtlDTO.getOrderAvailableAmount());
            }
            Assert.isFalse((totalAvailableAmount.compareTo(docAmount) < 0 ? 1 : 0) != 0, (String)"\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
            Assert.isFalse((orderAvailableAmount.compareTo(docAmount) < 0 ? 1 : 0) != 0, (String)"\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
        }
        this.buildPayList(paymentRuleConfigParam, result);
        BigDecimal paymentAmount = result.stream().map(PaymentRuleConfigDtlDTO::getPaymentAmount).reduce(BigDecimal::add).get();
        Assert.isTrue((boolean)NumberUtil.equals((BigDecimal)paymentAmount, (BigDecimal)paymentRuleConfigParam.getDocAmount()), (String)"\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
        this.setAmount(paymentRuleConfigParam, result);
        this.generateAccountFlow(param, paymentRuleConfigParam, result);
        return result;
    }

    private void checkRebateAmount(PaymentRuleConfigParam paymentRuleConfigParam, List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList) {
        if (paymentRuleConfigParam.getRebateAmount() != null) {
            PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO = paymentRuleConfigDtlDTOList.stream().filter(item -> UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getOptAccountType())).findFirst().orElse(null);
            Assert.notNull((Object)paymentRuleConfigDtlDTO, (String)"\u67e5\u4e0d\u5230\u8fd4\u5229\u8d26\u6237", (Object[])new Object[0]);
            Assert.isTrue((boolean)paymentRuleConfigDtlDTO.isCalculateFlag(), (String)"\u672a\u4f7f\u7528\u8fd4\u5229\u8d26\u6237\u8bf7\u4e0d\u8981\u6307\u5b9a\u8fd4\u5229\u91d1\u989d", (Object[])new Object[0]);
        }
    }

    private void setCalculateFlag(List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList, Set<Long> ids) {
        paymentRuleConfigDtlDTOList.forEach(item -> {
            if (!ids.contains(item.getId())) {
                item.setCalculateFlag(false);
            }
        });
    }

    private void generateAccountFlow(PaymentRuleConfigParam param, PaymentRuleConfigParam paymentRuleConfigParam, List<PaymentRuleConfigDtlDTO> result) {
        result.stream().forEach(item -> {
            if (NumberUtil.equals((BigDecimal)item.getPaymentAmount(), (BigDecimal)BigDecimal.ZERO)) {
                return;
            }
            if (UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType())) {
                item.setFlowNo(this.generateCreditAccountFlow(param, paymentRuleConfigParam, (PaymentRuleConfigDtlDTO)item));
                return;
            }
            item.setFlowNo(this.generateAccountFlow(param, paymentRuleConfigParam, (PaymentRuleConfigDtlDTO)item));
        });
    }

    private List<PaymentRuleConfigDtlDTO> getAccountAndAmount(PaymentRuleConfigParam paymentRuleConfigParam, List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList) {
        ArrayList<PaymentRuleConfigDtlDTO> result = new ArrayList<PaymentRuleConfigDtlDTO>();
        HashMap appUdcCodeQueryMap = new HashMap();
        HashSet<String> set = new HashSet<String>();
        set.add(UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        set.add(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode());
        appUdcCodeQueryMap.put(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getModel(), set);
        Map udcAllValueMap = this.sysUdcService.getValueMapByUdcCodeBatch(appUdcCodeQueryMap);
        Map accountTypeUdc = udcAllValueMap.get(UdcEnum.ACCOUNT_TYPE_STORE.getModel()) != null ? (Map)((Map)udcAllValueMap.get(UdcEnum.ACCOUNT_TYPE_STORE.getModel())).get(UdcEnum.ACCOUNT_TYPE_STORE.getCode()) : null;
        Map creditAccountTypeUdc = udcAllValueMap.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getModel()) != null ? (Map)((Map)udcAllValueMap.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getModel())).get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode()) : null;
        Integer amtRound = SysUtils.getAmtPlace();
        paymentRuleConfigDtlDTOList.stream().forEach(item -> {
            if (UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getOptAccountType())) {
                PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO = this.buildCreditAccountResult((PaymentRuleConfigDtlDTO)item, paymentRuleConfigParam, creditAccountTypeUdc, amtRound);
                if (paymentRuleConfigDtlDTO != null) {
                    result.add(paymentRuleConfigDtlDTO);
                }
                return;
            }
            PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO = this.buildAccountResult((PaymentRuleConfigDtlDTO)item, paymentRuleConfigParam, accountTypeUdc, amtRound);
            if (paymentRuleConfigDtlDTO != null) {
                result.add(paymentRuleConfigDtlDTO);
            }
        });
        return result;
    }

    private void setAmount(PaymentRuleConfigParam paymentRuleConfigParam, List<PaymentRuleConfigDtlDTO> result) {
        result.stream().filter(item -> !item.isCalculateFlag()).forEach(item -> item.setOrderAvailableAmount(BigDecimal.ZERO));
        BigDecimal orderTotalAvailableAmount = result.stream().map(PaymentRuleConfigDtlDTO::getOrderAvailableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (paymentRuleConfigParam.getRebateAmount() != null) {
            orderTotalAvailableAmount = result.stream().filter(item -> !UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType())).map(PaymentRuleConfigDtlDTO::getOrderAvailableAmount).reduce(BigDecimal.ZERO, BigDecimal::add).add(paymentRuleConfigParam.getRebateAmount());
        }
        BigDecimal invoiceAmount = result.stream().filter(item -> !UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType())).map(PaymentRuleConfigDtlDTO::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (PaymentRuleConfigDtlDTO item2 : result) {
            item2.setOrderTotalAvailableAmount(orderTotalAvailableAmount);
            item2.setInvoiceAmount(invoiceAmount);
        }
    }

    private void buildPaymentRuleConfigParam(PaymentRuleConfigParam param) {
        param.setDocType(param.getDoc().concat("_").concat(param.getDocType()));
        param.setDocStatus(param.getDoc().concat("_").concat(param.getDocStatus()));
    }

    private void buildPayList(PaymentRuleConfigParam paymentRuleConfigParam, List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList) {
        BigDecimal paymentBalance = paymentRuleConfigParam.getDocAmount();
        BigDecimal rebateAmount = paymentRuleConfigParam.getRebateAmount();
        if (rebateAmount == null) {
            for (PaymentRuleConfigDtlDTO item : paymentRuleConfigDtlDTOList) {
                if (!item.isCalculateFlag()) continue;
                item.setPaymentAmount(item.getOrderAvailableAmount());
                if (item.getOrderAvailableAmount().compareTo(paymentBalance) >= 0) {
                    item.setPaymentAmount(paymentBalance);
                }
                paymentBalance = NumberUtil.isGreaterOrEqual((BigDecimal)(paymentBalance = paymentBalance.subtract(item.getOrderAvailableAmount())), (BigDecimal)BigDecimal.ZERO) ? paymentBalance : BigDecimal.ZERO;
            }
            return;
        }
        paymentBalance = paymentBalance.subtract(rebateAmount);
        for (PaymentRuleConfigDtlDTO item : paymentRuleConfigDtlDTOList) {
            if (!item.isCalculateFlag()) continue;
            if (UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType())) {
                item.setPaymentAmount(rebateAmount);
                continue;
            }
            item.setPaymentAmount(item.getOrderAvailableAmount());
            if (item.getOrderAvailableAmount().compareTo(paymentBalance) >= 0) {
                item.setPaymentAmount(paymentBalance);
            }
            paymentBalance = NumberUtil.isGreaterOrEqual((BigDecimal)(paymentBalance = paymentBalance.subtract(item.getOrderAvailableAmount())), (BigDecimal)BigDecimal.ZERO) ? paymentBalance : BigDecimal.ZERO;
        }
    }

    @Override
    public List<PaymentRuleConfigDtlDTO> queryPaymentRuleConfigDtl(PaymentRuleConfigParam paymentRuleConfigParam) {
        PaymentRuleConfigParam queryParam = new PaymentRuleConfigParam();
        queryParam.setOptDoc(paymentRuleConfigParam.getDoc());
        queryParam.setOptDocType(paymentRuleConfigParam.getDocType());
        queryParam.setOptDocStatus(paymentRuleConfigParam.getDocStatus());
        queryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList = this.paymentRuleConfigRepoProc.searchByPaymentRuleConfigParam(queryParam);
        Assert.notEmpty(paymentRuleConfigDtlDTOList, (String)"\u672a\u5339\u914d\u5230\u652f\u4ed8\u914d\u7f6e", (Object[])new Object[0]);
        paymentRuleConfigDtlDTOList.stream().forEach(item -> item.setCalculateFlag(true));
        paymentRuleConfigDtlDTOList = paymentRuleConfigDtlDTOList.stream().sorted(Comparator.comparing(PaymentRuleConfigDtlDTO::getPriorityNo)).collect(Collectors.toList());
        return paymentRuleConfigDtlDTOList;
    }

    @Override
    public List<PaymentRuleConfigDtlDTO> queryPaymentRuleConfigDtlByRuleCode(String ruleCode) {
        PaymentRuleConfigParam queryParam = new PaymentRuleConfigParam();
        queryParam.setRuleCode(ruleCode);
        queryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList = this.paymentRuleConfigRepoProc.searchByPaymentRuleConfigParam(queryParam);
        if (CollUtil.isEmpty(paymentRuleConfigDtlDTOList)) {
            return Collections.emptyList();
        }
        paymentRuleConfigDtlDTOList.stream().forEach(item -> item.setCalculateFlag(true));
        paymentRuleConfigDtlDTOList = paymentRuleConfigDtlDTOList.stream().sorted(Comparator.comparing(PaymentRuleConfigDtlDTO::getPriorityNo)).collect(Collectors.toList());
        return paymentRuleConfigDtlDTOList;
    }

    public List<PaymentRuleConfigDtlDTO> queryPaymentRuleConfigDtlWithRedis(PaymentRuleConfigParam paymentRuleConfigParam) {
        PaymentRuleConfigParam queryParam = new PaymentRuleConfigParam();
        queryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList = this.myRedisService.getListDataFromRedis("YST_FIN_PAYMENT_RULE_CONFIG", PaymentRuleConfigDtlDTO.class, "\u652f\u4ed8\u89c4\u5219\u914d\u7f6e", () -> this.paymentRuleConfigRepoProc.searchByPaymentRuleConfigParam(queryParam));
        if (!CollectionUtils.isEmpty(paymentRuleConfigDtlDTOList)) {
            paymentRuleConfigDtlDTOList = paymentRuleConfigDtlDTOList.stream().filter(v -> {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)paymentRuleConfigParam.getDoc()) && !paymentRuleConfigParam.getDoc().equals(v.getOptDoc())) {
                    return false;
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)paymentRuleConfigParam.getDocType()) && !paymentRuleConfigParam.getDocType().equals(v.getOptDocType())) {
                    return false;
                }
                return !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)paymentRuleConfigParam.getDocStatus()) || paymentRuleConfigParam.getDocStatus().equals(v.getOptDocStatus());
            }).collect(Collectors.toList());
        }
        Assert.notEmpty(paymentRuleConfigDtlDTOList, (String)"\u672a\u5339\u914d\u5230\u652f\u4ed8\u914d\u7f6e", (Object[])new Object[0]);
        paymentRuleConfigDtlDTOList.stream().forEach(item -> item.setCalculateFlag(true));
        paymentRuleConfigDtlDTOList = paymentRuleConfigDtlDTOList.stream().sorted(Comparator.comparing(PaymentRuleConfigDtlDTO::getPriorityNo)).collect(Collectors.toList());
        return paymentRuleConfigDtlDTOList;
    }

    private String generateAccountFlow(PaymentRuleConfigParam original, PaymentRuleConfigParam paymentRuleConfigParam, PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO) {
        AccountFlowParam accountFlowParam = this.buildAccountFlowParam(original, paymentRuleConfigParam, paymentRuleConfigDtlDTO);
        return this.accountFlowService.generateAccountFlow(accountFlowParam);
    }

    private AccountFlowParam buildAccountFlowParam(PaymentRuleConfigParam original, PaymentRuleConfigParam paymentRuleConfigParam, PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO) {
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setSourceDoc(paymentRuleConfigParam.getDoc());
        accountFlowParam.setSourceDocType(original.getDocType());
        accountFlowParam.setSourceDocStatus(original.getDocStatus());
        accountFlowParam.setSourceDocAmount(paymentRuleConfigDtlDTO.getPaymentAmount());
        accountFlowParam.setSourceId(paymentRuleConfigParam.getSourceId());
        accountFlowParam.setSourceNo(paymentRuleConfigParam.getSourceNo());
        accountFlowParam.setAccountCode(paymentRuleConfigDtlDTO.getAccountCode());
        accountFlowParam.setWorkflowProcInstId(original.getWorkflowProcInstId());
        return accountFlowParam;
    }

    private String generateCreditAccountFlow(PaymentRuleConfigParam original, PaymentRuleConfigParam paymentRuleConfigParam, PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO) {
        CreditAccountFlowParam creditAccountFlowParam = this.buildCreditAccountFlowParam(original, paymentRuleConfigParam, paymentRuleConfigDtlDTO);
        return this.creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
    }

    private CreditAccountFlowParam buildCreditAccountFlowParam(PaymentRuleConfigParam original, PaymentRuleConfigParam paymentRuleConfigParam, PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO) {
        CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
        creditAccountFlowParam.setSourceDoc(paymentRuleConfigParam.getDoc());
        creditAccountFlowParam.setSourceDocType(original.getDocType());
        creditAccountFlowParam.setSourceDocStatus(original.getDocStatus());
        creditAccountFlowParam.setSourceDocAmount(paymentRuleConfigDtlDTO.getPaymentAmount());
        creditAccountFlowParam.setSourceId(paymentRuleConfigParam.getSourceId());
        creditAccountFlowParam.setSourceNo(paymentRuleConfigParam.getSourceNo());
        creditAccountFlowParam.setCreditAccountCode(paymentRuleConfigDtlDTO.getAccountCode());
        creditAccountFlowParam.setWorkflowProcInstId(original.getWorkflowProcInstId());
        return creditAccountFlowParam;
    }

    private void checkPayParam(PaymentRuleConfigParam param) {
        Assert.notEmpty((CharSequence)param.getDoc(), (String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getDocType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getDocStatus(), (String)"\u5355\u636e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getDocAmount(), (String)"\u6765\u6e90\u5355\u636e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getOuCode(), (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getObjectCode(), (String)"\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getSourceNo(), (String)"\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getSourceId(), (String)"\u6765\u6e90\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty(param.getPaymentRuleConfigDtlIds(), (String)"\u652f\u4ed8\u89c4\u5219\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void checkQueryAccountAmountParam(PaymentRuleConfigParam param) {
        Assert.notEmpty((CharSequence)param.getDoc(), (String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getDocType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getDocStatus(), (String)"\u5355\u636e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getDocAmount(), (String)"\u6765\u6e90\u5355\u636e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getObjectCode(), (String)"\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getOuCode(), (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private PaymentRuleConfigDtlDTO buildAccountResult(PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO, PaymentRuleConfigParam paymentRuleConfigParam, Map<String, String> accountTypeUdc, Integer amtRound) {
        AccountParam accountParam = new AccountParam();
        accountParam.setAccountHolderCode(paymentRuleConfigParam.getObjectCode());
        accountParam.setSecOuCode(paymentRuleConfigParam.getOuCode());
        accountParam.setAccountType(paymentRuleConfigDtlDTO.getOptAccountType());
        accountParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<AccountDTO> accountDTOList = this.accountService.getAccountByAccountParam(accountParam);
        if (CollectionUtils.isEmpty(accountDTOList)) {
            return null;
        }
        Assert.isTrue((accountDTOList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237", (Object[])new Object[0]);
        AccountDTO accountDTO = accountDTOList.get(0);
        PaymentRuleConfigDtlDTO result = new PaymentRuleConfigDtlDTO();
        result.setCalculateFlag(paymentRuleConfigDtlDTO.isCalculateFlag());
        result.setAvailableAmount(BigDecimal.ZERO);
        result.setOrderAvailableAmount(BigDecimal.ZERO);
        result.setPaymentAmount(BigDecimal.ZERO);
        result.setOrderTotalAvailableAmount(BigDecimal.ZERO);
        result.setInvoiceAmount(BigDecimal.ZERO);
        result.setTime(LocalDateTime.now());
        result.setId(paymentRuleConfigDtlDTO.getId());
        result.setAccountType(accountDTO.getAccountType());
        result.setAccountTypeName(accountTypeUdc.get(accountDTO.getAccountType()));
        result.setAccountCode(accountDTO.getAccountCode());
        result.setAccountName(accountDTO.getAccountName());
        result.setAvailableAmount(accountDTO.getAccountAvailableAmount());
        result.setPriorityNo(paymentRuleConfigDtlDTO.getPriorityNo());
        if (paymentRuleConfigDtlDTO.getCalculatePercent() == null) {
            paymentRuleConfigDtlDTO.setCalculatePercent(ONE_HUNDRED_BIGDECIMAL);
        }
        BigDecimal orderAvailableAmount = paymentRuleConfigParam.getDocAmount().multiply(paymentRuleConfigDtlDTO.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL);
        result.setOrderAvailableAmount(orderAvailableAmount);
        if (accountDTO.getAccountAvailableAmount().compareTo(BigDecimal.ZERO) <= 0) {
            result.setOrderAvailableAmount(BigDecimal.ZERO);
        } else if (accountDTO.getAccountAvailableAmount().compareTo(orderAvailableAmount) < 0) {
            result.setOrderAvailableAmount(accountDTO.getAccountAvailableAmount());
        }
        result.setOrderAvailableAmount(result.getOrderAvailableAmount().setScale((int)amtRound, RoundingMode.HALF_UP));
        if (UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(result.getAccountType()) && paymentRuleConfigParam.getRebateAmount() != null) {
            Assert.isTrue((boolean)NumberUtil.isLessOrEqual((BigDecimal)paymentRuleConfigParam.getRebateAmount(), (BigDecimal)result.getOrderAvailableAmount()), (String)"\u6307\u5b9a\u8fd4\u5229\u8d26\u6237\u652f\u4ed8\u91d1\u989d\u5927\u4e8e\u672c\u8ba2\u5355\u53ef\u7528\u91d1\u989d", (Object[])new Object[0]);
        }
        return result;
    }

    private PaymentRuleConfigDtlDTO buildCreditAccountResult(PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO, PaymentRuleConfigParam paymentRuleConfigParam, Map<String, String> creditAccountTypeUdc, Integer amtRound) {
        CreditAccountParam creditAccountParam = new CreditAccountParam();
        creditAccountParam.setObjectCode(paymentRuleConfigParam.getObjectGroupCode());
        creditAccountParam.setOuCode(paymentRuleConfigParam.getOuCode());
        creditAccountParam.setCreditAccountType(paymentRuleConfigDtlDTO.getOptAccountType());
        creditAccountParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<CreditAccountDTO> creditAccountDTOList = this.creditAccountService.getAccountByAccountParam(creditAccountParam);
        if (CollectionUtils.isEmpty(creditAccountDTOList)) {
            return null;
        }
        Assert.isTrue((creditAccountDTOList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u4fe1\u7528\u8d26\u6237", (Object[])new Object[0]);
        CreditAccountDTO creditAccountDTO = creditAccountDTOList.get(0);
        PaymentRuleConfigDtlDTO result = new PaymentRuleConfigDtlDTO();
        result.setAvailableAmount(BigDecimal.ZERO);
        result.setCalculateFlag(paymentRuleConfigDtlDTO.isCalculateFlag());
        result.setOrderAvailableAmount(BigDecimal.ZERO);
        result.setPaymentAmount(BigDecimal.ZERO);
        result.setOrderTotalAvailableAmount(BigDecimal.ZERO);
        result.setInvoiceAmount(BigDecimal.ZERO);
        result.setTime(LocalDateTime.now());
        result.setId(paymentRuleConfigDtlDTO.getId());
        result.setAccountType(creditAccountDTO.getCreditAccountType());
        result.setAccountTypeName(creditAccountTypeUdc.get(creditAccountDTO.getCreditAccountType()));
        result.setAccountCode(creditAccountDTO.getCreditAccountCode());
        result.setAccountName(creditAccountDTO.getCreditAccountName());
        result.setAvailableAmount(creditAccountDTO.getCreditAccountAvailableLimit());
        result.setPriorityNo(paymentRuleConfigDtlDTO.getPriorityNo());
        if (paymentRuleConfigDtlDTO.getCalculatePercent() == null) {
            paymentRuleConfigDtlDTO.setCalculatePercent(ONE_HUNDRED_BIGDECIMAL);
        }
        BigDecimal orderAvailableAmount = paymentRuleConfigParam.getDocAmount().multiply(paymentRuleConfigDtlDTO.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL);
        result.setOrderAvailableAmount(orderAvailableAmount);
        if (creditAccountDTO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) <= 0) {
            result.setOrderAvailableAmount(BigDecimal.ZERO);
        } else if (creditAccountDTO.getCreditAccountAvailableLimit().compareTo(orderAvailableAmount) < 0) {
            result.setOrderAvailableAmount(creditAccountDTO.getCreditAccountAvailableLimit());
        }
        result.setOrderAvailableAmount(result.getOrderAvailableAmount().setScale((int)amtRound, RoundingMode.HALF_UP));
        return result;
    }

    public PaymentRuleConfigDomainServiceImpl(PaymentRuleConfigRepo paymentRuleConfigRepo, PaymentRuleConfigRepoProc paymentRuleConfigRepoProc, CreditAccountService creditAccountService, AccountService accountService, RmiSaleRpcService rmiSaleRpcService, CreditAccountFlowService creditAccountFlowService, AccountFlowService accountFlowService, FinSalMqProcessor finSalMqProcessor, UdcProvider udcProvider, CreditSettingService creditSettingService, ArOrderDomainService arOrderDomainService, UdcProvider sysUdcService, MyRedisService myRedisService) {
        this.paymentRuleConfigRepo = paymentRuleConfigRepo;
        this.paymentRuleConfigRepoProc = paymentRuleConfigRepoProc;
        this.creditAccountService = creditAccountService;
        this.accountService = accountService;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.creditAccountFlowService = creditAccountFlowService;
        this.accountFlowService = accountFlowService;
        this.finSalMqProcessor = finSalMqProcessor;
        this.udcProvider = udcProvider;
        this.creditSettingService = creditSettingService;
        this.arOrderDomainService = arOrderDomainService;
        this.sysUdcService = sysUdcService;
        this.myRedisService = myRedisService;
    }
}

