package com.elitesland.fin.application.facade.vo.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "值集")
public class FinFlexibleVO extends BaseModelVO {

    @ApiModelProperty("值集编码")
    private String flexibleCode;

    @ApiModelProperty("值集名称")
    private String flexibleName;

    @ApiModelProperty("值集类型，0：主值集，1：从属值集")
    @SysCode(sys = "yst-fin", mod = "FLEXIBLE_TYPE")
    private String flexibleType;
    private String flexibleTypeName;

    @ApiModelProperty("主值集编码")
    private String parentFlexibleCode;

    @ApiModelProperty("主值集名称")
    private String parentFlexibleName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("值集明细")
    private List<FinFlexibleValueVO> detailList;
}
