package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_AWAIT_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class DefaultFinAwaitExportServiceImpl implements DataExport<InvoiceAwaitVO, InvoiceAwaitQueryParam> {
    private final InvoiceAwaitService invoiceAwaitService;
    @Override
    public String getTmplCode() {
        return FIN_AWAIT_EXPORT_DEFAULT;
    }
    @Override
    @BusinessObjectOperation(permissionRef = FinBusinessObjectConstant.FIN_INVOICE_AWAIT_LIST, businessObjectType = FinBusinessObjectConstant.FIN_INVOICE_AWAIT,
            operationType = OperationTypeEnum.EXPORT, operationDescription = "待开发票单默认导出",operationCode = FinBusinessObjectConstant.FIN_INVOICE_AWAIT_EXPORT_DEFAULT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<InvoiceAwaitVO> executeExport(InvoiceAwaitQueryParam queryParam) {
        return invoiceAwaitService.queryInvoiceAwait(queryParam);
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
}
