package com.elitesland.fin.application.service.financial;

import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.FinancialBillConvert;
import com.elitesland.fin.application.convert.financial.FinancialBillDConvert;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDDTO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillDSaveParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillPageParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillSaveParam;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillVO;
import com.elitesland.fin.domain.service.financial.FinancialBillDDomainService;
import com.elitesland.fin.domain.service.financial.FinancialBillDomainService;
import com.elitesland.fin.entity.financial.FinancialBillDDO;
import com.elitesland.fin.entity.financial.FinancialBillDO;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2025/10/14 14:56
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FinancialBillServiceImpl implements FinancialBillService{

    private final FinancialBillDomainService financialBillDomainService;
    private final FinancialBillDDomainService financialBillDDomainService;
    private final SysUdcProxyService sysUdcProxyService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    @SysCodeProc
    @Override
    public PagingVO<FinancialBillVO> pageSearch(FinancialBillPageParam financialBillPageParam) {
        PagingVO<FinancialBillVO> financialBillVOPagingVO = FinancialBillConvert.INSTANCE.convertPage(financialBillDomainService.page(financialBillPageParam));
        List<String> ouCodes = financialBillVOPagingVO.getRecords().stream().map(FinancialBillVO::getOuCode).collect(Collectors.toList());
        Map<String, String> ouMap = rmiOrgOuRpcServiceService.findBaseOuByCodes(ouCodes).stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, OrgOuRpcSimpleDTO::getOuName));
        financialBillVOPagingVO.getRecords().forEach(vo->{
            if(ouMap.get(vo.getOuCode())!=null){
                vo.setOuName(ouMap.get(vo.getOuCode()));
            }
        });
        return financialBillVOPagingVO;
    }

    @SysCodeProc
    @Override
    public FinancialBillVO get(Long id) {
        FinancialBillDTO financialBillDTO = financialBillDomainService.get(id);
        List<FinancialBillDDTO> financialBillDDTOS = financialBillDDomainService.queryByMasId(id);
        sysUdcProxyService.translate(financialBillDDTOS);
        financialBillDTO.setFinancialBillDList(financialBillDDTOS);
        return FinancialBillConvert.INSTANCE.dtoToVo(financialBillDTO);
    }

    @Transactional
    @Override
    public void batchSaveFinancialBill(List<FinancialBillSaveParam> param) {
        if(!CollectionUtils.isEmpty(param)){
            List<FinancialBillDDO> dtlData=new ArrayList<>();
            param.forEach(vo->{
                FinancialBillDO financialBillDO = FinancialBillConvert.INSTANCE.saveToDos(vo);
                Long save = financialBillDomainService.save(financialBillDO);
                vo.getFinancialBillDList().forEach(dtl->{
                    FinancialBillDDO financialBillDDO = FinancialBillDConvert.INSTANCE.paramToDO(dtl);
                    financialBillDDO.setMasId(save);
                    dtlData.add(financialBillDDO);
                });
            });
            if(!CollectionUtils.isEmpty(dtlData)){
                financialBillDDomainService.batchSaveFinancialBillD(dtlData);
            }
        }
    }
}
